/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.searchsong;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVAssociateSearchModel;
import java.util.ArrayList;
import java.util.List;
import net.ihago.ktv.api.search.SuggestedRecord;
import net.ihago.ktv.api.search.SuggestedRecordType;

public class KTVAssociateSearchAdapter
extends RecyclerView.Adapter<CustomerViewHolder> {
    private Context mContext;
    private List<KTVAssociateSearchModel> mDatas;
    private OnItemClickListener onItemClickListener;

    public KTVAssociateSearchAdapter(Context context) {
        this.mContext = context;
    }

    @NonNull
    public CustomerViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_ktv_search_associate_result_channel, parent, false);
        CustomerViewHolder viewHolder = new CustomerViewHolder(view);
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull CustomerViewHolder holder, final int position) {
        if (position == this.mDatas.size() - 1) {
            holder.mTvBottom.setVisibility(0);
        } else {
            holder.mTvBottom.setVisibility(8);
        }
        final KTVAssociateSearchModel mModel = this.mDatas.get(position);
        SuggestedRecord record = mModel.getRecord();
        if (record != null) {
            SuggestedRecordType recordType = record.type;
            if (recordType != null) {
                if (recordType == SuggestedRecordType.kSuggestedIsSinger) {
                    holder.mIvHead.setImageResource(R.drawable.icon_ktv_associate_search_singer);
                } else if (recordType == SuggestedRecordType.kSuggestedIsSong) {
                    holder.mIvHead.setImageResource(R.drawable.icon_ktv_associate_search_sing);
                }
            } else {
                holder.mIvHead.setImageResource(R.drawable.icon_ktv_associate_search_sing);
            }
            String strRecord = record.value;
            String publicRecord = mModel.getPublicRecord();
            if (!TextUtils.isEmpty((CharSequence)strRecord)) {
                if (!TextUtils.isEmpty((CharSequence)publicRecord)) {
                    int index = strRecord.indexOf(publicRecord);
                    if (index != -1) {
                        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.modify_roominfo_tag_selected));
                        SpannableStringBuilder stringBuilder = new SpannableStringBuilder((CharSequence)strRecord);
                        stringBuilder.setSpan((Object)foregroundColorSpan, index, publicRecord.length() + index, 33);
                        holder.mTvSearchResult.setText((CharSequence)stringBuilder);
                    } else {
                        holder.mTvSearchResult.setText((CharSequence)strRecord);
                    }
                } else {
                    holder.mTvSearchResult.setText((CharSequence)strRecord);
                }
            } else {
                holder.mTvSearchResult.setText((CharSequence)"");
            }
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (KTVAssociateSearchAdapter.this.onItemClickListener != null) {
                    KTVAssociateSearchAdapter.this.onItemClickListener.onItemClickListener(position, mModel);
                }
            }
        });
    }

    public int getItemCount() {
        return this.mDatas == null ? 0 : this.mDatas.size();
    }

    public void updateData(List<KTVAssociateSearchModel> tempList) {
        if (this.mDatas == null) {
            this.mDatas = new ArrayList<KTVAssociateSearchModel>();
        }
        this.mDatas.clear();
        this.mDatas.addAll(tempList);
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    static interface OnItemClickListener {
        public void onItemClickListener(int var1, KTVAssociateSearchModel var2);
    }

    static class CustomerViewHolder
    extends RecyclerView.ViewHolder {
        private YYTextView mTvSearchResult;
        private YYImageView mIvHead;
        private YYTextView mTvBottom;

        public CustomerViewHolder(View itemView) {
            super(itemView);
            this.mTvSearchResult = (YYTextView)itemView.findViewById(R.id.tv_ktv_associate_search);
            this.mIvHead = (YYImageView)itemView.findViewById(R.id.iv_head);
            this.mTvBottom = (YYTextView)itemView.findViewById(R.id.tv_bottom);
        }
    }
}

