/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.list.KTVAnimator;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.KTVLibraryContract;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.KTVLibraryPresenter;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view.KTVInstructionDialog;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view.KTVMusicItemAdapter;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view.KTVSongPagerAdapter;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import java.util.ArrayList;
import java.util.List;

public class KTVLibraryPanel
extends YYConstraintLayout
implements KTVLibraryContract.View,
View.OnClickListener,
KTVMusicItemAdapter.ItemClickListener,
KTVMusicItemAdapter.TabClickListener {
    private ConstraintLayout mContentLayout;
    private View mLibraryPager;
    private BasePanel mPanel;
    private PanelLayer mLayer;
    private YYViewPager mVpPagers;
    private YYTextView mTvOutside;
    private YYTextView mTvSongListCount;
    private YYImageView mIvHelp;
    private YYImageView mIvUpload;
    private RecyclerView mRvLibrary;
    private ConstraintLayout mClBtnSongList;
    private CommonStatusLayout mLibraryStatusLayout;
    private SmartRefreshLayout mRefreshLayout;
    private KTVAnimator mAnimator;
    private DialogLinkManager mDialogLinkManager;
    private KTVSongPagerAdapter mPagerAdapter;
    private KTVMusicItemAdapter mLibraryAdapter;
    private KTVLibraryContract.Presenter mPresenter;

    private KTVLibraryPanel(Context context) {
        this(context, null);
    }

    private KTVLibraryPanel(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private KTVLibraryPanel(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public KTVLibraryPanel(@NonNull PanelLayer layer) {
        this(layer != null ? layer.getContext() : RuntimeContext.sApplicationContext);
        this.mLayer = layer;
        this.mDialogLinkManager = new DialogLinkManager(this.getContext());
        this.createView();
    }

    public void setPresenter(KTVLibraryContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    @Override
    public void show() {
        if (this.mLayer != null && !this.mLayer.hasPanelShowing()) {
            this.mPresenter.start();
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            params.addRule(12);
            if (this.mPanel == null) {
                this.mPanel = new BasePanel(RuntimeContext.sApplicationContext);
            }
            this.mPanel.setShowAnim(this.mPanel.createBottomShowAnimation());
            this.mPanel.setHideAnim(this.mPanel.createBottomHideAnimation());
            this.mPanel.setContent((View)this, params);
            this.mLayer.showPanel(this.mPanel, true);
            this.mPanel.setListener((BasePanel.IPanelListener)new BasePanel.SimplePanelListener(){

                public void onPanelHidden(BasePanel panel) {
                    super.onPanelHidden(panel);
                    if (null != KTVLibraryPanel.this.mPresenter) {
                        KTVLibraryPanel.this.mPresenter.onPanelHidden();
                    }
                }
            });
            KTVEventReportUtil.reportSongLibShow("9", "1");
        }
    }

    @Override
    public void hide() {
        if (this.mLayer != null && this.mLayer.hasPanelShowing()) {
            this.mLayer.hideShowingPanel();
            this.mPresenter.stop();
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    KTVLibraryPanel.this.mRvLibrary.scrollToPosition(0);
                    KTVLibraryPanel.this.mVpPagers.setCurrentItem(0);
                }
            }, (long)300L);
        }
    }

    @Override
    public void updateLibrary(List<KTVMusicInfo> list, boolean isFirstPage) {
        this.mLibraryStatusLayout.hideLoading();
        if (isFirstPage) {
            this.mRefreshLayout.finishRefresh();
            if (FP.empty(list)) {
                this.mLibraryStatusLayout.showNoData(R.drawable.icon_default_no_data, ResourceUtils.getString((int)R.string.short_tips_no_song), null);
            } else {
                this.mLibraryStatusLayout.hideNoData();
            }
        } else {
            this.mRefreshLayout.finishLoadMore();
        }
        this.mLibraryAdapter.setData(list);
    }

    @Override
    public void updateSongListCount(int count) {
        int curCount = StringUtils.parseInt((String)this.mTvSongListCount.getText().toString());
        if (count > curCount) {
            this.mClBtnSongList.startAnimation(this.mAnimator.getZoomInOut());
        }
        this.mTvSongListCount.setText((CharSequence)String.valueOf(count));
    }

    private void createView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_song_library_panel_channel, (ViewGroup)this);
        this.mContentLayout = (ConstraintLayout)view.findViewById(R.id.view_content);
        this.mIvHelp = (YYImageView)view.findViewById(R.id.iv_help);
        this.mIvUpload = (YYImageView)view.findViewById(R.id.iv_upload);
        this.mVpPagers = (YYViewPager)view.findViewById(R.id.vp_pagers);
        this.mTvOutside = (YYTextView)view.findViewById(R.id.tv_outside);
        this.mClBtnSongList = (ConstraintLayout)view.findViewById(R.id.cl_btn_song_list);
        this.mTvSongListCount = (YYTextView)view.findViewById(R.id.tv_song_list_count);
        this.mIvHelp.setOnClickListener(this::onClick);
        this.mIvUpload.setOnClickListener(this::onClick);
        this.mTvOutside.setOnClickListener((View.OnClickListener)this);
        this.mClBtnSongList.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.ll_search).setOnClickListener((View.OnClickListener)this);
        this.mTvSongListCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.initPagers();
        this.initAnimation();
    }

    private void initAnimation() {
        this.mAnimator = new KTVAnimator(this.getContext());
    }

    private void initPagers() {
        this.initLibraryPager();
        ArrayList<View> pagers = new ArrayList<View>();
        pagers.add(this.mLibraryPager);
        this.mPagerAdapter = new KTVSongPagerAdapter(this.getContext(), pagers);
        this.mVpPagers.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mVpPagers.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (position == 0) {
                    KTVEventReportUtil.reportClickMusicLib();
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    @Override
    public String getCurrentPage() {
        String page = this.mVpPagers.getCurrentItem() == 0 ? "1" : "2";
        return page;
    }

    private void initLibraryPager() {
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mLibraryPager = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_song_library_page_channel, null);
        this.mRefreshLayout = (SmartRefreshLayout)this.mLibraryPager.findViewById(R.id.srl_refresh);
        this.mLibraryStatusLayout = (CommonStatusLayout)this.mLibraryPager.findViewById(R.id.csl_status);
        this.mLibraryStatusLayout.showLoading();
        this.mRvLibrary = (RecyclerView)this.mLibraryPager.findViewById(R.id.rv_song_list);
        this.mLibraryAdapter = new KTVMusicItemAdapter(this.getContext(), 1);
        this.mLibraryAdapter.setOnItemClickListener(this);
        this.mLibraryAdapter.setOnTablickListener(this);
        this.mRvLibrary.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRvLibrary.setAdapter((RecyclerView.Adapter)this.mLibraryAdapter);
        this.mLibraryStatusLayout.showNoData(R.drawable.icon_default_no_data, ResourceUtils.getString((int)R.string.short_tips_no_song), null);
        this.mRefreshLayout.setOnRefreshLoadMoreListener(new OnRefreshLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                if (KTVLibraryPanel.this.mPresenter.getHasNext()) {
                    KTVLibraryPanel.this.mPresenter.getSongList(false);
                } else {
                    KTVLibraryPanel.this.mRefreshLayout.finishLoadMore();
                }
            }

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                KTVLibraryPanel.this.mPresenter.getSongList(true);
            }
        });
        this.mRvLibrary.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                View view;
                LinearLayoutManager llm;
                int position;
                super.onScrolled(recyclerView, dx, dy);
                int count = recyclerView.getChildCount();
                if (count > 0 && (position = (llm = (LinearLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition()) == 0 && (view = llm.findViewByPosition(position)).getY() >= (float)(-ResolutionUtils.dip2Px((float)50.0f))) {
                    KTVEventReportUtil.reportSingoTipShow();
                }
            }
        });
    }

    @Override
    public void showLoading() {
        int index = this.mVpPagers.getCurrentItem();
        if (index == 0) {
            this.mLibraryStatusLayout.showLoading();
        }
    }

    @Override
    public void hideLoading() {
        int index = this.mVpPagers.getCurrentItem();
        if (index == 0) {
            this.mLibraryStatusLayout.hideLoading();
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.cl_btn_song_list) {
            this.mPresenter.openSongListPanel();
            if (this.getCurrentPage() == "1") {
                KTVEventReportUtil.reportOpenSongList("5");
            }
        } else if (v.getId() == R.id.tv_outside) {
            this.hide();
        } else if (v.getId() == R.id.iv_help) {
            this.showInstructionDialog();
        } else if (v.getId() == R.id.iv_upload) {
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_UPLOAD_SONG_WINDOW);
            if (KTVLibraryPresenter.mMode == 0) {
                KTVEventReportUtil.reportUploadEnterClick("1");
            } else {
                RadioUtils.INSTANCE.reportUploadEnterClick("1");
            }
        } else if (v.getId() == R.id.ll_search) {
            this.mPresenter.openSearchWindow();
            if (KTVLibraryPresenter.mMode == 0) {
                KTVEventReportUtil.reportSearchBtnClick();
            } else {
                RadioUtils.INSTANCE.reportSearchBtnClick();
            }
        }
    }

    @Override
    public void onSingersClick() {
        if (RepeatClickUtils.canRepeatClick() && null != this.mPresenter) {
            this.mPresenter.onSingersClick(this.getContext(), (ViewGroup)this.mContentLayout);
        }
    }

    @Override
    public void onRankingClick() {
        if (RepeatClickUtils.canRepeatClick() && null != this.mPresenter) {
            this.mPresenter.onRankingClick(this.getContext(), (ViewGroup)this.mContentLayout);
        }
    }

    @Override
    public void onRecordClick() {
        if (RepeatClickUtils.canRepeatClick()) {
            if (null != this.mPresenter) {
                this.mPresenter.onRecordClick(this.getContext(), (ViewGroup)this.mContentLayout);
            }
            KTVEventReportUtil.reportClickHistory();
        }
    }

    private void showInstructionDialog() {
        KTVInstructionDialog dialog2 = new KTVInstructionDialog();
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
    }

    @Override
    public void onItemClick(KTVMusicInfo song) {
        this.selectSong(song);
    }

    private void selectSong(KTVMusicInfo song) {
        this.mPresenter.requestSong(song, "1");
    }

    static interface PageType {
        public static final String LIBRARY = "1";
        public static final String HISTORY = "2";
    }
}

