/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVSingersData;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVSingersItemInfo;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.AZSidebar;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.ISelectSingerListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.KTVSingersAdapter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KTVSingersPage
extends YYConstraintLayout {
    public static final int TYPE_ALL = 1;
    public static final int TYPE_FEMALE = 2;
    public static final int TYPE_MALE = 3;
    public static final int TYPE_BAND = 4;
    private Context mContext;
    private RecyclerView singersRv;
    private KTVSingersAdapter mAdapter;
    private CommonStatusLayout mStatusLayout;
    private List<KTVSingersItemInfo> mList = new ArrayList<KTVSingersItemInfo>();
    private YYLinearLayout letterLayout;
    private YYImageView letterIv;
    private YYTextView letterTv;
    private AZSidebar mSlidebar;
    private Map<String, Integer> charPositions = new HashMap<String, Integer>();
    private int pageType;

    public KTVSingersPage(Context context, int type) {
        super(context);
        this.mContext = context;
        this.pageType = type;
        this.createView();
    }

    private void createView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_singers_page_channel, (ViewGroup)this);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.statuslayout);
        this.mStatusLayout.showLoading();
        this.letterLayout = (YYLinearLayout)this.findViewById(R.id.layout_letter);
        this.letterIv = (YYImageView)this.findViewById(R.id.iv_letter);
        this.letterTv = (YYTextView)this.findViewById(R.id.tv_letter);
        this.singersRv = (RecyclerView)this.findViewById(R.id.rv_list);
        final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.singersRv.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mAdapter = new KTVSingersAdapter(this.mContext, this.mList, this.pageType);
        this.singersRv.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mSlidebar = (AZSidebar)this.findViewById(R.id.sidebar);
        if (this.pageType == 1) {
            this.mSlidebar.setLettersHeader(R.drawable.ktv_singers_hot, R.drawable.ktv_singers_hot_white);
        }
        this.mSlidebar.setOnTouchingLetterChangedListener(new AZSidebar.OnTouchingLetterChangedListener(){

            @Override
            public void onTouchingLetterChanged(String currentLetter) {
                int position;
                KTVSingersPage.this.letterLayout.setVisibility(0);
                if (currentLetter.equals("*")) {
                    KTVSingersPage.this.letterTv.setVisibility(8);
                    KTVSingersPage.this.letterIv.setVisibility(0);
                } else {
                    KTVSingersPage.this.letterTv.setVisibility(0);
                    KTVSingersPage.this.letterIv.setVisibility(8);
                    KTVSingersPage.this.letterTv.setText((CharSequence)currentLetter);
                }
                Integer i = (Integer)KTVSingersPage.this.charPositions.get(currentLetter);
                int n = position = i == null ? -1 : i;
                if (position != -1) {
                    linearLayoutManager.scrollToPositionWithOffset(position, 0);
                }
            }

            @Override
            public void onTouchUp() {
                KTVSingersPage.this.letterLayout.setVisibility(8);
            }
        });
    }

    private void initCharList(List<KTVSingersItemInfo> list) {
        this.charPositions.clear();
        for (int i = 0; i < list.size(); ++i) {
            KTVSingersItemInfo info = list.get(i);
            if (info.getType() != 0) continue;
            this.charPositions.put(info.getLetter().toUpperCase(), i);
        }
    }

    public void scrollStateChanged(boolean isScrolling) {
        this.mSlidebar.setVisibility(isScrolling ? 8 : 0);
    }

    public void dataChanged(KTVSingersData data) {
        List<KTVSingersItemInfo> list = null;
        if (this.pageType == 1) {
            list = data.getAllList();
        } else if (this.pageType == 2) {
            list = data.getFemaleList();
        } else if (this.pageType == 3) {
            list = data.getMaleList();
        } else if (this.pageType == 4) {
            list = data.getBandList();
        }
        if (null == list || list.isEmpty()) {
            this.mStatusLayout.showNoData();
            this.mSlidebar.setVisibility(8);
        } else {
            this.mStatusLayout.hideAllStatus();
            this.mSlidebar.setVisibility(0);
            this.mList.clear();
            this.mList.addAll(list);
            this.initCharList(list);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void showError() {
        this.mStatusLayout.showError();
    }

    public void setOnSelectSingerListener(ISelectSingerListener listener) {
        this.mAdapter.setOnSelectSingerListener(listener);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PageType {
    }
}

