/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.ktvplayer;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.audioplay.IAudioPlayerListener;
import com.yy.appbase.service.audioplay.IAudioPlayerService;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.KTVPlayerInfo;
import com.yy.hiyo.channel.plugins.ktv.ktvplayer.IKTVPlayerUiCallback;
import com.yy.hiyo.channel.plugins.ktv.ktvplayer.KTVPlayerPage;
import com.yy.hiyo.channel.plugins.ktv.ktvplayer.KTVPlayerWindow;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.KTVDownloadUtils;
import com.yy.hiyo.channel.plugins.ktv.model.record.RecordCompleteDialog;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001.B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u0012\u0010\u001b\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\bH\u0016J\u0012\u0010%\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0012\u0010(\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0012\u0010)\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\b\u0010+\u001a\u00020\u0012H\u0016J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\bH\u0016J\b\u0010-\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/ktvplayer/KTVPlayerController;", "Lcom/yy/appbase/core/DefaultWindowController;", "Lcom/yy/hiyo/channel/plugins/ktv/ktvplayer/IKTVPlayerUiCallback;", "Lcom/yy/appbase/service/audioplay/IAudioPlayerListener;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "mFrom", "", "mInitRunnable", "Ljava/lang/Runnable;", "mKTVPlayerInfo", "Lcom/yy/hiyo/channel/base/bean/KTVPlayerInfo;", "mRecordCompleteDialog", "Lcom/yy/hiyo/channel/plugins/ktv/model/record/RecordCompleteDialog;", "mWindow", "Lcom/yy/hiyo/channel/plugins/ktv/ktvplayer/KTVPlayerWindow;", "back", "", "closeWindow", "downloadLyric", "getAudioPlayerService", "Lcom/yy/appbase/service/audioplay/IAudioPlayerService;", "handleMessage", "msg", "Landroid/os/Message;", "initView", "onDataCapture", "data", "", "onDurationChanged", "duration", "onPlayComplete", "onProgressChanged", "position", "onStateChanged", "state", "onWindowAttach", "abstractWindow", "Lcom/yy/framework/core/ui/AbstractWindow;", "onWindowDetach", "onWindowShown", "pause", "resume", "seekTo", "showWindow", "Companion", "ktv_release"})
public final class KTVPlayerController
extends DefaultWindowController
implements IKTVPlayerUiCallback,
IAudioPlayerListener {
    private KTVPlayerWindow mWindow;
    private KTVPlayerInfo mKTVPlayerInfo;
    private RecordCompleteDialog mRecordCompleteDialog;
    private Runnable mInitRunnable;
    private int mFrom;
    @NotNull
    public static final String TAG = "KTVPlayerController";
    public static final Companion Companion = new Companion(null);

    public void handleMessage(@NotNull Message msg) {
        Bundle bundle;
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        super.handleMessage(msg);
        if (msg.what == ChannelBaseMsgDef.OPEN_KTV_PLAYER_PAGE && (bundle = msg.getData()) != null) {
            Serializable ktvPlayerInfo = bundle.getSerializable("KTVPlayerInfo");
            Serializable recordCompleteDialog = bundle.getSerializable("RecordCompleteDialog");
            if (ktvPlayerInfo instanceof KTVPlayerInfo) {
                this.mKTVPlayerInfo = (KTVPlayerInfo)ktvPlayerInfo;
                this.mFrom = msg.arg1;
                if (this.mFrom != 1) {
                    String channelId;
                    IChannelCenterService iChannelCenterService = (IChannelCenterService)ServiceManagerProxy.getInstance().getService(IChannelCenterService.class);
                    String string2 = iChannelCenterService != null && (iChannelCenterService = iChannelCenterService.getCurrentChannel()) != null ? iChannelCenterService.getChannelId() : (channelId = null);
                    if (!FP.empty((CharSequence)channelId)) {
                        this.sendMessage(AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL, -1, -1, channelId);
                    }
                }
                MLog.info((Object)TAG, (String)("KTVPlayerInfo: " + this.mKTVPlayerInfo), (Object[])new Object[0]);
                this.showWindow();
                this.mRecordCompleteDialog = recordCompleteDialog instanceof RecordCompleteDialog ? (RecordCompleteDialog)recordCompleteDialog : null;
                this.mInitRunnable = new Runnable(this){
                    final /* synthetic */ KTVPlayerController this$0;

                    public final void run() {
                        KTVPlayerController.access$initView(this.this$0);
                    }
                    {
                        this.this$0 = kTVPlayerController;
                    }
                };
            }
        }
    }

    private final void initView() {
        Object object;
        Object object2 = this.mWindow;
        if (object2 != null && (object2 = object2.getPage()) != null) {
            KTVPlayerInfo kTVPlayerInfo = this.mKTVPlayerInfo;
            KTVPlayerInfo kTVPlayerInfo2 = this.mKTVPlayerInfo;
            KTVPlayerInfo kTVPlayerInfo3 = this.mKTVPlayerInfo;
            ((KTVPlayerPage)((Object)object2)).initSongInfo(kTVPlayerInfo != null ? kTVPlayerInfo.getSongName() : null, kTVPlayerInfo2 != null ? kTVPlayerInfo2.getSinger() : null, kTVPlayerInfo3 != null ? kTVPlayerInfo3.getSongCover() : null);
        }
        if ((object = this.mWindow) != null && (object = ((KTVPlayerWindow)((Object)object)).getPage()) != null) {
            ((KTVPlayerPage)((Object)object)).setPauseView();
        }
        KTVPlayerInfo kTVPlayerInfo = this.mKTVPlayerInfo;
        if (!FP.empty((CharSequence)(kTVPlayerInfo != null ? kTVPlayerInfo.getSongUrl() : null))) {
            IAudioPlayerService iAudioPlayerService = this.getAudioPlayerService();
            if (iAudioPlayerService != null) {
                iAudioPlayerService.addAudioPlayerListener((IAudioPlayerListener)this);
            }
            IAudioPlayerService iAudioPlayerService2 = this.getAudioPlayerService();
            if (iAudioPlayerService2 != null) {
                KTVPlayerInfo kTVPlayerInfo4 = this.mKTVPlayerInfo;
                iAudioPlayerService2.play(kTVPlayerInfo4 != null ? kTVPlayerInfo4.getSongUrl() : null);
            }
            IAudioPlayerService iAudioPlayerService3 = this.getAudioPlayerService();
            if (iAudioPlayerService3 != null) {
                iAudioPlayerService3.registerEnterMediaChannelNotify();
            }
        }
        KTVPlayerInfo kTVPlayerInfo5 = this.mKTVPlayerInfo;
        if (!FP.empty((CharSequence)(kTVPlayerInfo5 != null ? kTVPlayerInfo5.getLyricUrl() : null))) {
            this.downloadLyric();
        }
        this.mInitRunnable = null;
    }

    private final void showWindow() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
        Context context = this.mContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
        this.mWindow = new KTVPlayerWindow(context, this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
    }

    private final void closeWindow() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
        }
    }

    private final void downloadLyric() {
        String parentPath = KTVDownloadUtils.INSTANCE.getKTVLyricDir();
        Object object = this.mKTVPlayerInfo;
        if (object == null || (object = object.getSongId()) == null) {
            object = String.valueOf(System.currentTimeMillis());
        }
        String fileName = KTVDownloadUtils.INSTANCE.getLyricFileName((String)object);
        KTVPlayerInfo kTVPlayerInfo = this.mKTVPlayerInfo;
        String url = kTVPlayerInfo != null ? kTVPlayerInfo.getLyricUrl() : null;
        Downloader.Builder builder = new Downloader.Builder(url, parentPath, fileName);
        builder.setPriority(100);
        builder.setSupportContinueTransfer(true);
        builder.setTaskGroup(DownloadBussinessGroup.KTV_FILE);
        builder.setTaskSubGroup("lyric");
        builder.setCallBack(new IDownloadCallback(this){
            final /* synthetic */ KTVPlayerController this$0;

            public void onComplete(@Nullable Downloader downloader) {
                block1: {
                    Object object = KTVPlayerController.access$getMWindow$p(this.this$0);
                    if (object == null || (object = object.getPage()) == null) break block1;
                    Object object2 = downloader;
                    if (object2 == null || (object2 = object2.getFilePath()) == null) {
                        object2 = "";
                    }
                    ((KTVPlayerPage)((Object)object)).initLyricView((String)object2);
                }
            }

            public void onProgressChange(@Nullable Downloader downloader, long totalSize, long curSize) {
            }

            public void onError(@Nullable Downloader downloader, int errorType, @Nullable String errorInfo) {
            }

            public void onStart(@Nullable Downloader downloader) {
            }
            {
                this.this$0 = $outer;
            }
        });
        Downloader downloader = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)downloader, (String)"builder.build()");
        Downloader downloader2 = downloader;
        downloader2.start();
    }

    @Override
    public void pause() {
        block1: {
            Object object = this.mWindow;
            if (object != null && (object = object.getPage()) != null) {
                ((KTVPlayerPage)((Object)object)).setPauseView();
            }
            IAudioPlayerService iAudioPlayerService = this.getAudioPlayerService();
            if (iAudioPlayerService == null) break block1;
            iAudioPlayerService.pause();
        }
    }

    @Override
    public void resume() {
        block1: {
            Object object = this.mWindow;
            if (object != null && (object = object.getPage()) != null) {
                ((KTVPlayerPage)((Object)object)).setPlayView();
            }
            IAudioPlayerService iAudioPlayerService = this.getAudioPlayerService();
            if (iAudioPlayerService == null) break block1;
            iAudioPlayerService.resume();
        }
    }

    @Override
    public void back() {
        this.closeWindow();
    }

    public void onDurationChanged(int duration) {
        block0: {
            Object object = this.mWindow;
            if (object == null || (object = object.getPage()) == null) break block0;
            ((KTVPlayerPage)((Object)object)).setTotalTime(duration);
        }
    }

    public void onProgressChanged(int position) {
        block0: {
            Object object = this.mWindow;
            if (object == null || (object = object.getPage()) == null) break block0;
            ((KTVPlayerPage)((Object)object)).updateProgress(position);
        }
    }

    public void onStateChanged(int state) {
        block6: {
            Object object;
            if (state == 3) {
                Object object2;
                IAudioPlayerService iAudioPlayerService = this.getAudioPlayerService();
                if (iAudioPlayerService != null) {
                    FragmentActivity fragmentActivity = this.getActivity();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"activity");
                    iAudioPlayerService.enableVisualizer(true, (Activity)fragmentActivity);
                }
                if ((object2 = this.mWindow) != null && (object2 = ((KTVPlayerWindow)((Object)object2)).getPage()) != null) {
                    ((KTVPlayerPage)((Object)object2)).setPlayView();
                }
            } else {
                Object object3;
                IAudioPlayerService iAudioPlayerService = this.getAudioPlayerService();
                if (iAudioPlayerService != null) {
                    FragmentActivity fragmentActivity = this.getActivity();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"activity");
                    iAudioPlayerService.enableVisualizer(false, (Activity)fragmentActivity);
                }
                if ((object3 = this.mWindow) != null && (object3 = ((KTVPlayerWindow)((Object)object3)).getPage()) != null) {
                    ((KTVPlayerPage)((Object)object3)).clearMusicBar();
                }
            }
            if ((object = this.mWindow) == null || (object = ((KTVPlayerWindow)((Object)object)).getPage()) == null) break block6;
            ((KTVPlayerPage)((Object)object)).setSeekBarEnable(state == 2 || state == 3 || state == 4 || state == 5);
        }
    }

    public void onPlayComplete() {
        block0: {
            Object object = this.mWindow;
            if (object == null || (object = object.getPage()) == null) break block0;
            ((KTVPlayerPage)((Object)object)).setPauseView();
        }
    }

    public void onDataCapture(@Nullable byte[] data) {
        block0: {
            Object object = this.mWindow;
            if (object == null || (object = object.getPage()) == null) break block0;
            ((KTVPlayerPage)((Object)object)).setMusicBarData(data);
        }
    }

    public void onWindowAttach(@Nullable AbstractWindow abstractWindow) {
        block0: {
            super.onWindowAttach(abstractWindow);
            Object object = this.mWindow;
            if (object == null || (object = object.getPage()) == null) break block0;
            ((KTVPlayerPage)((Object)object)).windowAttach();
        }
    }

    public void onWindowShown(@Nullable AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.mInitRunnable != null) {
            YYTaskExecutor.postToMainThread((Runnable)this.mInitRunnable);
        }
    }

    public void onWindowDetach(@Nullable AbstractWindow abstractWindow) {
        Object object;
        super.onWindowDetach(abstractWindow);
        IAudioPlayerService iAudioPlayerService = this.getAudioPlayerService();
        if (iAudioPlayerService != null) {
            iAudioPlayerService.release();
        }
        if ((object = this.mWindow) != null && (object = ((KTVPlayerWindow)((Object)object)).getPage()) != null) {
            ((KTVPlayerPage)((Object)object)).windowDetach();
        }
        if (Intrinsics.areEqual((Object)abstractWindow, (Object)((Object)this.mWindow))) {
            this.mWindow = null;
            if (this.mFrom == 1 && this.mRecordCompleteDialog != null) {
                RecordCompleteDialog recordCompleteDialog = this.mRecordCompleteDialog;
                if (recordCompleteDialog == null) {
                    Intrinsics.throwNpe();
                }
                recordCompleteDialog.show();
            }
        }
    }

    @Override
    public void seekTo(int position) {
        block1: {
            IAudioPlayerService iAudioPlayerService = this.getAudioPlayerService();
            if (iAudioPlayerService != null) {
                iAudioPlayerService.seekTo(position);
            }
            IAudioPlayerService iAudioPlayerService2 = this.getAudioPlayerService();
            if (iAudioPlayerService2 == null) break block1;
            iAudioPlayerService2.resume();
        }
    }

    private final IAudioPlayerService getAudioPlayerService() {
        return (IAudioPlayerService)ServiceManagerProxy.getService(IAudioPlayerService.class);
    }

    public KTVPlayerController(@NotNull Environment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        super(env);
    }

    public static final /* synthetic */ void access$initView(KTVPlayerController $this) {
        $this.initView();
    }

    public static final /* synthetic */ KTVPlayerWindow access$getMWindow$p(KTVPlayerController $this) {
        return $this.mWindow;
    }

    public static final /* synthetic */ void access$setMWindow$p(KTVPlayerController $this, KTVPlayerWindow kTVPlayerWindow) {
        $this.mWindow = kTVPlayerWindow;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/ktvplayer/KTVPlayerController$Companion;", "", "()V", "TAG", "", "ktv_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

