/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.live;

import android.content.Context;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.hiyo.channel.cbase.module.common.BaseLivePresenter;
import com.yy.hiyo.channel.cbase.module.common.KtvRoomModel;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvLivePresenter;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvLiveView;
import com.yy.hiyo.channel.cbase.module.ktv.live.ILiveView;
import com.yy.hiyo.channel.cbase.utils.preference.RoomSetting;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.ktv.api.biz.QueryVideoAuthorityReq;
import net.ihago.ktv.api.biz.QueryVideoAuthorityRsp;
import net.ihago.ktv.api.biz.SwitchAVModeReq;
import net.ihago.ktv.api.biz.SwitchAVModeRsp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0005H\u0016J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0005H\u0002R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/live/KtvLivePresenter;", "Lcom/yy/hiyo/channel/cbase/module/common/BaseLivePresenter;", "Lcom/yy/framework/core/INotify;", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/IKtvLivePresenter;", "mIsRoomOwner", "", "mRoomId", "", "mIsOnSit", "mIsSinger", "(ZLjava/lang/String;ZZ)V", "getMIsOnSit", "()Z", "getMIsSinger", "mKtvLiveView", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/IKtvLiveView;", "checkNeedRestoreVideoState", "", "checkVideoWhiteList", "needShowVideoSchemeTip", "onSingEnd", "isBackground", "onSingStart", "reportVideoSchemeSwitch", "videoScheme", "setView", "iView", "start", "startLive", "isSwitchToStart", "useFront", "startTip", "stopLive", "isSwitchToEnd", "tryPublishStream", "autoOpenVideo", "ktv_release"})
public final class KtvLivePresenter
extends BaseLivePresenter
implements INotify,
IKtvLivePresenter {
    private IKtvLiveView mKtvLiveView;
    private final boolean mIsRoomOwner;
    private final String mRoomId;
    private final boolean mIsOnSit;
    private final boolean mIsSinger;

    public void startLive(boolean isSwitchToStart, boolean useFront) {
        this.setMLiveQualityLevel(0);
        super.startLive(isSwitchToStart, true);
        FeatureLog.i((String)"FTVoiceLive", (String)"startLive", (Object[])new Object[0]);
        if (isSwitchToStart) {
            KTVEventReportUtil.reportVideoOpen(this.mIsRoomOwner, this.mIsSinger, this.mIsOnSit);
        }
        this.reportVideoSchemeSwitch(true);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).switchFrontCamera(true);
    }

    protected void checkNeedRestoreVideoState() {
        this.setMNeedRestoreKtvVideoState(true);
    }

    public void start() {
        super.start();
        if (!this.getMHasStart()) {
            this.checkVideoWhiteList();
        } else {
            this.onSingStart(false);
        }
    }

    public void stopLive(boolean isSwitchToEnd) {
        FeatureLog.i((String)"FTVoiceLive", (String)("stopLive  isSwitchToEnd:" + isSwitchToEnd + " mHasStart:" + this.getMHasStart()), (Object[])new Object[0]);
        super.stopLive(isSwitchToEnd);
    }

    private final void tryPublishStream(boolean autoOpenVideo) {
        IKtvLiveView iKtvLiveView = this.mKtvLiveView;
        if (iKtvLiveView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mKtvLiveView");
        }
        iKtvLiveView.updateVideoIcon(autoOpenVideo, false);
        if (autoOpenVideo) {
            KtvRoomModel.INSTANCE.setMVideoScheme(SwitchAVModeReq.AVMode.AVMode_Video);
            this.checkNetWork();
        }
        KTVEventReportUtil.reportVideoIconExpose(this.mIsRoomOwner, this.mIsSinger, this.mIsOnSit);
    }

    public void setView(@NotNull IKtvLiveView iView) {
        Intrinsics.checkParameterIsNotNull((Object)iView, (String)"iView");
        this.mKtvLiveView = iView;
        iView.setPresenter((IKtvLivePresenter)this);
        this.setBaseView((ILiveView)iView);
    }

    public void startTip() {
        if (this.needShowVideoSchemeTip() && RoomSetting.isWhiteListUser) {
            IKtvLiveView iKtvLiveView = this.mKtvLiveView;
            if (iKtvLiveView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mKtvLiveView");
            }
            iKtvLiveView.showVideoSchemeTip();
        } else {
            boolean showRemoveWhiteList = RoomSetting.onLastIsWhiteList();
            if (showRemoveWhiteList) {
                IKtvLiveView iKtvLiveView = this.mKtvLiveView;
                if (iKtvLiveView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mKtvLiveView");
                }
                iKtvLiveView.showWhitelistChangeTip();
            }
        }
    }

    private final boolean needShowVideoSchemeTip() {
        boolean isFirstOpenVideo = RoomSetting.getPreference().getBoolean("FirstInRoom", true);
        if (isFirstOpenVideo) {
            RoomSetting.getPreference().edit().putBoolean("FirstInRoom", false).apply();
        }
        return isFirstOpenVideo;
    }

    public void onSingEnd(boolean isBackground) {
        FeatureLog.i((String)"FTVoiceLive", (String)("onSingEnd,mOnVideoMode:" + this.getMOnVideoMode() + " mHasPause:" + this.getMHasPause() + " isBackground:" + isBackground), (Object[])new Object[0]);
        super.onSingEnd(false);
    }

    public void onSingStart(boolean isBackground) {
        FeatureLog.i((String)"FTVoiceLive", (String)("onSingStart,mOnVideoMode:" + this.getMOnVideoMode() + " mHasPause:" + this.getMHasPause()), (Object[])new Object[0]);
        super.onSingStart(false);
    }

    private final void reportVideoSchemeSwitch(boolean videoScheme) {
        SwitchAVModeReq.AVMode mode = videoScheme ? SwitchAVModeReq.AVMode.AVMode_Video : SwitchAVModeReq.AVMode.AVMode_Audio;
        SwitchAVModeReq biz = new SwitchAVModeReq.Builder().mode(mode).build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)biz, (IProtoCallback)new SimpleProtoCallback<SwitchAVModeRsp>(){

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                FeatureLog.i((String)"FTVoiceLive", (String)("reportVideoSchemeSwitch onError:" + reason + " code:" + code), (Object[])new Object[0]);
            }

            public void onResponse(@Nullable SwitchAVModeRsp message) {
                super.onResponse((AndroidMessage)message);
                FeatureLog.i((String)"FTVoiceLive", (String)("reportVideoSchemeSwitch message:" + message), (Object[])new Object[0]);
            }
        });
    }

    private final void checkVideoWhiteList() {
        boolean autoOpenVideo = NetworkUtils.isWifiActive((Context)RuntimeContext.sApplicationContext) ? RoomSetting.lastOpenVideo() : (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) ? RoomSetting.lastOpenVideo() && RoomSetting.useMobileNetWork : false);
        this.setMOnVideoMode(autoOpenVideo);
        QueryVideoAuthorityReq biz = new QueryVideoAuthorityReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)biz, (IProtoCallback)new SimpleProtoCallback<QueryVideoAuthorityRsp>(this, autoOpenVideo){
            final /* synthetic */ KtvLivePresenter this$0;
            final /* synthetic */ boolean $autoOpenVideo;

            public void onResponse(@Nullable QueryVideoAuthorityRsp message) {
                super.onResponse((AndroidMessage)message);
                QueryVideoAuthorityRsp queryVideoAuthorityRsp = message;
                FeatureLog.i((String)"FTVoiceLive", (String)("checkVideoWhiteList onResponse:" + (queryVideoAuthorityRsp != null ? queryVideoAuthorityRsp.has_authority : null)), (Object[])new Object[0]);
                QueryVideoAuthorityRsp queryVideoAuthorityRsp2 = message;
                if (Intrinsics.areEqual((Object)(queryVideoAuthorityRsp2 != null ? queryVideoAuthorityRsp2.has_authority : null), (Object)true)) {
                    KtvLivePresenter.access$getMKtvLiveView$p(this.this$0).showHideVideoScheme(true, false);
                    KtvLivePresenter.access$tryPublishStream(this.this$0, this.$autoOpenVideo);
                    RoomSetting.isWhiteListUser = true;
                } else {
                    KtvLivePresenter.access$getMKtvLiveView$p(this.this$0).showHideVideoScheme(false, false);
                    RoomSetting.isWhiteListUser = false;
                    KtvLivePresenter.access$setMOnVideoMode$p(this.this$0, false);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                FeatureLog.i((String)"FTVoiceLive", (String)("checkVideoWhiteList onError:" + reason + " code:" + code), (Object[])new Object[0]);
                KtvLivePresenter.access$getMKtvLiveView$p(this.this$0).showHideVideoScheme(false, false);
                RoomSetting.isWhiteListUser = false;
                KtvLivePresenter.access$setMOnVideoMode$p(this.this$0, false);
            }
            {
                this.this$0 = $outer;
                this.$autoOpenVideo = $captured_local_variable$1;
            }
        });
    }

    public final boolean getMIsOnSit() {
        return this.mIsOnSit;
    }

    public final boolean getMIsSinger() {
        return this.mIsSinger;
    }

    public KtvLivePresenter(boolean mIsRoomOwner, @NotNull String mRoomId, boolean mIsOnSit, boolean mIsSinger) {
        Intrinsics.checkParameterIsNotNull((Object)mRoomId, (String)"mRoomId");
        super(mRoomId);
        this.mIsRoomOwner = mIsRoomOwner;
        this.mRoomId = mRoomId;
        this.mIsOnSit = mIsOnSit;
        this.mIsSinger = mIsSinger;
    }

    public static final /* synthetic */ IKtvLiveView access$getMKtvLiveView$p(KtvLivePresenter $this) {
        IKtvLiveView iKtvLiveView = $this.mKtvLiveView;
        if (iKtvLiveView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mKtvLiveView");
        }
        return iKtvLiveView;
    }

    public static final /* synthetic */ void access$setMKtvLiveView$p(KtvLivePresenter $this, IKtvLiveView iKtvLiveView) {
        $this.mKtvLiveView = iKtvLiveView;
    }

    public static final /* synthetic */ void access$tryPublishStream(KtvLivePresenter $this, boolean autoOpenVideo) {
        $this.tryPublishStream(autoOpenVideo);
    }

    public static final /* synthetic */ boolean access$getMOnVideoMode$p(KtvLivePresenter $this) {
        return $this.getMOnVideoMode();
    }

    public static final /* synthetic */ void access$setMOnVideoMode$p(KtvLivePresenter $this, boolean bl) {
        $this.setMOnVideoMode(bl);
    }
}

