/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.safelivedata.SafeLiveData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.ChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomData;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.RecommendSongMsg;
import com.yy.hiyo.channel.common.FacePoint;
import com.yy.hiyo.channel.component.base.ProxyPresenter;
import com.yy.hiyo.channel.component.music.musicplayer.MusicPlayerPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.base.FunctionInterceptor;
import com.yy.hiyo.channel.component.profile.profilecard.base.InterceptCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomFunctionInterceptor;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.plugins.ktv.IUICallback;
import com.yy.hiyo.channel.plugins.ktv.KTVMvp;
import com.yy.hiyo.channel.plugins.ktv.KTVRoomPageController;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVLifecycle;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVLifecycle;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.model.songList.KTVMusicListProvider;
import com.yy.hiyo.channel.plugins.ktv.publicscreen.KtvPublicScreen;
import com.yy.hiyo.channel.plugins.ktv.room.IRoomOperater;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.channel.plugins.ktv.widget.swipe.KTVSwipeContainer;
import com.yy.hiyo.channel.plugins.ktv.widget.swipe.KTVSwipeHelper;
import com.yy.hiyo.channel.plugins.voiceroom.IRoomPage;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.ktv.IKTVPluginPresenter;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.ihago.ktv.api.search.RankingType;
import org.jetbrains.annotations.NotNull;

public class KTVPresenter
extends IKTVPluginPresenter
implements KTVMvp.IPresenter,
IHolderPresenter,
IUICallback {
    private static final String TAG = "KTVPresenter";
    private KTVRoomPageController ktvRoomPageController;
    private HeadsetReceiver mHeadsetReceiver;
    private MutableLiveData<Boolean> isKtvMode;
    private static final long KEEP_IN_ROOM = 60000L;
    private boolean mIsRecommendTipsShow = false;
    private KtvPublicScreen ktvPublicScreen = new KtvPublicScreen();
    private KTVSwipeHelper mSwipeHelper = new KTVSwipeHelper();
    private boolean mLastIsSwipeOut = false;
    IKTVLifecycle iktvLifecycleInner = new KTVLifecycle(){

        @Override
        public void onCreate(KTVBaseContext context) {
        }

        @Override
        public void onVideoModeChange(boolean isVideoMode) {
            if (isVideoMode) {
                KTVPresenter.this.mSwipeHelper.setSwipeEnable(true);
                KTVPresenter.this.mSwipeHelper.swipeOut(KTVPresenter.this.mLastIsSwipeOut, false);
                KTVPresenter.this.mSwipeHelper.startGuideAnim();
            } else {
                KTVPresenter.this.mLastIsSwipeOut = KTVPresenter.this.mSwipeHelper.isSwipedOut();
                KTVPresenter.this.mSwipeHelper.reset();
                KTVPresenter.this.mSwipeHelper.setSwipeEnable(false);
            }
        }

        @Override
        public void onQuited(KTVBaseContext context) {
            super.onQuited(context);
            KTVPresenter.this.closeKTV();
            ((ProxyPresenter)KTVPresenter.this.getPresenter(ProxyPresenter.class)).closeCurrentPlugin(null);
        }

        @Override
        public void onDestroy(KTVBaseContext context) {
        }
    };
    private Runnable mRecommendSongRunnable = () -> {
        if (this.isDestroyed()) {
            FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable isDestroy", (Object[])new Object[0]);
            return;
        }
        if (this.getRoomData() == null) {
            FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable getRoomData null", (Object[])new Object[0]);
            return;
        }
        if (this.getKtvManager() == null) {
            FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable getKtvManager null", (Object[])new Object[0]);
            return;
        }
        if (this.getKtvManager().getKTVMusicListProvider() == null) {
            FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable getKTVMusiclistProvider null", (Object[])new Object[0]);
            return;
        }
        if (this.getRoomData().getRoomGame() != null && !"ktv".equals(this.getRoomData().getRoomGame().getPluginId())) {
            FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable not ktv, current gameId:%s", (Object[])new Object[]{this.getRoomData().getRoomGame().getPluginId()});
            return;
        }
        if (!this.getChannel().getSeatService().isInSeat(AccountUtil.getUid()) && !this.getChannel().getSeatService().isSeatFullWithLocked()) {
            FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable not in seat", (Object[])new Object[0]);
            List<KTVMusicInfo> ktvMusicInfos = this.getKtvManager().getKTVMusicListProvider().getMusicHistoryList();
            if (ktvMusicInfos == null || ktvMusicInfos != null && ktvMusicInfos.size() == 0) {
                this.getKtvManager().getKTVMusicListProvider().getRankingList(RankingType.kRankingAll, true, new IKTVProtoCallback<KTVMusicListProvider.KTVSongListResponse>(){

                    @Override
                    public void onSuccess(@NonNull KTVMusicListProvider.KTVSongListResponse data) {
                        if (data == null || KTVPresenter.this.isDestroyed()) {
                            FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable getRankingList null", (Object[])new Object[0]);
                            return;
                        }
                        List<KTVMusicInfo> ktvMusicInfoList = data.songList;
                        if (ktvMusicInfoList == null || ktvMusicInfoList != null && ktvMusicInfoList.size() == 0) {
                            FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable getRankingList songList null", (Object[])new Object[0]);
                            return;
                        }
                        Random random = new Random();
                        int index = random.nextInt(ktvMusicInfoList.size());
                        if (ktvMusicInfoList.size() > index) {
                            FeatureLog.i((String)"FTKTVBase", (String)"getRankingList songList:%s, index:%s", (Object[])new Object[]{ktvMusicInfoList, index});
                            KTVPresenter.this.mIsRecommendTipsShow = true;
                            KTVEventReportUtil.reportGuideShow();
                            KTVMusicInfo ktvMusicInfo = ktvMusicInfoList.get(index);
                            String song = "\u300a" + ktvMusicInfo.getSongName() + "\u300b";
                            String tips = ResourceUtils.getString((int)R.string.tips_hot_song, (Object[])new Object[]{song});
                            SpannableString spannableString = new SpannableString((CharSequence)tips);
                            ForegroundColorSpan colorSpan = new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.channel_chat_text_link));
                            int indexStr = tips.indexOf(song);
                            spannableString.setSpan((Object)colorSpan, indexStr, indexStr + song.length(), 17);
                            RecommendSongMsg baseImMsg = KTVPresenter.this.ktvPublicScreen.generateRecommendSong(KTVPresenter.this.getChannel().getChannelId(), ktvMusicInfo, (CharSequence)spannableString, ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory());
                            ((IPublicScreenModulePresenter)KTVPresenter.this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().appendLocalMsg((BaseImMsg)baseImMsg);
                        }
                    }

                    @Override
                    public void onError(int code, String errorMessage) {
                        FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable getRankingList error, code:%s, msg:%s", (Object[])new Object[]{code, errorMessage});
                    }
                });
                return;
            }
            Random random = new Random();
            int index = random.nextInt(ktvMusicInfos.size());
            if (ktvMusicInfos.size() > index) {
                this.mIsRecommendTipsShow = true;
                FeatureLog.i((String)"FTKTVBase", (String)"mRecommendSongRunnable songList:%s, index:%s", (Object[])new Object[]{ktvMusicInfos, index});
                KTVMusicInfo ktvMusicInfo = ktvMusicInfos.get(index);
                String song = "\u300a" + ktvMusicInfo.getSongName() + "\u300b";
                String tips = ResourceUtils.getString((int)R.string.tips_show_song, (Object[])new Object[]{song});
                SpannableString spannableString = new SpannableString((CharSequence)tips);
                ForegroundColorSpan colorSpan = new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.channel_chat_text_link));
                int indexStr = tips.indexOf(song);
                spannableString.setSpan((Object)colorSpan, indexStr, indexStr + song.length(), 17);
                RecommendSongMsg baseImMsg = this.ktvPublicScreen.generateRecommendSong(this.getChannel().getChannelId(), ktvMusicInfo, (CharSequence)spannableString, ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory());
                ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().appendLocalMsg((BaseImMsg)baseImMsg);
                KTVEventReportUtil.reportGuideShow();
            }
        }
    };

    public void onInit(IChannelPageContext<AbsPage> mvpContext) {
        super.onInit(mvpContext);
        this.isKtvMode = new SafeLiveData();
        IPublicScreenModulePresenter publicScreenPresenter = (IPublicScreenModulePresenter)mvpContext.getPresenter(IPublicScreenModulePresenter.class);
        publicScreenPresenter.addItemActionListener(this.ktvPublicScreen.getItemAction().action((IMvpContext)mvpContext));
        ((SeatPresenter)this.getPresenter(SeatPresenter.class)).setInterceptListener(() -> {
            if (this.hasMySingingSong()) {
                OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_delete_song_after_leave_seat), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, false, new OkCancelDialogListener(){

                    public void onCancel() {
                        if (((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager() != null) {
                            ((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
                        }
                    }

                    public void onOk() {
                        ((SeatPresenter)KTVPresenter.this.getPresenter(SeatPresenter.class)).onStandUp();
                        KTVEventReportUtil.reportSongListDelClick("4");
                    }
                });
                dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog2) {
                        if (((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager() != null) {
                            ((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
                        }
                    }
                });
                ((IChannelPageContext)this.getMvpContext()).getDialogLinkManager().showDialog((BaseDialog)dialog2);
                return true;
            }
            return false;
        });
    }

    public void setContainer(@NonNull YYPlaceHolderView container) {
        super.setContainer(container);
        YYFrameLayout virtualView = new YYFrameLayout((Context)this.getContext());
        container.inflate((View)virtualView);
        this.startKTV(virtualView, ((IRoomPage)this.getPage()).getBaseWindow().getPanelLayer());
    }

    @Override
    public void initSwipeHelper() {
        this.mSwipeHelper.initSwipeView((KTVSwipeContainer)Objects.requireNonNull(this.getPage().findViewById(R.id.swipe_container)));
        this.mSwipeHelper.setSwipeEnable(false);
        this.mSwipeHelper.addScrollView(this.getPage().getPageView().findViewById(R.id.topBarHolder));
        this.mSwipeHelper.addScrollView(this.getPage().findViewById(R.id.topNoticeHolder));
        this.mSwipeHelper.addScrollView(this.getPage().findViewById(R.id.noticeHolder));
        this.mSwipeHelper.addScrollView(this.getPage().findViewById(R.id.giftContributeHolder));
        this.mSwipeHelper.addScrollView(this.getPage().findViewById(R.id.topLeftActivityHolder));
        this.mSwipeHelper.addScrollView(this.getPage().findViewById(R.id.debugHolder));
        if (this.ktvRoomPageController != null) {
            this.mSwipeHelper.addScrollViews(this.ktvRoomPageController.getScrollViews());
        }
    }

    @Override
    public boolean startKTV(YYFrameLayout panelContainer, PanelLayer listContainer) {
        MLog.info((Object)TAG, (String)"startKTV", (Object[])new Object[0]);
        if (this.ktvRoomPageController == null) {
            this.ktvRoomPageController = new KTVRoomPageController((ChannelPageContext<AbsPage>)((ChannelPageContext)this.getMvpContext()), this.iktvLifecycleInner);
        }
        this.setStartKTVDate();
        this.ktvRoomPageController.startKTV(panelContainer, listContainer);
        ((MusicPlayerPresenter)this.getPresenter(MusicPlayerPresenter.class)).stopMusic(false);
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class) != null) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableAudioPlaySpectrum(true);
        }
        this.ktvRoomPageController.setUICallback(this);
        this.ktvRoomPageController.setCommRoomCallback(new IRoomOperater.IExtRoomOperater(){

            @Override
            public boolean onSitDownRandom(Callback callback) {
                ((SeatPresenter)KTVPresenter.this.getPresenter(SeatPresenter.class)).onSitDown(-1, callback);
                return true;
            }
        });
        this.registerHeadsetReceiver();
        FeatureLog.i((String)"FTKTVBase", (String)"startKTV\uff0crecommendTipsShow:%s", (Object[])new Object[]{this.mIsRecommendTipsShow});
        if (!this.mIsRecommendTipsShow) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRecommendSongRunnable);
            YYTaskExecutor.postToMainThread((Runnable)this.mRecommendSongRunnable, (long)60000L);
        }
        if (this.getKtvManager() != null && this.getKtvManager().getKTVMusicListProvider() != null) {
            this.getKtvManager().getKTVMusicListProvider().getRankingList(RankingType.kRankingAll, true, null);
        }
        ((ProfileCardPresenter)this.getPresenter(ProfileCardPresenter.class)).setFunctionInterceptor((FunctionInterceptor)new VoiceRoomFunctionInterceptor(){

            public void onLeaveSeatSelf(long uid, final @NotNull InterceptCallback cb) {
                if (KTVPresenter.this.hasMySingingSong()) {
                    OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_delete_song_after_leave_seat), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, false, new OkCancelDialogListener(){

                        public void onCancel() {
                            if (((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager() != null) {
                                ((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
                            }
                        }

                        public void onOk() {
                            cb.done();
                            KTVEventReportUtil.reportSongListDelClick("4");
                        }
                    });
                    dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog2) {
                            if (((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager() != null) {
                                ((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
                            }
                        }
                    });
                    ((IChannelPageContext)KTVPresenter.this.getMvpContext()).getDialogLinkManager().showDialog((BaseDialog)dialog2);
                } else {
                    cb.done();
                }
            }
        });
        return true;
    }

    @Override
    public boolean closeKTV() {
        FeatureLog.i((String)"FTKTVBase", (String)"closeKTV", (Object[])new Object[0]);
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class) != null) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableReverb(false);
        }
        this.unregisterHeadsetReceiver();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRecommendSongRunnable);
        if (this.ktvRoomPageController != null) {
            this.ktvRoomPageController.closeKTV();
            this.ktvRoomPageController = null;
        }
        return true;
    }

    @Override
    public boolean hasMySingingSong() {
        int count = 0;
        if (this.ktvRoomPageController != null && this.ktvRoomPageController.getKTVManager() != null && this.ktvRoomPageController.getKTVManager().getKTVRoomServices().getMySongList() != null) {
            count = this.ktvRoomPageController.getKTVManager().getKTVRoomServices().getMySongList().size();
        }
        return count > 0;
    }

    @Override
    public void terminateSong() {
        FeatureLog.i((String)"FTKTVBase", (String)"terminate song", (Object[])new Object[0]);
        if (this.ktvRoomPageController == null) {
            return;
        }
        IKTVManager ktvManager = this.ktvRoomPageController.getKTVManager();
        if (ktvManager == null) {
            return;
        }
        KTVRoomData currentKTVRoomData = ktvManager.getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        String songId = currentSongInfo.getSongId();
        FeatureLog.i((String)"FTKTVBase", (String)"terminate song id: %s", (Object[])new Object[]{songId});
        if (StringUtils.isNotEmpty((String)songId)) {
            ktvManager.getKTVRoomServices().terminateSong(songId, 1, null);
        }
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        if (this.ktvRoomPageController != null) {
            this.ktvRoomPageController.onPageDetach();
        }
    }

    @Override
    public boolean isSinging() {
        if (this.ktvRoomPageController == null) {
            return false;
        }
        IKTVManager ktvManager = this.ktvRoomPageController.getKTVManager();
        if (ktvManager == null) {
            return false;
        }
        KTVRoomData currentKTVRoomData = ktvManager.getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return false;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return false;
        }
        return currentSongInfo.getStatus() == 1 || currentSongInfo.getStatus() == 2;
    }

    @Override
    public void startGiftSvga(String url, long recvUid, int propsId) {
        if (this.ktvRoomPageController == null) {
            return;
        }
        IKTVManager ktvManager = this.ktvRoomPageController.getKTVManager();
        if (ktvManager == null) {
            return;
        }
        KTVRoomData currentKTVRoomData = ktvManager.getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        long uid = currentKTVRoomData.getCurrentSongInfo().getUid();
        if (recvUid == uid && this.ktvRoomPageController != null) {
            this.ktvRoomPageController.startGiftSvga(url, propsId, uid);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        FeatureLog.i((String)"FTKTVBase", (String)"onDestroy", (Object[])new Object[0]);
        this.closeKTV();
    }

    public void setStartKTVDate() {
        if (!SettingFlags.getBoolean((String)"key_ktv_hasjoin", (boolean)false)) {
            SettingFlags.setBoolean((String)"key_ktv_hasjoin", (boolean)true);
        }
    }

    private void registerHeadsetReceiver() {
        if (this.mHeadsetReceiver != null) {
            return;
        }
        this.mHeadsetReceiver = new HeadsetReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.HEADSET_PLUG");
        this.getContext().registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, filter);
    }

    private void unregisterHeadsetReceiver() {
        if (null != this.mHeadsetReceiver) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
            this.mHeadsetReceiver = null;
        }
    }

    public boolean addSongFromChat(String songId, KTVCommonCallback callback) {
        if (this.ktvRoomPageController == null) {
            FeatureLog.i((String)"FTKTVBase", (String)"addSongFromChat ktvRoomPageController null", (Object[])new Object[0]);
            ToastUtils.showToast((Context)this.getContext(), (int)R.string.short_tips_choose_fail);
            return false;
        }
        if (this.getRoomData().getRoomGame() != null && !"ktv".equals(this.getRoomData().getRoomGame().getPluginId())) {
            FeatureLog.i((String)"FTKTVBase", (String)"addSongFromChat not ktv, current gameId:%s", (Object[])new Object[]{this.getRoomData().getRoomGame().getPluginId()});
            ToastUtils.showToast((Context)this.getContext(), (int)R.string.short_tips_choose_fail);
            return false;
        }
        if (!this.getChannel().getSeatService().isInSeat(AccountUtil.getUid()) && !this.getRoomData().isPlayManager(AccountUtil.getUid()) && this.getChannel().getSeatService().isSeatFullWithLocked()) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.select_song_must_inseat), (int)0);
            return false;
        }
        return this.ktvRoomPageController.addSongFromChat(songId, callback);
    }

    @Nullable
    public IKTVManager getKtvManager() {
        if (this.ktvRoomPageController != null) {
            return this.ktvRoomPageController.getKTVManager();
        }
        return null;
    }

    @Override
    public MutableLiveData<Boolean> getIsKtvMode() {
        return this.isKtvMode;
    }

    @Override
    public KTVRoomSongInfo getCurSongInfo() {
        if (this.ktvRoomPageController != null && this.ktvRoomPageController.getKTVManager() != null) {
            return this.ktvRoomPageController.getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo();
        }
        return null;
    }

    private FragmentActivity getContext() {
        return ((IChannelPageContext)this.getMvpContext()).getContext();
    }

    public void handleModeChange(long mode) {
        super.handleModeChange(mode);
        this.isKtvMode.setValue((Object)true);
        this.setGameContainerVisibility(true);
        this.setSeatViewVisibility(true);
    }

    public IPlugin.InterceptPluginChange canBeRemoveWhileRunning(@Nullable GameInfo cur, @Nullable GameInfo next) {
        IPlugin.InterceptPluginChange intercept = new IPlugin.InterceptPluginChange();
        intercept.canChange = this.ktvRoomPageController == null || this.ktvRoomPageController.getKTVManager() == null || this.ktvRoomPageController.getKTVManager().getKTVRoomServices() == null || this.ktvRoomPageController.getKTVManager().getKTVRoomServices().getKTVRoomSongInfoList().isEmpty();
        return intercept;
    }

    public boolean canChangeSeat() {
        return true;
    }

    public boolean haveSelfFaceLocation() {
        return false;
    }

    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        return null;
    }

    public boolean interceptRunningState() {
        return false;
    }

    public boolean interceptModeChange() {
        if (this.getRoomData() != null && this.getRoomData().getRoomInfo() != null && !this.getRoomData().getRoomInfo().isRoomOwner(AccountUtil.getUid())) {
            this.closeKTV();
        }
        return super.interceptModeChange();
    }

    @Override
    public void audioPlaying() {
        long status = this.getChannel().getSeatService().getSeatStatus(AccountUtil.getUid());
        MLog.info((Object)TAG, (String)("Record complete play audio && close mic , status: " + status), (Object[])new Object[0]);
        if (SeatStatusUtils.isMicOpen((long)status)) {
            this.getChannel().getMediaService().disablePublishMic(1);
        }
    }

    @Override
    public void operLocalMic(boolean open) {
        long status = this.getChannel().getSeatService().getSeatStatus(AccountUtil.getUid());
        MLog.info((Object)TAG, (String)("Record complete play audio && close mic , status: " + status), (Object[])new Object[0]);
        if (SeatStatusUtils.isMicOpen((long)status) && !open) {
            this.getChannel().getMediaService().disablePublishMic(1);
            MLog.info((Object)TAG, (String)"operLocalMic CLOSE MIC", (Object[])new Object[0]);
        } else if (SeatStatusUtils.isMicClose((long)status) && open) {
            this.getChannel().getMediaService().enablePublishMic(1);
            MLog.info((Object)TAG, (String)"operLocalMic OPEN MIC", (Object[])new Object[0]);
        }
    }

    private class HeadsetReceiver
    extends BroadcastReceiver {
        private HeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra("state") && null != KTVPresenter.this.ktvRoomPageController && null != KTVPresenter.this.ktvRoomPageController.getKTVManager()) {
                if (intent.getIntExtra("state", 0) == 0) {
                    FeatureLog.i((String)"FTKTVPlayer", (String)"\u8033\u673a\u62d4\u51fa", (Object[])new Object[0]);
                    KTVPresenter.this.ktvRoomPageController.getKTVManager().getKTVRoomServices().setHeadset(false);
                    if (null != KTVPresenter.this.ktvRoomPageController.getKTVPanelPresenter() && null != KTVPresenter.this.ktvRoomPageController.getKTVPanelPresenter().getView()) {
                        KTVPresenter.this.ktvRoomPageController.getKTVPanelPresenter().getView().headsetChanged(false);
                    }
                } else if (intent.getIntExtra("state", 0) == 1) {
                    FeatureLog.i((String)"FTKTVPlayer", (String)"\u8033\u673a\u63d2\u5165", (Object[])new Object[0]);
                    KTVPresenter.this.ktvRoomPageController.getKTVManager().getKTVRoomServices().setHeadset(true);
                    if (null != KTVPresenter.this.ktvRoomPageController.getKTVPanelPresenter() && null != KTVPresenter.this.ktvRoomPageController.getKTVPanelPresenter().getView()) {
                        KTVPresenter.this.ktvRoomPageController.getKTVPanelPresenter().getView().headsetChanged(true);
                    }
                    KTVEventReportUtil.reportHeadsetIn(KTVPresenter.this.ktvRoomPageController.getmRoomDataContainer().getRoomInfo().isRoomOwner(AccountUtil.getUid()), KTVPresenter.this.ktvRoomPageController.getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().isSinger(), KTVPresenter.this.getChannel().getSeatService().isInSeat(AccountUtil.getUid()));
                }
            }
        }
    }
}

