/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.web;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;

public class SendImageMsgJsEvent
implements JsEvent {
    private static final String TAG = "SendImageMsgJsEvent";

    @NonNull
    public JsMethod method() {
        return JsEventDefine.IM.sendIMImageMessage;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            this.callbackErr(callback, 0, "paramJson is null");
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SendImageMsgJsEvent.this.sendImageMsg(param, callback);
            }
        });
    }

    private void sendImageMsg(@NonNull String paramJson, @Nullable IJsEventCallback callback) {
        ImageMsgParam param = null;
        try {
            param = (ImageMsgParam)JsonParser.parseJsonObject((String)paramJson, ImageMsgParam.class);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"json\u89e3\u6790\u5f02\u5e38", (Object[])new Object[0]);
            param = null;
        }
        if (param != null) {
            ImageMsgParam finalParam = param;
            YYTaskExecutor.execute(() -> {
                Pair pair = ImDataFactory.INSTANCE.sendImageMsg("", finalParam.url, true, "", finalParam.uid, finalParam.avatar, finalParam.nick, finalParam.width, finalParam.height, 0, null, 0, false, null, false);
                if (ServiceManagerProxy.getServiceManager() != null) {
                    ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().sendOldIMToDbMsg((ImMsgReqParam)pair.first, (ImMessageDBBean)pair.second, null);
                }
            });
        } else {
            this.callbackErr(callback, 0, "paramJson is illegal");
        }
    }

    private void callbackErr(@Nullable IJsEventCallback callback, int code, String msg) {
        if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)code, (String)msg);
            callback.callJs((IJsParam)err);
        }
    }

    @DontProguardClass
    static class ImageMsgParam {
        @SerializedName(value="uid")
        long uid;
        @SerializedName(value="url")
        String url;
        @SerializedName(value="nick")
        String nick;
        @SerializedName(value="avatar")
        String avatar;
        @SerializedName(value="width")
        int width;
        @SerializedName(value="height")
        int height;

        ImageMsgParam() {
        }
    }
}

