/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.viewmodel;

import android.app.Activity;
import android.app.Application;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModelProviders;
import com.yy.appbase.service.IServiceManager;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.im.viewmodel.mvvm.AbstractAndroidViewModel;
import java.lang.ref.WeakReference;

public class BizViewModel
extends AbstractAndroidViewModel
implements INotify {
    private IServiceManager mService;
    private WeakReference<DialogLinkManager> mDialogManagerWeakReference;
    private WeakReference<Activity> mAty;

    public BizViewModel(@NonNull Application application) {
        super(application);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    public IServiceManager getService() {
        return this.mService;
    }

    protected BizViewModel setService(IServiceManager mService) {
        this.mService = mService;
        return this;
    }

    protected BizViewModel setDialogManager(DialogLinkManager dialogManager) {
        this.mDialogManagerWeakReference = new WeakReference<DialogLinkManager>(dialogManager);
        return this;
    }

    public Activity getAty() {
        return this.mAty != null ? (Activity)this.mAty.get() : null;
    }

    protected BizViewModel setAty(Activity mAty) {
        this.mAty = new WeakReference<Activity>(mAty);
        return this;
    }

    public DialogLinkManager getDialogManager() {
        if (this.mDialogManagerWeakReference != null) {
            return (DialogLinkManager)this.mDialogManagerWeakReference.get();
        }
        return null;
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            this.resetWhenLogout();
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            boolean isForeground = (Boolean)notification.extObj;
            if (isForeground) {
                this.onResume();
            } else {
                this.onPause();
            }
        }
    }

    protected void resetWhenLogout() {
    }

    public static <VM extends BizViewModel> VM getVM(FragmentActivity aty, Class<VM> clazz, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        return (VM)((BizViewModel)ViewModelProviders.of((FragmentActivity)aty).get(clazz)).setAty((Activity)aty).setDialogManager(dialogLinkManager).setService(serviceManager);
    }
}

