/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.window;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.bbs.DiscoverABHelper;
import com.yy.hiyo.bbs.base.BBSUtils;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.im.R;
import com.yy.im.interfaces.OnItemDataClickListener;
import com.yy.im.interfaces.OnItemDataLongClickListener;
import com.yy.im.model.ChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.ui.component.FbTipsComponent;
import com.yy.im.ui.component.StrangeChatSessionListComponent;
import com.yy.im.ui.widget.DeleteConfirmDialog;
import com.yy.im.ui.widget.OnDeleteDialogCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.base.srv.strategy.GetUserStatusRes;
import net.ihago.base.srv.strategy.UserStatus;
import org.jetbrains.annotations.NotNull;

public class StrangerSessionWindow
extends DefaultWindow {
    private StrangeChatSessionListComponent viewComponent;
    private FbTipsComponent mEmptyComponent;
    private MutableLiveData<List<ChatSession>> mSessions;
    private YYFrameLayout container;
    private final SimpleTitleBar mStb;
    private MutableLiveData<Boolean> mPageState = new MutableLiveData();
    View.OnClickListener mRemoveDoneListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (StrangerSessionWindow.this.viewComponent.getReadyToRemoveSessions().size() > 0) {
                StrangerSessionWindow.this.showDeleteConfirmDialog();
            } else {
                StrangerSessionWindow.this.viewComponent.setRemovable(false, false);
                StrangerSessionWindow.this.mStb.setRightBtn(R.drawable.icon_nav_delete, StrangerSessionWindow.this.mRemoveStartListener);
            }
        }
    };
    View.OnClickListener mRemoveStartListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (StrangerSessionWindow.this.mSessions.getValue() == null || ((List)StrangerSessionWindow.this.mSessions.getValue()).size() <= 0) {
                return;
            }
            StrangerSessionWindow.this.mStb.setRightBtn((CharSequence)ResourceUtils.getString((int)R.string.btn_stranger_delete_done), StrangerSessionWindow.this.mRemoveDoneListener);
            StrangerSessionWindow.this.viewComponent.setRemovable(true, false);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "delete_click"));
        }
    };
    private Observer<List<ChatSession>> mObserver = new Observer<List<ChatSession>>(){

        public void onChanged(@Nullable List<ChatSession> chatSessions) {
            if (StrangerSessionWindow.this.container == null) {
                return;
            }
            StrangerSessionWindow.this.container.removeAllViews();
            if (chatSessions == null || chatSessions.isEmpty()) {
                StrangerSessionWindow.this.container.addView(StrangerSessionWindow.this.mEmptyComponent.getRoot());
            } else {
                StrangerSessionWindow.this.container.addView(StrangerSessionWindow.this.viewComponent.getRoot());
                StrangerSessionWindow.this.getUserDistanceOnline();
            }
        }
    };
    private Map<Long, Long> mChatSessionDistanceCache = new HashMap<Long, Long>();

    public StrangerSessionWindow(Context context, final UICallBacks callBacks, OnItemDataClickListener listener, MutableLiveData<List<ChatSession>> sessions, OnItemDataLongClickListener longClickListener) {
        super(context, callBacks, "StrangerSessionWindow");
        LayoutInflater.from((Context)context).inflate(R.layout.im_stranger_session_window, this.getBaseLayer());
        this.mStb = (SimpleTitleBar)this.findViewById(R.id.stb);
        this.mStb.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                if (callBacks != null) {
                    callBacks.onWindowExitEvent(true);
                }
            }
        });
        this.mStb.setLeftTitle(ResourceUtils.getString((int)R.string.title_stranger_message));
        this.mSessions = sessions;
        this.container = (YYFrameLayout)this.findViewById(R.id.fl_container);
        this.viewComponent = new StrangeChatSessionListComponent(context, (ViewGroup)this.container, listener, this.mSessions, longClickListener, ((ImModule)KvoModuleManager.getModule(ImModule.class)).getSessionMsgUIMapper(2), 2);
        this.viewComponent.setPageCallback((LiveData<Boolean>)this.mPageState);
        this.mEmptyComponent = new FbTipsComponent(context, (ViewGroup)this.container, null);
        this.mEmptyComponent.iconTopMargin(ResolutionUtils.dip2Px((float)80.0f)).icon(R.drawable.icon_connect_facebook).showHeaderDiv(false).tip1TopMargin(ResolutionUtils.dip2Px((float)20.0f)).tip2TopMargin(ResolutionUtils.dip2Px((float)14.0f)).tips1Text(ResourceUtils.getString((int)R.string.friends_tips1)).tips2Text(ResourceUtils.getString((int)R.string.no_match_tips)).funcStyle(0);
        this.mSessions.observe((LifecycleOwner)context, this.mObserver);
    }

    private void getUserDistanceOnline() {
        if (NAB.A.equals((Object)DiscoverABHelper.getRecValue()) || this.mSessions == null) {
            return;
        }
        final ArrayList<Long> uidList = new ArrayList<Long>();
        final HashMap<Long, ChatSession> toGetSessions = new HashMap<Long, ChatSession>();
        for (ChatSession session : (List)this.mSessions.getValue()) {
            Long lastRequestTime;
            if (!(session instanceof SingleChatSession) || AccountUtil.getUid() == session.getUid() || (lastRequestTime = this.mChatSessionDistanceCache.get(session.getUid())) != null && System.currentTimeMillis() - lastRequestTime <= 60000L) continue;
            uidList.add(session.getUid());
            toGetSessions.put(session.getUid(), session);
        }
        if (uidList.size() <= 0) {
            return;
        }
        ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).requestUserOnlines(uidList, (SimpleProtoCallback)new SimpleProtoCallback<GetUserStatusRes>(){

            public void onResponse(@NonNull @NotNull GetUserStatusRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                MLog.info((Object)"AbstractWindow", (String)("getUserDistanceOnline : " + res.toString()), (Object[])new Object[0]);
                if (res.users.size() <= 0) {
                    return;
                }
                int myAge = DateUtils.getAge((String)((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo((long)AccountUtil.getUid()).birthday);
                try {
                    for (int i = 0; i < res.users.size(); ++i) {
                        UserStatus status = (UserStatus)res.users.get(i);
                        long uid = (Long)uidList.get(i);
                        ChatSession chatSession = (ChatSession)toGetSessions.get(uid);
                        if (chatSession == null) {
                            MLog.error((Object)"AbstractWindow", (String)("getUserDistanceOnline chatSession is null, uid: " + uid), (Object[])new Object[0]);
                            continue;
                        }
                        if (status.offline_at > 0L) {
                            chatSession.setOfflineTime(BBSUtils.INSTANCE.formatPostTimeWithMax(status.offline_at));
                        } else {
                            chatSession.setOfflineTime("");
                        }
                        UserInfoKS userInfoKS = chatSession.getUserInfo();
                        if (userInfoKS == null) {
                            MLog.error((Object)"AbstractWindow", (String)("getUserDistanceOnline user is null, uid: " + uid), (Object[])new Object[0]);
                            continue;
                        }
                        StrangerSessionWindow.this.mChatSessionDistanceCache.put(uid, System.currentTimeMillis());
                        int otherAge = DateUtils.getAge((String)userInfoKS.birthday);
                        String otherCountry = (userInfoKS.country == null ? "" : userInfoKS.country).toUpperCase();
                        boolean isAmerica = "US".equals(otherCountry) || "BR".equals(otherCountry) || "ES".equals(otherCountry);
                        MLog.info((Object)"AbstractWindow", (String)("getUserDistanceOnline myAge: " + myAge + ", otherAge: " + otherAge + ", otherCountry: " + otherCountry), (Object[])new Object[0]);
                        if (TextUtils.isEmpty((CharSequence)status.dist) || isAmerica && (myAge < 18 || otherAge < 18) || !isAmerica && (myAge < 16 || otherAge < 16)) {
                            chatSession.setDistance("");
                            continue;
                        }
                        chatSession.setDistance(status.dist);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)"AbstractWindow", (String)"", (Object[])new Object[0]);
                }
            }
        });
    }

    private void reportStrangerListShow(List<ChatSession> sessions) {
        if (sessions == null) {
            return;
        }
        String inCludeNoActionStrategy = "0";
        String isNewGuideStrategyType = "0";
        StringBuffer uids = new StringBuffer();
        for (ChatSession session : sessions) {
            if (session instanceof SingleChatSession && ((SingleChatSession)session).getStrategyType() > 0) {
                inCludeNoActionStrategy = "1";
            }
            if (session instanceof SingleChatSession && ((SingleChatSession)session).getNewGuideStrategyType() > 0) {
                isNewGuideStrategyType = "1";
            }
            if (uids.length() > 0) {
                uids.append("#");
            }
            uids.append(session.getUid());
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "stranger_msg_list_show").put("is_include_no_action_strategy", inCludeNoActionStrategy).put("is_new_guide_strategy_type", isNewGuideStrategyType).put("stranger_list_uid", uids.toString()));
    }

    private void reportChatSessionShow(List<ChatSession> chatSessions) {
        if (chatSessions == null) {
            return;
        }
        for (ChatSession chatSession : chatSessions) {
            if (!(chatSession instanceof SingleChatSession)) continue;
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", "2").put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())).put("is_include_no_action_strategy", ((SingleChatSession)chatSession).getStrategyType() > 0 ? "1" : "0").put("new_guide_strategy_type", String.valueOf(((SingleChatSession)chatSession).getNewGuideStrategyType())));
            ChatSessionEventReporter.INSTANCE.reportPersonalUnreadShow(chatSession.getUid(), chatSession.getUnReadCounts(), this.parseStrategyType((SingleChatSession)chatSession));
        }
    }

    private int parseStrategyType(SingleChatSession chatSession) {
        int strategyType = chatSession.getStrategyType();
        if (strategyType <= 0) {
            switch (chatSession.getNewGuideStrategyType()) {
                case 3: {
                    strategyType = 3;
                    break;
                }
                case 1: {
                    strategyType = 4;
                    break;
                }
                case 2: {
                    strategyType = 5;
                    break;
                }
            }
        }
        return strategyType;
    }

    public void onShown() {
        super.onShown();
        this.mPageState.setValue((Object)true);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023783").put("function_id", "show"));
        if (this.mSessions != null) {
            this.reportStrangerListShow((List)this.mSessions.getValue());
            this.reportChatSessionShow((List)this.mSessions.getValue());
        }
    }

    public void onHidden() {
        super.onHidden();
        this.mPageState.setValue((Object)false);
    }

    public void onDetached() {
        super.onDetached();
        this.mChatSessionDistanceCache.clear();
        if (this.mSessions != null) {
            this.mSessions.removeObserver(this.mObserver);
            if (this.mSessions.getValue() != null) {
                for (ChatSession session : (List)this.mSessions.getValue()) {
                    session.setIsNew(false);
                }
            }
            this.mSessions = null;
        }
        if (this.viewComponent != null) {
            this.viewComponent.onWindowDetach();
        }
        if (this.mEmptyComponent != null) {
            this.mEmptyComponent.onWindowDetach();
        }
        this.container = null;
    }

    public void onAttach() {
        super.onAttach();
        if (this.viewComponent != null) {
            this.viewComponent.onWindowAttach();
        }
        if (this.mEmptyComponent != null) {
            this.mEmptyComponent.onWindowAttach();
        }
    }

    private void showDeleteConfirmDialog() {
        this.getDialogLinkManager().showDialog((BaseDialog)new DeleteConfirmDialog(new OnDeleteDialogCallback(){

            @Override
            public void onYesClicked() {
                StrangerSessionWindow.this.viewComponent.setRemovable(false, true);
                StrangerSessionWindow.this.mStb.setRightBtn(R.drawable.icon_nav_delete, StrangerSessionWindow.this.mRemoveStartListener);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "delete_confirm_yes").put("delete_num", String.valueOf(StrangerSessionWindow.this.viewComponent.getReadyToRemoveSessions().size())));
            }

            @Override
            public void onNoClicked() {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "delete_confirm_no").put("delete_num", String.valueOf(StrangerSessionWindow.this.viewComponent.getReadyToRemoveSessions().size())));
                StrangerSessionWindow.this.viewComponent.setRemovable(false, false);
                StrangerSessionWindow.this.mStb.setRightBtn(R.drawable.icon_nav_delete, StrangerSessionWindow.this.mRemoveStartListener);
            }
        }));
    }

    public boolean isTranslucentBar() {
        return true;
    }

    public boolean isDarkMode() {
        return true;
    }

    @Nullable
    public View getNeedOffsetView() {
        return this.getBaseLayer().findViewById(R.id.stb);
    }
}

