/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.window;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.EditText;
import androidx.databinding.DataBindingUtil;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.appbase.ui.widget.EndlessListScrollListener;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ImeUtil;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.im.R;
import com.yy.im.databinding.ImSearchFriendPageBinding;
import com.yy.im.interfaces.ISearchViewCallback;
import com.yy.im.ui.adapter.SearchFriendAdapter;
import com.yy.im.viewmodel.SearchFriendViewModel;

public class SearchFriendWindow
extends DefaultWindow {
    private ImSearchFriendPageBinding binding;
    private ISearchViewCallback mListener;
    private SearchFriendViewModel mViewModel;
    private PullToRefreshListView mLvResult;
    private EndlessListScrollListener mScrollListener;
    private CommonStatusLayout mCommonStatusLayout;
    private SearchFriendAdapter mAdapter;
    private EditText mEtInput;
    private YYRelativeLayout mRlSearchTip;
    private YYTextView tvSearchNick;

    public SearchFriendWindow(Context context, SearchFriendViewModel vm, UICallBacks callBacks, ISearchViewCallback mListener) {
        super(context, callBacks, "SearchFriend");
        this.mListener = mListener;
        this.mViewModel = vm;
        this.createViews();
        this.setEnableSwipeGesture(true);
    }

    private void createViews() {
        this.binding = (ImSearchFriendPageBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.im_search_friend_page, (ViewGroup)this.getBaseLayer(), (boolean)true);
        this.mLvResult = this.binding.lvResult;
        this.mCommonStatusLayout = this.binding.slStatus;
        this.mScrollListener = new EndlessListScrollListener(this.mCommonStatusLayout){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                super.onScrollStateChanged(view, scrollState);
                if (scrollState == 1) {
                    ImeUtil.hideIME((Activity)((Activity)SearchFriendWindow.this.getContext()));
                }
            }
        };
        this.mScrollListener.setListener(this.mViewModel.getmLoadingListener());
        this.mLvResult.setMode(PullToRefreshBase.Mode.PULL_FROM_START);
        this.mLvResult.setOnScrollListener((AbsListView.OnScrollListener)this.mScrollListener);
        this.mLvResult.setOnRefreshListener(this.mViewModel.getmPullToRefreshListener());
        this.binding.setBackListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SearchFriendWindow.this.mListener != null) {
                    SearchFriendWindow.this.mListener.onSearchBackClick(view);
                }
            }
        });
        this.binding.setVm(this.mViewModel);
        this.mViewModel.setmLvRef(this.mLvResult);
        this.mViewModel.setmStatusLayoutRef(this.mCommonStatusLayout);
        this.mAdapter = new SearchFriendAdapter(this.mViewModel, this.mViewModel.getmSearchedWithNickFriends());
        this.binding.setAdapter(this.mAdapter);
        this.mEtInput = this.binding.etInput;
        this.mRlSearchTip = this.binding.rlSearchTips;
        this.tvSearchNick = this.binding.tvSearchNick;
    }

    public void onShown() {
        super.onShown();
        this.setSoftInputMode(48);
        if (this.mAdapter.getCount() == 0) {
            this.binding.etInput.requestFocus();
            ImeUtil.showIMEDelay((Activity)((Activity)this.getContext()), (View)this.binding.etInput);
        }
    }

    public void onHidden() {
        super.onHidden();
        ImeUtil.hideIME((Activity)((Activity)this.getContext()));
    }

    public void onAttach() {
        super.onAttach();
    }

    public void onDetached() {
        super.onDetached();
        if (this.mAdapter != null) {
            this.mAdapter.onDestroy();
        }
        if (this.mEtInput != null) {
            this.mEtInput.setOnEditorActionListener(null);
        }
    }
}

