/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.window;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.Observer;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.tablayout.MsgView;
import com.yy.appbase.ui.widget.tablayout.OnTabPositionChangedListener;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.im.base.ITitleBarListener;
import com.yy.hiyo.module.main.internal.modules.chat.contact.ContactTabAdapter;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.friend.IFriendServices;
import com.yy.hiyo.relation.base.friend.INewFansAndFriendHandler;
import com.yy.im.R;
import com.yy.im.addfriend.hiido.AddFriendReporter;
import com.yy.im.databinding.ImFriendListPageBinding;
import com.yy.im.friend.IFanFollowCallback;
import com.yy.im.friend.IFanFollowPresenter;
import com.yy.im.friend.fans.FansPresenter;
import com.yy.im.friend.follow.FollowPresenter;
import com.yy.im.interfaces.IComponent;
import com.yy.im.model.IContact;
import com.yy.im.msg.ImModuleMsgDef;
import com.yy.im.ui.component.FbTipsComponent;
import com.yy.im.ui.component.FriendListComponent;
import com.yy.im.ui.window.TabData;
import com.yy.im.ui.window.TabId;
import com.yy.im.ui.window.specialtab.mychannel.MyChannelListPage;
import com.yy.im.utils.ImSpUtil;
import com.yy.im.viewmodel.ChatSessionViewModel;
import com.yy.im.viewmodel.FriendListViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

public class FriendsListPageWindow
extends DefaultWindow {
    private ViewGroup mContainer;
    private ITitleBarListener mListener;
    private IComponent mFriendListComponent;
    private FbTipsComponent mEmptyComponent;
    private ImFriendListPageBinding mBinding;
    private ChatSessionViewModel chatVm;
    private FriendListViewModel friendVm;
    private IFanFollowPresenter mFansPresenter;
    private IFanFollowPresenter mFollowPresenter;
    private List<TabData> tabData = new ArrayList<TabData>();
    private ContactTabAdapter tabAdapter;
    private SlidingTabLayout slidingTabLayout;
    private YYViewPager viewPager;
    private RecycleImageView mIvBack;
    private long lastUpateTab;
    private boolean isDefaultTab = true;
    private int defaultTab = TabId.FRIEND.getId();
    private SimpleTitleBar mSimpleTitleBar;
    private View mGuideView;
    private YYPlaceHolderView mGuideHolderView;
    private Observer<List<IContact>> mContactObs = new Observer<List<IContact>>(){

        public void onChanged(@Nullable List<IContact> searchFriends) {
            if (searchFriends == null || searchFriends.isEmpty()) {
                FriendsListPageWindow.this.ensureEmptyComponent(FriendsListPageWindow.this.chatVm);
                FriendsListPageWindow.this.mContainer.removeAllViews();
                FriendsListPageWindow.this.mContainer.addView(FriendsListPageWindow.this.mEmptyComponent.getRoot());
                FriendsListPageWindow.this.mBinding.setShowDiv(true);
            } else {
                FriendsListPageWindow.this.ensureFriendListComponent(FriendsListPageWindow.this.friendVm);
                FriendsListPageWindow.this.mContainer.removeAllViews();
                FriendsListPageWindow.this.mContainer.addView(FriendsListPageWindow.this.mFriendListComponent.getRoot());
                FriendsListPageWindow.this.mBinding.setShowDiv(false);
            }
        }
    };

    public FriendsListPageWindow(Context context, UICallBacks callBacks, ITitleBarListener l, ChatSessionViewModel chatVm, FriendListViewModel friendVm, int defaultTab) {
        super(context, callBacks, "FriendsListPage");
        this.mListener = l;
        this.chatVm = chatVm;
        this.friendVm = friendVm;
        this.defaultTab = defaultTab;
        IFanFollowCallback callback = id2 -> {
            long gap = System.currentTimeMillis() - this.lastUpateTab;
            this.lastUpateTab = System.currentTimeMillis();
            if (gap > 0L && gap < 500L) {
                YYTaskExecutor.postToMainThread(() -> this.onFanOrFollowShow(id2), (long)(500L - gap));
            } else {
                this.onFanOrFollowShow(id2);
            }
        };
        this.mFansPresenter = new FansPresenter();
        this.mFansPresenter.setCallback(callback);
        this.mFollowPresenter = new FollowPresenter();
        this.mFollowPresenter.setCallback(callback);
        this.createView();
        this.setEnableSwipeGesture(true);
    }

    private void createView() {
        View inflate = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_new_contact_b, (ViewGroup)this.getBarLayer(), true);
        this.mBinding = (ImFriendListPageBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.im_friend_list_page, null, (boolean)false);
        this.mContainer = this.mBinding.llContainer;
        MyChannelListPage listPage = new MyChannelListPage(this.getContext());
        this.slidingTabLayout = (SlidingTabLayout)inflate.findViewById(R.id.tab_layout);
        this.tabData.add(new TabData((View)this.mContainer, ResourceUtils.getString((int)R.string.friends), TabId.FRIEND));
        if (this.mFollowPresenter.canShow(true)) {
            this.tabData.add(new TabData((View)this.mFollowPresenter.createPage(this.getContext(), true), ResourceUtils.getString((int)R.string.short_title_follow_list_title), TabId.FOLLOW));
        }
        if (this.mFansPresenter.canShow(true)) {
            this.tabData.add(new TabData((View)this.mFansPresenter.createPage(this.getContext(), false), ResourceUtils.getString((int)R.string.title_fans_tab), TabId.FANS));
        }
        this.tabData.add(new TabData((View)listPage, ResourceUtils.getString((int)R.string.title_search_channel_group_chat), TabId.CHANNEL));
        this.viewPager = (YYViewPager)inflate.findViewById(R.id.viewpager);
        this.tabAdapter = new ContactTabAdapter();
        this.tabAdapter.setData(this.tabData);
        this.viewPager.setAdapter((PagerAdapter)this.tabAdapter);
        listPage.getView();
        this.slidingTabLayout.setViewPager((ViewPager)this.viewPager);
        this.slidingTabLayout.setOnTabPositionChangedListener(new OnTabPositionChangedListener(){

            public void onUpdateTabPosition(int position) {
                TabId id2 = ((TabData)FriendsListPageWindow.this.tabData.get(position)).getId();
                boolean isDelay = false;
                if (FriendsListPageWindow.this.isDefaultTab && id2.getId() == FriendsListPageWindow.this.defaultTab) {
                    isDelay = true;
                    FriendsListPageWindow.this.isDefaultTab = false;
                }
                if (id2 == TabId.FRIEND) {
                    FriendsListPageWindow.this.onFriendTabSelect(isDelay);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "add_book_pg_show"));
                } else if (id2 == TabId.CHANNEL) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "add_book_channel_tab_click"));
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "add_book_channel_pg_show"));
                } else if (id2 == TabId.FANS) {
                    FriendsListPageWindow.this.mFansPresenter.selectTab(isDelay);
                    FriendsListPageWindow.this.showRedPoint(TabId.FANS, 0);
                } else if (id2 == TabId.FOLLOW) {
                    FriendsListPageWindow.this.mFollowPresenter.selectTab(isDelay);
                }
            }
        });
        this.mSimpleTitleBar = (SimpleTitleBar)inflate.findViewById(R.id.stb_title);
        this.mSimpleTitleBar.setLeftBtn(R.drawable.icon_nav_back, v -> {
            if (this.mListener != null) {
                this.mListener.onLeftBtnClick(v);
            }
        });
        this.mSimpleTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.title_contacts));
        if (!RuntimeContext.isHagoPartySdk()) {
            this.mSimpleTitleBar.setRightBtn(R.drawable.icon_new_add_friend, v -> {
                MsgDispatcher.getInstance().sendMessage(ImModuleMsgDef.OPEN_NEW_ADD_FRIENDS_PAGE, 1);
                AddFriendReporter.INSTANCE.reportUpperRightCornerClick();
            });
        }
        this.showNewFriend();
        this.showNewFans();
        this.showFirstGuide(inflate);
        ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationNum(AccountUtil.getUid(), true, null);
    }

    @Nullable
    public View getNeedOffsetView() {
        return this.mSimpleTitleBar;
    }

    public boolean isTranslucentBar() {
        return true;
    }

    public boolean isDarkMode() {
        return true;
    }

    private void showNewFans() {
        if (FP.empty(this.tabData) || this.mFansPresenter == null || !this.mFansPresenter.canShow(false) || this.mFansPresenter.redCount() <= 0) {
            return;
        }
        this.showRedPoint(TabId.FANS, this.mFansPresenter.redCount());
    }

    private void showNewFriend() {
        if (FP.empty(this.tabData)) {
            return;
        }
        int red = ((IFriendServices)ServiceManagerProxy.getInstance().getService(IFriendServices.class)).getNewFansFriendHandler(AccountUtil.getUid()).getNewFansAndFriend().getFriend();
        if (red > 0) {
            this.showRedPoint(TabId.FRIEND, red);
        }
    }

    private void showFirstGuide(View contentView2) {
        if (ImSpUtil.INSTANCE.showAddFriendGuide()) {
            this.mGuideView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_add_friend_guide, null);
            this.mGuideHolderView = (YYPlaceHolderView)contentView2.findViewById(R.id.guideHolderView);
            this.mGuideHolderView.inflate(this.mGuideView);
            this.mGuideView.setOnClickListener(v -> this.mGuideView.setVisibility(8));
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (FriendsListPageWindow.this.isAttachToWindow() && FriendsListPageWindow.this.mGuideView != null) {
                        FriendsListPageWindow.this.mGuideView.setVisibility(8);
                    }
                }
            }, (long)3000L);
            ImSpUtil.INSTANCE.setAddFriendGuide();
        }
    }

    private void showRedPoint(TabId tabId, int count) {
        int size = this.tabData.size();
        for (int i = 0; i < size - 1; ++i) {
            if (this.tabData.get(i).getId() != tabId) continue;
            if (count <= 0) {
                this.slidingTabLayout.hideMsg(i);
                break;
            }
            this.slidingTabLayout.showMsg(i, count);
            this.redStyle(this.slidingTabLayout.getMsgView(i), count);
            break;
        }
    }

    private void onFriendTabSelect(boolean isDelay) {
        this.showRedPoint(TabId.FRIEND, 0);
        long time = 0L;
        if (isDelay) {
            time = 2000L;
        }
        YYTaskExecutor.postToMainThread(this::resetRedPoint, (long)time);
    }

    private void resetRedPoint() {
        INewFansAndFriendHandler handler = ((IFriendServices)ServiceManagerProxy.getInstance().getService(IFriendServices.class)).getNewFansFriendHandler(AccountUtil.getUid());
        handler.updateFriendTimestamp();
        handler.getNewFansAndFriend().setFriend(0);
        ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).resetNewFriends();
    }

    private void redStyle(MsgView tipView, int num) {
        tipView.setBackgroundColor(ColorUtils.parseColor((String)"#FF4A6D"));
        ViewGroup.LayoutParams lp = tipView.getLayoutParams();
        FontUtils.setFontType((TextView)tipView, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        tipView.setText((CharSequence)("" + num));
        if (num == 0) {
            lp.width = ResolutionUtils.dip2Px((float)9.0f);
            lp.height = ResolutionUtils.dip2Px((float)9.0f);
            int padding = 0;
            tipView.setPadding(padding, padding, padding, padding);
            tipView.requestLayout();
        } else if (num < 10) {
            lp.width = ResolutionUtils.dip2Px((float)12.0f);
            lp.height = ResolutionUtils.dip2Px((float)12.0f);
            int padding = 0;
            tipView.setPadding(padding - ResolutionUtils.dip2Px((float)0.5f), padding + ResolutionUtils.dip2Px((float)0.5f), padding, padding);
            tipView.requestLayout();
        } else {
            lp.width = -2;
            lp.height = -2;
            int padding = ResolutionUtils.dip2Px((float)2.0f);
            tipView.setPadding(padding - ResolutionUtils.dip2Px((float)0.5f), ResolutionUtils.dip2Px((float)0.5f), padding, 0);
            tipView.requestLayout();
        }
    }

    private void onFanOrFollowShow(int id2) {
        if (this.containTab(id2)) {
            return;
        }
        if (id2 == 2) {
            int index = 2;
            if (!this.mFollowPresenter.canShow(false)) {
                index = 1;
            }
            this.tabData.add(index, new TabData((View)this.mFansPresenter.createPage(this.getContext(), false), ResourceUtils.getString((int)R.string.title_fans_tab), TabId.FANS));
            this.tabAdapter.setData(this.tabData);
            this.viewPager.setAdapter((PagerAdapter)this.tabAdapter);
            this.slidingTabLayout.setViewPager((ViewPager)this.viewPager);
            this.showNewFans();
        } else if (id2 == 1) {
            int index = 1;
            this.tabData.add(index, new TabData((View)this.mFollowPresenter.createPage(this.getContext(), false), ResourceUtils.getString((int)R.string.title_follow_tab), TabId.FOLLOW));
            this.tabAdapter.setData(this.tabData);
            this.viewPager.setAdapter((PagerAdapter)this.tabAdapter);
            this.slidingTabLayout.setViewPager((ViewPager)this.viewPager);
        }
    }

    private boolean containTab(int id2) {
        if (FP.empty(this.tabData)) {
            return false;
        }
        for (TabData tab : this.tabData) {
            if (tab.getId().getId() != id2) continue;
            return true;
        }
        return false;
    }

    public void onAttach() {
        super.onAttach();
        if (this.mFriendListComponent != null) {
            this.mFriendListComponent.onWindowAttach();
        }
        this.mFansPresenter.attach();
        this.mFollowPresenter.attach();
    }

    public void onDetached() {
        super.onDetached();
        this.friendVm.getFriends().removeObserver(this.mContactObs);
        if (this.mFriendListComponent != null) {
            this.mFriendListComponent.onWindowDetach();
        }
        this.mFansPresenter.detach();
        this.mFollowPresenter.detach();
    }

    private void ensureFriendListComponent(FriendListViewModel vm) {
        if (this.mFriendListComponent == null) {
            this.mFriendListComponent = new FriendListComponent(this.getContext(), this.mContainer, vm);
        }
    }

    private void ensureEmptyComponent(ChatSessionViewModel chatVm) {
        if (this.mEmptyComponent == null) {
            this.mEmptyComponent = new FbTipsComponent(this.getContext(), this.mContainer, chatVm);
            this.mEmptyComponent.iconTopMargin(ResolutionUtils.dip2Px((float)80.0f)).showHeaderDiv(true).tip1TopMargin(ResolutionUtils.dip2Px((float)20.0f)).tip2TopMargin(ResolutionUtils.dip2Px((float)14.0f)).tips1Text(ResourceUtils.getString((int)R.string.friends_tips1)).tips2Text(ResourceUtils.getString((int)R.string.friends_tips2)).funcStyle(0);
        }
    }

    public SlidingTabLayout getSlidingTabLayout() {
        return this.slidingTabLayout;
    }

    public ContactTabAdapter getTabAdapter() {
        return this.tabAdapter;
    }

    public YYViewPager getViewPager() {
        return this.viewPager;
    }

    public void onWindowShow() {
        this.friendVm.getFriends().observeForever(this.mContactObs);
        if (this.mFansPresenter != null) {
            this.mFansPresenter.initData();
        }
        if (this.mFollowPresenter != null) {
            this.mFollowPresenter.initData();
        }
    }

    public void selectTab(TabId tabId) {
        for (int i = 0; i < this.tabData.size(); ++i) {
            TabData tab = this.tabData.get(i);
            if (tab.getId() != tabId) continue;
            this.viewPager.setCurrentItem(i);
            break;
        }
    }
}

