/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.window;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.databinding.Observable;
import androidx.databinding.ObservableField;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.ui.widget.status.LoadingStatusLayout;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.NotificationsUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.TimeUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.base.ITitleBarListener;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.hiyo.im.base.data.ITabPageView;
import com.yy.im.R;
import com.yy.im.interfaces.IComponent;
import com.yy.im.interfaces.OnItemDataClickListener;
import com.yy.im.interfaces.OnItemDataLongClickListener;
import com.yy.im.model.ChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.module.room.callback.IChatSessionPageCallback;
import com.yy.im.ui.component.AddFriendsHeaderComponent;
import com.yy.im.ui.component.BindFaceBookHeaderComponent;
import com.yy.im.ui.component.ChannelGroupRecommendComponent;
import com.yy.im.ui.component.ChatSessionListComponent;
import com.yy.im.ui.component.FbTipsComponent;
import com.yy.im.ui.component.ImBottomRecommendComponent;
import com.yy.im.ui.window.IMTabReport;
import com.yy.im.viewmodel.ChannelGroupRecommendViewModel;
import com.yy.im.viewmodel.ChatSessionViewModel;
import com.yy.im.viewmodel.CrawlerGroupModel;
import com.yy.im.viewmodel.SuggestedFriendViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChatSessionPage
extends YYFrameLayout
implements ITabPageView {
    private static final String TAG = "ChatSessionPageWindow";
    private ViewGroup mBaseLayer;
    private ViewGroup mRoot;
    private View mTitleBar;
    private YYLinearLayout llContent;
    private YYLinearLayout mChatHeaderContainer;
    private YYLinearLayout mChatFooterContainer;
    private View mChatdLVDividerView;
    private LoadingStatusLayout mLoadingStatusLayout;
    private View notificationSwitchTipView;
    private FbTipsComponent mFbTipsComponent;
    private ChatSessionViewModel.SessionDataState mCacheState = null;
    private int mCacheFriendSize;
    private IComponent mBindContactComponent;
    private IComponent mAddFriendsComponent;
    private IComponent mChatSessionListComponent;
    private IComponent mBottomRecommendComponent;
    private IComponent mChannelRecommendComponent;
    private OnItemDataLongClickListener mLongClickListener;
    private IChatSessionPageCallback mCallBacks;
    private ChatSessionViewModel mViewModel;
    private SuggestedFriendViewModel mSuggestedFriendViewModel;
    private ChannelGroupRecommendViewModel mChannelGroupRecommendViewModel;
    private ITitleBarListener mTitleBarListener;
    private OnItemDataClickListener mSessionClickListener;
    private boolean hasHideLoading = false;
    private Set<View> visibleViews = new HashSet<View>();
    private Runnable mShowLoadingTask = new Runnable(){

        @Override
        public void run() {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)ChatSessionPage.this.mShowLoadingTask);
            MLog.info((Object)ChatSessionPage.TAG, (String)"mShowLoadingTask execute!!!mLoadingStatusLayout:%s, llContent:%s,hasHideLoading:%b", (Object[])new Object[]{ChatSessionPage.this.mLoadingStatusLayout, ChatSessionPage.this.llContent, ChatSessionPage.this.hasHideLoading});
            if (ChatSessionPage.this.mLoadingStatusLayout != null && ChatSessionPage.this.llContent != null && !ChatSessionPage.this.hasHideLoading) {
                ChatSessionPage.this.llContent.setVisibility(8);
                ChatSessionPage.this.mLoadingStatusLayout.setVisibility(0);
            }
        }
    };
    private Runnable mHideLoadingTask = new Runnable(){

        @Override
        public void run() {
            MLog.info((Object)ChatSessionPage.TAG, (String)"mHideLoadingTask execute!!!mLoadingStatusLayout:%s, llContent:%s,hasHideLoading:%b", (Object[])new Object[]{ChatSessionPage.this.mLoadingStatusLayout, ChatSessionPage.this.llContent, ChatSessionPage.this.hasHideLoading});
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)ChatSessionPage.this.mHideLoadingTask);
            if (ChatSessionPage.this.mLoadingStatusLayout != null && ChatSessionPage.this.llContent != null && !ChatSessionPage.this.hasHideLoading) {
                ChatSessionPage.this.hasHideLoading = true;
                if (ChatSessionPage.this.mCacheState != null) {
                    ChatSessionPage.this.onDataChanged(ChatSessionPage.this.mCacheState, ChatSessionPage.this.mCacheFriendSize);
                    ChatSessionPage.this.mCacheState = null;
                    ChatSessionPage.this.mCacheFriendSize = 0;
                } else {
                    ChatSessionPage.this.llContent.setVisibility(0);
                }
                ChatSessionPage.this.mLoadingStatusLayout.setVisibility(8);
            }
        }
    };
    private Observer<ChatSessionViewModel.SessionDataState> mViewStateObs = new Observer<ChatSessionViewModel.SessionDataState>(){

        public void onChanged(@Nullable ChatSessionViewModel.SessionDataState state2) {
            MLog.info((Object)"vanda", (String)("onChanged sessionDataState = " + state2), (Object[])new Object[0]);
            List value = (List)ChatSessionPage.this.mSuggestedFriendViewModel.getSuggestedFriendDatas().getValue();
            ChatSessionPage.this.onDataChanged(state2, value == null ? 0 : value.size());
        }
    };
    private Observer<List<SuggestFriendData>> mFriendObs = new Observer<List<SuggestFriendData>>(){

        public void onChanged(@Nullable List<SuggestFriendData> objects) {
            ChatSessionPage.this.onDataChanged((ChatSessionViewModel.SessionDataState)ChatSessionPage.this.mViewModel.getSessionDataState().getValue(), objects == null ? 0 : objects.size());
        }
    };
    private MutableLiveData<Boolean> mPageState = new MutableLiveData();
    private final Observable.OnPropertyChangedCallback fbCloseCallback = new Observable.OnPropertyChangedCallback(){

        public void onPropertyChanged(Observable sender, int propertyId) {
            Boolean close;
            ObservableField<Boolean> closeOb = ((ChatSessionPage)ChatSessionPage.this).mViewModel.mClickCloseBindFb;
            if (closeOb != null && (close = (Boolean)closeOb.get()) != null && close.booleanValue()) {
                ChatSessionPage.this.postDelayed(() -> ChatSessionPage.this.checkShowNotificationSwitchTipView(), 618L);
            }
        }
    };
    private Set<View> allViews = new HashSet<View>();

    private void onDataChanged(@Nullable ChatSessionViewModel.SessionDataState state2, int friendSize) {
        ImBottomRecommendComponent bottomRecommendComponent;
        MLog.info((Object)TAG, (String)"onDataChanged state:%s, friendSize:%d, hasHideLoading:%b", (Object[])new Object[]{state2, friendSize, this.hasHideLoading});
        if (state2 == null) {
            return;
        }
        if (!this.hasHideLoading) {
            this.mCacheState = state2;
            this.mCacheFriendSize = friendSize;
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("update: " + state2.mContactState + ", " + state2.mSessionState + ", " + state2.mFbState), (Object[])new Object[0]);
        }
        if (this.mChatHeaderContainer == null) {
            this.mChatHeaderContainer = new YYLinearLayout(this.mRoot.getContext());
            this.mChatHeaderContainer.setOrientation(1);
        }
        this.visibleViews.clear();
        if (1 == state2.mSessionState) {
            boolean isZalo;
            boolean bl = isZalo = AccountUtil.isShowZaloBind() && state2.mZaloState == CheckStatus.UNAUTH;
            if (2 == state2.mContactState || state2.mZaloState == CheckStatus.AUTH) {
                this.getFbTipsComponent().funcStyle(2).icon(R.drawable.icon_message_empty).iconTopMargin(ResolutionUtils.dip2Px((float)25.0f)).tip1TopMargin(ResolutionUtils.dip2Px((float)20.0f)).tip2TopMargin(ResolutionUtils.dip2Px((float)16.0f)).tips1Text(ResourceUtils.getString((int)R.string.play_with_friends)).tips2Text(ResourceUtils.getString((int)R.string.chat_tips3));
                this.addAndShow(this.getFbTipsComponent().getRoot(), -1);
                this.visibleViews.add(this.getFbTipsComponent().getRoot());
            } else {
                this.getFbTipsComponent().funcStyle(isZalo ? 4 : 3).icon(isZalo ? R.drawable.zalo_firends : R.drawable.icon_add_contact_friend).iconTopMargin(ResolutionUtils.dip2Px((float)35.0f)).tip1TopMargin(ResolutionUtils.dip2Px((float)25.0f)).tip2TopMargin(ResolutionUtils.dip2Px((float)16.0f)).tips1Text(ResourceUtils.getString((int)(isZalo ? R.string.chat_zalo_tips1 : R.string.chat_contact_tips1))).tips2Text(ResourceUtils.getString((int)(isZalo ? R.string.chat_zalo_tips2 : R.string.chat_contact_tips2)));
                this.addAndShow(this.getFbTipsComponent().getRoot(), -1);
                this.visibleViews.add(this.getFbTipsComponent().getRoot());
            }
        } else {
            Boolean hasClosed;
            if (friendSize == 0 && 1 == state2.mContactState) {
                boolean notShowClose;
                boolean bl = notShowClose = this.mViewModel.mClickCloseBindFb != null && this.mViewModel.mClickCloseBindFb.get() != null && (Boolean)this.mViewModel.mClickCloseBindFb.get() != false;
                if (!notShowClose) {
                    this.addAndShow(this.getBindContactView().getRoot(), 0);
                    this.visibleViews.add(this.getBindContactView().getRoot());
                }
            }
            if (2 == state2.mContactState && (hasClosed = (Boolean)this.mViewModel.mAddFriendsHasClosed.get()) != null && !hasClosed.booleanValue()) {
                this.addAndShow(this.getAddFriendsView().getRoot(), 0);
                this.visibleViews.add(this.getAddFriendsView().getRoot());
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024335").put("function_id", "add_friend_show"));
            }
            if (this.mChatdLVDividerView == null) {
                this.mChatdLVDividerView = LayoutInflater.from((Context)this.mRoot.getContext()).inflate(R.layout.layout_chat_lv_divider, null);
            }
            this.addAndShow(this.mChatdLVDividerView, -1);
            this.visibleViews.add(this.mChatdLVDividerView);
        }
        this.checkShowNotificationSwitchTipView();
        View channelComponent = this.getChannelGroupRecommendComponent().getRoot();
        this.addToHeader(channelComponent, -1);
        this.unShowAllViews();
        ListView refreshableView = (ListView)((ChatSessionListComponent)this.getChatSessionView()).getPullToRefreshListView().getRefreshableView();
        refreshableView.removeHeaderView((View)this.mChatHeaderContainer);
        refreshableView.addHeaderView((View)this.mChatHeaderContainer);
        if (this.mChatFooterContainer == null) {
            this.mChatFooterContainer = new YYLinearLayout(this.mRoot.getContext());
            this.mChatFooterContainer.setOrientation(1);
        }
        if ((bottomRecommendComponent = (ImBottomRecommendComponent)this.getBottomRecommendComponent()).isEnable()) {
            this.mChatFooterContainer.removeView(bottomRecommendComponent.getRoot());
            this.mChatFooterContainer.addView(bottomRecommendComponent.getRoot());
        } else {
            this.mChatFooterContainer.removeView(this.mBottomRecommendComponent.getRoot());
        }
        refreshableView.removeFooterView((View)this.mChatFooterContainer);
        refreshableView.addFooterView((View)this.mChatFooterContainer);
        if (this.getChatSessionView().getRoot().getParent() == null) {
            this.llContent.addView(this.getChatSessionView().getRoot());
        }
        MLog.info((Object)TAG, (String)"llContent setVisibility hasHideLoading:%b, size:%d", (Object[])new Object[]{this.hasHideLoading, this.llContent.getChildCount()});
        this.llContent.setVisibility(this.hasHideLoading ? 0 : 8);
    }

    private void checkShowNotificationSwitchTipView() {
        Boolean closeFb;
        ObservableField<Boolean> closeFbField = this.mViewModel.mClickCloseBindFb;
        if (closeFbField != null && (closeFb = (Boolean)closeFbField.get()) != null && !closeFb.booleanValue()) {
            closeFbField.addOnPropertyChangedCallback(this.fbCloseCallback);
            return;
        }
        if (NotificationsUtils.isNotificationEnabled((Context)this.getContext())) {
            return;
        }
        int unreadMsgCount = 0;
        List chatSessionList = (List)this.mViewModel.getChatSessionList().getValue();
        if (FP.empty((Collection)chatSessionList)) {
            return;
        }
        for (ChatSession chatSession : chatSessionList) {
            unreadMsgCount += chatSession.getUnReadCounts();
        }
        if (unreadMsgCount == 0) {
            return;
        }
        long lastDisappearTime = SettingFlags.getLongValue((String)"tip_im_pop_disappear_time", (long)-1L);
        if (lastDisappearTime != -1L && System.currentTimeMillis() - lastDisappearTime < TimeUtils.DAYS.toMillis((long)1L)) {
            return;
        }
        this.showNotificationPrTipView();
    }

    private void showNotificationPrTipView() {
        if (this.notificationSwitchTipView == null) {
            this.notificationSwitchTipView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.im_notification_permission_tip_layout, (ViewGroup)this.llContent, false);
        }
        TextView tvDesc = (TextView)this.notificationSwitchTipView.findViewById(R.id.tv_desc);
        Object messageSync = MsgDispatcher.getInstance().sendMessageSync(ImBaseMsgDef.GET_PUSH_FLOAT_ALERT_TEST);
        if (messageSync instanceof String) {
            tvDesc.setText((CharSequence)((String)messageSync));
        }
        if (this.notificationSwitchTipView.getParent() != null) {
            ((ViewGroup)this.notificationSwitchTipView.getParent()).removeView(this.notificationSwitchTipView);
        }
        this.addAndShow(this.notificationSwitchTipView, 0);
        this.notificationSwitchTipView.setVisibility(0);
        this.visibleViews.add(this.notificationSwitchTipView);
        this.notificationSwitchTipView.findViewById(R.id.iv_open).setOnClickListener(v -> {
            NotificationsUtils.openNotificationSetting((Context)this.getContext());
            this.disappearNotificationPrTipsView();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "notification_pr_dialog_click").put("location", String.valueOf(5)));
        });
        this.notificationSwitchTipView.findViewById(R.id.iv_close).setOnClickListener(v -> {
            this.disappearNotificationPrTipsView();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "notification_pr_dialog_close").put("location", String.valueOf(5)));
        });
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "notification_pr_dialog_show").put("location", String.valueOf(5)));
    }

    private void disappearNotificationPrTipsView() {
        SettingFlags.setLongValue((String)"tip_im_pop_disappear_time", (long)System.currentTimeMillis());
        this.notificationSwitchTipView.setVisibility(8);
        this.visibleViews.remove(this.notificationSwitchTipView);
    }

    private void addToHeader(View view, int index) {
        if (view == null || this.mChatHeaderContainer == null) {
            return;
        }
        if (view.getParent() != null) {
            this.mChatHeaderContainer.removeView(view);
        }
        this.mChatHeaderContainer.addView(view, index);
    }

    private void addAndShow(View view, int position) {
        if (view == null || this.mChatHeaderContainer == null) {
            return;
        }
        if (view.getParent() == null) {
            this.mChatHeaderContainer.addView(view, position);
            this.allViews.add(view);
        }
        view.setVisibility(0);
    }

    private void unShowAllViews() {
        for (View view : this.allViews) {
            if (view == null || this.visibleViews.contains(view)) continue;
            view.setVisibility(8);
        }
    }

    public View getView() {
        return this;
    }

    public void showLoading() {
        MLog.info((Object)TAG, (String)"showLoading hasHideLoading:%b", (Object[])new Object[]{this.hasHideLoading});
        if (!this.hasHideLoading) {
            YYTaskExecutor.postToMainThread((Runnable)this.mShowLoadingTask);
            YYTaskExecutor.postToMainThread((Runnable)this.mHideLoadingTask, (long)2000L);
        }
    }

    public void hideLoading() {
        MLog.info((Object)TAG, (String)"hideLoading", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideLoadingTask);
    }

    public ChatSessionPage(Context context, IChatSessionPageCallback callBacks, ChatSessionViewModel mViewModel, SuggestedFriendViewModel suggestedFriendViewModel, ChannelGroupRecommendViewModel channelGroupRecommendViewModel, CrawlerGroupModel crawlerGroupModel, OnItemDataClickListener mSessionClickListener, ITitleBarListener listener, OnItemDataLongClickListener longClickListener, ViewGroup baseLayer) {
        super(context);
        this.mBaseLayer = baseLayer;
        this.mCallBacks = callBacks;
        this.mViewModel = mViewModel;
        this.mSuggestedFriendViewModel = suggestedFriendViewModel;
        this.mChannelGroupRecommendViewModel = channelGroupRecommendViewModel;
        this.mSessionClickListener = mSessionClickListener;
        this.mLongClickListener = longClickListener;
        this.mTitleBarListener = listener;
        this.createView();
    }

    private void createView() {
        YYLinearLayout container2 = new YYLinearLayout(this.getContext());
        this.mRoot = container2;
        this.mTitleBar = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.im_chat_session_top_bar, null);
        this.llContent = new YYLinearLayout(this.getContext());
        this.mLoadingStatusLayout = new LoadingStatusLayout(this.getContext());
        container2.setOrientation(1);
        container2.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-1, ResourceUtils.getDimen((int)R.dimen.chatsession_title_bar));
        this.mTitleBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        layoutParams2 = new LinearLayout.LayoutParams(-1, -1);
        this.llContent.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.llContent.setOrientation(1);
        layoutParams2 = new LinearLayout.LayoutParams(-1, -1);
        this.mLoadingStatusLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.mTitleBar.setId(R.id.chat_tb_session);
        this.mTitleBar.setVisibility(0);
        this.llContent.setId(R.id.chat_ll_content);
        this.mLoadingStatusLayout.setId(R.id.chat_status_layout);
        container2.setBackgroundColor(ResourceUtils.getColor((int)R.color.white));
        container2.addView(this.mTitleBar);
        container2.addView((View)this.llContent);
        container2.addView((View)this.mLoadingStatusLayout);
        this.addView((View)container2);
        this.mTitleBar.findViewById(R.id.iv_search).setOnClickListener(v -> {
            if (this.mTitleBarListener != null) {
                this.mTitleBarListener.onLeftBtnClick(v);
            }
        });
        this.mTitleBar.findViewById(R.id.iv_friend).setOnClickListener(v -> {
            if (this.mTitleBarListener != null) {
                this.mTitleBarListener.onRightBtnClick(v);
            }
        });
        this.getChannelGroupRecommendComponent();
        this.getBottomRecommendComponent();
    }

    private IComponent getBindContactView() {
        if (this.mBindContactComponent == null) {
            this.mBindContactComponent = new BindFaceBookHeaderComponent(this.getContext(), this.mRoot, this.mViewModel);
        }
        return this.mBindContactComponent;
    }

    private IComponent getAddFriendsView() {
        if (this.mAddFriendsComponent == null) {
            this.mAddFriendsComponent = new AddFriendsHeaderComponent(this.getContext(), this.mRoot, this.mViewModel);
        }
        return this.mAddFriendsComponent;
    }

    private IComponent getChatSessionView() {
        if (this.mChatSessionListComponent == null) {
            this.mChatSessionListComponent = new ChatSessionListComponent(this.getContext(), this.mRoot, this.mSessionClickListener, (LiveData<List<ChatSession>>)this.mViewModel.getChatSessionList(), this.mLongClickListener, ((ImModule)KvoModuleManager.getModule(ImModule.class)).getSessionMsgUIMapper(1), 1, this.mBaseLayer);
            this.mChatSessionListComponent.setPageCallback((LiveData<Boolean>)this.mPageState);
        }
        return this.mChatSessionListComponent;
    }

    private FbTipsComponent getFbTipsComponent() {
        if (this.mFbTipsComponent == null) {
            this.mFbTipsComponent = new FbTipsComponent(this.getContext(), this.mRoot, this.mViewModel);
        }
        return this.mFbTipsComponent;
    }

    private IComponent getChannelGroupRecommendComponent() {
        if (this.mChannelRecommendComponent == null) {
            this.mChannelRecommendComponent = new ChannelGroupRecommendComponent(this.getContext(), this.mChannelGroupRecommendViewModel);
        }
        return this.mChannelRecommendComponent;
    }

    private IComponent getBottomRecommendComponent() {
        if (this.mBottomRecommendComponent == null) {
            this.mBottomRecommendComponent = new ImBottomRecommendComponent(this.getContext(), this.mViewModel);
        }
        return this.mBottomRecommendComponent;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onAttach();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDetached();
    }

    public void onAttach() {
        if (this.mCallBacks != null) {
            this.mCallBacks.onAttached();
        }
        if (this.mViewModel != null) {
            this.mViewModel.getSessionDataState().observeForever(this.mViewStateObs);
        }
        if (this.mSuggestedFriendViewModel != null) {
            this.mSuggestedFriendViewModel.getSuggestedFriendDatas().observeForever(this.mFriendObs);
        }
        if (this.mChatSessionListComponent != null) {
            this.mChatSessionListComponent.onWindowAttach();
        }
        if (this.mChannelRecommendComponent != null) {
            this.mChannelRecommendComponent.onWindowAttach();
        }
        if (this.mBottomRecommendComponent != null) {
            this.mBottomRecommendComponent.onWindowAttach();
        }
    }

    public void onDetached() {
        if (this.mCallBacks != null) {
            this.mCallBacks.onDetached();
        }
        if (this.mViewModel != null) {
            this.mViewModel.mClickCloseBindFb.removeOnPropertyChangedCallback(this.fbCloseCallback);
            this.mViewModel.getSessionDataState().removeObserver(this.mViewStateObs);
        }
        if (this.mSuggestedFriendViewModel != null) {
            this.mSuggestedFriendViewModel.getSuggestedFriendDatas().removeObserver(this.mFriendObs);
        }
        if (this.mChatSessionListComponent != null) {
            this.mChatSessionListComponent.onWindowDetach();
        }
        if (this.mChannelRecommendComponent != null) {
            this.mChannelRecommendComponent.onWindowDetach();
        }
        if (this.mBottomRecommendComponent != null) {
            this.mBottomRecommendComponent.onWindowDetach();
        }
    }

    public void resetWhenAccountChange() {
        this.hasHideLoading = false;
    }

    public void onShow(boolean fromTab) {
        this.mPageState.setValue((Object)true);
        this.showLoading();
        if (this.mChannelRecommendComponent != null) {
            ((ChannelGroupRecommendComponent)this.mChannelRecommendComponent).onImPageShow();
        }
        if (this.mBottomRecommendComponent != null) {
            ((ImBottomRecommendComponent)this.mBottomRecommendComponent).onPageShow();
        }
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).onChatPageShow();
        IMTabReport.INSTANCE.msgPageShow();
        this.reportSessionNum();
    }

    private void reportSessionNum() {
        List sessions = (List)this.mViewModel.getChatSessionList().getValue();
        int total = 0;
        int singleChatNum = 0;
        int stickTopNum = 0;
        if (this.mChannelRecommendComponent != null && this.mChannelRecommendComponent.getRoot().getVisibility() == 0) {
            ++total;
        }
        if (sessions != null) {
            total += sessions.size();
            for (ChatSession session : sessions) {
                if (session instanceof SingleChatSession) {
                    ++singleChatNum;
                }
                if (!session.isStickTop()) continue;
                ++stickTopNum;
            }
        }
        IMTabReport.INSTANCE.reportSingleMsgNum(total, singleChatNum, stickTopNum);
    }

    public void onHide(boolean fromTab) {
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).onChatPageHide();
        this.mPageState.setValue((Object)false);
        if (this.mChannelRecommendComponent != null) {
            ((ChannelGroupRecommendComponent)this.mChannelRecommendComponent).onImPageHide();
        }
        if (this.mBottomRecommendComponent != null) {
            ((ImBottomRecommendComponent)this.mBottomRecommendComponent).onPageHide();
        }
    }

    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
    }

    public void onFriendRedPoint(int count) {
        if (this.mTitleBar != null) {
            TextView tvCount2 = (TextView)this.mTitleBar.findViewById(R.id.red_point_count);
            View redView = this.mTitleBar.findViewById(R.id.red_point);
            if (count < 0) {
                tvCount2.setVisibility(8);
                redView.setVisibility(8);
            } else if (count == 0) {
                tvCount2.setVisibility(8);
                redView.setVisibility(0);
            } else {
                String stringCount = count > 99 ? "99+" : String.valueOf(count);
                tvCount2.setText((CharSequence)stringCount);
                tvCount2.setVisibility(0);
                redView.setVisibility(8);
            }
        }
    }
}

