/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.window;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.socialmdeia.SocialMediaInfo;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.status.LoadingStatusLayout;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.im.ContactUtils;
import com.yy.hiyo.im.base.ITitleBarListener;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.im.R;
import com.yy.im.interfaces.IComponent;
import com.yy.im.interfaces.OnInviteMoreFriendsClick;
import com.yy.im.interfaces.OnSearchEntranceClick;
import com.yy.im.ui.component.SuggestedFriendVerticalComponent;
import com.yy.im.ui.component.SuggestedTipsComponent;
import com.yy.im.viewmodel.SuggestedFriendViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class AddFriendsWindow
extends DefaultWindow {
    private SimpleTitleBar stb;
    private YYRelativeLayout rlContent;
    private YYRelativeLayout rlSearch;
    private YYRelativeLayout mRlBarContactFriends;
    private YYRelativeLayout mRlBarFacebookFriends;
    private YYRelativeLayout mSocialMedia;
    private YYRelativeLayout mRlBarZaloFriends;
    private IComponent mSuggestedFriendsListComponent;
    private SuggestedTipsComponent mSfTipsComponent;
    private YYLinearLayout mllContainer;
    private LoadingStatusLayout mLoadingStatusLayout;
    private BubblePopupWindow mSocialMediaBubble;
    private ITitleBarListener mListener;
    private OnSearchEntranceClick mClickSearch;
    private OnInviteMoreFriendsClick mClickInvite;
    private SuggestedFriendViewModel mSuggestedFriendVm;
    private int mContactState;
    private int mNearbyState;
    private List<SuggestFriendData> mFriends;
    private Observer<Integer> mContactStateObs = new Observer<Integer>(){

        public void onChanged(@Nullable Integer integer) {
            if (integer == null) {
                return;
            }
            AddFriendsWindow.this.mContactState = integer;
            AddFriendsWindow.this.setViewsWithState();
        }
    };
    private Observer<Integer> mNearbyStateobs = new Observer<Integer>(){

        public void onChanged(@Nullable Integer integer) {
            if (integer == null) {
                return;
            }
            AddFriendsWindow.this.mNearbyState = integer;
            AddFriendsWindow.this.setViewsWithState();
        }
    };
    private Observer<Integer> mZaloStateobs = new Observer<Integer>(){

        public void onChanged(@Nullable Integer integer) {
            if (integer == null) {
                return;
            }
            MLog.info((Object)"vanda", (String)("mZaloStateobs integer = " + integer), (Object[])new Object[0]);
            if (AccountUtil.isShowZaloBind()) {
                AddFriendsWindow.this.mRlBarZaloFriends.setVisibility(integer == CheckStatus.UNAUTH ? 0 : 8);
                AddFriendsWindow.this.setFacebookItemVisibility(integer == CheckStatus.UNAUTH ? 0 : 8);
            }
        }
    };
    private Observer<List<SuggestFriendData>> mSuggestedFriendObs = new Observer<List<SuggestFriendData>>(){

        public void onChanged(@Nullable List<SuggestFriendData> searchFriends) {
            AddFriendsWindow.this.mFriends = searchFriends;
            AddFriendsWindow.this.setViewsWithState();
        }
    };
    private Runnable mShowLoadingTask = new Runnable(){

        @Override
        public void run() {
            if (AddFriendsWindow.this.mLoadingStatusLayout != null && AddFriendsWindow.this.mllContainer != null) {
                AddFriendsWindow.this.mllContainer.setVisibility(8);
                AddFriendsWindow.this.mLoadingStatusLayout.setVisibility(0);
            }
        }
    };
    private Runnable mHideLoadingTask = new Runnable(){

        @Override
        public void run() {
            if (AddFriendsWindow.this.mLoadingStatusLayout != null && AddFriendsWindow.this.mllContainer != null) {
                AddFriendsWindow.this.mllContainer.setVisibility(0);
                AddFriendsWindow.this.mLoadingStatusLayout.setVisibility(8);
            }
        }
    };

    public AddFriendsWindow(Context context, SuggestedFriendViewModel sfvm, UICallBacks callBacks, ITitleBarListener listener, OnSearchEntranceClick searchEntranceClick, OnInviteMoreFriendsClick inviteMoreFriendsClick) {
        super(context, callBacks, "AddFriends");
        this.mListener = listener;
        this.mClickSearch = searchEntranceClick;
        this.mClickInvite = inviteMoreFriendsClick;
        this.mSuggestedFriendVm = sfvm;
        this.createView();
        this.setEnableSwipeGesture(true);
    }

    private void createView() {
        View root2 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.im_add_friends_page, this.getBaseLayer(), true);
        this.stb = (SimpleTitleBar)root2.findViewById(R.id.stb);
        this.rlSearch = (YYRelativeLayout)root2.findViewById(R.id.rl_search);
        this.rlContent = (YYRelativeLayout)root2.findViewById(R.id.rl_content);
        this.mRlBarZaloFriends = (YYRelativeLayout)root2.findViewById(R.id.connect_zalo_friends);
        this.mRlBarContactFriends = (YYRelativeLayout)root2.findViewById(R.id.connect_contact_friends);
        this.mRlBarFacebookFriends = (YYRelativeLayout)root2.findViewById(R.id.connect_facebook_friends);
        this.mSocialMedia = (YYRelativeLayout)root2.findViewById(R.id.connect_social_media);
        this.mLoadingStatusLayout = (LoadingStatusLayout)root2.findViewById(R.id.status_layout);
        this.mllContainer = (YYLinearLayout)root2.findViewById(R.id.ll_container);
        this.rlSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AddFriendsWindow.this.mClickSearch != null) {
                    AddFriendsWindow.this.mClickSearch.onSearchEntranceClick(view);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023791").put("function_id", "search_click"));
                }
            }
        });
        this.stb.setLeftTitle(ResourceUtils.getString((int)R.string.add_friends));
        this.stb.setLeftBtn(R.drawable.icon_nav_back, view -> {
            if (this.mListener != null) {
                this.mListener.onLeftBtnClick(view);
            }
        });
        if (SettingFlags.getIntValue((String)"second_friend_list_switch", (int)0) > 0) {
            this.stb.setRightBtn(R.drawable.selector_friendlist_btn, view -> {
                if (this.mListener != null) {
                    this.mListener.onRightBtnClick(view);
                }
            });
        }
        this.mRlBarZaloFriends.setVisibility(8);
        this.mRlBarFacebookFriends.setVisibility(8);
        this.mRlBarContactFriends.setVisibility(8);
        this.mSocialMedia.setVisibility(8);
        ContactUtils.hasContactPermission((Activity)((Activity)this.getContext()), has -> YYTaskExecutor.postToMainThread(() -> {
            if (this.mRlBarContactFriends != null) {
                this.mRlBarContactFriends.setVisibility(has ? 8 : 0);
            }
        }));
        root2.findViewById(R.id.connect_contact_friends_btn).setOnClickListener(v -> {
            ContactUtils.showContactPemissionDialog((Activity)((Activity)this.getContext()), null);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024335").put("function_id", "contact_click").put("ent_id", "3"));
        });
        root2.findViewById(R.id.connect_facebook_friends_btn).setOnClickListener(v -> this.mClickSearch.onFacebookConnectClick());
        root2.findViewById(R.id.connect_zalo_friends_btn).setOnClickListener(v -> this.mClickSearch.onZaloConnectClick());
        this.mSocialMedia.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Object obj = AddFriendsWindow.this.mSocialMedia.getTag();
                if (obj instanceof SocialMediaInfo) {
                    AddFriendsWindow.this.mClickSearch.onSocialMediaClick((SocialMediaInfo)obj);
                }
            }
        });
        this.ensureFbListComponent();
        this.ensureSfTipsComponent();
        if (this.mSuggestedFriendVm.isHadFinishCheck()) {
            this.hideLoading();
        }
    }

    public void onAttach() {
        super.onAttach();
        this.mSuggestedFriendVm.getZaloState().observeForever(this.mZaloStateobs);
        this.mSuggestedFriendVm.getmContactState().observeForever(this.mContactStateObs);
        this.mSuggestedFriendVm.getmNearbyState().observeForever(this.mNearbyStateobs);
        this.mSuggestedFriendVm.getSuggestedFriendDatas().observeForever(this.mSuggestedFriendObs);
        if (this.mSuggestedFriendsListComponent != null) {
            this.mSuggestedFriendsListComponent.onWindowAttach();
        }
    }

    public void onDetached() {
        super.onDetached();
        this.mSuggestedFriendVm.getZaloState().removeObserver(this.mZaloStateobs);
        this.mSuggestedFriendVm.getmContactState().removeObserver(this.mContactStateObs);
        this.mSuggestedFriendVm.getmNearbyState().removeObserver(this.mNearbyStateobs);
        this.mSuggestedFriendVm.getSuggestedFriendDatas().removeObserver(this.mSuggestedFriendObs);
        if (this.mSuggestedFriendsListComponent != null) {
            this.mSuggestedFriendsListComponent.onWindowDetach();
            this.mSuggestedFriendsListComponent = null;
        }
    }

    private void setViewsWithState() {
        if (this.mFriends != null && !this.mFriends.isEmpty()) {
            this.ensureFbListComponent();
            this.rlContent.removeAllViews();
            this.rlContent.addView(this.mSuggestedFriendsListComponent.getRoot());
        } else {
            this.ensureSfTipsComponent();
            this.rlContent.removeAllViews();
            this.rlContent.addView(this.mSfTipsComponent.getRoot());
            this.mSfTipsComponent.iconTopMargin(ResolutionUtils.dip2Px((float)50.0f)).tip1TopMargin(25).tip2TopMargin(ResolutionUtils.dip2Px((float)16.0f)).tips1Text(ResourceUtils.getString((int)R.string.invite_tips1)).showIcon(true).tips2Text(ResourceUtils.getString((int)R.string.invite_tips2));
        }
    }

    private void ensureFbListComponent() {
        if (this.mSuggestedFriendsListComponent == null) {
            this.mSuggestedFriendsListComponent = new SuggestedFriendVerticalComponent(this.getContext(), (ViewGroup)this.rlContent, this.mSuggestedFriendVm, this.mClickInvite);
        }
    }

    private void ensureSfTipsComponent() {
        if (this.mSfTipsComponent == null) {
            this.mSfTipsComponent = new SuggestedTipsComponent(this.getContext(), (ViewGroup)this.rlContent);
        }
    }

    public void onShown() {
        super.onShown();
        this.checkContactAuthStatus();
    }

    public void checkContactAuthStatus() {
        ContactUtils.hasContactPermission((Activity)((Activity)this.getContext()), (ContactUtils.IContactPermissionCheckCallBack)new ContactUtils.IContactPermissionCheckCallBack(){

            public void onHasContactPermissionCallBack(final boolean has) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (AddFriendsWindow.this.mRlBarContactFriends != null) {
                            AddFriendsWindow.this.mRlBarContactFriends.setVisibility(has ? 8 : 0);
                        }
                    }
                });
            }
        });
    }

    public void setFacebookItemVisibility(int visibility) {
        if (this.mRlBarFacebookFriends != null) {
            this.mRlBarFacebookFriends.setVisibility(visibility);
        }
        if (8 == visibility) {
            this.mRlBarZaloFriends.setVisibility(8);
        }
    }

    public void showLoading() {
        YYTaskExecutor.postToMainThread((Runnable)this.mShowLoadingTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideLoadingTask, (long)5000L);
    }

    public void hideLoading() {
        YYTaskExecutor.postToMainThread((Runnable)this.mHideLoadingTask);
    }

    public void hideSocialMedia() {
        this.mSocialMedia.setVisibility(8);
        if (this.mSocialMediaBubble != null) {
            this.mSocialMediaBubble.dismiss();
            this.mSocialMediaBubble = null;
        }
    }

    public void showSocialMedia(SocialMediaInfo info) {
        this.mSocialMedia.setVisibility(0);
        this.mSocialMedia.setTag((Object)info);
        Object red = info.getExt("addFriendTips");
        boolean showTips = red instanceof Boolean && (Boolean)red != false;
        this.showSocialMedia(showTips, info.getIconUrl(), info.getText());
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20038709").put("function_id", "follow_but_show").put("follow_enter_type", "1"));
    }

    private void showSocialMedia(boolean showTips, String icon, String content) {
        RecycleImageView iconView = (RecycleImageView)this.mSocialMedia.findViewById(R.id.iv_social_media_icon);
        ImageLoader.loadImage((ImageView)iconView, (String)icon);
        TextView contentView2 = (TextView)this.mSocialMedia.findViewById(R.id.social_media_content);
        contentView2.setText((CharSequence)content);
        if (showTips) {
            this.initSocialMediaBubble();
            if (!this.mSocialMediaBubble.isShowing()) {
                final View socialBtn = this.mSocialMedia.findViewById(R.id.social_media_btn);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (AddFriendsWindow.this.mSocialMediaBubble != null) {
                            AddFriendsWindow.this.mSocialMediaBubble.showArrowTo(socialBtn, BubbleStyle.ArrowDirection.Up, ResolutionUtils.dip2Px((float)10.0f));
                        }
                    }
                }, (long)300L);
            }
        } else if (this.mSocialMediaBubble != null) {
            this.mSocialMediaBubble.dismiss();
        }
    }

    private void initSocialMediaBubble() {
        if (this.mSocialMediaBubble != null) {
            return;
        }
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_green_bubble, null);
        TextView tips = (TextView)view.findViewById(R.id.tips_content);
        tips.setText(R.string.tips_add_friend_social_media);
        BubbleStyle bubbleStyle = (BubbleStyle)view.findViewById(R.id.bfl_root);
        bubbleStyle.setFillColor(ColorUtils.parseColor((String)"#00D672"));
        bubbleStyle.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        this.mSocialMediaBubble = new BubblePopupWindow(view, bubbleStyle);
        this.mSocialMediaBubble.setCancelOnTouchOutside(true);
        this.mSocialMediaBubble.setCancelOnTouch(true);
        this.mSocialMediaBubble.setCancelOnLater(3000L);
        this.mSocialMediaBubble.setPadding(ResolutionUtils.dip2Px((float)10.0f));
    }
}

