/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget.overScroll;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;

public class ImGameListItemDecoration
extends RecyclerView.ItemDecoration {
    private int mPD8;
    private int mPD10;
    private int mPD12;
    private int mPD22;
    private boolean mIsFocusStyle;

    public ImGameListItemDecoration(boolean isFocusStyle) {
        this.mIsFocusStyle = isFocusStyle;
        this.mPD8 = ResolutionUtils.dip2Px((float)8.0f);
        this.mPD10 = ResolutionUtils.dip2Px((float)10.0f);
        this.mPD12 = ResolutionUtils.dip2Px((float)12.0f);
        this.mPD22 = ResolutionUtils.dip2Px((float)22.0f);
    }

    public void setIsFocusStyle(boolean isFocusStyle) {
        this.mIsFocusStyle = isFocusStyle;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state2) {
        super.getItemOffsets(outRect, view, parent, state2);
        LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
        int pos = parent.getChildAdapterPosition(view);
        if (LanguageUtils.isRtl()) {
            if (pos == 0) {
                outRect.set(this.mPD12, 0, this.mPD10, 0);
            } else if (pos == layoutManager.getItemCount() - 1) {
                outRect.set(this.mIsFocusStyle ? this.mPD8 : this.mPD22, 0, 0, 0);
            } else {
                outRect.set(this.mPD12, 0, 0, 0);
            }
        } else if (pos == 0) {
            outRect.set(this.mPD10, 0, this.mPD12, 0);
        } else if (pos == layoutManager.getItemCount() - 1) {
            outRect.set(0, 0, this.mIsFocusStyle ? this.mPD8 : this.mPD22, 0);
        } else {
            outRect.set(0, 0, this.mPD12, 0);
        }
    }
}

