/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget.joinedchannel;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.channel.base.callback.IAdapterNotify;
import com.yy.hiyo.channel.base.service.JoinChannelUnreadManager;
import com.yy.im.R;
import com.yy.im.ui.widget.joinedchannel.JoinedChannelDiffCallback;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class JoinedChannelAdapter
extends RecyclerView.Adapter<MyViewHolder>
implements IAdapterNotify {
    public static final String TAG = "JoinedChannelAdapter";
    private List<JoinedChannelInfo> mData;
    private List<UserInfoKS> mUserInfoList;
    private List<String> mColors;
    private OnItemClickListener mItemClickListener;
    private JoinChannelUnreadManager mUnreadManager;

    public JoinedChannelAdapter(int count) {
        this.mData = new ArrayList<JoinedChannelInfo>(count);
        this.mUnreadManager = new JoinChannelUnreadManager();
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public void setData(List<JoinedChannelInfo> list) {
        if (!FP.empty(list)) {
            block0: for (int i = 0; i < list.size(); ++i) {
                JoinedChannelInfo info = list.get(i);
                this.addUserInfo(info, this.mUserInfoList);
                this.addColor(info, this.mColors, i);
                if (FP.empty(this.mData)) continue;
                for (JoinedChannelInfo groupInfo : this.mData) {
                    if (!StringUtils.equal((String)info.cid, (String)groupInfo.cid)) continue;
                    info.unreadCount = groupInfo.unreadCount;
                    continue block0;
                }
            }
        }
        List<JoinedChannelInfo> tempList = this.reorderByUnread(list);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new JoinedChannelDiffCallback(this.mData, tempList));
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
        this.mData = tempList;
        this.mUnreadManager.init(this.mData, (IAdapterNotify)this);
    }

    public void setBackGround(List<String> colors) {
        this.mColors = colors;
        try {
            if (!FP.empty(this.mData) && !FP.empty(colors)) {
                ArrayList<JoinedChannelInfo> list = new ArrayList<JoinedChannelInfo>(this.getItemCount());
                for (int i = 0; i < this.getItemCount(); ++i) {
                    JoinedChannelInfo info = this.mData.get(i).clone();
                    this.addColor(info, colors, i);
                    list.add(info);
                }
                this.setData(list);
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    public void setUserInfo(List<UserInfoKS> userInfoList) {
        this.mUserInfoList = userInfoList;
        try {
            if (!FP.empty(this.mData) && !FP.empty(userInfoList)) {
                ArrayList<JoinedChannelInfo> list = new ArrayList<JoinedChannelInfo>(this.getItemCount());
                for (int i = 0; i < this.getItemCount(); ++i) {
                    JoinedChannelInfo info = this.mData.get(i).clone();
                    this.addUserInfo(info, userInfoList);
                    list.add(info);
                }
                this.setData(list);
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    private void addUserInfo(JoinedChannelInfo info, List<UserInfoKS> userInfoKSList) {
        if (!FP.empty(userInfoKSList)) {
            for (UserInfoKS userInfoKS : userInfoKSList) {
                if (userInfoKS.uid != info.ownerUid) continue;
                info.gender = userInfoKS.sex;
                info.avatar = userInfoKS.avatar;
                break;
            }
        }
    }

    private void addColor(JoinedChannelInfo info, List<String> colors, int index) {
        if (!FP.empty(colors)) {
            int colorSize = colors.size();
            info.backgroundColor = colorSize < this.getItemCount() ? colors.get(index % colorSize) : colors.get(index);
        }
    }

    public int getItemCount() {
        if (this.mData != null) {
            return this.mData.size();
        }
        return 0;
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_joined_group_list, parent, false);
        MyViewHolder viewHolder = new MyViewHolder(view);
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {
        final JoinedChannelInfo info = this.mData.get(position);
        if (info != null) {
            ImageLoader.loadImage((ImageView)holder.avatar, (String)(info.avatar + YYImageUtils.getThumbnailPostfix((int)35)), (int)(info.gender == UserInfoKS.FEMALE ? R.drawable.icon_avatar_default_female : R.drawable.icon_avatar_default_male));
            holder.name.setText((CharSequence)info.name);
            try {
                GradientDrawable drawable2 = (GradientDrawable)holder.itemBackground.getBackground();
                drawable2.setColor(Color.parseColor((String)info.backgroundColor));
            }
            catch (Exception ex) {
                GradientDrawable drawable3 = (GradientDrawable)holder.itemBackground.getBackground();
                drawable3.setColor(ColorUtils.parseColor((String)"#ffedc9"));
            }
            if (info.unreadCount > 0L) {
                holder.redPoint.setVisibility(0);
                if (info.unreadCount <= 99L) {
                    holder.redPoint.setText((CharSequence)String.valueOf(info.unreadCount));
                } else {
                    holder.redPoint.setText((CharSequence)"99+");
                }
            } else {
                holder.redPoint.setVisibility(4);
            }
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (JoinedChannelAdapter.this.mItemClickListener != null) {
                    JoinedChannelAdapter.this.mItemClickListener.onItemClick(info);
                }
            }
        });
    }

    public void notifyItem(int position) {
        if (this.getItemCount() > position) {
            this.notifyItemChanged(position);
        }
        if (!FP.empty(this.mData)) {
            List<JoinedChannelInfo> tempList = this.reorderByUnread(this.mData);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new JoinedChannelDiffCallback(this.mData, tempList), (boolean)true);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
            this.mData = tempList;
            this.mUnreadManager.init(this.mData, (IAdapterNotify)this);
        }
    }

    private List<JoinedChannelInfo> reorderByUnread(List<JoinedChannelInfo> list) {
        if (!FP.empty(list)) {
            ArrayList<JoinedChannelInfo> sortedList = new ArrayList<JoinedChannelInfo>();
            ArrayList<JoinedChannelInfo> tempList = new ArrayList<JoinedChannelInfo>(list);
            Iterator iterator = tempList.iterator();
            while (iterator.hasNext()) {
                JoinedChannelInfo info = (JoinedChannelInfo)iterator.next();
                if (info == null || info.unreadCount <= 0L) continue;
                sortedList.add(info);
                iterator.remove();
            }
            tempList.addAll(0, sortedList);
            return tempList;
        }
        return list;
    }

    public static interface OnItemClickListener {
        public void onItemClick(JoinedChannelInfo var1);
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        private YYTextView itemBackground;
        private YYTextView redPoint;
        private CircleImageView avatar;
        private YYTextView name;

        public MyViewHolder(View view) {
            super(view);
            this.itemBackground = (YYTextView)view.findViewById(R.id.tv_bg);
            this.itemBackground.setBackgroundResource(R.drawable.shape_bg_joined_group);
            this.redPoint = (YYTextView)view.findViewById(R.id.tv_red_point);
            this.avatar = (CircleImageView)view.findViewById(R.id.civ_avatar);
            this.name = (YYTextView)view.findViewById(R.id.tv_name);
        }
    }
}

