/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.im.R;
import com.yy.im.ui.widget.GameInviteCardLayout;
import com.yy.im.ui.widget.MessageGameLayout;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;

public class GameInviteLayout
extends YYLinearLayout
implements GameInviteCardLayout.IInviteOperateListener {
    public static final int DURATION = 400;
    private IExitGameInviteListener mExitGameInviteListener;
    private MessageGameLayout.IGameOperateListener mGameOperateListener;
    private final int mLenForOneCard = ScreenUtils.getInstance().dip2px(280);
    private final int mLenForTwoCard;
    private final int mCardLenWhenTowCard;
    private final int mCardHeightWhenTwoCards;

    public GameInviteLayout(Context context) {
        this(context, null);
    }

    public GameInviteLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GameInviteLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int sw = this.getResources().getDisplayMetrics().widthPixels;
        int sh = this.getResources().getDisplayMetrics().heightPixels;
        if (sw > sh) {
            sw = sh;
        }
        this.mCardHeightWhenTwoCards = ResolutionUtils.dip2Px((float)158.0f);
        this.mLenForTwoCard = sw - ScreenUtils.getInstance().dip2px(32);
        this.mCardLenWhenTowCard = (sw - ScreenUtils.getInstance().dip2px(32) - ScreenUtils.getInstance().dip2px(12)) / 2;
    }

    public void setExitGameInviteListener(IExitGameInviteListener exitGameInviteListener) {
        this.mExitGameInviteListener = exitGameInviteListener;
    }

    public void setGameOperateListener(MessageGameLayout.IGameOperateListener gameOperateListener) {
        this.mGameOperateListener = gameOperateListener;
    }

    public void show(GameInfo gameInfo, String pkId, int state2, long startTime, String gameModeName, Map<String, Object> extendInfo) {
        this.removeAllViews();
        final GameInviteCardLayout inviteCardLayout = this.createInviteCardLayout(this.mLenForOneCard, -2, 0, gameInfo, pkId, state2, true, startTime, gameModeName);
        inviteCardLayout.setCoverHeight(this.mCardHeightWhenTwoCards);
        this.addView((View)inviteCardLayout);
        this.setVisibility(0);
        RelativeLayout.LayoutParams containLayoutLp = (RelativeLayout.LayoutParams)this.getLayoutParams();
        containLayoutLp.width = this.mLenForOneCard;
        this.setLayoutParams((ViewGroup.LayoutParams)containLayoutLp);
        Animation enterAnim2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.game_invite_layout_enter_anim);
        DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
        enterAnim2.setInterpolator((Interpolator)decelerateInterpolator);
        this.startAnimation(enterAnim2);
        enterAnim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                inviteCardLayout.setJoinBtnStatus(false);
            }

            public void onAnimationEnd(Animation animation) {
                inviteCardLayout.setJoinBtnStatus(true);
                inviteCardLayout.startCountdown();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        boolean isReceive = state2 != 1;
        HiidoEvent event = HiidoEvent.obtain().eventId("20042069").put("function_id", "im_invite_show").put("gid", gameInfo.gid).put("is_self", isReceive ? "2" : "1");
        if (isReceive && extendInfo != null && extendInfo.get("otherUid") instanceof Long) {
            long otherUid = (Long)extendInfo.get("otherUid");
            event.put("is_ai", SystemUtils.isAI((long)otherUid) ? "1" : "2");
        }
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public void hide(boolean isAnim) {
        if (isAnim) {
            Animation anim2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.game_invite_layout_exit_anim);
            DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
            anim2.setInterpolator((Interpolator)decelerateInterpolator);
            this.startAnimation(anim2);
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    GameInviteLayout.this.setVisibility(8);
                    GameInviteLayout.this.removeAllViews();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else {
            this.setVisibility(8);
            this.removeAllViews();
        }
    }

    @Override
    public void gameInviteOperate(int operate, boolean isTimeout, GameInfo gameInfo, String pkId, GameInviteCardLayout layout2, boolean cancelByBack) {
        if (operate != 2) {
            this.popGameInviteCard(gameInfo, pkId, 1);
        }
        if (this.mGameOperateListener != null) {
            this.mGameOperateListener.cancelInvite();
            this.mGameOperateListener.inviteOperate(operate, isTimeout, gameInfo, pkId, cancelByBack);
        }
    }

    public void pushGameInviteCard(GameInfo gameInfo, String pkId, int state2, long startTime, String gameModeName) {
        if (gameInfo == null || this.getChildCount() >= 2) {
            return;
        }
        final GameInviteCardLayout newCardLayout = this.createInviteCardLayout(this.mCardLenWhenTowCard, -2, ScreenUtils.getInstance().dip2px(10), gameInfo, pkId, state2, false, startTime, gameModeName);
        this.addView((View)newCardLayout);
        final GameInviteCardLayout firstCardLayout = (GameInviteCardLayout)this.getChildAt(0);
        final LinearLayout.LayoutParams firstCardLp = (LinearLayout.LayoutParams)firstCardLayout.getLayoutParams();
        final RelativeLayout.LayoutParams containLayoutLp = (RelativeLayout.LayoutParams)this.getLayoutParams();
        final int mainLayoutTotalValue = this.mLenForTwoCard - this.mLenForOneCard;
        final int explodeTotalValue = this.mLenForOneCard - this.mCardLenWhenTowCard;
        ValueAnimator anim2 = this.getValueAnimator();
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                firstCardLp.width = GameInviteLayout.this.mLenForOneCard - explodeTotalValue * (Integer)valueAnimator.getAnimatedValue() / 400;
                containLayoutLp.width = GameInviteLayout.this.mLenForOneCard + mainLayoutTotalValue * (Integer)valueAnimator.getAnimatedValue() / 400;
                GameInviteLayout.this.setLayoutParams((ViewGroup.LayoutParams)containLayoutLp);
                firstCardLayout.setLayoutParams((ViewGroup.LayoutParams)firstCardLp);
                firstCardLayout.setAnimValue((Integer)valueAnimator.getAnimatedValue(), false);
            }
        });
        anim2.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                newCardLayout.startCountdown();
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        anim2.start();
    }

    public void popGameInviteCard(GameInfo gameInfo, String pkId, int state2) {
        if (!this.isContain(pkId)) {
            return;
        }
        if (this.getChildCount() == 1) {
            GameInviteCardLayout cardLayout = (GameInviteCardLayout)this.getChildAt(0);
            cardLayout.popupCard();
            if (this.mExitGameInviteListener != null) {
                this.mExitGameInviteListener.exitInviteLayout();
            }
        } else if (this.getChildCount() > 1) {
            boolean isFirstCard = this.isFirstCard(pkId, state2);
            GameInviteCardLayout cardLayout = isFirstCard ? (GameInviteCardLayout)this.getChildAt(0) : (GameInviteCardLayout)this.getChildAt(1);
            cardLayout.popupCard();
            this.popGameInviteCard(isFirstCard);
        }
    }

    public void exitMessagePage() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            GameInviteCardLayout cardLayout = (GameInviteCardLayout)this.getChildAt(i);
            cardLayout.exitMessagePage();
        }
    }

    private GameInviteCardLayout createInviteCardLayout(int width, int height, int leftMargin, GameInfo gameInfo, String pkId, int state2, boolean onlyOne, long startTime, String gameModeName) {
        GameInviteCardLayout inviteCardLayout = new GameInviteCardLayout(this.getContext());
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(width, height);
        lp.leftMargin = leftMargin;
        inviteCardLayout.setData(gameInfo, pkId, gameModeName);
        inviteCardLayout.setOperateListener(this);
        inviteCardLayout.setState(state2);
        inviteCardLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        inviteCardLayout.setOnlyOne(onlyOne);
        inviteCardLayout.setStartTime(startTime);
        return inviteCardLayout;
    }

    private void popGameInviteCard(final boolean popFirstCard) {
        if (this.getChildCount() < 2) {
            return;
        }
        final GameInviteCardLayout firstCardLayout = (GameInviteCardLayout)this.getChildAt(0);
        final LinearLayout.LayoutParams firstCardLp = (LinearLayout.LayoutParams)firstCardLayout.getLayoutParams();
        final GameInviteCardLayout lastCardLayout = (GameInviteCardLayout)this.getChildAt(1);
        final LinearLayout.LayoutParams lastCardLp = (LinearLayout.LayoutParams)lastCardLayout.getLayoutParams();
        final ViewGroup.LayoutParams containLayoutLp = this.getLayoutParams();
        final int mainLayoutTotalValue = this.mLenForTwoCard - this.mLenForOneCard;
        final int explodeTotalValue = this.mLenForOneCard - this.mCardLenWhenTowCard;
        final int leftMoveTotalValue = this.mCardLenWhenTowCard + ScreenUtils.getInstance().dip2px(10);
        ValueAnimator anim2 = this.getValueAnimator();
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                if (popFirstCard) {
                    firstCardLp.leftMargin = -leftMoveTotalValue * (Integer)valueAnimator.getAnimatedValue() / 400;
                    lastCardLp.width = GameInviteLayout.this.mCardLenWhenTowCard + explodeTotalValue * (Integer)valueAnimator.getAnimatedValue() / 400;
                    lastCardLayout.setAnimValue((Integer)valueAnimator.getAnimatedValue(), true);
                    if ((Integer)valueAnimator.getAnimatedValue() > 200) {
                        firstCardLayout.setAlpha(1.0f - 1.0f * (float)((Integer)valueAnimator.getAnimatedValue()).intValue() / 400.0f + 0.2f);
                    }
                } else {
                    firstCardLp.width = GameInviteLayout.this.mCardLenWhenTowCard + explodeTotalValue * (Integer)valueAnimator.getAnimatedValue() / 400;
                    firstCardLayout.setAnimValue((Integer)valueAnimator.getAnimatedValue(), true);
                    if ((Integer)valueAnimator.getAnimatedValue() > 200) {
                        lastCardLayout.setAlpha(1.0f - 1.0f * (float)((Integer)valueAnimator.getAnimatedValue()).intValue() / 400.0f + 0.2f);
                    }
                }
                containLayoutLp.width = GameInviteLayout.this.mLenForTwoCard - mainLayoutTotalValue * (Integer)valueAnimator.getAnimatedValue() / 400;
                GameInviteLayout.this.setLayoutParams(containLayoutLp);
                lastCardLayout.setLayoutParams((ViewGroup.LayoutParams)lastCardLp);
                firstCardLayout.setLayoutParams((ViewGroup.LayoutParams)firstCardLp);
            }
        });
        anim2.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (popFirstCard) {
                    GameInviteLayout.this.removeView((View)firstCardLayout);
                    lastCardLp.leftMargin = 0;
                    lastCardLayout.setLayoutParams((ViewGroup.LayoutParams)lastCardLp);
                } else {
                    GameInviteLayout.this.removeView((View)lastCardLayout);
                }
                GameInviteLayout.this.checkExitIfEmptyView();
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        anim2.start();
    }

    private ValueAnimator getValueAnimator() {
        ValueAnimator anim2 = ValueAnimator.ofInt((int[])new int[]{0, 400});
        anim2.setDuration(400L);
        anim2.setRepeatCount(0);
        anim2.setRepeatMode(1);
        return anim2;
    }

    private void checkExitIfEmptyView() {
        if (this.getChildCount() == 0 && this.mExitGameInviteListener != null) {
            this.mExitGameInviteListener.exitInviteLayout();
        }
    }

    private boolean isFirstCard(String pkId, int state2) {
        if (this.getChildCount() > 0) {
            GameInviteCardLayout cardLayout = (GameInviteCardLayout)this.getChildAt(0);
            return !TextUtils.isEmpty((CharSequence)cardLayout.getPkId()) && cardLayout.getPkId().equals(pkId);
        }
        return false;
    }

    private boolean isFirstCard(GameInviteCardLayout layout2) {
        if (this.getChildCount() > 0) {
            return this.getChildAt(0) == layout2;
        }
        return false;
    }

    private boolean isContain(String pkId) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            GameInviteCardLayout cardLayout = (GameInviteCardLayout)this.getChildAt(i);
            if (TextUtils.isEmpty((CharSequence)cardLayout.getPkId()) || !cardLayout.getPkId().equals(pkId)) continue;
            return true;
        }
        return false;
    }

    public GameInfo getGameInfoByPkId(String pkId) {
        GameInfo gameInfo = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            GameInviteCardLayout cardLayout = (GameInviteCardLayout)this.getChildAt(i);
            if (TextUtils.isEmpty((CharSequence)cardLayout.getPkId()) || !cardLayout.getPkId().equals(pkId)) continue;
            gameInfo = cardLayout.getData();
            break;
        }
        return gameInfo;
    }

    public void startDownloadGame(GameInfo gameInfo, String pkId) {
        this.initGameState((BasicGameInfo)gameInfo, pkId, true);
    }

    public void gameDownloadFailed(BasicGameInfo gameInfo, String pkId) {
        this.initGameState(gameInfo, pkId, false);
    }

    public void gameDownloadSucceed(GameInfo gameInfo, String pkId) {
        this.initGameState((BasicGameInfo)gameInfo, pkId, false);
    }

    private void initGameState(BasicGameInfo gameInfo, String pkId, boolean isDownloading) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)pkId)) {
            return;
        }
        GameInviteCardLayout layout2 = this.getCardLayoutByPkId(pkId);
        if (layout2 == null) {
            return;
        }
        layout2.setDownloadState(isDownloading);
    }

    private GameInviteCardLayout getCardLayoutByPkId(String pkId) {
        GameInviteCardLayout ret = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            GameInviteCardLayout cardLayout = (GameInviteCardLayout)this.getChildAt(i);
            if (!pkId.equals(cardLayout.getPkId())) continue;
            ret = cardLayout;
            break;
        }
        return ret;
    }

    public void setJoinGame(String pkId) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            GameInviteCardLayout cardLayout = (GameInviteCardLayout)this.getChildAt(i);
            if (!cardLayout.getPkId().equals(pkId)) continue;
            cardLayout.setJoinGame();
            break;
        }
    }

    public boolean isInviteExist(String pkId) {
        boolean isExist = false;
        for (int j = 0; j < this.getChildCount(); ++j) {
            GameInviteCardLayout cardLayout = (GameInviteCardLayout)this.getChildAt(j);
            if (!cardLayout.getPkId().equals(pkId)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public static interface IExitGameInviteListener {
        public void exitInviteLayout();
    }
}

