/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.im.R;
import com.yy.im.ui.widget.GameCountdownBgView;

public class GameCountdownView
extends YYFrameLayout {
    private static final int MAX_TIME = 30;
    private boolean mIsDestroy = false;
    private ICountdownFinishListener mCountdownFinishListener;
    private GameCountdownBgView mGameCountdownBgView;
    private YYTextView numberTv;
    private AnimationSet animationSet;
    private int mState = 1;
    private Runnable countdownRunnable = new Runnable(){

        @Override
        public void run() {
            GameCountdownView.this.mGameCountdownBgView.startCountdown();
            String text = String.valueOf((int)(GameCountdownView.this.getMax() - (float)GameCountdownView.this.getProgress()));
            GameCountdownView.this.numberTv.setText((CharSequence)text);
            GameCountdownView.this.numberTv.startAnimation((Animation)GameCountdownView.this.animationSet);
            if ((float)GameCountdownView.this.getProgress() >= GameCountdownView.this.getMax()) {
                if (GameCountdownView.this.mCountdownFinishListener != null) {
                    GameCountdownView.this.mCountdownFinishListener.countdownFinish();
                }
            } else {
                GameCountdownView.this.postDelayed(this, 1000L);
            }
        }
    };

    public GameCountdownView(Context context) {
        this(context, null);
    }

    public GameCountdownView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GameCountdownView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.im_game_countdown_layout, (ViewGroup)this);
        this.mGameCountdownBgView = (GameCountdownBgView)this.findViewById(R.id.game_countdown_bg);
        this.numberTv = (YYTextView)this.findViewById(R.id.number);
        FontUtils.setFontType((TextView)this.numberTv, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.animationSet = (AnimationSet)AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.game_countdown_number_anim);
    }

    public void setCountdownFinishListener(ICountdownFinishListener countdownFinishListener) {
        this.mCountdownFinishListener = countdownFinishListener;
    }

    private int getProgress() {
        return this.mGameCountdownBgView.getProgress();
    }

    private float getMax() {
        return 30.0f;
    }

    public void startCountdown() {
        if (this.mIsDestroy) {
            return;
        }
        this.removeCallbacks(this.countdownRunnable);
        this.post(this.countdownRunnable);
    }

    public void setBackgroundColor(int color2) {
        if (this.mGameCountdownBgView != null) {
            this.mGameCountdownBgView.setBackgroundColor(color2);
        }
    }

    public void destroy() {
        this.mIsDestroy = true;
        this.removeCallbacks(this.countdownRunnable);
        this.mGameCountdownBgView.destroy();
    }

    public void setState(int state2) {
        this.mState = state2;
    }

    public void setStartTime(long startTime) {
        this.mGameCountdownBgView.setStartTime(this.mState, startTime);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.destroy();
    }

    public static interface ICountdownFinishListener {
        public void countdownFinish();
    }
}

