/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.im.utils.TimeUtils;

public class GameCountdownBgView
extends YYView {
    private static final String TAG = "GameCountdownBgView";
    private static final int MAX_TIME = 30;
    private Paint mBgPaint;
    private Paint mProgressPaint;
    private long mStartTime;
    private int mStrokeWidth;
    private int mCircleRadius;
    private boolean mIsDestroy = false;
    private RectF mTempRectF;
    private int mState = 1;
    private Runnable countdownRunnable = new Runnable(){

        @Override
        public void run() {
            GameCountdownBgView.this.postInvalidate();
            if (GameCountdownBgView.this.getProgress() < GameCountdownBgView.this.getMax()) {
                GameCountdownBgView.this.postDelayed(this, 1000L);
            }
        }
    };

    public GameCountdownBgView(Context context) {
        this(context, null);
    }

    public GameCountdownBgView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GameCountdownBgView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float density = context.getResources().getDisplayMetrics().density;
        this.mTempRectF = new RectF();
        this.mCircleRadius = (int)(20.0f * density);
        this.mStrokeWidth = (int)(3.0f * density);
        this.mBgPaint = new Paint();
        this.mBgPaint.setColor(0x7F000000);
        this.mBgPaint.setAntiAlias(true);
        this.mProgressPaint = new Paint();
        this.mProgressPaint.setColor(-1);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.mProgressPaint.setAntiAlias(true);
    }

    public void setBackgroundColor(int color2) {
        if (this.mBgPaint != null) {
            this.mBgPaint.setColor(color2);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        canvas.drawCircle((float)this.mCircleRadius, (float)this.mCircleRadius, (float)(this.mCircleRadius - this.mStrokeWidth / 2), this.mBgPaint);
        float currentAngle = (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f;
        this.mTempRectF.left = this.mTempRectF.top = (float)(this.mStrokeWidth / 2);
        this.mTempRectF.right = this.mTempRectF.bottom = (float)(this.mCircleRadius * 2 - this.mStrokeWidth / 2);
        canvas.drawArc(this.mTempRectF, currentAngle - 90.0f, 360.0f - currentAngle, false, this.mProgressPaint);
        canvas.restore();
    }

    public int getProgress() {
        if (this.mState == 2) {
            return (int)(TimeUtils.getCurrentTime() - this.mStartTime) / 1000;
        }
        if (this.mState == 1) {
            return (int)(System.currentTimeMillis() - this.mStartTime) / 1000;
        }
        return 0;
    }

    private int getMax() {
        return 30;
    }

    public void startCountdown() {
        if (this.mIsDestroy) {
            return;
        }
        this.removeCallbacks(this.countdownRunnable);
        this.post(this.countdownRunnable);
    }

    public void destroy() {
        this.mIsDestroy = true;
        this.removeCallbacks(this.countdownRunnable);
    }

    public void setStartTime(int state2, long startTime) {
        this.mState = state2;
        this.mStartTime = startTime;
    }
}

