/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.im.R;

public class ClickAndScaleButton
extends YYTextView {
    private Context context;
    private boolean mDownloading = false;
    private View btnShadowView;

    public ClickAndScaleButton(Context context) {
        this(context, null);
        this.context = context;
    }

    public ClickAndScaleButton(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.context = context;
    }

    public ClickAndScaleButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (!this.mDownloading) {
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.beginScale(R.anim.btn_click_to_zoom_out_anim, true);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    this.beginScale(R.anim.btn_click_to_zoom_in_anim, false);
                    break;
                }
            }
        }
        return !this.mDownloading;
    }

    private synchronized void beginScale(int animation, boolean isZoomOut) {
        Animation an = AnimationUtils.loadAnimation((Context)this.context, (int)animation);
        an.setDuration(80L);
        an.setFillAfter(isZoomOut);
        this.startAnimation(an);
        if (this.btnShadowView != null) {
            this.btnShadowView.startAnimation(an);
        }
    }

    public void setDownloading(boolean downloading) {
        this.mDownloading = downloading;
        if (this.mDownloading) {
            this.setBackgroundResource(R.drawable.bg_btn_im_downloading);
            if (this.btnShadowView != null) {
                this.btnShadowView.setVisibility(8);
            }
        } else {
            this.setBackgroundResource(R.drawable.bg_btn_im_game_card_join);
            if (this.btnShadowView != null) {
                this.btnShadowView.setVisibility(0);
            }
        }
    }

    public void setDownloading(boolean downloading, int resId) {
        this.mDownloading = downloading;
        if (this.mDownloading) {
            this.setBackgroundResource(R.drawable.bg_btn_im_downloading);
            if (this.btnShadowView != null) {
                this.btnShadowView.setBackgroundColor(0);
            }
        } else {
            this.setBackgroundResource(R.drawable.bg_btn_im_game_card_join);
            if (this.btnShadowView != null) {
                this.btnShadowView.setBackgroundResource(resId);
            }
        }
    }

    public void setBtnShadowView(View btnShadowView) {
        this.btnShadowView = btnShadowView;
    }
}

