/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import com.yy.base.utils.ScreenUtils;
import com.yy.im.ui.widget.ClickAndScaleButton;

public class ClickAndScaleAutoFixButton
extends ClickAndScaleButton {
    private Paint mTextPaint;
    private float mTextSize;
    private boolean isAutoFit = false;

    public ClickAndScaleAutoFixButton(Context context) {
        super(context);
    }

    public ClickAndScaleAutoFixButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ClickAndScaleAutoFixButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAutoFit(boolean autoFit) {
        this.isAutoFit = autoFit;
    }

    private void refitText(String text, int textViewWidth) {
        if (text == null || textViewWidth <= 0) {
            return;
        }
        this.mTextPaint = new Paint();
        this.mTextPaint.set((Paint)this.getPaint());
        int availableTextViewWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        float[] charsWidthArr = new float[text.length()];
        Rect boundsRect = new Rect();
        this.mTextPaint.getTextBounds(text, 0, text.length(), boundsRect);
        int textWidth = boundsRect.width();
        this.mTextSize = this.getTextSize();
        while (textWidth > availableTextViewWidth) {
            this.mTextSize -= (float)ScreenUtils.getInstance().dip2px(1);
            this.mTextPaint.setTextSize(this.mTextSize);
            textWidth = this.mTextPaint.getTextWidths(text, charsWidthArr);
        }
        this.setTextSize(0, this.mTextSize);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isAutoFit) {
            this.refitText(this.getText().toString(), this.getWidth());
        }
    }
}

