/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.component;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ISessionMsgUIMapper;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.im.R;
import com.yy.im.databinding.ImSessionListBinding;
import com.yy.im.hiido.OfficialDataReportManager;
import com.yy.im.interfaces.IComponent;
import com.yy.im.interfaces.OnItemDataClickListener;
import com.yy.im.interfaces.OnItemDataLongClickListener;
import com.yy.im.localpush.CommonPushType;
import com.yy.im.model.BbsNoticeEntranceSession;
import com.yy.im.model.ChannelEntranceMsg;
import com.yy.im.model.ChannelEntranceSession;
import com.yy.im.model.ChannelNoticeEntranceSession;
import com.yy.im.model.ChatSession;
import com.yy.im.model.CommonMsgChatSession;
import com.yy.im.model.GamePublicChatSession;
import com.yy.im.model.GamePushChatSession;
import com.yy.im.model.LikeMeSession;
import com.yy.im.model.OfficialAccountChatSession;
import com.yy.im.model.PublicChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.model.StrangerEntranceSession;
import com.yy.im.model.WhoHasSeenMeSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.report.LikeMeSessionEventReporter;
import com.yy.im.session.guide.SessionOperateGuideHandler;
import com.yy.im.ui.adapter.ChatSessionAdapter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ChatSessionListComponent
implements IComponent,
ChatSessionAdapter.IInitItemWithDataListener {
    private View mRoot;
    private PullToRefreshListView mChatSession;
    private ChatSessionAdapter mAdapter;
    private int sessionCount = 0;
    private int from;
    private SessionOperateGuideHandler mSessionOperateGuideHandler;
    private ViewGroup mBaseLayer;
    private LiveData<Boolean> mPageState;
    private static final int UNREAD_MSG_LIMIT = 10;
    private long mLastScrollIdleTime = 0L;
    private long mLastShowTime = 0L;
    private List<ChatSession> mReadyToRemoveSessions = new LinkedList<ChatSession>();
    private final Set<String> reportedChatSessionSet = new HashSet<String>();
    private AbsListView.OnScrollListener listListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (scrollState == 0) {
                if (System.currentTimeMillis() - ChatSessionListComponent.this.mLastScrollIdleTime < 1000L) {
                    ChatSessionListComponent.this.mLastScrollIdleTime = System.currentTimeMillis();
                    return;
                }
                ChatSessionListComponent.this.mLastScrollIdleTime = System.currentTimeMillis();
                ChatSessionListComponent.this.addReportShow(view.getFirstVisiblePosition(), view.getLastVisiblePosition(), ((ListView)ChatSessionListComponent.this.mChatSession.getRefreshableView()).getHeaderViewsCount());
                ChatSessionListComponent.this.getUserOnlineState(view.getFirstVisiblePosition(), view.getLastVisiblePosition(), ((ListView)ChatSessionListComponent.this.mChatSession.getRefreshableView()).getHeaderViewsCount(), ((ListView)ChatSessionListComponent.this.mChatSession.getRefreshableView()).getFooterViewsCount());
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }
    };

    public ChatSessionListComponent(Context ctx, ViewGroup vg, OnItemDataClickListener listener, LiveData<List<ChatSession>> sessions, OnItemDataLongClickListener longClickListener, ISessionMsgUIMapper msgUIMapper, int from, ViewGroup baseLayer) {
        this(ctx, vg, listener, sessions, longClickListener, msgUIMapper, from);
        this.mBaseLayer = baseLayer;
    }

    public ChatSessionListComponent(Context ctx, ViewGroup vg, final OnItemDataClickListener listener, final LiveData<List<ChatSession>> sessions, OnItemDataLongClickListener longClickListener, ISessionMsgUIMapper msgUIMapper, final int from) {
        this.from = from;
        ImSessionListBinding binding = (ImSessionListBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)ctx), (int)R.layout.im_session_list, (ViewGroup)vg, (boolean)false);
        HashMap<Integer, Integer> map = null;
        map = msgUIMapper != null ? msgUIMapper.getLayoutIds() : new HashMap<Integer, Integer>();
        this.mAdapter = new ChatSessionAdapter(sessions, map);
        binding.setAdapter(this.mAdapter);
        this.mRoot = binding.getRoot();
        this.mChatSession = binding.lvSession;
        this.mChatSession.setPullToRefreshEnabled(false);
        ((ListView)this.mChatSession.getRefreshableView()).setSelector(ResourceUtils.getDrawable((int)R.drawable.bg_item_transparent_selector));
        ((ListView)this.mChatSession.getRefreshableView()).setOnScrollListener(this.listListener);
        ((ListView)this.mChatSession.getRefreshableView()).setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Object list;
                if (i < ((ListView)ChatSessionListComponent.this.mChatSession.getRefreshableView()).getHeaderViewsCount()) {
                    return;
                }
                int position = i - ((ListView)ChatSessionListComponent.this.mChatSession.getRefreshableView()).getHeaderViewsCount();
                Object object = list = ((ChatSessionListComponent)ChatSessionListComponent.this).mAdapter.isRemovable.get() ? ChatSessionListComponent.this.mAdapter.getDatas() : (List)sessions.getValue();
                if (!FP.empty(list) && position < FP.size(list)) {
                    ChatSession session = (ChatSession)list.get(position);
                    if (((ChatSessionListComponent)ChatSessionListComponent.this).mAdapter.isRemovable.get()) {
                        if (session.getRemoveSelected()) {
                            ChatSessionListComponent.this.mReadyToRemoveSessions.remove(session);
                        } else {
                            ChatSessionListComponent.this.mReadyToRemoveSessions.add(session);
                        }
                        session.setRemoveSelected(!session.getRemoveSelected());
                        return;
                    }
                    if (listener != null) {
                        if (session.getUnReadCounts() > 0) {
                            ChatSessionEventReporter.INSTANCE.reportMessageAccountUnreadClick(session);
                        }
                        listener.onClickItem(view, session, position);
                        session.setIsNew(false);
                        ((ImModule)KvoModuleManager.getModule(ImModule.class)).handleClickItem((Object)session, view, i, from);
                        session.setUnReadCounts(0);
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
                        if (session instanceof BbsNoticeEntranceSession) {
                            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.BBS_NOTICE_READ_ALL_MSG));
                            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.BBS_SQUARE_NOTICE_CLEAR));
                        }
                    }
                }
            }
        });
        ((ListView)this.mChatSession.getRefreshableView()).setOnItemLongClickListener((parent, view, position, id2) -> {
            int positionActual = position - ((ListView)this.mChatSession.getRefreshableView()).getHeaderViewsCount();
            List value = (List)sessions.getValue();
            if (position < ((ListView)this.mChatSession.getRefreshableView()).getHeaderViewsCount() || FP.empty((Collection)value) || positionActual >= value.size()) {
                return true;
            }
            if (longClickListener != null) {
                ChatSession session = (ChatSession)value.get(positionActual);
                ChatSessionEventReporter.INSTANCE.reportLongPress(session);
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).handleLongClickItem((Object)session, view, position, from);
            }
            return true;
        });
        if (msgUIMapper != null && msgUIMapper.getType() == 0) {
            sessions.observeForever((Observer)new Observer<List<ChatSession>>(){

                public void onChanged(@Nullable List<ChatSession> chatSessions) {
                    ChatSessionListComponent.this.setListViewHeightBasedOnChildren();
                }
            });
        }
        this.mAdapter.setInitItemWithDataListener(this);
    }

    @Override
    public void setPageCallback(LiveData<Boolean> pageState) {
        this.mPageState = pageState;
        this.mPageState.observeForever(isPageShow -> {
            if (Boolean.FALSE.equals(isPageShow) && this.mSessionOperateGuideHandler != null) {
                this.mSessionOperateGuideHandler.removeGuideView();
            }
            if (Boolean.FALSE.equals(isPageShow)) {
                if (System.currentTimeMillis() - this.mLastShowTime < 1000L) {
                    this.mLastShowTime = System.currentTimeMillis();
                    return;
                }
                this.mLastShowTime = System.currentTimeMillis();
                int firstPosition = ((ListView)this.mChatSession.getRefreshableView()).getFirstVisiblePosition();
                int lastPosition = ((ListView)this.mChatSession.getRefreshableView()).getLastVisiblePosition();
                int headerCount = ((ListView)this.mChatSession.getRefreshableView()).getHeaderViewsCount();
                this.addReportShow(firstPosition, lastPosition, headerCount);
            } else {
                int firstPosition = ((ListView)this.mChatSession.getRefreshableView()).getFirstVisiblePosition();
                int lastPosition = ((ListView)this.mChatSession.getRefreshableView()).getLastVisiblePosition();
                int headerCount = ((ListView)this.mChatSession.getRefreshableView()).getHeaderViewsCount();
                int footerCount = ((ListView)this.mChatSession.getRefreshableView()).getFooterViewsCount();
                this.getUserOnlineState(firstPosition, lastPosition, headerCount, footerCount);
            }
            this.reportedChatSessionSet.clear();
        });
    }

    private void setListViewHeightBasedOnChildren() {
        ListAdapter listAdapter2 = ((ListView)this.mChatSession.getRefreshableView()).getAdapter();
        if (null == listAdapter2) {
            return;
        }
        if (this.sessionCount == listAdapter2.getCount()) {
            return;
        }
        this.sessionCount = listAdapter2.getCount();
        int totalHeight = 0;
        int len = listAdapter2.getCount();
        for (int i = 0; i < len; ++i) {
            View listItem = listAdapter2.getView(i, null, (ViewGroup)this.mChatSession);
            listItem.measure(0, 0);
            totalHeight += listItem.getMeasuredHeight();
        }
        ViewGroup.LayoutParams params = this.mChatSession.getLayoutParams();
        params.height = totalHeight + ((ListView)this.mChatSession.getRefreshableView()).getDividerHeight() * (listAdapter2.getCount() - 1);
        this.mChatSession.setLayoutParams(params);
    }

    @Override
    public View getRoot() {
        return this.mRoot;
    }

    public PullToRefreshListView getPullToRefreshListView() {
        return this.mChatSession;
    }

    @Override
    public void onWindowAttach() {
        if (this.mAdapter != null) {
            this.mAdapter.onStart();
        }
    }

    @Override
    public void onWindowDetach() {
        if (this.mAdapter != null) {
            this.mAdapter.onDestroy();
        }
    }

    @Override
    public void onInitItemWithData(View itemView, ChatSession chatSession, int position) {
        if (this.mPageState != null && Boolean.TRUE.equals(this.mPageState.getValue())) {
            if (this.reportedChatSessionSet.add(chatSession.getSessionId())) {
                this.reportChatSession(chatSession);
            }
            itemView.post(() -> {
                if (chatSession != null && position == 0 && chatSession.getUnReadCounts() >= 10 && this.mBaseLayer != null && Boolean.TRUE.equals(this.mPageState.getValue()) && this.mSessionOperateGuideHandler == null) {
                    this.mSessionOperateGuideHandler = new SessionOperateGuideHandler(this.mBaseLayer, itemView);
                    this.mSessionOperateGuideHandler.showGuide();
                }
            });
        }
    }

    private void reportChatSession(ChatSession chatSession) {
        if (chatSession instanceof GamePublicChatSession) {
            int page2;
            GamePublicChatSession gamePublicChatSession = (GamePublicChatSession)chatSession;
            boolean entryPage = ((ImModule)KvoModuleManager.getModule(ImModule.class)).getShowGamePublicEntrance();
            int n = page2 = entryPage ? 2 : 1;
            if (gamePublicChatSession.getLastMessage() != null) {
                int jumpType = ((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getJumpType();
                OfficialDataReportManager.INSTANCE.reportMsgShow(((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getReserve1(), ((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getReserve3(), "1", entryPage, page2, jumpType, chatSession.getUnReadCounts());
            }
        } else if (chatSession instanceof OfficialAccountChatSession) {
            boolean entryPage = ((ImModule)KvoModuleManager.getModule(ImModule.class)).getShowOfficialAccountEntrance();
            int page3 = entryPage ? 2 : 1;
            OfficialAccountChatSession oaChatSession = (OfficialAccountChatSession)chatSession;
            ImMessageDBBean bean = (ImMessageDBBean)oaChatSession.getLastMessage();
            if (bean != null) {
                int jumpType = bean.getJumpType();
                int type = bean.getReserveInt1();
                String said = bean.getReserve1();
                if (type == 3 && chatSession.getUnReadCounts() > 0) {
                    page3 = 5;
                    entryPage = false;
                }
                OfficialDataReportManager.INSTANCE.reportMsgShow(type == 3 ? said : bean.getReserve5(), bean.getExtra(), String.valueOf(bean.getReserveInt1()), entryPage, page3, jumpType, chatSession.getUnReadCounts());
            }
        } else if (chatSession instanceof GamePushChatSession) {
            GamePushChatSession gamePushChatSession = (GamePushChatSession)chatSession;
            String type = "5";
            if (((ImMessageDBBean)gamePushChatSession.getLastMessage()).getFromType() == 2) {
                type = "6";
            }
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", type).put("message_id", ((ImMessageDBBean)gamePushChatSession.getLastMessage()).getReserve3()).put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())).put("is_include_no_action_strategy", "0"));
        } else if (chatSession instanceof CommonMsgChatSession) {
            String reserve5;
            CommonMsgChatSession commonMsgChatSession = (CommonMsgChatSession)chatSession;
            ImMessageDBBean lastMessage = (ImMessageDBBean)commonMsgChatSession.getLastMessage();
            String type = String.valueOf(CommonPushType.parseCommonTypeByUrl(lastMessage.getReserve1()));
            if (lastMessage != null && StringUtils.isNotEmpty((String)(reserve5 = lastMessage.getReserve5())) && StringUtils.safeParseBoolean((String)reserve5)) {
                type = "7";
            }
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", type).put("message_id", ((ImMessageDBBean)commonMsgChatSession.getLastMessage()).getReserve3()).put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())).put("is_include_no_action_strategy", "0"));
        } else if (chatSession instanceof LikeMeSession) {
            LikeMeSession likeMeSession = (LikeMeSession)chatSession;
            LikeMeSessionEventReporter.reportSessionShow(likeMeSession);
        } else if (chatSession instanceof SingleChatSession) {
            ChatSessionEventReporter.INSTANCE.reportPersonalUnreadShow(chatSession.getUid(), chatSession.getUnReadCounts(), this.parseStrategyType((SingleChatSession)chatSession));
            UserOnlineDBBean onlineDBBean = chatSession.getUserOnlineDBBean();
            String singleStatus = onlineDBBean == null || !onlineDBBean.isOnline() ? "" : (onlineDBBean.isInRoom() && "radio_video".equals(onlineDBBean.getChannelPlugin()) ? "3" : (onlineDBBean.isInRoom() && "radio_video".equals(onlineDBBean.getChannelPlugin()) ? "2" : "1"));
            IRelationService relationService = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
            String userIdentity = "";
            if (relationService != null) {
                Relation relation = relationService.getRelationLocal(chatSession.getUid()).getRelation();
                userIdentity = relation == Relation.FOLLOW ? "2" : (relation == Relation.FRIEND ? "3" : "1");
            }
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", "2").put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())).put("is_include_no_action_strategy", ((SingleChatSession)chatSession).getStrategyType() > 0 ? "1" : "0").put("new_guide_strategy_type", String.valueOf(((SingleChatSession)chatSession).getNewGuideStrategyType())).put("single_status", singleStatus).put("user_indentity", userIdentity));
        } else if (chatSession instanceof StrangerEntranceSession) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", "9").put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())).put("is_include_no_action_strategy", "0"));
        } else if (chatSession instanceof WhoHasSeenMeSession) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", "10").put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())));
        } else if (chatSession instanceof ChannelEntranceSession) {
            MyJoinChannelItem myJoinChannelItem;
            ChannelEntranceMsg channelEntranceMsg = (ChannelEntranceMsg)chatSession.getLastMessage();
            if (channelEntranceMsg != null && (myJoinChannelItem = channelEntranceMsg.getMyJoinChannelItem()) != null) {
                if (myJoinChannelItem.source.equals("hago.game")) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "game_group_imtab_show").put("gameid", myJoinChannelItem.indieGameId));
                }
                if (myJoinChannelItem.source.equals("hago.channel") && myJoinChannelItem.mPluginData.getPluginId().equals("base")) {
                    String exposeType = "";
                    switch (((ChannelEntranceSession)chatSession).getPid()) {
                        case "chat": {
                            exposeType = "voice chat";
                            break;
                        }
                        case "ludoyuyinfang": {
                            exposeType = "ludo";
                            break;
                        }
                        case "nihuawocai_yn": {
                            exposeType = "draw&guess";
                            break;
                        }
                        case "party": {
                            exposeType = "party";
                            break;
                        }
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", "1").put("im_expose_type", exposeType).put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())));
                }
            }
        } else if (chatSession instanceof PublicChatSession) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", "13").put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())));
        } else if (chatSession instanceof BbsNoticeEntranceSession) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", "11").put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())));
        } else if (chatSession instanceof ChannelNoticeEntranceSession) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_show").put("message_type", "12").put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())));
        }
    }

    private int parseStrategyType(SingleChatSession chatSession) {
        int strategyType = chatSession.getStrategyType();
        if (strategyType <= 0) {
            switch (chatSession.getNewGuideStrategyType()) {
                case 3: {
                    strategyType = 3;
                    break;
                }
                case 1: {
                    strategyType = 4;
                    break;
                }
                case 2: {
                    strategyType = 5;
                    break;
                }
            }
        }
        return strategyType;
    }

    private void addReportShow(int firstPosition, int lastPosition, int headerCount) {
        int start = 0;
        int end = 0;
        if (lastPosition >= 0) {
            if (firstPosition > headerCount) {
                start = firstPosition - headerCount;
            }
            end = lastPosition - headerCount;
            if (start >= 0 && end >= 0 && start < this.mAdapter.getDatas().size() && end < this.mAdapter.getDatas().size()) {
                for (int i = start; i < end + 1; ++i) {
                    ChatSessionEventReporter.INSTANCE.addReportMessageAccountShow((ChatSession)this.mAdapter.getDatas().get(i));
                }
            }
        }
    }

    private void getUserOnlineState(int firstPosition, int lastPosition, int headerCount, int footerCount) {
        int start = 0;
        int end = 0;
        ArrayList<Object> list = new ArrayList<Object>();
        if (lastPosition >= 0) {
            if (firstPosition > headerCount) {
                start = firstPosition - headerCount;
            }
            if ((end = lastPosition - headerCount) == this.mAdapter.getDatas().size()) {
                end -= footerCount;
            }
            if (start >= 0 && end >= 0 && start < this.mAdapter.getDatas().size() && end < this.mAdapter.getDatas().size()) {
                for (int i = start; i < end + 1; ++i) {
                    list.add(this.mAdapter.getDatas().get(i));
                }
            }
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).getUserOnlineState(list);
        }
    }

    public void setRemovable(boolean removable, boolean removeMsg2) {
        if (removable) {
            for (ChatSession session : this.mAdapter.getDatas()) {
                session.setRemoveSelected(true);
                this.mReadyToRemoveSessions.add(session);
            }
        }
        this.mAdapter.isRemovable.set(removable);
        if (this.mAdapter.isRemovable.get()) {
            this.mAdapter.removeObserver();
        } else {
            this.mAdapter.registerObj();
        }
        if (!removable) {
            if (removeMsg2) {
                ArrayList<String> sessionIds = new ArrayList<String>(this.mReadyToRemoveSessions.size());
                for (ChatSession session : this.mReadyToRemoveSessions) {
                    sessionIds.add(session.getSessionId());
                }
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteStrangerSessions(sessionIds);
            } else {
                this.mReadyToRemoveSessions.clear();
            }
        }
    }

    public boolean getRemovable() {
        return this.mAdapter.isRemovable.get();
    }

    public List<ChatSession> getReadyToRemoveSessions() {
        return this.mReadyToRemoveSessions;
    }
}

