/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.im.ImPageSourceData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.ArchiveStrangerSessionConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.R;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.im.model.ChatSession;
import com.yy.im.model.PublicChatSession;
import com.yy.im.model.RechargeAccountChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.OfficialAccountPositionStrategyKt;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import com.yy.im.viewmodel.ChatSessionViewModel;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SingleChatSessionPresenter
extends BaseSessionPresenter
implements INotify {
    private static final String TAG = "SingleChatSessionPresenter";
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(0, ImMessageDBBean.class, SingleChatSession.class);
    private boolean isChatPageShow = false;

    @Override
    @NotNull
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public long getUserUid(ChatSession temp) {
        if (temp instanceof SingleChatSession) {
            return ((SingleChatSession)temp).getTargetUid();
        }
        return 0L;
    }

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(GameNotificationDef.GAME_ACCEPT_INVITE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_ENTER_CHAT_PAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_EXIT_CHAT_PAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(GameNotificationDef.GAME_RESULT_LIKE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_LIKE_PROFILE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_UPDATE_MSG, (INotify)this);
    }

    @Override
    public void notify(Notification notification) {
        ImMessageDBBean msgBean;
        if (notification.id == ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE) {
            List list;
            Object msgs = notification.extObj;
            if (msgs instanceof ImMessageDBBean) {
                this.onReceiveImMessage((ImMessageDBBean)msgs);
            } else if (msgs instanceof List && !(list = (List)msgs).isEmpty()) {
                for (ImMessageDBBean msg : list) {
                    this.onReceiveImMessage(msg);
                }
            }
        } else if (notification.id == GameNotificationDef.GAME_ACCEPT_INVITE) {
            ChatSession session = this.getTargetSession(Utils.getSessionId((long)AccountUtil.getUid(), (long)((Long)notification.extObj)));
            if (this.mISessionCallback != null && session != null && session.isStrangerChat()) {
                this.mISessionCallback.deleteSession(session, false);
                this.mISessionCallback.updateNormalSession(session);
            }
        } else if (notification.id == ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD) {
            if (notification.extObj instanceof String && this.mISessionCallback != null) {
                this.mISessionCallback.ignoreUnRead((String)notification.extObj);
            }
        } else if (notification.id == ImNotificationDef.IM_ENTER_CHAT_PAGE) {
            if (notification.extObj instanceof Long && this.mISessionCallback != null) {
                ChatSessionViewModel.mCurrentChatUid = (Long)notification.extObj;
                this.mISessionCallback.ignoreUnRead(Utils.getSessionId((long)ChatSessionViewModel.mCurrentChatUid, (long)AccountUtil.getUid()));
            }
        } else if (notification.id == ImNotificationDef.IM_EXIT_CHAT_PAGE) {
            ChatSessionViewModel.mCurrentChatUid = 0L;
        } else if (notification.id == GameNotificationDef.GAME_RESULT_LIKE || notification.id == ImNotificationDef.IM_LIKE_PROFILE) {
            if (notification.extObj instanceof Long && this.mISessionCallback != null) {
                long targetUid = (Long)notification.extObj;
                String sessionId2 = Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid);
                ChatSession session = this.getTargetSession(sessionId2);
                if (session != null && session.isStrangerChat()) {
                    this.mISessionCallback.deleteSession(session, false);
                    this.mISessionCallback.updateNormalSession(session);
                }
            }
        } else if (notification.id == ImNotificationDef.IM_UPDATE_MSG && notification.extObj instanceof ImMessageDBBean && (msgBean = (ImMessageDBBean)notification.extObj).getMsgType() == 62) {
            this.updateRevokedMsg(msgBean);
        }
    }

    private void onReceiveImMessage(ImMessageDBBean msg) {
        GameMessageModel model2;
        if (this.messageFilter(msg)) {
            return;
        }
        MLog.debug((Object)TAG, (String)"onReceiveImMessage message uid: %d toUserId: %d, content: %s", (Object[])new Object[]{msg.getUid(), msg.getToUserId(), msg.getContent()});
        ImMessageDBBean copy = ImMessageDBBean.copy((ImMessageDBBean)msg);
        if (TextUtils.isEmpty((CharSequence)copy.getSessionId())) {
            return;
        }
        if (copy.getContentType() == 6 && copy.getExtObj() instanceof GameMessageModel && TextUtils.isEmpty((CharSequence)(model2 = (GameMessageModel)msg.getExtObj()).getGameName())) {
            GameInfo info = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(model2.getGameId());
            if (info == null || TextUtils.isEmpty((CharSequence)info.getGname())) {
                return;
            }
            model2.setGameName(info.getGname());
            msg.setExtObj((Object)model2);
        }
        String sessionId2 = copy.getSessionId();
        ChatSession session = this.getTargetSession(sessionId2);
        boolean isSendByMe = copy.isSendByMe();
        if (session == null) {
            long uid;
            long l = uid = isSendByMe ? copy.getToUserId() : copy.getUid();
            if (uid == 10L || uid == 14L) {
                session = new PublicChatSession(copy);
                OfficialAccountPositionStrategyKt.updateOfficialAccountSessionExposure(session, this.isChatPageShow);
                this.mISessionCallback.updateNormalSession(session);
            } else if (uid == 13L) {
                session = new RechargeAccountChatSession(copy);
                this.mISessionCallback.updateNormalSession(session);
            } else {
                boolean archiveStrangerSession;
                session = new SingleChatSession(copy);
                OfficialAccountPositionStrategyKt.updateOfficialAccountSessionExposure(session, this.isChatPageShow);
                boolean isFollowing = this.isFollowing(session);
                boolean bl = archiveStrangerSession = !isSendByMe && !isFollowing;
                if (NewABDefine.BBS_IM_REC.matchB()) {
                    ArchiveStrangerSessionConfig archiveStrangerSessionConfig = (ArchiveStrangerSessionConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.COUNT_OF_ARCHIVING_STRANGER_SESSION);
                    if (archiveStrangerSession && archiveStrangerSessionConfig != null) {
                        long timeOfLatestReceivingSession = SettingFlags.getLongValue((String)"time_of_receiving_stranger_session", (long)0L);
                        if (TimeUtils.isSameDay((long)timeOfLatestReceivingSession, (long)System.currentTimeMillis())) {
                            SettingFlags.setIntValue((String)"count_of_receiving_stranger_session_today", (int)1);
                        } else {
                            SettingFlags.setIntValue((String)"count_of_receiving_stranger_session_today", (int)(SettingFlags.getIntValue((String)"count_of_receiving_stranger_session_today", (int)0) + 1));
                        }
                        int countOfReceivingSessionToday = SettingFlags.getIntValue((String)"count_of_receiving_stranger_session_today", (int)0);
                        MLog.info((Object)TAG, (String)("count of receiving session today " + countOfReceivingSessionToday + " sessionId " + sessionId2), (Object[])new Object[0]);
                        MLog.info((Object)TAG, (String)("archive stranger config count: " + archiveStrangerSessionConfig.moreThanCountOf()), (Object[])new Object[0]);
                        if (countOfReceivingSessionToday <= archiveStrangerSessionConfig.moreThanCountOf()) {
                            session.setNotArchiveInStrangerSessionContainer(true);
                            archiveStrangerSession = false;
                        }
                    }
                }
                if (archiveStrangerSession) {
                    this.mISessionCallback.updateStrangerSession(session);
                } else {
                    this.mISessionCallback.updateNormalSession(session);
                }
            }
        } else {
            session.update(copy);
            OfficialAccountPositionStrategyKt.updateOfficialAccountSessionExposure(session, this.isChatPageShow);
            if (session.isStrangerChat()) {
                if (isSendByMe) {
                    this.mISessionCallback.deleteSession(session, false);
                    this.mISessionCallback.updateNormalSession(session);
                    this.mISessionCallback.updateNormalSession(this.getTargetSession("-3"));
                } else {
                    this.mISessionCallback.updateStrangerSession(session);
                }
            } else {
                this.mISessionCallback.updateNormalSession(session);
            }
        }
        if (session instanceof SingleChatSession && this.mISessionCallback != null) {
            ((SingleChatSession)session).bindData(this.mISessionCallback.getISingleChatDataChange());
            this.mISessionCallback.getSessionOnlineState(session);
            ((SingleChatSession)session).setStrategyType(msg.getStrategyType());
            ((SingleChatSession)session).setNewGuideStrategyType(msg.getNewGuideStrategyType());
        }
        ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(session);
    }

    private boolean isFollowing(ChatSession session) {
        RelationInfo mRelation = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(session.getUid());
        return mRelation.isFollow();
    }

    private void updateRevokedMsg(ImMessageDBBean msgBean) {
        ChatSession targetSession = this.getTargetSession(msgBean.getSessionId());
        if (targetSession != null) {
            ImMessageDBBean lastMessage = (ImMessageDBBean)targetSession.getLastMessage();
            boolean isLastestMessage = false;
            if (lastMessage.isSendByMe()) {
                isLastestMessage = lastMessage.getClientSendTime() == msgBean.getClientSendTime();
            } else {
                boolean bl = isLastestMessage = lastMessage.getSendTime() == msgBean.getSendTime();
            }
            if (isLastestMessage) {
                if (lastMessage.isSendByMe()) {
                    lastMessage.setContent(ResourceUtils.getString((int)R.string.im_revoked_msg_by_me));
                } else {
                    IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
                    UserInfoKS userInfo = null;
                    if (userInfoService != null) {
                        userInfo = userInfoService.getUserInfo(lastMessage.getUid());
                    }
                    String text = userInfo != null ? userInfo.nick : "";
                    lastMessage.setContent(StringUtils.format((String)ResourceUtils.getString((int)R.string.im_revoked_msg_by_other), (Object[])new Object[]{text}));
                }
                targetSession.setSubTitle(lastMessage.getContent());
                if (this.mISessionCallback != null) {
                    this.mISessionCallback.updateNormalSession(targetSession);
                }
            }
        }
    }

    private boolean messageFilter(Object msg) {
        if (msg == null) {
            return true;
        }
        if (msg instanceof ImMessageDBBean) {
            ImMessageDBBean bean = (ImMessageDBBean)msg;
            boolean isSendByMe = bean.isSendByMe();
            if (bean.getMsgType() == 5 && isSendByMe) {
                return true;
            }
            if (bean.getMsgType() == 37 || bean.getMsgType() == 42 || bean.getMsgType() == 45 || bean.getMsgType() == 47 || bean.getMsgType() == 48 || bean.getMsgType() == 70 || bean.getMsgType() == 77 || bean.getMsgType() == 76) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateUserOnline(ChatSession session, UserOnlineDBBean bean) {
        super.updateUserOnline(session, bean);
        session.setUserOnlineDBBean(bean);
        session.notifyChange();
    }

    @Override
    public boolean isStrangerChat(ChatSession session) {
        if (session != null && "1".equals(session.getSessionFrom())) {
            return true;
        }
        return super.isStrangerChat(session);
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        long uid = chatSession.getUid();
        if (uid <= 0L) {
            MLog.info((Object)TAG, (String)"handleClickItem uid is <=0 chat:%s", (Object[])new Object[]{chatSession});
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(chatSession.getSessionId());
            return;
        }
        ImPageSourceData imPageBean = new ImPageSourceData(uid, 4);
        if (ServiceManagerProxy.getService(ImService.class) != null) {
            ((ImService)ServiceManagerProxy.getService(ImService.class)).openImPage(imPageBean);
        }
    }

    @Override
    public boolean filter(ChatSession session) {
        if (session instanceof SingleChatSession) {
            long targetUid = ((SingleChatSession)session).getTargetUid();
            boolean isBlack = ((IBlacklistService)ServiceManagerProxy.getServiceManager().getService(IBlacklistService.class)).isInBlacklist(targetUid).getInBlacklist();
            return isBlack;
        }
        return false;
    }

    @Override
    public void onChatPageShow() {
        if (this.isChatPageShow) {
            return;
        }
        this.isChatPageShow = true;
    }

    @Override
    public void onChatPageHide() {
        if (!this.isChatPageShow) {
            return;
        }
        this.isChatPageShow = false;
    }
}

