/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.view.View;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.im.ImPageSourceData;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.im.ImService;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import com.yy.im.model.PublicChatSession;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import java.util.ArrayList;

public class PublicChatPresenter
extends BaseSessionPresenter {
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(3, ImMessageDBBean.class, PublicChatSession.class);

    @Override
    public void notify(Notification notification) {
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public long getUserUid(ChatSession temp) {
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        long uid = chatSession.getUid();
        if (uid <= 0L) {
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(chatSession.getSessionId());
            return;
        }
        ImPageSourceData imPageBean = new ImPageSourceData(uid, 4);
        if (ServiceManagerProxy.getService(ImService.class) != null) {
            ((ImService)ServiceManagerProxy.getService(ImService.class)).openImPage(imPageBean);
        }
    }

    @Override
    public void handleLongClickItem(ChatSession session, View v, int position, int from) {
        ArrayList<ButtonItem> buttonList = new ArrayList<ButtonItem>();
        ButtonItem deleteButton2 = this.getCommonDeleteBtnItem(() -> {
            this.clearUnRead(session);
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
        });
        ButtonItem ignoreButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.tips_ignore), () -> this.clearUnRead(session));
        ButtonItem stickTopButton = new ButtonItem(ResourceUtils.getString((int)(session.isStickTop() ? R.string.btn_msg_cancel_stick_top : R.string.btn_msg_stick_top)), () -> {
            boolean stickTop = !session.isStickTop();
            session.setStickTop(stickTop);
            session.setPresentationTime(System.currentTimeMillis());
            session.setPresentWeight(stickTop ? 5 : 0);
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession((Object)session);
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, session.isStickTop() ? "10" : "9");
        });
        if (session.getUnReadCounts() > 0) {
            buttonList.add(ignoreButton2);
        }
        buttonList.add(stickTopButton);
        this.mDialogLinkManager.showCommonPopupDialog(buttonList, true, true);
    }
}

