/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotifyPushToastInfo;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.AbstractGameContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.im.R;
import com.yy.im.localpush.ImLocalPushPresenter;
import com.yy.im.model.ChatSession;
import com.yy.im.model.GamePushChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GamePushSessionPresenter
extends BaseSessionPresenter {
    private static final String TAG = "GamePushSessionPresenter";
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(11, ImMessageDBBean.class, GamePushChatSession.class);
    private ImLocalPushPresenter mPresenter;

    @Override
    public void notify(Notification notification) {
        Object message;
        if (notification.id == ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE) {
            List list;
            Object message2 = notification.extObj;
            if (message2 instanceof ImMessageDBBean) {
                this.onReceiveImMessage((ImMessageDBBean)message2);
            } else if (message2 instanceof List && !(list = (List)message2).isEmpty()) {
                for (ImMessageDBBean msg : list) {
                    this.onReceiveImMessage(msg);
                }
            }
        } else if (notification.id == ImNotificationDef.IM_RECEIVE_COMMON_SESSION && (message = notification.extObj) instanceof ImMessageDBBean) {
            this.onReceiveImMessage((ImMessageDBBean)message);
        }
    }

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        this.mPresenter = callback.getImLocalPushPresenter();
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_COMMON_SESSION, (INotify)this);
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public long getUserUid(ChatSession temp) {
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        chatSession.setUnReadCounts(0);
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession((Object)chatSession);
        GamePushChatSession gamePushChatSession = (GamePushChatSession)chatSession;
        this.joinGame(gamePushChatSession);
        String type = "5";
        if (((ImMessageDBBean)gamePushChatSession.getLastMessage()).getFromType() == 2) {
            type = "6";
        }
        HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", type).put("message_id", ((ImMessageDBBean)gamePushChatSession.getLastMessage()).getReserve3()));
    }

    @Override
    public void handleLongClickItem(ChatSession chatSession, View v, int position, int from) {
        this.showDialogBottom(chatSession);
    }

    private void showDialogBottom(final ChatSession session) {
        ArrayList<ButtonItem> buttonList = new ArrayList<ButtonItem>();
        final GamePushChatSession gamePublicChatSession = (GamePushChatSession)session;
        ButtonItem deleteButton2 = this.getCommonDeleteBtnItem(() -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "1");
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
            this.ignoreOrDelGamePush(gamePublicChatSession);
        });
        ButtonItem ignoreButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.button_ignore_unread), new ButtonItem.OnClickListener(){

            public void onClick() {
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "2");
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (Object)session.getSessionId()));
                GamePushSessionPresenter.this.ignoreOrDelGamePush(gamePublicChatSession);
            }
        });
        if (session.getUnReadCounts() > 0) {
            buttonList.add(ignoreButton2);
        }
        ButtonItem joinGameButton = new ButtonItem(ResourceUtils.getString((int)R.string.tips_short_join_game), () -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "3");
            this.joinGame(gamePublicChatSession);
        });
        buttonList.add(joinGameButton);
        buttonList.add(deleteButton2);
        this.mDialogLinkManager.showCommonPopupDialog(DialogId.GamePublicSessonButtonDialog, buttonList, true, true);
    }

    private void ignoreOrDelGamePush(GamePushChatSession session) {
    }

    private void joinGame(GamePushChatSession gamePublicChatSession) {
        GameInfo gameInfo;
        String gameId = ((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getReserve1();
        if (!StringUtils.isEmpty((String)gameId) && (gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId)) != null) {
            boolean isDownloaded = ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo);
            if (isDownloaded) {
                this.realStartGame(gameInfo, gamePublicChatSession);
            } else {
                MLog.info((Object)TAG, (String)"joinGame gid: %s but not download!!!", (Object[])new Object[]{gameId});
                ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).downloadGame(gameInfo);
            }
        }
    }

    private void realStartGame(GameInfo mGameInfo, GamePushChatSession gamePublicChatSession) {
        switch (mGameInfo.getGameMode()) {
            case 1: 
            case 5: 
            case 7: {
                this.startPk(mGameInfo, gamePublicChatSession);
                break;
            }
            case 4: {
                this.startTeam(mGameInfo, gamePublicChatSession);
                break;
            }
            default: {
                this.startOtherGame(mGameInfo, gamePublicChatSession);
            }
        }
    }

    private void startPk(GameInfo gameInfo, GamePushChatSession gamePublicChatSession) {
        GameMatchContext gameMatchContext = new GameMatchContext(GameContextDef.JoinFrom.FROM_IM_LOCAL_GAME_SESSION);
        gameMatchContext.addExtendValue("sessionId", (Object)((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getSessionId());
        this.addGameFrom(gamePublicChatSession, (AbstractGameContext)gameMatchContext);
        ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).matchGame(gameInfo, gameMatchContext, null);
    }

    private void startTeam(GameInfo gameInfo, GamePushChatSession gamePublicChatSession) {
        GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_IM_LOCAL_GAME_SESSION);
        teamMatchContext.setGameInfo(gameInfo);
        teamMatchContext.addExtendValue("sessionId", (Object)((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getSessionId());
        this.addGameFrom(gamePublicChatSession, (AbstractGameContext)teamMatchContext);
        ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).teamMatchGame(gameInfo, teamMatchContext);
    }

    private void startOtherGame(GameInfo gameInfo, GamePushChatSession gamePublicChatSession) {
        GamePlayContext gamePlayContext = new GamePlayContext(GameContextDef.JoinFrom.FROM_IM_LOCAL_GAME_SESSION);
        gamePlayContext.addExtendValue("sessionId", (Object)((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getSessionId());
        this.addGameFrom(gamePublicChatSession, (AbstractGameContext)gamePlayContext);
        ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, gamePlayContext);
    }

    private void addGameFrom(ChatSession chatSession, AbstractGameContext context) {
        if (11 == chatSession.getSessionType()) {
            context.addExtendValue("game_from", (Object)GameContextDef.GameFrom.GAME_INVITE_JOIN.getId());
        } else if (8 == chatSession.getSessionType()) {
            context.addExtendValue("game_from", (Object)GameContextDef.GameFrom.OFFICIAL_NO_Game.getId());
        }
    }

    private boolean messageFilter(Object msg) {
        if (msg instanceof ImMessageDBBean) {
            ImMessageDBBean bean = (ImMessageDBBean)msg;
            return bean.getMsgType() != 47;
        }
        return true;
    }

    private void onReceiveImMessage(ImMessageDBBean msg) {
        if (this.messageFilter(msg)) {
            return;
        }
        ImMessageDBBean copy = ImMessageDBBean.copy((ImMessageDBBean)msg);
        if (TextUtils.isEmpty((CharSequence)copy.getSessionId())) {
            return;
        }
        String gameId = msg.getReserve1();
        if (FP.empty((CharSequence)gameId)) {
            MLog.error((Object)TAG, (String)"onReceiveImMessage but gameId is null!!!!", (Object[])new Object[0]);
            return;
        }
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo == null) {
            MLog.error((Object)TAG, (String)"onReceiveImMessage gid: %s but gameInfo is null!!!!", (Object[])new Object[]{gameId});
            return;
        }
        String sessionId2 = copy.getSessionId();
        MLog.info((Object)TAG, (String)"onReceiveImMessage sessionId %s", (Object[])new Object[]{sessionId2});
        ChatSession session = this.getTargetSession(sessionId2);
        if (session == null) {
            session = new GamePushChatSession(copy);
            this.mISessionCallback.updateNormalSession(session);
        } else {
            session.update(copy);
            this.mISessionCallback.updateNormalSession(session);
        }
        if (RuntimeContext.sIsForeground && StringUtils.parseBoolean((String)msg.getReserve4(), (boolean)false)) {
            msg.setReserve1(String.format("hago://game/jumpGame?gameId=%s", gameId));
            this.showFloatView(msg);
        }
        ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(session);
    }

    private void showFloatView(ImMessageDBBean msg) {
        MLog.info((Object)TAG, (String)"need showFloatView!!!!", (Object[])new Object[0]);
        Message pushMsg = Message.obtain();
        pushMsg.what = BaseMsgDef.MSG_SHOW_NOTIFY_TOAST;
        NotifyPushToastInfo info = new NotifyPushToastInfo();
        info.setJumpType(10000);
        info.setPushType(10000);
        info.setJumpUri(msg.getReserve1());
        info.setImgUrl(msg.getImageUrl());
        info.setPushTittle(msg.getReserve2());
        info.setPushContent((CharSequence)msg.getContent());
        info.setButtonText(ResourceUtils.getString((int)R.string.im_push_join));
        info.setSource(msg.getSource());
        Bundle bundle = new Bundle();
        bundle.putSerializable("base_toast_info_type", (Serializable)info);
        pushMsg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(pushMsg);
    }
}

