/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoSource;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.wallet.base.IAdService;
import com.yy.im.ImModuleData;
import com.yy.im.model.AdChatMessage;
import com.yy.im.model.AdChatSession;
import com.yy.im.model.ChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AdSessionPresenter
extends BaseSessionPresenter {
    private SessionConfig mSessionConfig = new SessionConfig(1, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(5, AdChatMessage.class, AdChatSession.class);

    @Override
    public long getUserUid(@NotNull ChatSession temp) {
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.CHAT_AD_SESSION, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.CHAT_REMOVE_AD_SESSION, (INotify)this);
    }

    @Override
    public void notify(Notification notification) {
        List sessions;
        KvoSource moduleData;
        ChatSession session;
        if (notification.id == ImNotificationDef.CHAT_AD_SESSION) {
            int adLineNumber = ((IAdService)ServiceManagerProxy.getServiceManager().getService(IAdService.class)).getAdLineNumber(5);
            if (adLineNumber == -1) {
                return;
            }
            ChatSession session2 = this.getTargetSession("-4");
            if (session2 == null) {
                session2 = new AdChatSession();
                ((AdChatSession)session2).setServiceManager(ServiceManagerProxy.getServiceManager());
                if (this.mISessionCallback != null) {
                    this.mISessionCallback.appendAdSessionToIndex((AdChatSession)session2, adLineNumber);
                }
            }
            if (session2 instanceof AdChatSession) {
                ((AdChatSession)session2).setDataNew("");
            }
        } else if (notification.id == ImNotificationDef.CHAT_REMOVE_AD_SESSION && (session = this.getTargetSession("-4")) instanceof AdChatSession && (moduleData = KvoModuleManager.getModuleData(ImModule.class)) instanceof ImModuleData && (sessions = (List)((ImModuleData)moduleData).normalChatSessions.getValue()) != null && sessions.contains(session) && sessions.size() == 1 && this.mISessionCallback != null) {
            this.mISessionCallback.deleteSession(session, false);
        }
    }

    public void interceptAdSession(List<ChatSession> sessions) {
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        int adLineNumber = ((IAdService)ServiceManagerProxy.getServiceManager().getService(IAdService.class)).getAdLineNumber(5);
        if (adLineNumber != -1) {
            ChatSession adSession = this.getTargetSession("-4");
            if (adSession == null) {
                return;
            }
            sessions.remove(adSession);
            if (adLineNumber < 0) {
                adLineNumber = 0;
            }
            if (sessions.size() < adLineNumber) {
                adLineNumber = sessions.size();
            }
            sessions.add(adLineNumber, adSession);
        }
    }

    @Override
    @NotNull
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }
}

