/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.QueryMatcher;
import com.yy.appbase.callback.QueryResult;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.BbsNoticeDBBean;
import com.yy.appbase.data.ChatSessionDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.SubAccountDBBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.AutoUnbindMutableLiveData;
import com.yy.appbase.kvomodule.BaseModuleData;
import com.yy.appbase.kvomodule.BizModule;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.callback.OnUnReadChangeNotify;
import com.yy.appbase.kvomodule.module.ISessionMsgUIMapper;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IOfficialAccountListAuthCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.family.FamilyLuckyBagActivity;
import com.yy.hiyo.channel.base.service.IFamilyLuckyBagService;
import com.yy.hiyo.channel.base.service.channelpartyactivity.IChannelActivityService;
import com.yy.hiyo.game.base.config.GamePublicConfig;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.relation.base.blacklist.data.BlacklistInfo;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.im.ImModuleData;
import com.yy.im.R;
import com.yy.im.interfaces.ISingleChatDataChange;
import com.yy.im.localpush.ImLocalPushPresenter;
import com.yy.im.model.AdChatSession;
import com.yy.im.model.BbsNoticeEntranceSession;
import com.yy.im.model.ChannelEntranceMsg;
import com.yy.im.model.ChannelEntranceSession;
import com.yy.im.model.ChatSession;
import com.yy.im.model.GamePublicChatSession;
import com.yy.im.model.GamePublicEntranceSession;
import com.yy.im.model.GamePublicMessage;
import com.yy.im.model.GamePushChatSession;
import com.yy.im.model.OfficialAccountChatSession;
import com.yy.im.model.OfficialAccountEntranceMessage;
import com.yy.im.model.OfficialAccountEntranceSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.model.StrangerEntranceSession;
import com.yy.im.model.StrangerMessage;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.session.BaseSessionMsgUIMapper;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.OfficialAccountPositionStrategyKt;
import com.yy.im.session.SessionPresenterCenter;
import com.yy.im.session.bean.CacheObserver;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.AdSessionPresenter;
import com.yy.im.session.presenter.ChannelEntranceSessionPresenter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ihago.base.api.subaccount.SAType;
import net.ihago.channel.srv.callact.ActInfo;
import org.jetbrains.annotations.NotNull;

public class ImModuleImplV1
extends BizModule<ImModuleData>
implements ImModule,
ISingleChatDataChange {
    private static final String TAG = "ImModuleImpl";
    private boolean isLoadingData;
    private boolean hasLoadSessionFinish;
    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    private ImLocalPushPresenter mImLocalPushPresenter;
    private LiveData<Map<Long, UserOnlineDBBean>> friendsOnlineStatusLiveData = null;
    private final Map<Long, UserOnlineDBBean> friendsOnlineStatus = new HashMap<Long, UserOnlineDBBean>();
    private final Observer<Map<Long, UserOnlineDBBean>> friendsOnlineChangeObserver = this::friendsOnlineStatusChange;
    private BaseSessionMsgUIMapper mWemeetMapper = new BaseSessionMsgUIMapper(0){

        @Override
        void init() {
            this.put(0, R.layout.im_session_wemeet_item);
        }
    };
    private BaseSessionMsgUIMapper mNormalMapper = new BaseSessionMsgUIMapper(1){

        @Override
        void init() {
            this.put(0, R.layout.im_session_item);
            this.put(1, R.layout.im_session_ad_item);
            this.put(2, R.layout.im_channel_entrace_session_item);
            this.put(3, R.layout.im_channel_entrace_session_item_new);
        }
    };
    private BaseSessionMsgUIMapper mStrangerMapper = new BaseSessionMsgUIMapper(2){

        @Override
        void init() {
            this.put(0, R.layout.im_session_item_stranger);
            this.put(1, R.layout.im_session_ad_item);
            this.put(2, R.layout.im_channel_entrace_session_item);
            this.put(3, R.layout.im_channel_entrace_session_item_new);
        }
    };
    private List<WeakReference<OnUnReadChangeNotify>> mUnreadNotifys = new ArrayList<WeakReference<OnUnReadChangeNotify>>();
    private Observer normalSessionsObs = chatSessions -> this.updateNormalUnreadCounts();
    private Observer channelSessionsObs = chatSessions -> this.updateChannelUnread();
    private List<ChatSession> mCacheStrangeSessions = null;
    private int mCacheStrangeSize = 0;
    private CacheObserver strangerSessionsObs = new CacheObserver<List<ChatSession>>(){
        private Runnable mRunnable = () -> this.updateStrangeSession(ImModuleImplV1.this.mCacheStrangeSessions, ImModuleImplV1.this.mCacheStrangeSize);

        @Override
        public void onChangedInnerV1(List<ChatSession> chatSessions, int oldSize) {
            ImModuleImplV1.this.mCacheStrangeSessions = chatSessions;
            ImModuleImplV1.this.mCacheStrangeSize = oldSize;
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRunnable);
            YYTaskExecutor.postToMainThread((Runnable)this.mRunnable, (long)300L);
        }

        private void updateStrangeSession(List<ChatSession> chatSessions, int oldSize) {
            if (chatSessions == null || chatSessions.isEmpty()) {
                ChatSession<Object> entrance = ImModuleImplV1.this.getTargetSession("-3");
                if (entrance != null) {
                    ImModuleImplV1.this.deleteSession(entrance, true);
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"stranger session empty and remove exist", (Object[])new Object[0]);
                } else {
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"stranger session empty and entrance not exist", (Object[])new Object[0]);
                }
            } else {
                int nowSum = chatSessions != null ? chatSessions.size() : 0;
                int priviousSum = oldSize;
                boolean hasAppendOne = nowSum == priviousSum + 1;
                ArrayList<ChatSession> sessions = new ArrayList<ChatSession>(chatSessions);
                StrangerEntranceSession session = ImModuleImplV1.this.getTargetSession("-3");
                if (session == null) {
                    session = new StrangerEntranceSession(new StrangerMessage(sessions));
                    ImModuleImplV1.this.updateStrangerUnreadCounts(hasAppendOne);
                    ImModuleImplV1.this.updateSession(session);
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"stranger session not empty and append entrance", (Object[])new Object[0]);
                } else {
                    ImModuleImplV1.this.updateStrangerSessions(session, sessions);
                    ImModuleImplV1.this.updateStrangerUnreadCounts(hasAppendOne);
                    ImModuleImplV1.this.updateNormalUnreadCounts();
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"stranger session not empty and update entrance", (Object[])new Object[0]);
                }
            }
            if (RuntimeContext.isHagoPartySdk()) {
                List list = (List)((ImModuleData)((ImModuleImplV1)ImModuleImplV1.this).mData).normalChatSessions.getValue();
                ((ImModuleData)((ImModuleImplV1)ImModuleImplV1.this).mData).normalChatSessions.setValue((Object)list);
            }
        }

        @Override
        public int sizeOf(List<ChatSession> data2) {
            return data2 != null ? data2.size() : 0;
        }
    };
    private CacheObserver gamePublicSessionsObs = new CacheObserver<List<ChatSession>>(){

        @Override
        public void onChangedInnerV1(List<ChatSession> chatSessions, int oldSize) {
            MLog.info((Object)ImModuleImplV1.TAG, (String)"game public begin oldSize=%s", (Object[])new Object[]{oldSize});
            if (chatSessions == null || chatSessions.isEmpty()) {
                ChatSession<Object> entrance = ImModuleImplV1.this.getTargetSession("-6");
                if (entrance != null) {
                    ImModuleImplV1.this.deleteSession(entrance, true);
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"game public session empty and remove exist", (Object[])new Object[0]);
                } else {
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"game public session empty and entrance not exist", (Object[])new Object[0]);
                }
            } else {
                int nowSum;
                int n = nowSum = chatSessions != null ? chatSessions.size() : 0;
                if (!ImModuleImplV1.this.isShowGamePublicEntrance(nowSum)) {
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"gamePublicSessionsObs not isShowGamePublicEntrance", (Object[])new Object[0]);
                    ChatSession<Object> session = ImModuleImplV1.this.getTargetSession("-6");
                    if (session != null) {
                        MLog.info((Object)ImModuleImplV1.TAG, (String)"gamePublicSessionsObs delete", (Object[])new Object[0]);
                        ImModuleImplV1.this.deleteSession("-6");
                        for (ChatSession chatSession : chatSessions) {
                            ImModuleImplV1.this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)((ImModuleImplV1)ImModuleImplV1.this).mData).normalChatSessions, chatSession);
                        }
                    }
                    return;
                }
                int priviousSum = oldSize;
                boolean hasAppendOne = nowSum == priviousSum + 1;
                ImModuleImplV1.this.filterGameAll(chatSessions);
                ArrayList<ChatSession> sessions = new ArrayList<ChatSession>(chatSessions);
                ImModuleImplV1.this.filterGameAll(sessions);
                GamePublicEntranceSession session = ImModuleImplV1.this.getTargetSession("-6");
                if (session == null) {
                    session = new GamePublicEntranceSession(new GamePublicMessage(sessions));
                    ImModuleImplV1.this.updateGamePublicUnreadCounts(hasAppendOne);
                    ImModuleImplV1.this.updateSession(session);
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"game public session not empty and append entrance", (Object[])new Object[0]);
                } else {
                    ImModuleImplV1.this.updateGamePublicEntranceSessions(session, sessions);
                    ImModuleImplV1.this.updateGamePublicUnreadCounts(hasAppendOne);
                    ImModuleImplV1.this.updateNormalUnreadCounts();
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"game public session not empty and update entrance", (Object[])new Object[0]);
                }
                ImModuleImplV1.this.deleteDataBySessionFrom((MutableLiveData<List<ChatSession>>)((ImModuleData)((ImModuleImplV1)ImModuleImplV1.this).mData).normalChatSessions, "4");
            }
        }

        @Override
        public int sizeOf(List<ChatSession> data2) {
            return data2 != null ? data2.size() : 0;
        }
    };
    private ISessionPresenter.ISessionCallback mISessionCallback = new ISessionPresenter.ISessionCallback(){

        @Override
        public void getSessionOnlineState(ChatSession session) {
            ImModuleImplV1.this.getSessionOnlineState(session);
        }

        @Override
        public void deleteUnsubscribeSession(List<SubAccountDBBean> accountDBBeanList) {
            ImModuleImplV1.this.deleteUnsubscribeSession(accountDBBeanList);
        }

        @Override
        public boolean isShowOfficialAccountEntrance() {
            return ImModuleImplV1.this.isShowOfficialAccountEntrance();
        }

        @Override
        public boolean isShowGamePublicEntrance() {
            return ImModuleImplV1.this.isShowGamePublicEntrance();
        }

        @Override
        @NotNull
        public ISingleChatDataChange getISingleChatDataChange() {
            return ImModuleImplV1.this;
        }

        @Override
        public void appendAdSessionToIndex(@NotNull AdChatSession session, int adLineNumber) {
            ImModuleImplV1.this.appendAdChatSessionToNormalList(session, adLineNumber);
        }

        @Override
        public void ignoreUnRead(@NotNull String sessionId2) {
            ImModuleImplV1.this.ignoreUnread(sessionId2);
        }

        @Override
        public void deleteSession(@NotNull ChatSession session, boolean deleteMsg) {
            ImModuleImplV1.this.deleteSession(session, false);
            if (deleteMsg) {
                ImModuleImplV1.this.deleteSessionMsg(session);
            }
        }

        @Override
        public void deleteSession(@NotNull ChatSession session, boolean deleteSessionIncludeDB, boolean deleteMsg) {
            ImModuleImplV1.this.deleteSession(session, deleteSessionIncludeDB);
            if (deleteMsg) {
                ImModuleImplV1.this.deleteSessionMsg(session);
            }
        }

        @Override
        public void updateStrangerSession(ChatSession session) {
            ImModuleImplV1.this.updateStrangerSession(session);
        }

        @Override
        public void updateGamePublicSession(ChatSession session) {
            ImModuleImplV1.this.updateGamePublicSession(session);
        }

        @Override
        public void updateBbsNoticeSession(ChatSession session) {
            ImModuleImplV1.this.updateBbsNoticeSession(session);
        }

        @Override
        public void updateNoticeStartShowSession(ChatSession session) {
            ImModuleImplV1.this.updateNoticeStartShowSession(session);
        }

        @Override
        public void updateOfficialAccountSession(ChatSession session) {
            ImModuleImplV1.this.updateOfficialAccountSession(session);
        }

        @Override
        public void updateNormalSession(ChatSession session) {
            ImModuleImplV1.this.updateSession(session);
        }

        @Override
        public void updateChannelSession(ChatSession session) {
            ImModuleImplV1.this.updateChannelSession(session);
        }

        @Override
        public ChatSession<Object> getTargetSession(@NotNull String sessionId2) {
            return ImModuleImplV1.this.getTargetSession(sessionId2);
        }

        @Override
        public ImLocalPushPresenter getImLocalPushPresenter() {
            return ImModuleImplV1.this.mImLocalPushPresenter;
        }

        @Override
        public List<GamePushChatSession> getLocalGamePushSession() {
            return ImModuleImplV1.this.getLocalGamePushChatSeesions();
        }

        @Override
        public void updateNormalSessions(List<Object> updates) {
            ImModuleImplV1.this.updateSessions(updates);
        }

        @Override
        public void updateChannelSessions(List<Object> updates) {
            ImModuleImplV1.this.updateChannelSessions(updates);
        }

        @Override
        public ArrayList<ChatSession> getChannelSessions() {
            List listInSessions;
            ArrayList<ChatSession> result = new ArrayList<ChatSession>();
            if (((ImModuleData)((ImModuleImplV1)ImModuleImplV1.this).mData).channelChatSessions != null && (listInSessions = (List)((ImModuleData)((ImModuleImplV1)ImModuleImplV1.this).mData).channelChatSessions.getValue()) != null) {
                result.addAll(listInSessions);
            }
            return result;
        }
    };
    private SessionPresenterCenter mSessionPresenterCenter = new SessionPresenterCenter(this.mISessionCallback);
    private CacheObserver officialAccountSessionsObs = new CacheObserver<List<ChatSession>>(){

        @Override
        public void onChangedInnerV1(List<ChatSession> chatSessions, int oldSize) {
            MLog.info((Object)ImModuleImplV1.TAG, (String)"officialAccount begin oldSize=%s", (Object[])new Object[]{oldSize});
            if (chatSessions == null || chatSessions.isEmpty()) {
                ChatSession<Object> entrance = ImModuleImplV1.this.getTargetSession("-8");
                if (entrance != null) {
                    ImModuleImplV1.this.deleteSession(entrance, true);
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"officialAccount session empty and remove exist", (Object[])new Object[0]);
                } else {
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"officialAccount session empty and entrance not exist", (Object[])new Object[0]);
                }
            } else {
                int nowSum;
                int n = nowSum = chatSessions != null ? chatSessions.size() : 0;
                if (!ImModuleImplV1.this.isShowGamePublicEntrance(nowSum)) {
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"official AccountSessionsObs not isShowGamePublicEntrance", (Object[])new Object[0]);
                    ChatSession<Object> session = ImModuleImplV1.this.getTargetSession("-8");
                    if (session != null) {
                        MLog.info((Object)ImModuleImplV1.TAG, (String)"official AccountSessionsObs delete", (Object[])new Object[0]);
                        ImModuleImplV1.this.deleteSession("-8");
                        for (ChatSession chatSession : chatSessions) {
                            ImModuleImplV1.this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)((ImModuleImplV1)ImModuleImplV1.this).mData).normalChatSessions, chatSession);
                        }
                    }
                    return;
                }
                int priviousSum = oldSize;
                boolean hasAppendOne = nowSum == priviousSum + 1;
                ArrayList<ChatSession> sessions = new ArrayList<ChatSession>(chatSessions);
                OfficialAccountEntranceSession session = ImModuleImplV1.this.getTargetSession("-8");
                if (session == null) {
                    session = new OfficialAccountEntranceSession(new OfficialAccountEntranceMessage(sessions));
                    ImModuleImplV1.this.updateOfficialAccountUnreadCounts(hasAppendOne);
                    ImModuleImplV1.this.updateSession(session);
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"officialAccount session not empty and append entrance", (Object[])new Object[0]);
                } else {
                    ImModuleImplV1.this.updateOfficialAccountEntranceSessions(session, sessions);
                    ImModuleImplV1.this.updateOfficialAccountUnreadCounts(hasAppendOne);
                    ImModuleImplV1.this.updateNormalUnreadCounts();
                    MLog.info((Object)ImModuleImplV1.TAG, (String)"officialAccount session not empty and update entrance", (Object[])new Object[0]);
                }
                ImModuleImplV1.this.deleteDataBySessionFrom((MutableLiveData<List<ChatSession>>)((ImModuleData)((ImModuleImplV1)ImModuleImplV1.this).mData).normalChatSessions, "5");
            }
        }

        @Override
        public int sizeOf(List<ChatSession> data2) {
            return data2 != null ? data2.size() : 0;
        }
    };
    private Observer<FamilyLuckyBagActivity> mLuckyBagOb = act -> {
        MLog.debug((Object)TAG, (String)(act == null ? "lucky bag activity null" : act.toString()), (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread(() -> {
            List normal = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
            if (normal == null || normal.isEmpty()) {
                return;
            }
            for (ChatSession session : normal) {
                if (session == null || session.getLastMessage() == null || !(session instanceof ChannelEntranceSession) || ((ChannelEntranceMsg)((ChannelEntranceSession)session).getLastMessage()).getMyJoinChannelItem() == null || !((ChannelEntranceMsg)((ChannelEntranceSession)session).getLastMessage()).getMyJoinChannelItem().isFamily()) continue;
                ((ChannelEntranceSession)session).mHadLuckyBagActivity = act != null && !act.getHadGain();
                session.notifyChange();
                break;
            }
        }, (long)3000L);
    };
    private final Observer<List<ActInfo>> mMyJoinChannelActivityOb = list -> {
        MLog.debug((Object)"cpt", (String)(list == null ? "my join channel activity null" : "\u6536\u5230\u56de\u8c03\u6570\u636e " + list.size() + " list= " + list.toString()), (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread(() -> {
            List normal = (List)((ImModuleData)this.mData).channelChatSessions.getValue();
            if (normal == null || normal.isEmpty()) {
                return;
            }
            IChannelActivityService activityService = (IChannelActivityService)ServiceManagerProxy.getService(IChannelActivityService.class);
            if (activityService == null) {
                return;
            }
            for (ChatSession session : normal) {
                if (session == null || session.getLastMessage() == null || !(session instanceof ChannelEntranceSession) || ((ChannelEntranceMsg)((ChannelEntranceSession)session).getLastMessage()).getMyJoinChannelItem() == null || ((ChannelEntranceMsg)((ChannelEntranceSession)session).getLastMessage()).getMyJoinChannelItem().isFamily()) continue;
                ChannelEntranceSession entranceSession = (ChannelEntranceSession)session;
                MyJoinChannelItem channelItem = ((ChannelEntranceMsg)entranceSession.getLastMessage()).getMyJoinChannelItem();
                ActInfo actInfo = activityService.getPlanChannelActivityByCid(channelItem.cid);
                if (actInfo == null || TextUtils.isEmpty((CharSequence)actInfo.act_id) || SettingFlags.getBoolean((String)("k_i_l_c_a_t_i_show" + actInfo.act_id), (boolean)false)) continue;
                entranceSession.hasChannelActivity = true;
                entranceSession.channelActivityName = actInfo.name;
                entranceSession.channelActivityId = actInfo.act_id;
                ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(entranceSession.getClass());
                if (presenter instanceof ChannelEntranceSessionPresenter) {
                    ((ChannelEntranceSessionPresenter)presenter).updateMsgStyle(entranceSession);
                }
                session.notifyChange();
            }
        }, (long)3000L);
    };

    private void filterGameAll(List<ChatSession> sessions) {
        if (!FP.empty(sessions)) {
            int removeIndex = -1;
            for (int i = 0; i < sessions.size(); ++i) {
                ImMessageDBBean imMessageDBBean;
                if (!(sessions.get(i).getLastMessage() instanceof ImMessageDBBean) || (imMessageDBBean = (ImMessageDBBean)sessions.get(i).getLastMessage()).getReserveInt1() != SAType.GAME_ALL.getValue()) continue;
                removeIndex = i;
                break;
            }
            if (removeIndex != -1) {
                sessions.remove(removeIndex);
            }
        }
    }

    public ImModuleImplV1(ImModuleData mData) {
        super((BaseModuleData)mData);
    }

    public SessionPresenterCenter getSessionPresenterCenter() {
        return this.mSessionPresenterCenter;
    }

    public void onCreate(IServiceManager serviceManager, Environment evn) {
        super.onCreate(serviceManager, evn);
        if (this.isLoadingData || this.hasLoadSessionFinish) {
            return;
        }
        this.mImLocalPushPresenter = new ImLocalPushPresenter(this.mISessionCallback);
        this.mSessionPresenterCenter.init(evn);
        if (RuntimeContext.isHagoPartySdk()) {
            ((ImModuleData)this.mData).normalChatSessions.observeForever(this.normalSessionsObs);
            ((ImModuleData)this.mData).strangerChatSessions.observeForever((Observer)this.strangerSessionsObs);
            ((ImModuleData)this.mData).channelChatSessions.observeForever(this.channelSessionsObs);
        } else {
            ((ImModuleData)this.mData).normalChatSessions.observeForever(this.normalSessionsObs);
            ((ImModuleData)this.mData).strangerChatSessions.observe((LifecycleOwner)evn.getActivity(), (Observer)this.strangerSessionsObs);
            ((ImModuleData)this.mData).gamePublicChatSessions.observe((LifecycleOwner)evn.getActivity(), (Observer)this.gamePublicSessionsObs);
            ((ImModuleData)this.mData).officialAccountChatSessions.observe((LifecycleOwner)evn.getActivity(), (Observer)this.officialAccountSessionsObs);
        }
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_UNREAD_COUNTS_CHANGE, (INotify)this);
        this.loadChatSessions();
        YYTaskExecutor.postToMainThread(() -> this.mImLocalPushPresenter.judgeAndSendMsgPush(), (long)1000L);
        if (!RuntimeContext.isHagoPartySdk() && ServiceManagerProxy.getServiceManager() != null) {
            ServiceManagerProxy.getServiceManager().observeService(IFamilyLuckyBagService.class, service2 -> service2.getMLuckyBagActivityLiveData().observe((LifecycleOwner)this.getEnv().getActivity(), this.mLuckyBagOb));
            ServiceManagerProxy.getServiceManager().observeService(IChannelActivityService.class, service2 -> {
                service2.getMyJoinChannelActivityListLiveData().observe((LifecycleOwner)evn.getActivity(), this.mMyJoinChannelActivityOb);
                service2.fetchMyJoinChannelPlanActivity();
            });
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == ImNotificationDef.IM_UNREAD_COUNTS_CHANGE) {
            this.updateNormalUnreadCounts();
            this.updateStrangerUnreadCounts(false);
            this.updateGamePublicUnreadCounts(false);
        }
    }

    private void loadChatSessionFromDB() {
        IDBService idbService = null;
        if (this.getService() == null || (idbService = (IDBService)this.getService().getService(IDBService.class)) == null) {
            this.isLoadingData = false;
            return;
        }
        MyBox mybox = idbService.boxForCurUser(ChatSessionDBBean.class);
        if (mybox == null) {
            this.isLoadingData = false;
            return;
        }
        mybox.getAll(datas -> YYTaskExecutor.execute(() -> {
            MLog.info((Object)TAG, (String)("load chat session from db, size = " + (datas != null ? datas.size() : 0)), (Object[])new Object[0]);
            ArrayList<ChatSession> normalList = new ArrayList<ChatSession>();
            ArrayList<ChatSession> channelList = new ArrayList<ChatSession>();
            ArrayList<ChatSession> strangerList = new ArrayList<ChatSession>();
            ArrayList<ChatSession> gamePublicList = new ArrayList<ChatSession>();
            ArrayList<ChatSession> officialAccountList = new ArrayList<ChatSession>();
            if (datas != null && !datas.isEmpty()) {
                for (ChatSessionDBBean item : datas) {
                    ChatSession session = ChatSession.generateWithDBModel(item);
                    if (session == null || !session.isValid()) continue;
                    ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(session.getClass());
                    if (presenter != null) {
                        if (presenter.filter(session)) continue;
                        boolean isStranger = presenter.isStrangerChat(session);
                        if (isStranger) {
                            strangerList.add(session);
                        } else if (session instanceof ChannelEntranceSession) {
                            channelList.add(session);
                            MLog.info((Object)TAG, (String)"loadChatSessionFromDB add channel cid:%s, num:%d", (Object[])new Object[]{session.getSessionId(), session.getUnReadCounts()});
                        } else {
                            normalList.add(session);
                        }
                    } else {
                        normalList.add(session);
                    }
                    if (session instanceof GamePublicChatSession) {
                        gamePublicList.add(session);
                    }
                    if (!(session instanceof OfficialAccountChatSession)) continue;
                    officialAccountList.add(session);
                }
            }
            this.sortSessions(normalList);
            this.sortSessions(channelList);
            this.sortSessions(strangerList);
            this.sortSessions(gamePublicList);
            this.sortSessions(officialAccountList);
            YYTaskExecutor.postToMainThread(() -> {
                ((ImModuleData)this.mData).normalChatSessions.setValue((Object)normalList);
                ((ImModuleData)this.mData).channelChatSessions.setValue((Object)channelList);
                ((ImModuleData)this.mData).strangerChatSessions.setValue((Object)strangerList);
                ((ImModuleData)this.mData).gamePublicChatSessions.setValue((Object)gamePublicList);
                ((ImModuleData)this.mData).officialAccountChatSessions.setValue((Object)officialAccountList);
                this.onLoadCacheFinish(strangerList, normalList);
                this.isLoadingData = false;
                this.hasLoadSessionFinish = true;
            });
        }));
    }

    private void onLoadCacheFinish(List<ChatSession> stranger, List<ChatSession> normal) {
        ArrayList<ChatSession> copy = new ArrayList<ChatSession>();
        if (stranger != null && !stranger.isEmpty()) {
            copy.addAll(stranger);
        }
        if (normal != null && !normal.isEmpty()) {
            copy.addAll(normal);
        }
        if (!copy.isEmpty()) {
            IUserInfoService userInfoService;
            HashSet<Long> uids = new HashSet<Long>();
            final HashMap<Long, String> strangerUidToSession = new HashMap<Long, String>();
            ArrayList<Long> strangerSession = new ArrayList<Long>();
            for (ChatSession session : copy) {
                if (!(session instanceof SingleChatSession)) continue;
                ((SingleChatSession)session).bindData(this);
                uids.add(((SingleChatSession)session).getTargetUid());
                if (!session.isStrangerChat()) continue;
                long uid = session.getUid();
                strangerSession.add(uid);
                strangerUidToSession.put(uid, session.getSessionId());
            }
            if (!strangerSession.isEmpty() && (userInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)) != null) {
                userInfoService.requestOfficialAccountListAuth(strangerSession, new IOfficialAccountListAuthCallback(){

                    public void onSuccess(Map<Long, Boolean> officialAccountAuth) {
                        for (Map.Entry<Long, Boolean> entry : officialAccountAuth.entrySet()) {
                            String sessionId2;
                            long uid = entry.getKey();
                            boolean isOfficialAccountAuth = entry.getValue();
                            if (!isOfficialAccountAuth || (sessionId2 = (String)strangerUidToSession.get(uid)) == null) continue;
                            ChatSession<Object> session = ImModuleImplV1.this.getTargetSession(sessionId2);
                            ImModuleImplV1.this.deleteSession(session, false);
                            ImModuleImplV1.this.updateSession(session);
                        }
                    }

                    public void onFailed() {
                    }
                });
            }
            if (!uids.isEmpty()) {
                ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(new ArrayList(uids), null);
                this.getSessionOnlineState(copy);
                MLog.debug((Object)TAG, (String)"load all user info and online status:%s", (Object[])new Object[]{uids});
            }
        }
        this.mSessionPresenterCenter.onLoadDataFinish(stranger, normal);
    }

    private void updateStrangerSessions(ChatSession session, List<ChatSession> listData) {
        if (session instanceof StrangerEntranceSession && listData != null && !listData.isEmpty()) {
            StrangerMessage msg = (StrangerMessage)session.getLastMessage();
            msg.chatSessions = listData;
            session.update(msg);
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)TAG, (String)"update strange session entrance cell:%s", (Object[])new Object[]{session.getSessionId()});
            }
        }
    }

    private void updateGamePublicEntranceSessions(ChatSession session, List<ChatSession> listData) {
        if (session instanceof GamePublicEntranceSession && listData != null && !listData.isEmpty()) {
            GamePublicMessage msg = (GamePublicMessage)session.getLastMessage();
            msg.chatSessions = listData;
            session.update(msg);
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)TAG, (String)"update game public session entrance cell:%s", (Object[])new Object[]{session.getSessionId()});
            }
        }
    }

    private void updateOfficialAccountEntranceSessions(ChatSession session, List<ChatSession> listData) {
        if (session instanceof OfficialAccountEntranceSession && listData != null && !listData.isEmpty()) {
            OfficialAccountEntranceMessage msg = (OfficialAccountEntranceMessage)session.getLastMessage();
            msg.chatSessions = listData;
            session.update(msg);
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)TAG, (String)"update OfficialAccount session entrance cell:%s", (Object[])new Object[]{session.getSessionId()});
            }
        }
    }

    public MutableLiveData getStrangerSessions() {
        return ((ImModuleData)this.mData).strangerChatSessions;
    }

    public MutableLiveData getNormalChatSessions() {
        return ((ImModuleData)this.mData).normalChatSessions;
    }

    public MutableLiveData getChannelSessions() {
        return ((ImModuleData)this.mData).channelChatSessions;
    }

    public MutableLiveData getGamePublicChatSessions() {
        return ((ImModuleData)this.mData).gamePublicChatSessions;
    }

    public MutableLiveData getOfficialAccountChatSessions() {
        return ((ImModuleData)this.mData).officialAccountChatSessions;
    }

    public void loadChatSessions() {
        if (this.isLoadingData || this.hasLoadSessionFinish) {
            return;
        }
        if (AccountUtil.getUid() > 0L) {
            this.isLoadingData = true;
            YYTaskExecutor.execute(() -> this.loadChatSessionFromDB());
        }
    }

    public void updateSession(String sessionId2) {
        ChatSession<Object> chatSession = this.getTargetSession(sessionId2);
        this.updateDBItem(chatSession);
    }

    public void deleteSession(String sessionId2) {
        ChatSession<Object> targetSession = this.getTargetSession(sessionId2);
        this.deleteSession(targetSession, true);
        this.deleteSessionMsg(targetSession);
    }

    public void deleteStrangerSessions(List<String> sessionIds) {
        List strangers = (List)((ImModuleData)this.mData).strangerChatSessions.getValue();
        for (String sessionId2 : sessionIds) {
            ChatSession<Object> targetSession = this.getTargetSession(sessionId2);
            if (!FP.empty((Collection)strangers)) {
                strangers.remove(targetSession);
            }
            this.deleteDBItems(targetSession);
            this.deleteSessionMsg(targetSession);
        }
        ((ImModuleData)this.mData).strangerChatSessions.setValue((Object)strangers);
    }

    public void deleteAllStrangerSessions() {
        List strangerSessions = (List)((ImModuleData)this.mData).strangerChatSessions.getValue();
        for (ChatSession strangerSession : strangerSessions) {
            this.deleteDBItems(strangerSession);
        }
        strangerSessions.clear();
        ((ImModuleData)this.mData).strangerChatSessions.setValue((Object)strangerSessions);
    }

    private synchronized void deleteDBItems(ChatSession chatSession) {
        String sessionId2;
        IDBService idbService = (IDBService)this.getService().getService(IDBService.class);
        if (idbService == null) {
            return;
        }
        if (chatSession == null || StringUtils.isEmpty((String)(sessionId2 = chatSession.getSessionId()))) {
            return;
        }
        MyBox sessionBox = idbService.boxForCurUser(ChatSessionDBBean.class);
        if (sessionBox != null) {
            sessionBox.deleteByIndexs(Collections.singletonList(sessionId2));
        }
    }

    private void deleteDBItems(List<String> sessionIdList) {
        IDBService idbService = (IDBService)this.getService().getService(IDBService.class);
        if (idbService == null) {
            return;
        }
        MyBox sessionBox = idbService.boxForCurUser(ChatSessionDBBean.class);
        if (sessionBox != null) {
            sessionBox.deleteByIndexs(sessionIdList);
        }
    }

    private void deleteSessionMsg(ChatSession chatSession) {
        String sessionId2;
        IDBService idbService = (IDBService)this.getService().getService(IDBService.class);
        if (idbService == null) {
            return;
        }
        if (chatSession == null || StringUtils.isEmpty((String)(sessionId2 = chatSession.getSessionId()))) {
            return;
        }
        MyBox msgBox = idbService.boxForCurUser(ImMessageDBBean.class);
        if (msgBox != null) {
            String finalSessionId = sessionId2;
            msgBox.getAll(datas -> {
                if (datas != null && datas.size() > 0) {
                    ArrayList allData = datas;
                    ArrayList<ImMessageDBBean> deleteData = new ArrayList<ImMessageDBBean>();
                    for (ImMessageDBBean msg : allData) {
                        if (msg == null || !finalSessionId.equals(msg.getSessionId())) continue;
                        deleteData.add(msg);
                    }
                    msgBox.deleteItems(deleteData);
                }
            });
        }
    }

    private void deleteSession(ChatSession chatSession, boolean deleteSession) {
        boolean channelRemoved;
        List channelList;
        boolean officialAccountRemove;
        List officialAccountList;
        boolean gamePublicRemove;
        List gamePublicList;
        boolean remove;
        List value1;
        boolean remove2;
        if (chatSession == null) {
            return;
        }
        boolean hasRemove = false;
        List value = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
        if (!FP.empty((Collection)value) && (remove2 = value.remove(chatSession))) {
            ((ImModuleData)this.mData).normalChatSessions.setValue((Object)value);
            hasRemove = true;
        }
        if (!hasRemove && !FP.empty((Collection)(value1 = (List)((ImModuleData)this.mData).strangerChatSessions.getValue())) && (remove = value1.remove(chatSession))) {
            ((ImModuleData)this.mData).strangerChatSessions.setValue((Object)value1);
        }
        if (!FP.empty((Collection)(gamePublicList = (List)((ImModuleData)this.mData).gamePublicChatSessions.getValue())) && (gamePublicRemove = gamePublicList.remove(chatSession))) {
            ((ImModuleData)this.mData).gamePublicChatSessions.setValue((Object)gamePublicList);
        }
        if (!FP.empty((Collection)(officialAccountList = (List)((ImModuleData)this.mData).officialAccountChatSessions.getValue())) && (officialAccountRemove = officialAccountList.remove(chatSession))) {
            ((ImModuleData)this.mData).officialAccountChatSessions.setValue((Object)officialAccountList);
        }
        if (!FP.empty((Collection)(channelList = (List)((ImModuleData)this.mData).channelChatSessions.getValue())) && (channelRemoved = channelList.remove(chatSession))) {
            ((ImModuleData)this.mData).channelChatSessions.setValue((Object)channelList);
        }
        if (deleteSession) {
            chatSession.unbind();
            this.deleteDBItems(chatSession);
        }
    }

    public void updateChannelMsgMointer(boolean open) {
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(ChannelEntranceSession.class);
        if (presenter instanceof ChannelEntranceSessionPresenter) {
            ((ChannelEntranceSessionPresenter)presenter).updateChannelMsgMointer(open);
        }
    }

    public void updateChannelMsgKeep(boolean keep) {
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(ChannelEntranceSession.class);
        if (presenter instanceof ChannelEntranceSessionPresenter) {
            ((ChannelEntranceSessionPresenter)presenter).updateChannelMsgKeep(keep);
        }
    }

    public void clearSession(long uid) {
        AutoUnbindMutableLiveData<List<ChatSession>> sessionLiveData = ((ImModuleData)this.mData).strangerChatSessions;
        List sessionList = (List)sessionLiveData.getValue();
        if (sessionList != null) {
            for (ChatSession chatSession : sessionList) {
                if (chatSession.getUid() != uid) continue;
                this.deleteSession(chatSession.getSessionId());
                break;
            }
        } else {
            MLog.debug((Object)TAG, (String)"clearSession uid: %d fail, sessionList is null", (Object[])new Object[]{uid});
        }
        sessionLiveData = ((ImModuleData)this.mData).normalChatSessions;
        sessionList = (List)sessionLiveData.getValue();
        if (sessionList != null) {
            for (ChatSession chatSession : sessionList) {
                if (chatSession.getUid() != uid) continue;
                this.deleteSession(chatSession.getSessionId());
                break;
            }
        } else {
            MLog.debug((Object)TAG, (String)"clearSession uid: %d fail, sessionList is null", (Object[])new Object[]{uid});
        }
    }

    public void insertTempNormalSession(Object session) {
        if (!(session instanceof ChatSession)) {
            return;
        }
        ChatSession temp = (ChatSession)session;
        temp.setSessionFrom("0");
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
        if (presenter == null) {
            MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
            return;
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).normalChatSessions, temp);
    }

    public void updateSession(Object session) {
        if (!(session instanceof ChatSession)) {
            return;
        }
        ChatSession temp = (ChatSession)session;
        temp.setSessionFrom("0");
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
        if (presenter == null) {
            MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
            return;
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).normalChatSessions, temp);
        this.updateDBItem(temp);
        long userUid = presenter.getUserUid(temp);
        if (userUid > 0L && userUid != 10L && userUid != 14L && userUid != 11L && userUid != 13L) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(Collections.singletonList(userUid), null);
        }
    }

    public void updateSessions(List<?> sessions) {
        if (FP.empty(sessions)) {
            return;
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        ArrayList<ChatSession> chatSessions = new ArrayList<ChatSession>();
        for (Object session : sessions) {
            if (!(session instanceof ChatSession)) continue;
            ChatSession temp = (ChatSession)session;
            temp.setSessionFrom("0");
            ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
            if (presenter == null) {
                MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
                continue;
            }
            long uid = presenter.getUserUid(temp);
            if (uid > 0L && !uids.contains(uid) && uid != 10L && uid != 14L && uid != 11L && uid != 13L) {
                uids.add(uid);
            }
            chatSessions.add(temp);
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).normalChatSessions, (List<ChatSession>)chatSessions);
        this.updateDBItem(chatSessions);
        if (!FP.empty(uids)) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, null);
        }
    }

    public void updateChannelSessions(List<Object> sessions) {
        if (FP.empty(sessions)) {
            return;
        }
        if (RuntimeContext.isHagoPartySdk()) {
            this.updateSessions(sessions);
            return;
        }
        ArrayList<ChatSession> chatSessions = new ArrayList<ChatSession>();
        for (Object session : sessions) {
            if (!(session instanceof ChatSession)) {
                MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[0]);
                continue;
            }
            ChatSession temp = (ChatSession)session;
            if (temp.getUnReadCounts() > 0 && SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)TAG, (String)"updateChannelSessions session:%s unreadNum:%d!", (Object[])new Object[]{temp.getSessionId(), temp.getUnReadCounts()});
            }
            temp.setSessionFrom("6");
            ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
            if (presenter == null) {
                MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
                continue;
            }
            chatSessions.add(temp);
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).channelChatSessions, (List<ChatSession>)chatSessions);
        this.updateDBItem(chatSessions);
    }

    private void sortSessions(@Nullable List<ChatSession> sessions) {
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)"sort session start", (Object[])new Object[0]);
            for (ChatSession session : sessions) {
                MLog.info((Object)TAG, (String)("sort session " + session + " presentation weight " + session.getPresentWeight() + " presentation time " + session.getPresentationTime()), (Object[])new Object[0]);
            }
            MLog.info((Object)TAG, (String)"sort session end", (Object[])new Object[0]);
        }
        Collections.sort(sessions, (o1, o2) -> {
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (o1.getPresentWeight() > o2.getPresentWeight()) {
                return -1;
            }
            if (o1.getPresentWeight() < o2.getPresentWeight()) {
                return 1;
            }
            return Long.compare(o2.getPresentationTime(), o1.getPresentationTime());
        });
    }

    private void checkAppenToList(MutableLiveData<List<ChatSession>> targetData, List<ChatSession> sessions) {
        if (targetData == null || FP.empty(sessions)) {
            return;
        }
        ArrayList<ChatSession> listInSessions = (ArrayList<ChatSession>)targetData.getValue();
        if (listInSessions == null) {
            listInSessions = new ArrayList<ChatSession>();
        }
        for (ChatSession pengding : sessions) {
            if (pengding == null || listInSessions.contains(pengding)) continue;
            listInSessions.add(pengding);
        }
        this.sortSessions(listInSessions);
        targetData.setValue(listInSessions);
    }

    public void updateStrangerSession(Object session) {
        MLog.debug((Object)TAG, (String)"updateStrangerSession", (Object[])new Object[0]);
        if (!(session instanceof ChatSession)) {
            return;
        }
        ChatSession temp = (ChatSession)session;
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
        if (presenter == null) {
            MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
            return;
        }
        long userUid = presenter.getUserUid(temp);
        boolean isConfigOfficialAccount = false;
        IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        if (userInfoService != null) {
            isConfigOfficialAccount = userInfoService.requestOfficialAccountAuthCache(userUid);
        }
        if (isConfigOfficialAccount) {
            MLog.info((Object)TAG, (String)("userUid " + userUid + " is official account cannot set as stranger"), (Object[])new Object[0]);
            this.updateSession(session);
            return;
        }
        temp.setSessionFrom("1");
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).strangerChatSessions, temp);
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).normalChatSessions, this.getTargetSession("-3"));
        this.updateDBItem(temp);
        if (userUid > 0L && userUid != 10L && userUid != 14L && userUid != 11L && userUid != 13L) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(Collections.singletonList(userUid), null);
        }
    }

    public void updateChannelSession(Object session) {
        if (!(session instanceof ChatSession)) {
            return;
        }
        ChatSession temp = (ChatSession)session;
        temp.setSessionFrom("6");
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
        if (presenter == null) {
            MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
            return;
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).channelChatSessions, temp);
        this.updateDBItem(temp);
    }

    public void updateGamePublicSession(Object session) {
        if (!(session instanceof ChatSession)) {
            return;
        }
        ChatSession temp = (ChatSession)session;
        temp.setSessionFrom("4");
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
        if (presenter == null) {
            MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
            return;
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).normalChatSessions, temp);
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).gamePublicChatSessions, temp);
        this.updateDBItem(temp);
    }

    public void updateBbsNoticeSession(Object session) {
        if (!(session instanceof ChatSession)) {
            return;
        }
        ChatSession temp = (ChatSession)session;
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
        if (presenter == null) {
            MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
            return;
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).normalChatSessions, temp);
        this.updateDBItem(temp);
    }

    public void updateNoticeStartShowSession(Object session) {
        if (!(session instanceof ChatSession)) {
            return;
        }
        ChatSession temp = (ChatSession)session;
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
        if (presenter == null) {
            MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
            return;
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).normalChatSessions, temp);
        this.updateDBItem(temp);
    }

    public void updateOfficialAccountSession(Object session) {
        if (!(session instanceof ChatSession)) {
            return;
        }
        ChatSession temp = (ChatSession)session;
        temp.setSessionFrom("5");
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(temp.getClass());
        if (presenter == null) {
            MLog.error((Object)TAG, (String)"session:%s not support!!!", (Object[])new Object[]{temp});
            return;
        }
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).normalChatSessions, temp);
        this.checkAppenToList((MutableLiveData<List<ChatSession>>)((ImModuleData)this.mData).officialAccountChatSessions, temp);
        this.updateDBItem(temp);
    }

    public boolean getShowOfficialAccountEntrance() {
        return this.isShowOfficialAccountEntrance();
    }

    public boolean getShowGamePublicEntrance() {
        return this.isShowGamePublicEntrance();
    }

    private void deleteDataBySessionFrom(MutableLiveData<List<ChatSession>> targetData, String from) {
        MLog.info((Object)TAG, (String)"deleteDataBySessionFrom from=%s", (Object[])new Object[]{from});
        if (targetData == null || from == null) {
            return;
        }
        List sessions = (List)targetData.getValue();
        if (sessions == null) {
            return;
        }
        Iterator iterator = sessions.iterator();
        while (iterator.hasNext()) {
            ChatSession next = (ChatSession)iterator.next();
            if (!from.equals(next.getSessionFrom())) continue;
            MLog.info((Object)TAG, (String)"deleteDataBySessionFrom remove=%s", (Object[])new Object[]{next.getTitle()});
            iterator.remove();
        }
        targetData.setValue((Object)sessions);
    }

    private void checkAppenToList(MutableLiveData<List<ChatSession>> targetData, ChatSession session) {
        ISessionPresenter presenter;
        if (session == null || targetData == null) {
            return;
        }
        ArrayList<ChatSession> sessions = (ArrayList<ChatSession>)targetData.getValue();
        if (sessions == null) {
            sessions = new ArrayList<ChatSession>();
        }
        if (!sessions.contains(session)) {
            sessions.add(session);
        }
        this.sortSessions(sessions);
        if (targetData == ((ImModuleData)this.mData).normalChatSessions && (presenter = this.mSessionPresenterCenter.getPresenter(AdChatSession.class)) instanceof AdSessionPresenter) {
            ((AdSessionPresenter)presenter).interceptAdSession(sessions);
        }
        targetData.setValue(sessions);
    }

    private void updateNormalUnreadCounts() {
        List sessions = null;
        int i = 0;
        boolean redPoint = false;
        sessions = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
        if (sessions != null && !sessions.isEmpty()) {
            ArrayList sessions1 = new ArrayList(sessions);
            for (ChatSession item : sessions1) {
                int sessionUnreadCounts;
                MLog.debug((Object)TAG, (String)("updateNormalUnreadCounts item: " + item.getClass().getSimpleName() + ", unreadType: " + item.getUnReadType() + ", unreadCount: " + item.getUnReadCounts()), (Object[])new Object[0]);
                if (item.getUnReadType() == 0) {
                    sessionUnreadCounts = item.getUnReadCounts();
                    i += sessionUnreadCounts;
                    continue;
                }
                if (item.getUnReadType() != 1) continue;
                if (item instanceof StrangerEntranceSession) {
                    sessionUnreadCounts = item.getUnReadCounts();
                    i += sessionUnreadCounts > 0 ? 1 : sessionUnreadCounts;
                    continue;
                }
                boolean unRead = item.getUnReadCounts() > 0;
                if (!unRead) continue;
                redPoint = true;
            }
        }
        boolean lastRedPoints = ((ImModuleData)this.mData).mNormalSessionUnread.getRedPoints();
        int lastCount = ((ImModuleData)this.mData).mNormalSessionUnread.getCount();
        int value = i;
        MLog.info((Object)TAG, (String)("updateNormalUnreadCounts lastRedPoints: " + lastRedPoints + ", lastCount: " + lastCount + ", value: " + value), (Object[])new Object[0]);
        if (redPoint != lastRedPoints) {
            ((ImModuleData)this.mData).mNormalSessionUnread.setRedPoints(redPoint);
        }
        if (lastCount != value) {
            ((ImModuleData)this.mData).mNormalSessionUnread.setCount(value);
            YYTaskExecutor.execute(() -> {
                SharedPreferences.Editor editor = SharedPreferencesUtils.getDefaultPrf().edit();
                editor.putInt("pref_unread_counts" + AccountUtil.getUid(), value).apply();
            });
            if (value > 0) {
                MLog.info((Object)TAG, (String)"update normal unread counts:%d", (Object[])new Object[]{i});
            }
        }
        this.checkTotalUnRead();
    }

    private void updateChannelUnread() {
        List sessions = null;
        int i = 0;
        boolean redPoint = false;
        sessions = (List)((ImModuleData)this.mData).channelChatSessions.getValue();
        if (sessions != null && !sessions.isEmpty()) {
            ArrayList sessions1 = new ArrayList(sessions);
            for (ChatSession item : sessions1) {
                boolean unRead;
                if (item.getUnReadCounts() > 0 && SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)TAG, (String)("updateChannelUnread item: " + item.getClass().getSimpleName() + ", unreadType: " + item.getUnReadType() + ", unreadCount: " + item.getUnReadCounts()), (Object[])new Object[0]);
                    MLog.info((Object)TAG, (String)"updateChannelUnread unreadNum:%d, cid:%s, title:%s, mode:%d, icon:%s, sessionType:%d", (Object[])new Object[]{item.getUnReadCounts(), item.getSessionId(), item.getTitle() + item.getSubTitle(), item.getChannelPluginMode(), item.getAvatarUrl(), item.getSessionType()});
                    MLog.info((Object)TAG, (String)"isExpired:%d, valid:%d, showDuring:%s, expiredTime:%s, showIgnore:%d, session:%s", (Object[])new Object[]{item.isExpired() ? 1 : 0, item.isValid() ? 1 : 0, String.valueOf(item.getCanShowDuring()), String.valueOf(item.getExpiredTime()), item.getShowIgnore() ? 1 : 0, item.toString()});
                }
                if (item.getUnReadType() == 0) {
                    if (NewABDefine.BBS_IM_NUM_2.matchB() && item instanceof ChannelEntranceSession) {
                        if (item.getUnReadCounts() <= 0) continue;
                        ++i;
                        continue;
                    }
                    int sessionUnreadCounts = item.getUnReadCounts();
                    i += sessionUnreadCounts;
                    continue;
                }
                if (item.getUnReadType() != 1 || !(unRead = item.getUnReadCounts() > 0)) continue;
                redPoint = true;
            }
        }
        boolean lastRedPoints = ((ImModuleData)this.mData).mChannelSessionUnread.getRedPoints();
        int lastCount = ((ImModuleData)this.mData).mChannelSessionUnread.getCount();
        int value = i;
        MLog.info((Object)TAG, (String)("updateChannelUnread lastRedPoints: " + lastRedPoints + ", lastCount: " + lastCount + ", value: " + value), (Object[])new Object[0]);
        if (redPoint != lastRedPoints) {
            ((ImModuleData)this.mData).mChannelSessionUnread.setRedPoints(redPoint);
        }
        if (lastCount != value) {
            ((ImModuleData)this.mData).mChannelSessionUnread.setCount(value);
            if (value > 0) {
                MLog.info((Object)TAG, (String)"update channel unread counts:%d", (Object[])new Object[]{i});
            }
        }
        this.checkTotalUnRead();
    }

    private synchronized void appendAdChatSessionToNormalList(AdChatSession chatSession, int index) {
        if (chatSession == null) {
            return;
        }
        chatSession.setSessionFrom("0");
        ArrayList<AdChatSession> sessions = (ArrayList<AdChatSession>)((ImModuleData)this.mData).normalChatSessions.getValue();
        if (sessions == null) {
            sessions = new ArrayList<AdChatSession>();
        }
        if (index < 0) {
            index = 0;
        }
        if (sessions.size() < index) {
            index = sessions.size();
        }
        sessions.add(index, chatSession);
        ((ImModuleData)this.mData).normalChatSessions.setValue(sessions);
        this.updateDBItem(chatSession);
        MLog.info((Object)TAG, (String)"append to normal list:%s", (Object[])new Object[]{chatSession});
    }

    private void updateStrangerUnreadCounts(boolean hasAppend) {
        List sessions = null;
        int i = 0;
        boolean redPoint = false;
        sessions = (List)((ImModuleData)this.mData).strangerChatSessions.getValue();
        if (sessions != null && !sessions.isEmpty()) {
            ArrayList sessions1 = new ArrayList(sessions);
            ISessionPresenter sessionPresenter = null;
            SessionConfig config = null;
            for (ChatSession item : sessions1) {
                boolean unRead;
                sessionPresenter = this.mSessionPresenterCenter.getPresenter(item.getClass());
                if (sessionPresenter == null || (config = sessionPresenter.getSessionConfig()) == null) continue;
                if (config.getUnReadType() == 0) {
                    i += sessionPresenter.getUnread(item);
                    continue;
                }
                if (config.getUnReadType() != 1 || !(unRead = sessionPresenter.getUnread(item) > 0)) continue;
                redPoint = true;
            }
        }
        if (redPoint || hasAppend) {
            // empty if block
        }
        if (i == 0 && ((ImModuleData)this.mData).mStrangerSessionUnread.getSuperUnread()) {
            ++i;
        }
        if (!redPoint && ((ImModuleData)this.mData).mStrangerSessionUnread.getSuperUnread()) {
            redPoint = true;
        }
        ((ImModuleData)this.mData).mStrangerSessionUnread.setCount(i);
        ((ImModuleData)this.mData).mStrangerSessionUnread.setRedPoints(redPoint);
        MLog.info((Object)TAG, (String)("updateStrangerUnreadCounts count: " + i + ", readPoind: " + redPoint), (Object[])new Object[0]);
        this.checkTotalUnRead();
    }

    private void updateDBItem(ChatSession session) {
        this.mQueueTaskExecutor.execute(() -> {
            IDBService idbService = (IDBService)this.getService().getService(IDBService.class);
            if (idbService == null) {
                return;
            }
            MyBox box2 = idbService.boxForCurUser(ChatSessionDBBean.class);
            if (box2 != null) {
                box2.updateItem((BaseDBBean)session.getDBBean(), true);
            }
        }, 0L);
    }

    private void updateDBItem(List<ChatSession> session) {
        this.mQueueTaskExecutor.execute(() -> {
            IDBService idbService = (IDBService)this.getService().getService(IDBService.class);
            if (idbService == null) {
                return;
            }
            if (FP.empty((Collection)session)) {
                return;
            }
            ArrayList<ChatSessionDBBean> dbs = new ArrayList<ChatSessionDBBean>();
            for (ChatSession session1 : session) {
                ChatSessionDBBean dbBean = session1.getDBBean();
                if (dbBean == null) continue;
                dbs.add(dbBean);
            }
            MyBox box2 = idbService.boxForCurUser(ChatSessionDBBean.class);
            if (box2 != null) {
                box2.updateItems(dbs, true);
            }
        }, 0L);
    }

    private void ignoreUnread(String sessionId2) {
        ChatSession<Object> session = this.getTargetSession(sessionId2);
        if (session != null) {
            List list;
            session.setUnReadCounts(0);
            this.updateDBItem(session);
            if (RuntimeContext.isHagoPartySdk()) {
                list = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
                ((ImModuleData)this.mData).normalChatSessions.setValue((Object)list);
            }
            if (session instanceof GamePublicEntranceSession) {
                list = (List)((ImModuleData)this.mData).gamePublicChatSessions.getValue();
                for (ChatSession chatSession : list) {
                    if (chatSession == null) continue;
                    chatSession.setUnReadCounts(0);
                }
                this.updateGamePublicUnreadCounts(false);
            } else if (session instanceof GamePublicChatSession) {
                list = (List)((ImModuleData)this.mData).gamePublicChatSessions.getValue();
                this.updateGamePublicUnreadCounts(false);
                this.updateNormalUnreadCounts();
            } else if (session instanceof OfficialAccountChatSession) {
                list = (List)((ImModuleData)this.mData).officialAccountChatSessions.getValue();
                this.updateOfficialAccountUnreadCounts(false);
                this.updateNormalUnreadCounts();
            } else if (session.isStrangerChat()) {
                this.updateStrangerUnreadCounts(false);
            } else if (session instanceof BbsNoticeEntranceSession) {
                this.updateBbsNoticeUnreadCount();
                this.updateNormalUnreadCounts();
            } else if (session instanceof StrangerEntranceSession) {
                list = (List)((ImModuleData)this.mData).strangerChatSessions.getValue();
                for (ChatSession chatSession : list) {
                    if (chatSession == null) continue;
                    chatSession.setUnReadCounts(0);
                    chatSession.setIsNew(false);
                    this.updateDBItem(chatSession);
                }
                this.updateStrangerUnreadCounts(false);
                this.updateNormalUnreadCounts();
            } else {
                this.updateNormalUnreadCounts();
            }
        }
    }

    public ChatSession<Object> getTargetSession(String sessionId2) {
        List officialAccountList;
        List gamePublicList;
        List stranger;
        List channelSessions;
        if (StringUtils.isEmpty((String)sessionId2)) {
            return null;
        }
        List normal = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
        if (normal != null && !normal.isEmpty()) {
            for (Object session : normal) {
                if (session == null || !sessionId2.equals(((ChatSession)session).getSessionId())) continue;
                return session;
            }
        }
        if ((channelSessions = (List)((ImModuleData)this.mData).channelChatSessions.getValue()) != null && !channelSessions.isEmpty()) {
            for (Object session : channelSessions) {
                if (session == null || !sessionId2.equals(((ChatSession)session).getSessionId())) continue;
                return session;
            }
        }
        if ((stranger = (List)((ImModuleData)this.mData).strangerChatSessions.getValue()) != null && !stranger.isEmpty()) {
            for (Object session : stranger) {
                if (session == null || !sessionId2.equals(((ChatSession)session).getSessionId())) continue;
                return session;
            }
        }
        if ((gamePublicList = (List)((ImModuleData)this.mData).gamePublicChatSessions.getValue()) != null && !gamePublicList.isEmpty()) {
            for (ChatSession session : gamePublicList) {
                if (session == null || !sessionId2.equals(session.getSessionId())) continue;
                return session;
            }
        }
        if ((officialAccountList = (List)((ImModuleData)this.mData).officialAccountChatSessions.getValue()) != null && !officialAccountList.isEmpty()) {
            for (ChatSession session : officialAccountList) {
                if (session == null || !sessionId2.equals(session.getSessionId())) continue;
                return session;
            }
        }
        return null;
    }

    public List<GamePushChatSession> getLocalGamePushChatSeesions() {
        List normal = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
        ArrayList<GamePushChatSession> list = new ArrayList<GamePushChatSession>();
        if (normal != null && !normal.isEmpty()) {
            for (ChatSession session : normal) {
                if (session == null || !(session instanceof GamePushChatSession)) continue;
                list.add((GamePushChatSession)session);
            }
        }
        return list;
    }

    @Override
    public void onRelationChange(SingleChatSession session, RelationInfo info, Relation oldValue) {
        if (this.isBlack(info.getUid())) {
            this.deleteSession(session, true);
            this.deleteDBItems(session);
        } else if (info.isFriend()) {
            this.deleteSession(session, false);
            this.updateSession(session);
        } else if (!session.isStrangerChat() && oldValue == Relation.FRIEND) {
            this.reloadSessionAfterRemoveFriends(session);
        }
    }

    @Override
    public void onBlackChange(SingleChatSession session, BlacklistInfo info) {
        if (this.isBlack(info.getUid())) {
            this.deleteSession(session, true);
            this.deleteDBItems(session);
        }
    }

    private boolean isBlack(long uid) {
        return ((IBlacklistService)ServiceManagerProxy.getService(IBlacklistService.class)).isInBlacklist(uid).getInBlacklist();
    }

    @Override
    public void onFollowStatusChange(SingleChatSession session, RelationInfo relationInfo) {
        if (!relationInfo.isFollow()) {
            if (!"1".equals(session.getSessionFrom())) {
                this.reloadSessionAfterRemoveFriends(session);
            }
        } else {
            this.deleteSession(session, false);
            this.updateSession(session);
        }
    }

    private void reloadSessionAfterRemoveFriends(SingleChatSession session) {
        if (session.isNotArchiveInStrangerSessionContainer()) {
            return;
        }
        IDBService idbService = (IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class);
        if (idbService == null) {
            return;
        }
        MyBox msgs = idbService.boxForCurUser(ImMessageDBBean.class);
        if (msgs == null) {
            return;
        }
        SingleChatSession session1 = session;
        String sessionId2 = session.getSessionId();
        msgs.getAll(datas -> {
            if (datas == null || datas.isEmpty()) {
                this.deleteSession(session1, true);
            } else {
                ArrayList msgs1 = datas;
                boolean hasSelfSendMsg = false;
                for (ImMessageDBBean msg : msgs1) {
                    if (!msg.isSendByMe() || !StringUtils.isNotEmpty((String)sessionId2) || !sessionId2.equals(msg.getSessionId())) continue;
                    hasSelfSendMsg = true;
                    break;
                }
                if (!hasSelfSendMsg) {
                    this.deleteSession(session1, false);
                    this.updateStrangerSession(session1);
                }
            }
        });
    }

    @Override
    public void onUserInfoChange(SingleChatSession session, UserInfoKS userInfoKS) {
        ChatSession<Object> targetSession;
        if (session.isStrangerChat() && (targetSession = this.getTargetSession("-3")) != null) {
            targetSession.initial();
        }
    }

    private void getSessionOnlineState(ChatSession session) {
        if (session != null && session instanceof SingleChatSession) {
            ArrayList<ChatSession> sessions = new ArrayList<ChatSession>();
            sessions.add(session);
            this.getSessionOnlineState(sessions);
        }
    }

    private void getSessionOnlineState(List<ChatSession> mSession) {
        if (mSession == null || mSession.isEmpty()) {
            return;
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        ArrayList<ChatSession> sessions = new ArrayList<ChatSession>(mSession);
        for (ChatSession session : sessions) {
            if (!(session instanceof SingleChatSession)) continue;
            uids.add(((SingleChatSession)session).getTargetUid());
        }
        if (!uids.isEmpty()) {
            IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getInstance().getService(IUserInfoService.class);
            LiveData userOnlineDBBeanLiveData = null;
            if (userInfoService != null) {
                userOnlineDBBeanLiveData = userInfoService.getOnlineStatus(uids, true);
            }
            if (userOnlineDBBeanLiveData != null) {
                if (this.friendsOnlineStatusLiveData != null) {
                    this.friendsOnlineStatusLiveData.removeObserver(this.friendsOnlineChangeObserver);
                    this.friendsOnlineStatusLiveData = null;
                }
                this.friendsOnlineStatusLiveData = userOnlineDBBeanLiveData;
                this.friendsOnlineStatusLiveData.observeForever(this.friendsOnlineChangeObserver);
            }
        }
    }

    private void checkTotalUnRead() {
        boolean previousUnRead = ((ImModuleData)this.mData).mTotalListUnRead.getRedPoints();
        int previousCount = ((ImModuleData)this.mData).mTotalListUnRead.getCount();
        int unread = 0;
        boolean redPoint = ((ImModuleData)this.mData).mNormalSessionUnread.getRedPoints() || ((ImModuleData)this.mData).mExtUnRead.getRedPoints() || ((ImModuleData)this.mData).mChannelSessionUnread.getRedPoints();
        ((ImModuleData)this.mData).mTotalListUnRead.setRedPoints(redPoint);
        ((ImModuleData)this.mData).mTotalListUnRead.setCount(unread += ((ImModuleData)this.mData).mNormalSessionUnread.getCount() + ((ImModuleData)this.mData).mExtUnRead.getCount() + ((ImModuleData)this.mData).mChannelSessionUnread.getCount());
        MLog.info((Object)TAG, (String)"NormalSessionUnread:%d, mExtUnRea:%d, ChannelSessionUnread:%d ", (Object[])new Object[]{((ImModuleData)this.mData).mNormalSessionUnread.getCount(), ((ImModuleData)this.mData).mExtUnRead.getCount(), ((ImModuleData)this.mData).mChannelSessionUnread.getCount()});
        MLog.info((Object)TAG, (String)("checkTotalUnRead previousUnRead: " + previousUnRead + ", redPoint: " + redPoint + "; previousCount: " + previousCount + ", unread: " + unread), (Object[])new Object[0]);
        if (previousUnRead != redPoint || previousCount != unread) {
            this.notifyTotalUnReadChange();
        }
    }

    public void registerUnReadNotify(OnUnReadChangeNotify notify2, boolean notifyWhenRegister) {
        if (notify2 == null) {
            return;
        }
        Iterator<WeakReference<OnUnReadChangeNotify>> iterator = new ArrayList<WeakReference<OnUnReadChangeNotify>>(this.mUnreadNotifys).iterator();
        boolean hasMatch = false;
        while (iterator.hasNext()) {
            WeakReference<OnUnReadChangeNotify> next = iterator.next();
            if (next == null) {
                iterator.remove();
                continue;
            }
            OnUnReadChangeNotify onUnReadChangeNotify = (OnUnReadChangeNotify)next.get();
            if (onUnReadChangeNotify == null) {
                iterator.remove();
                continue;
            }
            if (onUnReadChangeNotify != notify2) continue;
            hasMatch = true;
            break;
        }
        if (!hasMatch) {
            this.mUnreadNotifys.add(new WeakReference<OnUnReadChangeNotify>(notify2));
        }
        if (notifyWhenRegister) {
            notify2.onUnReadChange(((ImModuleData)this.mData).mTotalListUnRead);
        }
    }

    public void unRegisterUnReadNotify(OnUnReadChangeNotify notify2) {
        if (notify2 == null) {
            return;
        }
        Iterator<WeakReference<OnUnReadChangeNotify>> iterator = this.mUnreadNotifys.iterator();
        while (iterator.hasNext()) {
            WeakReference<OnUnReadChangeNotify> next = iterator.next();
            OnUnReadChangeNotify onUnReadChangeNotify = (OnUnReadChangeNotify)next.get();
            if (onUnReadChangeNotify == null) {
                iterator.remove();
                continue;
            }
            if (onUnReadChangeNotify != notify2) continue;
            iterator.remove();
            break;
        }
    }

    public void handleClickItem(Object session, View view, int position, int from) {
        ISessionPresenter presenter;
        if (session instanceof ChatSession && (presenter = this.mSessionPresenterCenter.getPresenter(session.getClass())) != null) {
            presenter.handleClickItem((ChatSession)session, view, position, from);
        }
    }

    public void handleLongClickItem(Object session, View view, int position, int from) {
        ISessionPresenter presenter;
        if (session instanceof ChatSession && (presenter = this.mSessionPresenterCenter.getPresenter(session.getClass())) != null) {
            presenter.handleLongClickItem((ChatSession)session, view, position, from);
            presenter.reportManagePopShow((ChatSession)session);
        }
    }

    public ISessionMsgUIMapper getSessionMsgUIMapper(int type) {
        if (type == 0) {
            return this.mWemeetMapper;
        }
        if (type == 2) {
            return this.mNormalMapper;
        }
        return this.mNormalMapper;
    }

    public int getSessionUnRead(String sessionId2) {
        AutoUnbindMutableLiveData<List<ChatSession>> officialAccountChatSessions;
        AutoUnbindMutableLiveData<List<ChatSession>> gamePublicChatSessions;
        AutoUnbindMutableLiveData<List<ChatSession>> strangerChatSession;
        MLog.info((Object)TAG, (String)"sessionId :%s", (Object[])new Object[]{sessionId2});
        if (StringUtils.isEmpty((String)sessionId2)) {
            return 0;
        }
        AutoUnbindMutableLiveData<List<ChatSession>> normalChatSessions = ((ImModuleData)this.mData).normalChatSessions;
        ArrayList sessions = new ArrayList(0);
        List tempSession = null;
        if (normalChatSessions != null && (tempSession = (List)normalChatSessions.getValue()) != null) {
            sessions.clear();
            if (!tempSession.isEmpty()) {
                sessions.addAll(tempSession);
                for (int i = 0; i < sessions.size(); ++i) {
                    ChatSession temp = (ChatSession)sessions.get(i);
                    if (temp == null || !sessionId2.equals(temp.getSessionId())) continue;
                    MLog.info((Object)TAG, (String)"sessionId :%s in normal:%s", (Object[])new Object[]{sessionId2, temp});
                    return temp.getUnReadCounts();
                }
            }
        }
        if ((strangerChatSession = ((ImModuleData)this.mData).strangerChatSessions) != null && (tempSession = (List)strangerChatSession.getValue()) != null) {
            sessions.clear();
            if (!tempSession.isEmpty()) {
                sessions.addAll(tempSession);
                for (int i = 0; i < sessions.size(); ++i) {
                    ChatSession temp = (ChatSession)sessions.get(i);
                    if (temp == null || !sessionId2.equals(temp.getSessionId())) continue;
                    MLog.info((Object)TAG, (String)"sessionId :%s in stranger:%s", (Object[])new Object[]{sessionId2, temp});
                    return temp.getUnReadCounts();
                }
            }
        }
        if ((gamePublicChatSessions = ((ImModuleData)this.mData).gamePublicChatSessions) != null && (tempSession = (List)gamePublicChatSessions.getValue()) != null) {
            sessions.clear();
            if (!tempSession.isEmpty()) {
                sessions.addAll(tempSession);
                for (int i = 0; i < sessions.size(); ++i) {
                    ChatSession temp = (ChatSession)sessions.get(i);
                    if (temp == null || !sessionId2.equals(temp.getSessionId())) continue;
                    MLog.info((Object)TAG, (String)"sessionId :%s in gamePublic:%s", (Object[])new Object[]{sessionId2, temp});
                    return temp.getUnReadCounts();
                }
            }
        }
        if ((officialAccountChatSessions = ((ImModuleData)this.mData).officialAccountChatSessions) != null && (tempSession = (List)officialAccountChatSessions.getValue()) != null) {
            sessions.clear();
            if (!tempSession.isEmpty()) {
                sessions.addAll(tempSession);
                for (int i = 0; i < sessions.size(); ++i) {
                    ChatSession temp = (ChatSession)sessions.get(i);
                    if (temp == null || !sessionId2.equals(temp.getSessionId())) continue;
                    MLog.info((Object)TAG, (String)"sessionId :%s in officialAccount:%s", (Object[])new Object[]{sessionId2, temp});
                    return temp.getUnReadCounts();
                }
            }
        }
        MLog.info((Object)TAG, (String)"sessionId :%s not match!!!!", (Object[])new Object[]{sessionId2});
        return 0;
    }

    public void onShow() {
        if (!FP.empty(this.mSessionPresenterCenter.getSessionPresenter())) {
            for (ISessionPresenter presenter : this.mSessionPresenterCenter.getSessionPresenter()) {
                if (presenter == null) continue;
                presenter.onShow();
            }
        }
    }

    public void onHide() {
        if (!FP.empty(this.mSessionPresenterCenter.getSessionPresenter())) {
            for (ISessionPresenter presenter : this.mSessionPresenterCenter.getSessionPresenter()) {
                if (presenter == null) continue;
                presenter.onHide();
            }
        }
    }

    public void onChatPageShow() {
        if (!FP.empty(this.mSessionPresenterCenter.getSessionPresenter())) {
            for (ISessionPresenter presenter : this.mSessionPresenterCenter.getSessionPresenter()) {
                if (presenter == null) continue;
                presenter.onChatPageShow();
            }
            this.updateOfficialSessionExposure();
        }
    }

    public void onChatPageHide() {
        if (!FP.empty(this.mSessionPresenterCenter.getSessionPresenter())) {
            for (ISessionPresenter presenter : this.mSessionPresenterCenter.getSessionPresenter()) {
                if (presenter == null) continue;
                presenter.onChatPageHide();
            }
        }
    }

    public void entryMsgListPage() {
    }

    public void getMatchSessions(QueryMatcher matcher, QueryResult result) {
        if (matcher == null || result == null) {
            MLog.error((Object)TAG, (String)"error params", (Object[])new Object[0]);
            return;
        }
        if (this.hasLoadSessionFinish) {
            List valueNormal = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
            List valueStrange = (List)((ImModuleData)this.mData).strangerChatSessions.getValue();
            ArrayList copyValu = new ArrayList();
            if (valueNormal != null && !FP.empty((Collection)valueNormal)) {
                copyValu.addAll(valueNormal);
            }
            if (valueStrange != null && !FP.empty((Collection)valueStrange)) {
                copyValu.addAll(valueStrange);
            }
            ArrayList<ChatSession> resultValue = new ArrayList<ChatSession>();
            for (ChatSession temp : copyValu) {
                if (!matcher.isMatch((Object)temp)) continue;
                resultValue.add(temp);
            }
            result.onResult(resultValue);
        } else {
            MLog.error((Object)TAG, (String)"not finish!!!", (Object[])new Object[0]);
            if (result != null) {
                result.onResult(new ArrayList());
            }
        }
    }

    public int getMessageListCount() {
        if (((ImModuleData)this.mData).normalChatSessions.getValue() == null) {
            return 0;
        }
        return ((List)((ImModuleData)this.mData).normalChatSessions.getValue()).size();
    }

    public int getUnreadMessageCount() {
        List sessionList = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
        int count = 0;
        if (!FP.empty((Collection)sessionList)) {
            for (ChatSession item : sessionList) {
                if (item.getUnReadType() == 0 && item.getUnReadCounts() > 0) {
                    ++count;
                    continue;
                }
                if (item.getUnReadType() != 1 || item.getUnReadCounts() <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public int getUnreadRedCount() {
        return ((ImModuleData)this.mData).mTotalListUnRead.getCount();
    }

    public void ignoreUnReadBySessionId(String sessionId2) {
        this.ignoreUnread(sessionId2);
    }

    private void notifyTotalUnReadChange() {
        Iterator<WeakReference<OnUnReadChangeNotify>> iterator = new ArrayList<WeakReference<OnUnReadChangeNotify>>(this.mUnreadNotifys).iterator();
        while (iterator.hasNext()) {
            WeakReference<OnUnReadChangeNotify> next = iterator.next();
            OnUnReadChangeNotify onUnReadChangeNotify = (OnUnReadChangeNotify)next.get();
            if (onUnReadChangeNotify == null) {
                iterator.remove();
                continue;
            }
            onUnReadChangeNotify.onUnReadChange(((ImModuleData)this.mData).mTotalListUnRead);
        }
    }

    protected void unbindDataWhenDestroy() {
        super.unbindDataWhenDestroy();
        this.isLoadingData = false;
        this.hasLoadSessionFinish = false;
        if (this.mData != null) {
            FragmentActivity aty;
            Environment environment = this.getEnv();
            FragmentActivity fragmentActivity = aty = environment != null ? environment.getActivity() : null;
            if (((ImModuleData)this.mData).normalChatSessions != null && aty != null) {
                ((ImModuleData)this.mData).normalChatSessions.removeObservers((LifecycleOwner)aty);
            }
            if (((ImModuleData)this.mData).strangerChatSessions != null && aty != null) {
                ((ImModuleData)this.mData).strangerChatSessions.removeObservers((LifecycleOwner)aty);
            }
        }
    }

    protected void resetWhenLogout() {
        super.resetWhenLogout();
        this.hasLoadSessionFinish = false;
        this.isLoadingData = false;
    }

    protected void loginSuccess() {
        super.loginSuccess();
        if (AccountUtil.getUid() > 0L) {
            this.loadChatSessions();
        }
    }

    private boolean isShowGamePublicEntrance(int size) {
        GamePublicConfig config = (GamePublicConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.GAME_PUBLIC);
        if (config != null && config.getSessionCountData() != null) {
            int count = config.getSessionCountData().getSessionCount();
            MLog.info((Object)TAG, (String)"size=%s\uff0ccount=%s", (Object[])new Object[]{size, count});
            if (size >= count) {
                return true;
            }
        }
        return false;
    }

    public boolean isShowGamePublicEntrance() {
        List list = (List)((ImModuleData)this.mData).gamePublicChatSessions.getValue();
        return list != null && this.isShowGamePublicEntrance(list.size());
    }

    public boolean isShowOfficialAccountEntrance() {
        List list = (List)((ImModuleData)this.mData).officialAccountChatSessions.getValue();
        return list != null && this.isShowGamePublicEntrance(list.size());
    }

    private void updateGamePublicUnreadCounts(boolean hasAppend) {
        MLog.info((Object)TAG, (String)"updateGamePublicUnreadCounts hasAppend=%s", (Object[])new Object[]{hasAppend});
        List sessions = null;
        int i = 0;
        int redPointTypeCount = 0;
        int countTypeCount = 0;
        int curCount = 0;
        boolean redPoint = true;
        sessions = (List)((ImModuleData)this.mData).gamePublicChatSessions.getValue();
        if (sessions != null && !sessions.isEmpty()) {
            ArrayList sessionsList = new ArrayList(sessions);
            ISessionPresenter sessionPresenter = null;
            for (ChatSession item : sessionsList) {
                sessionPresenter = this.mSessionPresenterCenter.getPresenter(item.getClass());
                if (sessionPresenter == null) continue;
                curCount = sessionPresenter.getUnread(item);
                if (item.getUnReadType() == 0) {
                    countTypeCount += curCount;
                } else {
                    redPointTypeCount += curCount;
                }
                i += curCount;
            }
        }
        redPoint = countTypeCount <= 0;
        if (countTypeCount > 0) {
            ((ImModuleData)this.mData).mGamePublicSessionUnread.setCount(countTypeCount);
        } else {
            ((ImModuleData)this.mData).mGamePublicSessionUnread.setCount(redPointTypeCount);
        }
        ((ImModuleData)this.mData).mGamePublicSessionUnread.setRedPoints(redPoint);
        MLog.info((Object)TAG, (String)"update game public unread counts:%d, redPoint=%s, countTypeCount=%s", (Object[])new Object[]{i, redPoint, countTypeCount});
        this.checkTotalUnRead();
    }

    private void updateBbsNoticeUnreadCount() {
        YYTaskExecutor.execute(() -> {
            MyBox myBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(BbsNoticeDBBean.class);
            myBox.getAll(datas -> {
                if (!FP.empty((Collection)datas)) {
                    ArrayList<BbsNoticeDBBean> updateList = new ArrayList<BbsNoticeDBBean>();
                    for (BbsNoticeDBBean curBean : datas) {
                        if (curBean.isReaded()) continue;
                        curBean.setReaded(true);
                        updateList.add(curBean);
                    }
                    if (updateList.size() > 0) {
                        myBox.updateItems(updateList, false);
                    }
                }
            });
        });
    }

    private void updateOfficialAccountUnreadCounts(boolean hasAppend) {
        MLog.info((Object)TAG, (String)"updateOfficialAccountUnreadCounts hasAppend=%s", (Object[])new Object[]{hasAppend});
        List sessions = null;
        int i = 0;
        int redPointTypeCount = 0;
        int countTypeCount = 0;
        int curCount = 0;
        boolean redPoint = true;
        sessions = (List)((ImModuleData)this.mData).officialAccountChatSessions.getValue();
        if (sessions != null && !sessions.isEmpty()) {
            ArrayList sessionsList = new ArrayList(sessions);
            ISessionPresenter sessionPresenter = null;
            for (ChatSession item : sessionsList) {
                sessionPresenter = this.mSessionPresenterCenter.getPresenter(item.getClass());
                if (sessionPresenter == null) continue;
                curCount = sessionPresenter.getUnread(item);
                if (item.getUnReadType() == 0) {
                    countTypeCount += curCount;
                } else {
                    redPointTypeCount += curCount;
                }
                i += curCount;
            }
        }
        redPoint = countTypeCount <= 0;
        if (countTypeCount > 0) {
            ((ImModuleData)this.mData).mOfficialAccountSessionUnread.setCount(countTypeCount);
        } else {
            ((ImModuleData)this.mData).mOfficialAccountSessionUnread.setCount(redPointTypeCount);
        }
        ((ImModuleData)this.mData).mOfficialAccountSessionUnread.setRedPoints(redPoint);
        MLog.info((Object)TAG, (String)"update OfficialAccount unread counts:%d, redPoint=%s, countTypeCount=%s", (Object[])new Object[]{i, redPoint, countTypeCount});
        this.checkTotalUnRead();
    }

    public void deleteUnsubscribeSession(List<SubAccountDBBean> subscribeList) {
        List gamePublicList;
        if (FP.empty(subscribeList)) {
            return;
        }
        ArrayList<String> saidList = new ArrayList<String>();
        for (SubAccountDBBean bean : subscribeList) {
            if (bean.subAccountType == SAType.GAME.getValue()) {
                saidList.add(bean.ownerId);
                continue;
            }
            saidList.add(bean.subAccountId);
        }
        List officialAccountList = (List)((ImModuleData)this.mData).officialAccountChatSessions.getValue();
        if (!FP.empty((Collection)officialAccountList)) {
            ArrayList<ChatSession> removeOaList = new ArrayList<ChatSession>();
            ArrayList<String> removeOaIdList = new ArrayList<String>();
            for (ChatSession chatSession : officialAccountList) {
                OfficialAccountChatSession oaChatSession;
                String said;
                if (!(chatSession instanceof OfficialAccountChatSession) || StringUtils.isEmpty((String)(said = ((ImMessageDBBean)(oaChatSession = (OfficialAccountChatSession)chatSession).getLastMessage()).getReserve1())) || saidList.contains(said)) continue;
                removeOaList.add(chatSession);
                removeOaIdList.add(said);
                MLog.info((Object)TAG, (String)"deleteUnsubscribe oa said=%s", (Object[])new Object[]{said});
            }
            this.deleteDBItems(removeOaIdList);
            officialAccountList.removeAll(removeOaList);
            ((ImModuleData)this.mData).officialAccountChatSessions.setValue((Object)officialAccountList);
        }
        if (!FP.empty((Collection)(gamePublicList = (List)((ImModuleData)this.mData).gamePublicChatSessions.getValue()))) {
            ArrayList<ChatSession> removegpList = new ArrayList<ChatSession>();
            ArrayList<String> removegpIdList = new ArrayList<String>();
            for (ChatSession chatSession : gamePublicList) {
                GamePublicChatSession gpChatSession;
                String said;
                if (!(chatSession instanceof GamePublicChatSession) || StringUtils.isEmpty((String)(said = ((ImMessageDBBean)(gpChatSession = (GamePublicChatSession)chatSession).getLastMessage()).getReserve1())) || saidList.contains(said)) continue;
                removegpList.add(chatSession);
                removegpIdList.add(gpChatSession.getSessionId());
                MLog.info((Object)TAG, (String)"deleteUnsubscribe gp said=%s", (Object[])new Object[]{said});
            }
            this.deleteDBItems(removegpIdList);
            gamePublicList.removeAll(removegpList);
            ((ImModuleData)this.mData).gamePublicChatSessions.setValue((Object)gamePublicList);
        }
    }

    public synchronized void onDestroy() {
        this.mUnreadNotifys.clear();
        super.onDestroy();
    }

    public void getUserOnlineState(List<Object> sessions) {
        if (sessions == null || sessions.size() == 0) {
            return;
        }
        ArrayList<ChatSession> newSessionList = new ArrayList<ChatSession>(sessions.size());
        for (Object session : sessions) {
            boolean outOf2Min;
            SingleChatSession singleChatSession;
            UserOnlineDBBean userOnlineDBBean;
            if (!(session instanceof SingleChatSession) || (userOnlineDBBean = (singleChatSession = (SingleChatSession)session).getUserOnlineDBBean()) == null || !(outOf2Min = System.currentTimeMillis() - userOnlineDBBean.getUpdateTimestamp() > 120000L)) continue;
            newSessionList.add(singleChatSession);
        }
        if (newSessionList.size() > 0) {
            this.getSessionOnlineState(newSessionList);
        }
    }

    @MainThread
    private synchronized void friendsOnlineStatusChange(Map<Long, UserOnlineDBBean> userOnlineDBBeanMap) {
        this.friendsOnlineStatus.putAll(userOnlineDBBeanMap);
        ArrayList<Long> tobeRemove = new ArrayList<Long>(10);
        for (Map.Entry<Long, UserOnlineDBBean> entry : this.friendsOnlineStatus.entrySet()) {
            boolean outOf10Min = Math.abs(entry.getValue().getUpdateTimestamp() - System.currentTimeMillis()) > 600000L;
            if (!outOf10Min) continue;
            tobeRemove.add(entry.getKey());
        }
        for (Long rmKey : tobeRemove) {
            this.friendsOnlineStatus.remove(rmKey);
        }
        MLog.debug((Object)TAG, (String)("friends online status: " + this.friendsOnlineStatus.toString()), (Object[])new Object[0]);
        ArrayList<ChatSession> copy = new ArrayList<ChatSession>();
        if (((ImModuleData)this.mData).strangerChatSessions.getValue() != null && !((List)((ImModuleData)this.mData).strangerChatSessions.getValue()).isEmpty()) {
            copy.addAll((Collection)((ImModuleData)this.mData).strangerChatSessions.getValue());
        }
        if (((ImModuleData)this.mData).normalChatSessions.getValue() != null && !((List)((ImModuleData)this.mData).normalChatSessions.getValue()).isEmpty()) {
            copy.addAll((Collection)((ImModuleData)this.mData).normalChatSessions.getValue());
        }
        if (!copy.isEmpty()) {
            this.updateOnlineStatus(this.friendsOnlineStatus, copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnlineStatus(final Map<Long, UserOnlineDBBean> statusMap, List<ChatSession> mChatSessionList) {
        List<ChatSession> list = mChatSessionList;
        synchronized (list) {
            if (statusMap != null && !statusMap.isEmpty()) {
                for (final ChatSession session : mChatSessionList) {
                    long targetUid;
                    final ISessionPresenter sessionPresenter = this.mSessionPresenterCenter.getPresenter(session.getClass());
                    if (sessionPresenter == null || !statusMap.containsKey(targetUid = sessionPresenter.getUserUid(session))) continue;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            sessionPresenter.updateUserOnline(session, (UserOnlineDBBean)statusMap.get(targetUid));
                        }
                    }, (long)10L);
                }
            }
        }
    }

    public void getTempChannelChatInfo(Object joinChannelItem) {
        ISessionPresenter presenter;
        if (joinChannelItem instanceof MyJoinChannelItem && (presenter = this.mSessionPresenterCenter.getPresenter(ChannelEntranceSession.class)) instanceof ChannelEntranceSessionPresenter) {
            ((ChannelEntranceSessionPresenter)presenter).getTempChannelChatInfo((MyJoinChannelItem)joinChannelItem);
        }
    }

    public void channelPageVisibility(boolean visible) {
        ISessionPresenter presenter = this.mSessionPresenterCenter.getPresenter(ChannelEntranceSession.class);
        if (presenter instanceof ChannelEntranceSessionPresenter) {
            ((ChannelEntranceSessionPresenter)presenter).pageVisibilityChanged(visible);
        }
    }

    @MainThread
    private void updateOfficialSessionExposure() {
        List normalSessions = (List)((ImModuleData)this.mData).normalChatSessions.getValue();
        if (normalSessions == null || normalSessions.isEmpty()) {
            return;
        }
        boolean hasUpdate = OfficialAccountPositionStrategyKt.updateOfficialAccountSessionsExposure(normalSessions, true);
        if (hasUpdate) {
            this.updateSessions(normalSessions);
        }
    }
}

