/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.pushnotify;

import android.content.Context;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.common.Callback;
import com.yy.appbase.data.oas.OfficialAccountsDb;
import com.yy.appbase.data.oas.OfficialAccountsMsgDb;
import com.yy.appbase.extlayer.IExtViewService;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.notify.NotifyPushToastInfo;
import com.yy.appbase.notify.OnPushLayoutAnimateListener;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.MarginInfo;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.appbase.useractionstat.UserEnterActionStat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.im.R;
import com.yy.im.hiido.OfficialDataReportManager;
import com.yy.im.model.JumpBBSDetailsData;
import com.yy.im.pushnotify.BaseMessageToastView;
import com.yy.im.session.bean.ImOasSessionBean;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Map;

public class MessageToastView
extends BaseMessageToastView
implements View.OnClickListener {
    private Context mContext;
    private View mRoot;
    private RoundImageView mIvHeader;
    private YYTextView mTvContent;
    private YYTextView mTvName;
    private YYTextView mTvAction;
    private YYLinearLayout normalLayout;
    private YYLinearLayout wemeetMatchLayout;
    private YYTextView wemeetNameTv;
    private CircleImageView wemeetHeader1;
    private CircleImageView wemeetHeader2;
    private View mToastActionV2Container;
    private SVGAImageView mToastActionV2Svga;
    private View mFriendTag;
    private View mContentLayout;
    private int mType = -1;
    private GameMessageModel mGameMessageModel;
    private OnPushClickListener mOnPushClickListener;
    private Map<String, Object> mExtMap;
    public static final int TYPE_PK_INVITE = 0;
    public static final int TYPE_WEMEET_MATCHES = 2;
    public static final int TYPE_QUIZ_CHAT = 5;
    public static final int TYPE_VOICE_ROOM_INVITE = 6;
    public static final int TYPE_GROUP_MSG = 8;
    public static final int TYPE_CHANNEL_INVITE = 9;
    public static final int TYPE_CHANNEL_MSG = 10;
    public static final int TYPE_DEEPLINK_GAME_MSG = 11;
    public static final int TYPE_OFFICIAL_GAME_TO_CHANNEL = 12;
    public static final int TYPE_BBS_MSG = 13;
    public static final int TYPE_PROFILE_CERTIFICATION = 14;
    public static final int TYPE_PLATFORM_FRIEND = 15;
    public static final int TYPE_GAME_OFFICIAL = 16;
    public static final int TYPE_INTEREST_LABEL = 17;
    private static final int SEX_FEMALE = 0;
    private static final int SEX_MALE = 1;
    private NotifyPushToastInfo notifyPushToastInfo;
    private static final int GIFT_ICON_SIZE = ResolutionUtils.dip2Px((float)25.0f);
    private static final String IMAGE_THUMBNAIL = YYImageUtils.getThumbnailPostfix((int)75);
    private static final String SIT_DOWN_NOTIFY_SVGA = "voice_game_room.svga";
    private JumpBBSDetailsData mJumpBBSDetailsData;
    private int mCurrentCountdownTime;

    public void setType(int type, SpannableStringBuilder content, String name, String headerUrl, int sex) {
        this.mType = type;
        this.normalLayout.setVisibility(0);
        this.wemeetMatchLayout.setVisibility(8);
        this.mTvContent.setText((CharSequence)content);
        this.mTvName.setText((CharSequence)name);
        int placeHolderId = R.drawable.icon_avatar_default_male;
        if (sex == 0) {
            placeHolderId = R.drawable.icon_avatar_default_female;
        }
        if (!headerUrl.isEmpty()) {
            ImageLoader.loadImage((ImageView)this.mIvHeader, (String)(headerUrl + YYImageUtils.getThumbnailPostfix((int)75)), (int)placeHolderId);
        }
        switch (type) {
            case 0: 
            case 11: {
                this.mTvAction.setVisibility(0);
                this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.im_push_join));
                break;
            }
            case 5: {
                this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_quiz_message_chat));
                break;
            }
            case 6: {
                Spanned text = StringUtils.getHtmlText((int)R.string.tips_channel_invite_toast, (Object[])new Object[0]);
                this.mTvContent.setText((CharSequence)text);
                this.mTvAction.setVisibility(0);
                this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.im_push_join));
                break;
            }
            case 8: {
                this.mTvContent.setText((CharSequence)content);
                this.mTvAction.setVisibility(0);
                this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_quiz_message_chat));
                break;
            }
            case 9: {
                this.mTvContent.setText((CharSequence)content);
                this.mTvAction.setVisibility(0);
                this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.im_push_join));
                break;
            }
            case 12: {
                ImageLoader.loadImage((ImageView)this.mIvHeader, (int)R.drawable.icon_public_msg_avatar);
                this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_tab_challenge));
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                this.mTvAction.setVisibility(8);
                break;
            }
            case 16: {
                this.mTvContent.setText((CharSequence)content);
                this.mTvAction.setVisibility(0);
                this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_game_officila_toast));
                break;
            }
            case 17: {
                this.mTvName.setVisibility(8);
                ImageLoader.loadImage((ImageView)this.mIvHeader, (String)"", (int)R.drawable.icon_float_toast_hago_avatar);
                this.mTvContent.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_choose_prefer_game_type));
                this.mTvAction.setVisibility(0);
                this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_game_officila_toast));
                break;
            }
        }
    }

    public MessageToastView(Context context, OnPushLayoutAnimateListener listener, GameMessageModel gameMessageModel) {
        super(context);
        this.mGameMessageModel = gameMessageModel;
        this.mContext = context;
        this.mRoot = LayoutInflater.from((Context)context).inflate(R.layout.layout_im_toast_window, (ViewGroup)this, true);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setClipChildren(false);
        this.findViews(this.mRoot);
        this.setMPushLayoutAnimateListener(listener);
    }

    private void findViews(View root2) {
        this.mIvHeader = (RoundImageView)root2.findViewById(R.id.iv_im_toast_header);
        this.mTvAction = (YYTextView)root2.findViewById(R.id.tv_im_toast_action);
        this.mTvContent = (YYTextView)root2.findViewById(R.id.tv_im_toast_content);
        this.mTvName = (YYTextView)root2.findViewById(R.id.tv_im_toast_name);
        this.mTvName.setTypeface(Typeface.defaultFromStyle((int)1));
        this.mTvAction.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoTitle));
        this.mFriendTag = root2.findViewById(R.id.iv_im_toast_friend_tag);
        this.mContentLayout = root2.findViewById(R.id.content_layout);
        this.normalLayout = (YYLinearLayout)root2.findViewById(R.id.layout_normal);
        this.wemeetMatchLayout = (YYLinearLayout)root2.findViewById(R.id.laout_wemeet_matches);
        this.wemeetNameTv = (YYTextView)root2.findViewById(R.id.tv_wemeet_name);
        this.wemeetHeader1 = (CircleImageView)root2.findViewById(R.id.iv_wemeet_header1);
        this.wemeetHeader2 = (CircleImageView)root2.findViewById(R.id.iv_wemeet_header2);
        this.mToastActionV2Container = root2.findViewById(R.id.toast_action_container);
        this.mToastActionV2Container.setOnClickListener((View.OnClickListener)this);
        this.mToastActionV2Svga = (SVGAImageView)root2.findViewById(R.id.im_toast_action_svga);
        YYTextView toastActionV2 = (YYTextView)root2.findViewById(R.id.tv_im_toast_action_v2);
        FontUtils.setFontType((TextView)toastActionV2, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoTitle));
        this.mTvAction.setOnClickListener((View.OnClickListener)this);
    }

    public void updateView(NotifyPushToastInfo info) {
        this.notifyPushToastInfo = info;
        if (info == null) {
            return;
        }
        if (info.getPushTittle() == null) {
            this.mTvName.setVisibility(8);
        } else {
            this.mTvName.setText((CharSequence)info.getPushTittle());
        }
        if (info.getPushType() == 4) {
            this.mIvHeader.setType(1);
            this.mIvHeader.setBorderRadius(ResolutionUtils.dip2Px((float)8.0f));
            this.mTvAction.setVisibility(8);
            this.mToastActionV2Container.setVisibility(0);
            this.playSitDownNotifySvga();
        } else if (info.getPushType() == 3) {
            this.mTvAction.setVisibility(8);
            this.mToastActionV2Container.setVisibility(0);
            this.playSitDownNotifySvga();
        } else {
            this.mTvAction.setVisibility(0);
            this.mToastActionV2Container.setVisibility(8);
            if (TextUtils.isEmpty((CharSequence)info.getButtonText())) {
                this.mTvAction.setVisibility(8);
            } else {
                this.mTvAction.setText((CharSequence)info.getButtonText());
            }
        }
        if (info.getWhetherCountdown()) {
            this.mCurrentCountdownTime = info.getDuration() / 1000;
            this.mTvAction.setText((CharSequence)(this.notifyPushToastInfo.getButtonText() + " (" + this.mCurrentCountdownTime + "s)"));
            this.startCountdown();
        }
        if (TextUtils.isEmpty((CharSequence)info.getPushContent())) {
            this.mTvContent.setVisibility(8);
        } else {
            this.updatePushContent(info);
        }
        if (info.getImgUrl() != null) {
            if (info.getWhetherBlur()) {
                ImageLoader.loadBlurImage((ImageView)this.mIvHeader, (String)(info.getImgUrl() + YYImageUtils.getThumbnailPostfix((int)10)), (int)AvatarUtils.getDefaultAvatarSmall((int)info.getSex()));
            } else {
                ImageLoader.loadImage((ImageView)this.mIvHeader, (String)(info.getImgUrl() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatarSmall((int)info.getSex()));
            }
        } else if (info.getImgResId() != 0) {
            this.mIvHeader.setBackgroundResource(info.getImgResId());
        } else {
            this.mIvHeader.setBackgroundResource(R.drawable.ico_hago);
        }
    }

    @Override
    public void onCountdown() {
        super.onCountdown();
        --this.mCurrentCountdownTime;
        this.mTvAction.setText((CharSequence)(this.notifyPushToastInfo.getButtonText() + " (" + this.mCurrentCountdownTime + "s)"));
    }

    private void updatePushContent(NotifyPushToastInfo info) {
        if (info.getTextShowType() == 2) {
            this.bindGiftMsg(info.getExtraString2(), info.getPropsCount());
        } else {
            this.mTvContent.setText(info.getPushContent());
        }
    }

    private void bindGiftMsg(String iconUrl, int count) {
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)R.string.summary_im_send_gift, (Object[])new Object[]{String.valueOf(count)}), new Object[]{TextSpan.of().size(13).color(-16777216).build()}).replaceImage("[gift]", iconUrl + IMAGE_THUMBNAIL, GIFT_ICON_SIZE, GIFT_ICON_SIZE, R.drawable.icon_gift_box, MarginInfo.of()).onFinish((Callback)new Callback<Spannable>(){

            public void onResponse(Spannable data2) {
                MessageToastView.this.mTvContent.setText((CharSequence)data2);
            }
        }).build();
    }

    public void onClick(View v) {
        Runnable runnable2 = () -> {
            if (this.mTvName != null && this.mTvName.getText() != null && this.mTvName.getVisibility() == 0) {
                UserEnterActionStat.onFloawWindowClick((String)("FloawToast:" + this.mTvName.getText().toString()));
            } else if (this.mTvContent != null && this.mTvContent.getText() != null && this.mTvContent.getVisibility() == 0) {
                UserEnterActionStat.onFloawWindowClick((String)("FloawToast:" + this.mTvContent.getText().toString()));
            }
            if (this.mOnPushClickListener != null) {
                this.mOnPushClickListener.statClick();
            }
            int id2 = v.getId();
            boolean hasNotify = false;
            if (id2 == R.id.tv_im_toast_action) {
                if (this.mType == 0) {
                    if (this.mOnPushClickListener != null) {
                        this.mOnPushClickListener.startGame(this.mGameMessageModel);
                    }
                } else if (this.mType == 2 || this.mType == 5) {
                    if (null != this.mOnPushClickListener) {
                        this.mOnPushClickListener.jumpToChat(this.mType);
                    }
                } else if (this.mType == 6) {
                    if (null != this.mOnPushClickListener && null != this.mExtMap) {
                        String inviteUrl = (String)this.mExtMap.get("inviteUrl");
                        if (StringUtils.isNotEmpty((String)inviteUrl)) {
                            this.mOnPushClickListener.jumpToWeb(inviteUrl);
                        } else {
                            Object fromUid = this.mExtMap.get("fromUid");
                            this.mOnPushClickListener.jumpToRoom((String)this.mExtMap.get("roomId"), (String)this.mExtMap.get("roomToken"), fromUid != null ? (Long)fromUid : 0L, (String)this.mExtMap.get("roomSource"));
                        }
                    }
                } else if ((this.mType == 9 || this.mType == 10) && null != this.mExtMap) {
                    if (null != this.mOnPushClickListener) {
                        this.mOnPushClickListener.jumpToChannel((String)this.mExtMap.get("roomId"), (String)this.mExtMap.get("roomToken"), this.mType);
                    }
                } else if (this.mType == 11) {
                    if (null != this.mOnPushClickListener) {
                        this.mOnPushClickListener.startGameFlow(GameContextDef.JoinFrom.FROM_DEEP_LINK);
                    }
                } else if (this.mType == 12) {
                    if (null != this.mOnPushClickListener) {
                        this.mOnPushClickListener.jumpToGameChannel();
                    }
                } else if (this.mType == 16) {
                    if (null != this.mOnPushClickListener && this.mExtMap.get("url") instanceof String) {
                        this.mOnPushClickListener.handleUrl((String)this.mExtMap.get("url"));
                        this.reportClick();
                    }
                } else if (this.mType == 17) {
                    this.onActivelyHide(false);
                    hasNotify = true;
                    this.onTimeOutExit();
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (MessageToastView.this.mOnPushClickListener != null) {
                                MessageToastView.this.mOnPushClickListener.jumpToChooseInterestLabel();
                            }
                        }
                    }, (long)300L);
                }
            }
            if (!hasNotify) {
                this.notifyAllPushLayoutListener("onExitByClick");
            }
            if (this.mOnPushClickListener != null) {
                this.mOnPushClickListener.jumpToType(this.notifyPushToastInfo, id2);
            }
        };
        ((IExtViewService)ServiceManagerProxy.getInstance().getService(IExtViewService.class)).jumpWithExecTask(this.getContext(), runnable2);
    }

    private void reportClick() {
        ImOasSessionBean bean;
        if (this.mExtMap.get("data") instanceof ImOasSessionBean && (bean = (ImOasSessionBean)this.mExtMap.get("data")).getOasDb() != null && !FP.empty((Collection)bean.getOasDb().getMsgs())) {
            OfficialAccountsDb db = bean.getOasDb();
            OfficialAccountsMsgDb msgDb = (OfficialAccountsMsgDb)db.getMsgs().get(0);
            OfficialDataReportManager.INSTANCE.reportMsgClick(db.getSaid(), msgDb.getMsgId(), "3", false, 4, 1, 0);
        }
    }

    public void setWemeetMatchesType(int type, String name, String headUrl1, String headUrl2, int sex1, int sex2) {
        this.mType = type;
        this.normalLayout.setVisibility(8);
        this.wemeetMatchLayout.setVisibility(0);
        this.wemeetNameTv.setText((CharSequence)name);
        int placeHolderId1 = R.drawable.icon_avatar_default_male;
        if (sex1 == 0) {
            placeHolderId1 = R.drawable.icon_avatar_default_female;
        }
        ImageLoader.loadImage((ImageView)this.wemeetHeader1, (String)(headUrl1 + YYImageUtils.getThumbnailPostfix((int)75)), (int)placeHolderId1);
        int placeHolderId2 = R.drawable.icon_avatar_default_male;
        if (sex2 == 0) {
            placeHolderId2 = R.drawable.icon_avatar_default_female;
        }
        ImageLoader.loadImage((ImageView)this.wemeetHeader2, (String)(headUrl2 + YYImageUtils.getThumbnailPostfix((int)75)), (int)placeHolderId2);
        this.mTvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_im_push_wemeet_matches));
    }

    public void setOnNotifyPushClickListener(OnPushClickListener listener) {
        this.mOnPushClickListener = listener;
    }

    public String getPkId() {
        String pkId = "";
        if (this.mGameMessageModel != null) {
            pkId = this.mGameMessageModel.getPkId();
        }
        return pkId;
    }

    public void setExtParam(Map<String, Object> extMap) {
        this.mExtMap = extMap;
    }

    private void playSitDownNotifySvga() {
        if (this.mToastActionV2Svga != null) {
            SvgaLoader.load((SVGAImageView)this.mToastActionV2Svga, (String)SIT_DOWN_NOTIFY_SVGA, (boolean)true);
        }
    }

    @Override
    @NonNull
    public View getContentLayout() {
        return this.mContentLayout;
    }

    @Override
    public void contentClick() {
        boolean jump = false;
        if (this.mOnPushClickListener != null) {
            this.mOnPushClickListener.statClick();
        }
        if (this.mType == 13 && this.mJumpBBSDetailsData != null) {
            if (this.mJumpBBSDetailsData.isQualityComment()) {
                this.openBbsPostDetail(this.mJumpBBSDetailsData.getPpostId(), this.mJumpBBSDetailsData.getNeedback(), this.mJumpBBSDetailsData.getPpostsource(), this.mJumpBBSDetailsData.getChannelid(), this.mJumpBBSDetailsData.getPtype());
            } else if (this.mJumpBBSDetailsData.getType() == 0) {
                if (this.mJumpBBSDetailsData.getJumpType() == 0) {
                    this.jumpToPostDetailPage(this.mJumpBBSDetailsData.getPpostId(), this.mJumpBBSDetailsData.getPostId(), this.mJumpBBSDetailsData.getPostType(), this.mJumpBBSDetailsData.getNeedback(), this.mJumpBBSDetailsData.getPpostsource(), this.mJumpBBSDetailsData.getChannelid());
                } else {
                    this.openBbsPostDetail(this.mJumpBBSDetailsData.getPostId(), this.mJumpBBSDetailsData.getNeedback(), this.mJumpBBSDetailsData.getPpostsource(), this.mJumpBBSDetailsData.getChannelid(), 0);
                }
            } else {
                this.jumpToNoticeList(this.mJumpBBSDetailsData.getNeedback(), this.mJumpBBSDetailsData.getPpostsource(), this.mJumpBBSDetailsData.getChannelid());
            }
            jump = true;
            this.onTimeOutExit();
            this.onActivelyHide(false);
        } else if (this.mType == 14) {
            if (this.mOnPushClickListener != null) {
                this.mOnPushClickListener.jumpToWeb((String)this.mExtMap.get("url"));
                jump = true;
            }
            this.onActivelyHide(false);
        } else if (this.mType == 15) {
            ((IYYUriService)ServiceManagerProxy.getInstance().getService(IYYUriService.class)).handleUri(Uri.parse((String)((String)this.mExtMap.get("url"))));
            jump = true;
        }
        if (this.mOnPushClickListener != null) {
            this.onActivelyHide(false);
            this.mOnPushClickListener.jumpToType(this.notifyPushToastInfo, R.id.content_layout);
            jump = true;
        }
        if (!jump && RuntimeContext.isHagoPartySdk()) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_PARTY_SDK_BACK_ROOT_WINDOW, (Object)2000));
        }
    }

    private void openBbsPostDetail(String postId, boolean backSquare, int ppostsource, String channelid, int ptype) {
        Message msg = Message.obtain();
        msg.what = AppbaseMsgDef.BBSMsgDef.OPEN_POST_DETAIL;
        Bundle bundle = new Bundle();
        bundle.putSerializable("bbs_post_detail_postid", (Serializable)((Object)postId));
        bundle.putBoolean("needBackToSquare", backSquare);
        bundle.putInt("needBackToChannelPost", ppostsource);
        bundle.putString("needBackToChannelid", channelid);
        bundle.putInt("bbs_post_detail_from", 7);
        this.appendParamIfNeed(ptype, bundle);
        msg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    private void appendParamIfNeed(int ptype, @NonNull Bundle bundle) {
        int action;
        if (ptype == 0) {
            return;
        }
        switch (ptype) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                action = 1;
                break;
            }
            case 3: {
                action = 2;
                break;
            }
            default: {
                action = 0;
            }
        }
        bundle.putInt("bbs_post_detail_do_action", action);
    }

    private void jumpToPostDetailPage(String ppostId, String postId, int postType, boolean needBack, int ppostsource, String channelid) {
        Message msg = Message.obtain();
        msg.what = AppbaseMsgDef.BBSMsgDef.OPEN_POST_DETAIL_NOTICE;
        Bundle bundle = new Bundle();
        bundle.putSerializable("bbs_post_detail_postid", (Serializable)((Object)postId));
        bundle.putInt("bbs_post_detail_from", 1);
        bundle.putInt("bbs_post_detail_type", postType);
        bundle.putBoolean("needBackToSquare", needBack);
        bundle.putInt("needBackToChannelPost", ppostsource);
        bundle.putString("needBackToChannelid", channelid);
        msg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    private void jumpToNoticeList(boolean needBack, int ppostsource, String channelid) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.OPEN_WINDOW_BBS_NOTICE_LIST;
        Bundle bundle = new Bundle();
        msg.setData(bundle);
        bundle.putBoolean("needBackToSquare", needBack);
        bundle.putInt("needBackToChannelPost", ppostsource);
        bundle.putString("needBackToChannelid", channelid);
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    public void showFriendTag() {
        this.mFriendTag.setVisibility(0);
    }

    public void hideFriendTag() {
        this.mFriendTag.setVisibility(8);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mToastActionV2Svga != null && this.mToastActionV2Svga.isAnimating()) {
            this.mToastActionV2Svga.stopAnimation();
        }
        this.stopCountdown();
        this.releaseAllListener();
    }

    public void setJumpBBSDetailsData(JumpBBSDetailsData jumpBBSDetailsData) {
        this.mJumpBBSDetailsData = jumpBBSDetailsData;
    }

    public static interface OnPushClickListener {
        public void onHide();

        public void startGame(GameMessageModel var1);

        public void jumpToChat(int var1);

        public void jumpToType(NotifyPushToastInfo var1, int var2);

        public void jumpToRoom(String var1, String var2, long var3, String var5);

        public void jumpToChannel(String var1, String var2, int var3);

        public void startGameFlow(GameContextDef.JoinFrom var1);

        public void jumpToGameChannel();

        public void jumpToWeb(String var1);

        public void handleUrl(String var1);

        public void jumpToChooseInterestLabel();

        public void statClick();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotifyPushType {
    }
}

