/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.R;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONArray;
import org.json.JSONObject;

public class MsgInnerWinner
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerWinner(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        JSONObject contentJson = msgJson.optJSONObject("winner");
        int price = contentJson.optInt("price");
        long time = contentJson.optLong("time");
        JSONArray jsonArray = contentJson.optJSONArray("gift");
        StringBuilder giftBuilder = new StringBuilder();
        StringBuilder giftNumBuilder = new StringBuilder();
        if (jsonArray != null) {
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.optJSONObject(i);
                if (jsonObject == null) continue;
                String giftId = jsonObject.optString("giftid");
                giftBuilder.append(giftId + ",");
                int giftNum = jsonObject.optInt("cnt");
                giftNumBuilder.append(giftNum + ",");
            }
        }
        messageBuilder.content(ResourceUtils.getString((int)R.string.tips_wealth_im_content)).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).contentType(1).uid(item.getFromUid()).reserve1(price + "").reserve2(time * 1000L + "").reserve3(giftBuilder.toString()).reserve4(giftNumBuilder.toString());
        messageBuilder.msgType(31);
        return messageBuilder;
    }
}

