/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONObject;

public class MsgInnerReport
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerReport(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        if (msgJson != null) {
            MLog.debug((Object)"SafelyReviewDialogController", (String)("msgJson:" + msgJson.toString()), (Object[])new Object[0]);
            String reportInfo = msgJson.optString("info");
            String explain = msgJson.optString("explain");
            boolean isReporter = msgJson.optBoolean("isreporter");
            String reportTitle = msgJson.optString("title");
            String reportContent = msgJson.optString("content");
            String reportNick = msgJson.optString("reported_nick");
            String reportReason = msgJson.optString("resason");
            long reportTime = msgJson.optLong("time");
            String reportPunishment = msgJson.optString("punishment");
            String reportNote = msgJson.optString("note");
            String serial = msgJson.optString("serial");
            String againstSource = msgJson.optString("against_source");
            String againstDesc = msgJson.optString("against_desc");
            messageBuilder.content(reportInfo).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).contentType(9).uid(item.getFromUid()).reportTitle(reportTitle).reportContent(reportContent).reportNick(reportNick).reportReason(reportReason).reportTime(reportTime).reportPunishment(reportPunishment).reportNote(reportNote).reportAgainstSource(againstSource).reportAgainstDesc(againstDesc).msgType(isReporter ? 8 : 10).extra(explain).serial(serial);
        }
        this.ctlCallback.showDefaultNotification(item, item.getPushContent(), "", "10");
        return messageBuilder;
    }
}

