/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.module.room.data.OfficialGamePushInfo;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONObject;

public class MsgInnerGameTxtPic
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerGameTxtPic(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        if (msgJson.has("gpictxt")) {
            JSONObject msgDataJson = msgJson.optJSONObject("gpictxt");
            if (msgDataJson.has("gameId")) {
                String gameId = payloadJson.optString("gameId");
                GameInfo gameInfo = ((IGameInfoService)this.ctlCallback.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                if (gameInfo == null) {
                    return null;
                }
            }
            OfficialGamePushInfo officialGamePushInfo = (OfficialGamePushInfo)JsonParser.parseJsonObject((String)msgDataJson.toString(), OfficialGamePushInfo.class);
            messageBuilder.content(officialGamePushInfo.content).reserve3(msgDataJson.toString()).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).msgType(20).uid(item.getFromUid());
            this.ctlCallback.showDefaultNotification(item, officialGamePushInfo.content, officialGamePushInfo.gid, "10");
        }
        return messageBuilder;
    }
}

