/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.R;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONObject;

public class MsgInnerCustomerServiceNotify
extends IImMsgParse {
    private static final String TAG = "MsgInnerCustomerServiceNotify";
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerCustomerServiceNotify(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        if (msgJson.has("customer_service_notify")) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"\u63a5\u6536\u5230\u5ba2\u670d\u6d88\u606f success %s", (Object[])new Object[]{msgJson});
            }
            JSONObject object = msgJson.optJSONObject("customer_service_notify");
            String url = object.optString("url");
            MLog.info((Object)TAG, (String)"url: %s", (Object[])new Object[]{url});
            SettingFlags.setStringValue((String)("key_customer_service_url" + AccountUtil.getUid()), (String)url);
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.SHOW_DRAWER_CUSTOMER_SERVICE_REA_POINT);
            long feedbackTs = object.optLong("feedback_ts");
            String time = TimeUtils.getFormatTimeString((long)feedbackTs, (String)"year-mon-day");
            messageBuilder.content(ResourceUtils.getString((int)R.string.tips_feedback_help_center, (Object[])new Object[]{time})).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).reserve1(url).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).uid(item.getFromUid()).msgType(44);
            this.ctlCallback.showDefaultNotification(item, item.getPushContent(), "", "-1");
        }
        return messageBuilder;
    }
}

