/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerBbsFollowNotice
extends IImMsgParse {
    private static final String TAG = "MsgInnerBbsFollowNotice";
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerBbsFollowNotice(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        JSONObject postObject = msgJson.optJSONObject("notify");
        if (postObject != null) {
            messageBuilder.content(postObject.toString()).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).msgType(42).contentType(16).uid(item.getFromUid());
        }
        String pushPayload = item.getPushPayload();
        JSONObject json = null;
        if (!TextUtils.isEmpty((CharSequence)pushPayload)) {
            try {
                json = JsonParser.obtainJSONObject((String)pushPayload);
                String pushType = json.optString("push_source");
                if (json.has("display_front")) {
                    boolean isShowForeground = json.optBoolean("display_front");
                    this.ctlCallback.showNotification(item, pushType, isShowForeground);
                } else {
                    this.ctlCallback.showNotification(item, pushType, false);
                }
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return messageBuilder;
    }
}

