/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.utils;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.data.ViewDimension;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.camera.base.ImageOpenLargeHelper;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameSelectContext;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.callback.Callback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.officalmsg.IKXDOfficalmsgProto;
import ikxd.officalmsg.SlipGameMsgReq;
import ikxd.officalmsg.Uri;
import javax.annotation.Nonnull;

public class ChatMessageEventHandler {
    public static final String TAG = "ChatMessageEventHandler";

    public static void onChatMessageImageClick(View v, ChatMessageData data2) {
        Message message = Message.obtain();
        Bundle bundle = new Bundle();
        String imagePath = data2.message.getReserve5();
        boolean hideDownload = false;
        if (StringUtils.isEmpty((String)imagePath)) {
            imagePath = data2.message.getContent();
        }
        if (ImageUtil.isGif((String)imagePath)) {
            hideDownload = true;
        }
        ImageOpenLargeHelper.INSTANCE.setFromDrawable(v);
        bundle.putString("url", imagePath);
        bundle.putBoolean("hide_down_load", hideDownload);
        bundle.putParcelable("view_dimension", (Parcelable)new ViewDimension(v));
        message.what = BaseMsgDef.OPEN_WINDOW_PHOTO;
        message.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public static void onJumpToWebClick(String url, String title) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.url_is_null), (int)0);
        } else {
            ChatMessageEventHandler.parseJumpUrl(url, title);
        }
    }

    private static void parseJumpUrl(String url, String title) {
        if (url.startsWith("https://") || url.startsWith("http://")) {
            ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(url, title);
        } else if (url.startsWith("app://") || url.startsWith("hago://")) {
            android.net.Uri uri = android.net.Uri.parse((String)url);
            String gameId = uri.getQueryParameter("gameid");
            String type = uri.getQueryParameter("type");
            if (!TextUtils.isEmpty((CharSequence)type) && "Single".equalsIgnoreCase(type)) {
                ChatMessageEventHandler.jumpToSingleGame(gameId);
            } else {
                ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(url);
            }
        }
    }

    private static void jumpToSingleGame(final String gameId) {
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025737").put("gid", gameId).put("function_id", "msg_click").put("page_id", "middle_page"));
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameSelectContext selectContext = new GameSelectContext(GameContextDef.JoinFrom.FROM_IM);
                selectContext.setGameId(gameId);
                selectContext.setGameSelectMode("default");
                ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).toSelectPage(selectContext, 3);
            }
        });
    }

    public static void onStreakWinMsgClick(String data2) {
        Message message = Message.obtain();
        message.what = BaseMsgDef.SHOW_WINNING_STREAK_DIALOG;
        Bundle bundle = new Bundle();
        bundle.putString("winning_streak_data", data2);
        message.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public static void onJumpUri(@Nonnull String uri) {
        ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(uri);
    }

    public static void toggleGamePush(final String gid, final boolean isShowNotify, final Callback<Pair<String, Boolean>> callback) {
        MLog.info((Object)TAG, (String)"toggleGamePush response %s, isShowNotify %b", (Object[])new Object[]{gid, isShowNotify});
        SlipGameMsgReq req = new SlipGameMsgReq.Builder().gid(gid).status(Long.valueOf(isShowNotify ? 1L : 0L)).build();
        IKXDOfficalmsgProto proto = new IKXDOfficalmsgProto.Builder().header(ProtoManager.getInstance().getHeader("ikxd_offical_msg_d")).slip_game_msg_req(req).uri(Uri.kUriSlipGameMsgReq).build();
        ProtoManager.getInstance().send((AndroidMessage)proto, (IProtoCallback)new IProtoCallback<IKXDOfficalmsgProto>(){

            public void onResponse(@Nullable IKXDOfficalmsgProto message) {
                if (message != null && message.header != null) {
                    MLog.info((Object)ChatMessageEventHandler.TAG, (String)"toggleGamePush response %s", (Object[])new Object[]{message.header});
                    callback.onResponse(new Pair((Object)gid, (Object)(message.header.code == 0L != isShowNotify ? 1 : 0)));
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public static void onJumpToContactQuiz() {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.OPEN_WINDOW_QUIZ;
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    public static void onJumpHelpCenterOrFeedback(View v, String feedbackContent, String payOrderId) {
        ChatMessageEventHandler.enterFeedback(feedbackContent);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "succ_rec_issue_but_click").put("business_order_no", payOrderId));
    }

    private static void enterFeedback(String feedbackContent) {
        Message message = new Message();
        Bundle bundle = new Bundle();
        bundle.putString("feedback_content", feedbackContent);
        message.what = MixBaseMsgDef.SHOW_FEEDBACK_WRAP_WINDOW;
        message.arg1 = 7;
        message.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public static void onJumpIm(Long uid) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_ROOM_SHOW;
        Bundle bundle = new Bundle();
        bundle.putLong("target_uid", uid.longValue());
        bundle.putInt("im_page_source", 10);
        msg.setData(bundle);
        MsgDispatcher.getInstance().sendMessageSync(msg);
    }

    public static void onJumpHelpCenter(@Nullable String url) {
        Message message = new Message();
        Bundle bundle = new Bundle();
        bundle.putString("feedback_content", "");
        if (!TextUtils.isEmpty((CharSequence)url)) {
            bundle.putString("jump_url", url);
        }
        message.what = MixBaseMsgDef.SHOW_HELP_CENTER_WINDOW;
        message.arg1 = 7;
        message.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(message);
    }
}

