/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.utils;

import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import java.util.ArrayList;

public class ChatHistoryHelper {
    public static void queryHistoryMsg(IServiceManager serviceManager, long targetUid, String sessionId2, int limit, MyBox.IGetItemsCallBack listener) {
        ChatHistoryHelper.queryRecentHistoryMsgInner(serviceManager, targetUid, sessionId2, limit, false, listener);
    }

    public static void queryRecentHistoryMsg(IServiceManager serviceManager, long targetUid, String sessionId2, int limit, MyBox.IGetItemsCallBack listener) {
        ChatHistoryHelper.queryRecentHistoryMsgInner(serviceManager, targetUid, sessionId2, limit, true, listener);
    }

    public static void queryTargetRecentHistoryMsg(IServiceManager serviceManager, long targetUid, String sessionId2, int limit, MyBox.IGetItemsCallBack listener) {
        ChatHistoryHelper.queryRecentHistoryMsgInner(serviceManager, targetUid, sessionId2, limit, true, listener);
    }

    public static void queryRecentHistoryMsgInner(IServiceManager serviceManager, final long targetUid, final String sessionId2, final int limit, final boolean reverse, final MyBox.IGetItemsCallBack listener) {
        if (listener == null || serviceManager == null) {
            if (listener != null) {
                listener.onLoaded(new ArrayList());
            }
            return;
        }
        MyBox msgBox = ((IDBService)serviceManager.getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class);
        if (msgBox == null) {
            if (listener != null) {
                listener.onLoaded(new ArrayList());
            }
            return;
        }
        msgBox.getAll(new MyBox.IGetItemsCallBack(){

            public void onLoaded(ArrayList dbList) {
                int end;
                ArrayList<ImMessageDBBean> results = new ArrayList<ImMessageDBBean>();
                if (dbList == null || dbList.size() <= 0) {
                    listener.onLoaded(results);
                    return;
                }
                int size = dbList.size();
                int index = reverse ? size - 1 : 0;
                int n = end = reverse ? 0 : size - 1;
                if (size > 0) {
                    ImMessageDBBean msg = null;
                    while ((reverse ? index >= end : index <= end) && results.size() <= limit) {
                        msg = (ImMessageDBBean)dbList.get(index);
                        if (msg != null && StringUtils.equal((String)msg.getSessionId(), (String)sessionId2)) {
                            if (msg.getStatus() == 2) {
                                msg.setStatus(1);
                            }
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.info((Object)"ChatHistoryHelper", (String)("sessionId:" + msg.getSessionId() + "\uff0c \u67e5\u51fa\u6765\u7684\u6570\u636e:" + msg.getContent()), (Object[])new Object[0]);
                            }
                            if (targetUid > 0L) {
                                if (targetUid == msg.getUid() && msg.getMsgType() == 0) {
                                    results.add(msg);
                                }
                            } else {
                                results.add(msg);
                            }
                        }
                        if (reverse) {
                            --index;
                            continue;
                        }
                        ++index;
                    }
                }
                listener.onLoaded(results);
            }
        });
    }
}

