/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.base.data.ImMsgScreenData;
import com.yy.hiyo.im.base.data.ListDataState;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.im.R;
import com.yy.im.chatim.IMContext;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;

@DontProguardClass
public class ChatProfileUpateHolder
extends ChatBaseHolder {
    private YYTextView mContent;
    private int mType = 0;

    public ChatProfileUpateHolder(View itemView, final IMvpContext mvpContext) {
        super(itemView, mvpContext);
        View mClose = itemView.findViewById(R.id.iiupuc_close);
        YYTextView mEdit = (YYTextView)itemView.findViewById(R.id.iiupuc_edit);
        this.mContent = (YYTextView)itemView.findViewById(R.id.iiupuc_content);
        mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (mvpContext instanceof IMContext) {
                    long current = System.currentTimeMillis();
                    SettingFlags.setLongValue((String)("avatar_edit_close_time_" + AccountUtil.getUid()), (long)current);
                    long closeCount = SettingFlags.getLongValue((String)("avatar_edit_close_count_" + AccountUtil.getUid()), (long)0L);
                    SettingFlags.setLongValue((String)("avatar_edit_close_count_" + AccountUtil.getUid()), (long)(closeCount + 1L));
                    MLog.info((Object)"ChatProfileUpateHolder", (String)("close current: " + current + ", closeCount: " + (closeCount + 1L)), (Object[])new Object[0]);
                    ArrayList<Object> removeList = new ArrayList<Object>();
                    removeList.add(ChatProfileUpateHolder.this.getData());
                    ((IMContext)mvpContext).getImMsgVm().deleteDBMsg(removeList);
                    ((IMContext)mvpContext).getImMsgVm().notifyMsgListChange(new ImMsgScreenData(removeList, ListDataState.DEL));
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "profile_complete_close").put("profile_complete_type", String.valueOf(ChatProfileUpateHolder.this.mType)));
                }
            }
        });
        mEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                long current = System.currentTimeMillis();
                SettingFlags.setLongValue((String)("avatar_edit_click_" + AccountUtil.getUid()), (long)current);
                MLog.info((Object)"ChatProfileUpateHolder", (String)("edit current: " + current), (Object[])new Object[0]);
                switch (ChatProfileUpateHolder.this.mType) {
                    case 2: 
                    case 3: {
                        Message message = Message.obtain();
                        message.what = AppbaseMsgDef.MSG_OPEN_PUBLISH_WINDOW;
                        message.arg1 = 10;
                        message.arg2 = -1;
                        MsgDispatcher.getInstance().sendMessage(message);
                        break;
                    }
                    default: {
                        MsgDispatcher.getInstance().sendMessage(UserMsgDef.OPEN_WINDOW_EDIT_PROFILE);
                    }
                }
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "profile_complete_click").put("profile_complete_type", String.valueOf(ChatProfileUpateHolder.this.mType)));
            }
        });
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        String tag = data2.message.getTag();
        MLog.info((Object)"ChatProfileUpateHolder", (String)("setData type: " + tag), (Object[])new Object[0]);
        if (tag == null) {
            this.mType = 0;
            this.mContent.setText(R.string.user_avatar_guide_tips_one);
        } else {
            this.mType = StringUtils.safeParseInt((String)tag);
            switch (this.mType) {
                case 2: {
                    this.mContent.setText(R.string.user_avatar_guide_tips_two);
                    break;
                }
                case 3: {
                    this.mContent.setText(R.string.user_avatar_guide_tips_three);
                    break;
                }
                default: {
                    this.mContent.setText(R.string.user_avatar_guide_tips_one);
                }
            }
        }
    }

    public static BaseItemBinder<ChatMessageData, ChatProfileUpateHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatProfileUpateHolder>(){

            @NonNull
            protected ChatProfileUpateHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatProfileUpateHolder(inflater.inflate(R.layout.item_im_user_profile_update_card, parent, false), context);
            }
        };
    }
}

