/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.honor.HonorInfo;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnAlbumCallback;
import com.yy.appbase.service.callback.OnGetInsPhotosCallback;
import com.yy.appbase.service.callback.OnGetLatestHonorCallback;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.user.base.honor.HonorIntroPopupwindow;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

@DontProguardClass
public class ChatProfileHolder
extends ChatBaseHolder
implements View.OnClickListener {
    private YYRelativeLayout rlytCard;
    private YYRelativeLayout rlytCardInfo;
    private YYTextView tvUserName;
    private YYTextView tvAge;
    private YYTextView tvAddress;
    private YYTextView tvTime;
    private YYTextView tvSign;
    private YYImageView viewBg;
    private YYImageView ivOverlap;
    private RoundConerImageView ivAvatar;
    private RecycleImageView ivHonor;
    private Drawable drawableFemale;
    private Drawable drawableMale;
    private IUserInfoService userInfoService;
    private long mUid;
    private List<String> urlList;
    private HonorInfo mHonorInfo;
    private boolean isGetphotos = false;
    private boolean isGetHonrInfo = false;
    private boolean isgetInstagramPhotos = false;
    private boolean isgetUserInfo = false;
    private UserInfoKS userInfo;

    public ChatProfileHolder(View itemView, IMvpContext outerEventHandlerProvider) {
        super(itemView, outerEventHandlerProvider);
        this.rlytCard = (YYRelativeLayout)itemView.findViewById(R.id.rlyt_card);
        this.rlytCardInfo = (YYRelativeLayout)itemView.findViewById(R.id.rlyt_card_info);
        this.ivAvatar = (RoundConerImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.tvUserName = (YYTextView)itemView.findViewById(R.id.tv_user_name);
        this.tvAge = (YYTextView)itemView.findViewById(R.id.tv_user_age);
        this.tvSign = (YYTextView)itemView.findViewById(R.id.tv_sign);
        this.tvAddress = (YYTextView)itemView.findViewById(R.id.tv_user_address);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.viewBg = (YYImageView)itemView.findViewById(R.id.iv_profile_card_bg);
        this.ivOverlap = (YYImageView)itemView.findViewById(R.id.iv_overlap);
        this.ivHonor = (RecycleImageView)itemView.findViewById(R.id.iv_user_honor);
        this.drawableFemale = ResourceUtils.getDrawable((int)R.drawable.icon_female_white);
        this.drawableFemale.setBounds(0, 0, this.drawableFemale.getIntrinsicWidth(), this.drawableFemale.getIntrinsicHeight());
        this.drawableMale = ResourceUtils.getDrawable((int)R.drawable.icon_male_white);
        this.drawableMale.setBounds(0, 0, this.drawableMale.getIntrinsicWidth(), this.drawableMale.getIntrinsicHeight());
    }

    public static BaseItemBinder<ChatMessageData, ChatProfileHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatProfileHolder>(){

            @NonNull
            protected ChatProfileHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatProfileHolder(inflater.inflate(R.layout.layout_item_im_profile_info_card, parent, false), context);
            }
        };
    }

    public void setData(final ChatMessageData data2) {
        super.setData((Object)data2);
        IUserInfoService service2 = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        UserInfoKS bean = service2.getUserInfo(data2.message.getUid());
        this.mUid = data2.message.getUid();
        if (bean.ver == 0L) {
            service2.requestUserInfoFromServer(this.mUid, new OnKSProfileListCallback(){

                public void onUISuccess(@NonNull List<UserInfoKS> userInfoKSList) {
                    if (userInfoKSList != null && !userInfoKSList.isEmpty()) {
                        UserInfoKS info = userInfoKSList.get(0);
                        ChatProfileHolder.this.fillUserInfo(data2, info);
                    }
                }

                public void onError(String reason, long code) {
                }
            });
        } else {
            this.fillUserInfo(data2, bean);
        }
        this.userInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
        this.getPhotos();
        this.handleHonor();
    }

    private void fillUserInfo(ChatMessageData data2, UserInfoKS bean) {
        this.isgetUserInfo = true;
        this.userInfo = bean;
        this.reportProfileCardShow();
        this.showAvatar((RecycleImageView)this.ivAvatar, this.getUserInfo(bean.uid));
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        this.tvUserName.setText((CharSequence)(bean == null ? "" : bean.nick));
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
        this.viewBg.setTag(R.id.chat_message_data, (Object)data2);
        this.rlytCardInfo.setTag(R.id.chat_message_data, (Object)data2);
        this.rlytCard.setTag(R.id.chat_message_data, (Object)data2);
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        this.viewBg.setOnClickListener((View.OnClickListener)this);
        this.rlytCardInfo.setOnClickListener((View.OnClickListener)this);
        this.rlytCard.setOnClickListener((View.OnClickListener)this);
        this.tvAge.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.tvAddress.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        if (TextUtils.isEmpty((CharSequence)bean.sign)) {
            this.tvSign.setVisibility(8);
        } else {
            this.tvSign.setVisibility(0);
            this.tvSign.setText((CharSequence)bean.sign);
        }
        if (bean.ver > 0L && bean.hideLocation == 1L) {
            this.tvAddress.setVisibility(8);
        } else {
            this.tvAddress.setVisibility(0);
            if (!FP.empty((CharSequence)bean.city)) {
                String city = bean.city;
                if (!TextUtils.isEmpty((CharSequence)city)) {
                    this.tvAddress.setText((CharSequence)city);
                } else if (!FP.empty((CharSequence)bean.lastLoginLocation)) {
                    this.tvAddress.setText((CharSequence)bean.lastLoginLocation);
                } else {
                    this.tvAddress.setText(R.string.profile_no_location);
                }
            } else {
                this.tvAddress.setText(R.string.profile_no_location);
            }
        }
        if (bean.ver == 0L || bean.sex == UserInfoKS.FEMALE) {
            this.tvAge.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%d", (Object[])new Object[]{DateUtils.getAge((String)(bean == null ? "" : bean.birthday))}));
            LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.tvAge, (Drawable)this.drawableFemale, null, null, null);
            this.tvAge.setBackgroundResource(R.drawable.bg_pink_corner);
            this.viewBg.setImageResource(R.drawable.ico_im_profile_card_female_bg);
        } else {
            this.tvAge.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%d", (Object[])new Object[]{DateUtils.getAge((String)bean.birthday)}));
            LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.tvAge, (Drawable)this.drawableMale, null, null, null);
            this.tvAge.setBackgroundResource(R.drawable.bg_blue_corner);
            this.viewBg.setImageResource(R.drawable.ico_im_profile_card_male_bg);
        }
    }

    private void getPhotos() {
        if (this.userInfoService == null) {
            return;
        }
        this.urlList = new ArrayList<String>();
        this.userInfoService.requestAlbum(this.mUid, new OnAlbumCallback(){

            public void onUISuccess(List<String> list, long uid) {
                if (uid == ChatProfileHolder.this.mUid) {
                    ChatProfileHolder.this.updateAvatarOvetlapStatus(list);
                    ChatProfileHolder.this.isGetphotos = true;
                    ChatProfileHolder.this.reportProfileCardShow();
                }
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
        this.userInfoService.getInstagramPhotos(this.mUid, new OnGetInsPhotosCallback(){

            public void onGetInsStatusSuccess(List<String> th, List<String> st) {
                ChatProfileHolder.this.updateAvatarOvetlapStatus(th);
                ChatProfileHolder.this.isgetInstagramPhotos = true;
                ChatProfileHolder.this.reportProfileCardShow();
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    private void updateAvatarOvetlapStatus(List<String> list) {
        if (list != null) {
            this.urlList.addAll(list);
        }
        if (this.urlList != null && !this.urlList.isEmpty()) {
            this.ivOverlap.setVisibility(0);
        } else {
            this.ivOverlap.setVisibility(8);
        }
    }

    private void handleHonor() {
        if (this.userInfoService == null) {
            return;
        }
        this.ivHonor.setVisibility(8);
        this.userInfoService.getLatestHonor(this.mUid, new OnGetLatestHonorCallback(){

            public void onLatestHonorSuccess(final HonorInfo honorInfo) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ChatProfileHolder.this.initHonor(honorInfo);
                        ChatProfileHolder.this.isGetHonrInfo = true;
                        ChatProfileHolder.this.mHonorInfo = honorInfo;
                        ChatProfileHolder.this.reportProfileCardShow();
                    }
                });
            }

            public void onLatestHonorError() {
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    private void reportProfileCardShow() {
        if (this.isGetHonrInfo && this.isGetphotos && this.isgetInstagramPhotos && this.isgetUserInfo && this.userInfo != null) {
            HiidoEvent event = HiidoEvent.obtain().eventId("20023799").put("function_id", "profile_card_show").put("act_photo_num", String.valueOf(FP.size(this.urlList) + 1)).put("act_uid", String.valueOf(this.userInfo.uid));
            if (this.mHonorInfo != null) {
                event.put("honor_id", String.valueOf(this.mHonorInfo.getId()));
            } else {
                event.put("honor_id", String.valueOf(0));
            }
            HiidoStatis.reportEvent((HiidoEvent)event);
            this.isgetUserInfo = false;
            this.isgetInstagramPhotos = false;
            this.isGetphotos = false;
            this.isGetHonrInfo = false;
        }
    }

    private void initHonor(HonorInfo honorInfo) {
        if (honorInfo == null) {
            this.ivHonor.setVisibility(8);
            ViewGroup.LayoutParams layoutParams2 = this.tvUserName.getLayoutParams();
            layoutParams2.width = -2;
            this.tvUserName.setLayoutParams(layoutParams2);
            return;
        }
        ViewGroup.LayoutParams layoutParams3 = this.tvUserName.getLayoutParams();
        layoutParams3.width = -1;
        this.tvUserName.setLayoutParams(layoutParams3);
        this.ivHonor.setVisibility(0);
        this.ivHonor.setTag((Object)honorInfo);
        this.ivHonor.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new HonorIntroPopupwindow(v.getContext()).showHonorPopup(v, ((HonorInfo)v.getTag()).getName(), ((HonorInfo)v.getTag()).getDesc());
            }
        });
        ImageLoader.loadImage((ImageView)this.ivHonor, (String)honorInfo.getSicon());
    }

    public void onClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData) {
            ChatMessageData chatMessageData = (ChatMessageData)v.getTag(R.id.chat_message_data);
            HiidoEvent event = HiidoEvent.obtain().eventId("20023799").put("function_id", "profile_card_click").put("act_uid", String.valueOf(chatMessageData.message.getUid()));
            if (this.urlList != null) {
                event.put("act_photo_num", String.valueOf(FP.size(this.urlList) + 1));
            }
            if (this.mHonorInfo != null) {
                event.put("honor_id", String.valueOf(this.mHonorInfo.getId()));
            } else {
                event.put("honor_id", String.valueOf(0));
            }
            HiidoStatis.reportEvent((HiidoEvent)event);
            if (this.getEventCallback() != null) {
                this.getEventCallback().onUserAvatarClick(chatMessageData.message.getUid(), 8);
            }
        }
    }
}

