/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.content.SharedPreferences;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.util.Pair;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.callback.Callback;
import com.yy.im.module.room.data.OfficialGamePushInfo;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collections;
import org.json.JSONException;
import org.json.JSONObject;

@DontProguardClass
public class ChatOfficialGamePushHolder
extends ChatBaseHolder {
    private static final String SHARE_PREF = "chat_office_game";
    private static final String GAME_PUSH_NOTIFY_ENABLE = "game_push_notify";
    private static final String GID_MORNING = "in_happay_wish";
    private RecycleImageView mTitleIcon;
    private YYTextView mTitleText;
    private RecycleImageView mContentImg;
    private YYTextView mContentText;
    private ChatMessageData mItemData;
    private OfficialGamePushInfo mGamePushInfo;
    private static final String TAG = "ChatOfficialGamePushHol";

    public ChatOfficialGamePushHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.initViews();
    }

    public static BaseItemBinder<ChatMessageData, ChatOfficialGamePushHolder> getBinder(final IMvpContext provider) {
        return new BaseItemBinder<ChatMessageData, ChatOfficialGamePushHolder>(){

            @NonNull
            protected ChatOfficialGamePushHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatOfficialGamePushHolder(inflater.inflate(R.layout.im_item_official_game_push, parent, false), provider);
            }
        };
    }

    public void initViews() {
        this.mTitleIcon = (RecycleImageView)this.itemView.findViewById(R.id.title_icon);
        this.mTitleText = (YYTextView)this.itemView.findViewById(R.id.title_text);
        this.mContentImg = (RecycleImageView)this.itemView.findViewById(R.id.content_img);
        this.mContentText = (YYTextView)this.itemView.findViewById(R.id.tv_content);
        View.OnClickListener onViewMoreListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (ChatOfficialGamePushHolder.this.mItemData != null && ChatOfficialGamePushHolder.this.getEventCallback() != null) {
                    ChatOfficialGamePushHolder.this.getEventCallback().onViewMoreClick(ChatOfficialGamePushHolder.this.mItemData, ChatOfficialGamePushHolder.this.getAdapterPosition(), (OfficialGamePushInfo)((ChatOfficialGamePushHolder)ChatOfficialGamePushHolder.this).mItemData.message.getExtObj());
                }
            }
        };
        this.mContentImg.setOnClickListener(onViewMoreListener);
        this.mContentText.setOnClickListener(onViewMoreListener);
        this.itemView.findViewById(R.id.tv_more).setOnClickListener(onViewMoreListener);
        this.itemView.findViewById(R.id.title_more).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatOfficialGamePushHolder.this.showPopup(v);
            }
        });
    }

    private void onToggleGamePush(String gid, boolean isShowNotify) {
        if (this.getEventCallback() != null && this.mItemData != null) {
            this.getEventCallback().onTitleMoreClick(gid, isShowNotify, new Callback<Pair<String, Boolean>>(){

                @Override
                public void onResponse(Pair<String, Boolean> data2) {
                    if (data2 != null && data2.second != null) {
                        ChatOfficialGamePushHolder.this.getPreference().edit().putBoolean(ChatOfficialGamePushHolder.GAME_PUSH_NOTIFY_ENABLE + (String)data2.first, ((Boolean)data2.second).booleanValue()).apply();
                        if (((Boolean)data2.second).booleanValue()) {
                            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.short_tips_opened_notification), (int)0);
                        } else {
                            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.short_tips_hided_notification), (int)0);
                        }
                    }
                }
            });
        }
    }

    private void showPopup(View anchorView) {
        boolean isShowNotify = this.getPreference().getBoolean(GAME_PUSH_NOTIFY_ENABLE + this.mGamePushInfo.gid, true);
        if (!StringUtils.equal((String)this.mGamePushInfo.gid, (String)GID_MORNING)) {
            this.showBottomPopup(isShowNotify, ResourceUtils.getString((int)(isShowNotify ? R.string.short_tips_im_hide_game_notify : R.string.short_tips_im_show_game_notify)));
        } else {
            this.showBottomPopup(isShowNotify, ResourceUtils.getString((int)(isShowNotify ? R.string.short_tips_im_hide_morning_notify : R.string.short_tips_im_show_morning_notify)));
        }
    }

    private void showBottomPopup(final boolean isShowNotify, String text) {
        final DialogLinkManager dialogLinkManager = new DialogLinkManager(this.getContext());
        ButtonItem bottomItem = new ButtonItem(text, new ButtonItem.OnClickListener(){

            public void onClick() {
                dialogLinkManager.dismissDialog();
                ChatOfficialGamePushHolder.this.onToggleGamePush(((OfficialGamePushInfo)((ChatOfficialGamePushHolder)ChatOfficialGamePushHolder.this).mItemData.message.getExtObj()).gid, isShowNotify);
            }
        });
        dialogLinkManager.showCommonPopupDialog(Collections.singletonList(bottomItem), true, true);
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        if (data2.message.getExtObj() instanceof OfficialGamePushInfo) {
            this.reportShowEvent(data2.message);
            this.mItemData = data2;
            this.mGamePushInfo = (OfficialGamePushInfo)data2.message.getExtObj();
            ImageLoader.loadImage((ImageView)this.mTitleIcon, (String)this.mGamePushInfo.contentImageUrl);
            this.mTitleText.setText((CharSequence)this.mGamePushInfo.title);
            ImageLoader.loadImage((ImageView)this.mContentImg, (String)this.mGamePushInfo.contentImageUrl);
            this.mContentText.setText((CharSequence)this.mGamePushInfo.content);
        }
    }

    private void reportShowEvent(final ImMessageDBBean messageDBBean) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject payloadJson = JsonParser.obtainJSONObject((String)messageDBBean.getReserve3());
                    String gameId = payloadJson.optString("gameId");
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028013").put("function_id", "9").put("gid", gameId).put("act_uid", String.valueOf(messageDBBean.getUid())));
                }
                catch (JSONException e) {
                    MLog.error((Object)ChatOfficialGamePushHolder.TAG, (Throwable)e);
                }
            }
        });
    }

    private SharedPreferences getPreference() {
        return SharedPreferencesUtils.INSTANCE.getSharedPreferences(this.getContext(), SHARE_PREF, 0);
    }

    public static interface OnChatOfficialGameListener {
        public void onViewMoreClick(ChatMessageData var1, int var2, OfficialGamePushInfo var3);

        public void onTitleMoreClick(String var1, boolean var2, Callback<Pair<String, Boolean>> var3);
    }
}

