/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatCommonTxtPicMessageBaseHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class ChatCommonTxtPicReceivedHolder
extends ChatCommonTxtPicMessageBaseHolder {
    private HeadFrameImageView ivAvatar;
    private RecycleImageView ivIcon;
    private ChatMessageData msgData;
    private static final int SOURCE_RECALL = 99;
    private Runnable mReportRunnable = () -> {
        if (this.msgData != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "recall_im_read").put("id", String.valueOf(this.msgData.message.id)));
        }
    };

    public ChatCommonTxtPicReceivedHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.ivIcon = (RecycleImageView)itemView.findViewById(R.id.iv_icon);
        itemView.findViewById(R.id.content).setBackgroundResource(ImResourceManager.INSTANCE.getImOtherBackground());
    }

    public static BaseItemBinder<ChatMessageData, ChatCommonTxtPicReceivedHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatCommonTxtPicReceivedHolder>(){

            @NonNull
            protected ChatCommonTxtPicReceivedHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatCommonTxtPicReceivedHolder(inflater.inflate(R.layout.im_common_txt_pic_received_item, parent, false), context);
            }
        };
    }

    public void onViewShow() {
        super.onViewShow();
        if (this.msgData == null || this.msgData.message == null || this.msgData.message.getSource() != 99) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)this.mReportRunnable, (long)500L);
    }

    public void onViewHide() {
        super.onViewHide();
        if (this.msgData == null || this.msgData.message == null || this.msgData.message.getSource() != 99) {
            return;
        }
        YYTaskExecutor.removeTask((Runnable)this.mReportRunnable);
    }

    @Override
    public void setData(ChatMessageData data2) {
        super.setData(data2);
        this.msgData = data2;
        UserInfoKS bean = this.getUserInfo(data2.message.getUid());
        this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), bean);
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        this.ivIcon.setOnClickListener(v -> {
            this.onClick(v);
            if (this.msgData != null && this.msgData.message != null && this.msgData.message.getSource() == 99) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "recall_im_click").put("id", String.valueOf(this.msgData.message.id)));
            }
        });
        HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
        if (otherHeadFrameType != null) {
            Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }
}

