/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.im.R;
import com.yy.im.module.room.data.EmojiTypeData;
import com.yy.im.module.room.data.InteractiveEmojiTypeHelper;
import java.util.ArrayDeque;
import java.util.Queue;

public enum InteractiveEmojiViewManager {
    INSTANCE;

    private static final String TAG = "EmojiViewManager";
    private View mInteractiveEmojiView;
    private SVGAImageView svgaImageView;
    private Queue<EmojiTypeData> mDataList = new ArrayDeque<EmojiTypeData>(1);
    private ViewGroup mRootView;
    private Producer mProducer = new Producer(this.mDataList);
    private Consumer mConsumer = new Consumer(this.mDataList);

    private InteractiveEmojiViewManager() {
        this.mConsumer.setBeginTask(new Runnable(){

            @Override
            public void run() {
                InteractiveEmojiViewManager.this.removeEmojiView();
                EmojiTypeData consumeData = InteractiveEmojiViewManager.this.mConsumer.getCurrentData();
                if (consumeData != null) {
                    InteractiveEmojiViewManager.this.requestSvga(consumeData);
                }
            }
        });
        this.mConsumer.setAllEndTask(new Runnable(){

            @Override
            public void run() {
                InteractiveEmojiViewManager.this.removeEmojiView();
            }
        });
    }

    private void removeEmojiView() {
        if (this.mInteractiveEmojiView != null && this.mInteractiveEmojiView.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.mInteractiveEmojiView.getParent()).removeView(this.mInteractiveEmojiView);
        }
    }

    public void showView(ViewGroup rootView, EmojiTypeData data2) {
        if (data2 != null && rootView != null) {
            this.mProducer.product(data2);
            this.mRootView = rootView;
            this.addInteractiveEmojiView(this.mRootView);
            if (this.mConsumer != null) {
                this.mConsumer.beginConsume();
            }
        }
    }

    private void requestSvga(EmojiTypeData data2) {
        DResource resource = InteractiveEmojiTypeHelper.getImInteractiveFullSvga(data2);
        if (resource != null && this.svgaImageView != null) {
            DyResLoader.INSTANCE.loadSvga(this.svgaImageView, resource, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity entity) {
                    if (InteractiveEmojiViewManager.this.svgaImageView != null && InteractiveEmojiViewManager.this.mRootView != null) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (InteractiveEmojiViewManager.this.mInteractiveEmojiView != null && InteractiveEmojiViewManager.this.mInteractiveEmojiView.getParent() != null && InteractiveEmojiViewManager.this.mInteractiveEmojiView.getParent() instanceof ViewGroup) {
                                    ((ViewGroup)InteractiveEmojiViewManager.this.mInteractiveEmojiView.getParent()).removeView(InteractiveEmojiViewManager.this.mInteractiveEmojiView);
                                }
                                if (InteractiveEmojiViewManager.this.mRootView != null && InteractiveEmojiViewManager.this.mInteractiveEmojiView != null && InteractiveEmojiViewManager.this.svgaImageView != null) {
                                    InteractiveEmojiViewManager.this.mRootView.addView(InteractiveEmojiViewManager.this.mInteractiveEmojiView);
                                    InteractiveEmojiViewManager.this.svgaImageView.startAnimation();
                                }
                            }
                        });
                    } else if (InteractiveEmojiViewManager.this.mConsumer != null) {
                        InteractiveEmojiViewManager.this.mConsumer.endConsume();
                    }
                }

                public void onFailed(Exception e) {
                    if (InteractiveEmojiViewManager.this.mConsumer != null) {
                        InteractiveEmojiViewManager.this.mConsumer.endConsume();
                    }
                }
            });
        }
    }

    private void addInteractiveEmojiView(ViewGroup mRootView) {
        if (this.mInteractiveEmojiView == null || this.svgaImageView == null) {
            this.mInteractiveEmojiView = LayoutInflater.from((Context)mRootView.getContext()).inflate(R.layout.im_interactive_emoji_full, null, false);
            this.mInteractiveEmojiView.setVisibility(0);
            this.mInteractiveEmojiView.setClickable(true);
            this.svgaImageView = (SVGAImageView)this.mInteractiveEmojiView.findViewById(R.id.svga_iv);
            this.svgaImageView.setCallback(new SVGACallback(){

                public void onPause() {
                }

                public void onFinished() {
                    if (InteractiveEmojiViewManager.this.mConsumer != null) {
                        InteractiveEmojiViewManager.this.mConsumer.endConsume();
                    }
                }

                public void onRepeat() {
                }

                public void onStep(int i, double v) {
                }
            });
        }
    }

    public void release() {
        this.mRootView = null;
        this.svgaImageView = null;
        this.mInteractiveEmojiView = null;
    }

    private class Consumer {
        private Queue<EmojiTypeData> mList;
        private EmojiTypeData mCurrentData;
        private Runnable mEndTask;
        private Runnable mBeginTask;

        Consumer(Queue<EmojiTypeData> list) {
            this.mList = list;
        }

        private void beginConsume() {
            MLog.info((Object)InteractiveEmojiViewManager.TAG, (String)"beginConsume isRunning %b", (Object[])new Object[]{this.mCurrentData != null});
            if (this.mCurrentData == null) {
                this.mCurrentData = this.mList.poll();
                MLog.info((Object)InteractiveEmojiViewManager.TAG, (String)"beginConsume poll %s", (Object[])new Object[]{this.mCurrentData});
                if (this.mCurrentData != null && this.mBeginTask != null) {
                    this.mBeginTask.run();
                }
            }
            if (this.mCurrentData == null) {
                this.endConsume();
            }
        }

        private void endConsume() {
            MLog.info((Object)InteractiveEmojiViewManager.TAG, (String)"endConsume %s", (Object[])new Object[]{this.mCurrentData});
            this.mCurrentData = null;
            if (FP.empty(this.mList) && this.mEndTask != null) {
                this.mEndTask.run();
            } else {
                this.next();
            }
        }

        private void next() {
            this.beginConsume();
        }

        @Nullable
        public EmojiTypeData getCurrentData() {
            return this.mCurrentData;
        }

        public void setAllEndTask(Runnable endTask) {
            this.mEndTask = endTask;
        }

        public void setBeginTask(Runnable beginTask) {
            this.mBeginTask = beginTask;
        }
    }

    private class Producer {
        private Queue<EmojiTypeData> mList;

        Producer(Queue<EmojiTypeData> list) {
            this.mList = list;
        }

        public void product(EmojiTypeData data2) {
            MLog.info((Object)InteractiveEmojiViewManager.TAG, (String)"product %s", (Object[])new Object[]{data2});
            this.mList.add(data2);
        }
    }
}

