/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import androidx.annotation.Nullable;
import androidx.databinding.BaseObservable;
import androidx.databinding.Bindable;
import com.yy.appbase.R;
import com.yy.appbase.data.ChatSessionDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.base.IChatSession;
import com.yy.im.BR;
import com.yy.im.R;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.ui.adapter.IViewType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ChatSession<LastMessage>
extends BaseObservable
implements IChatSession,
IViewType {
    private ChatSessionDBBean mDBBean;
    public static Map<Integer, Class> mMsgClz = new HashMap<Integer, Class>();
    public static Map<Integer, Class> mSessionClz = new HashMap<Integer, Class>();
    private int mSessionType;
    private String mSessionId;
    private String mTitle;
    private CharSequence subTitle = "";
    private CharSequence unreadText = "";
    private int unReadCounts;
    private long timeStr;
    private long canShowDuring;
    private long expiredTime = -1L;
    private LastMessage mLastMessage;
    private List<String> mAvatarUrls = new ArrayList<String>();
    private int mDefaultAvatar = R.drawable.icon_avatar_default_female;
    private String avatarUrl;
    private boolean isValid = true;
    private long uid;
    private String sessionFrom;
    protected UserInfoKS userInfo;
    private String distance;
    private String offlineTime;
    private int unReadType = 0;
    private boolean titleBold = false;
    private int bgColor;
    private boolean showIgnore = false;
    private int avatarType = 0;
    private int smallIcon;
    private boolean needShoWUpdate;
    private boolean needShowDefault;
    private boolean needShowFamily;
    private boolean removeSelected = false;
    private boolean isFirstShow = true;
    private boolean isStickTop;
    private boolean fromDiscoveryPage;
    private String channelCover = "";
    private int channelPluginMode;
    @Nullable
    private String gameLabel;
    private UserOnlineDBBean userOnlineDBBean;
    @IChatSession.PresentWeight
    private int presentWeight = 0;
    private long presentationTime;
    private boolean msgNotExposed;
    private boolean notArchiveInStrangerSessionContainer;

    public ChatSession(int mSessionType, LastMessage mLastMessage) {
        this.mSessionType = mSessionType;
        this.mLastMessage = mLastMessage;
        if (mLastMessage instanceof ImMessageDBBean) {
            this.setFromDiscoveryPage(((ImMessageDBBean)mLastMessage).getFromDiscoveryPage());
        }
        this.initial();
    }

    public static void installClazz(SessionClzConfig clzConfig) {
        if (clzConfig != null) {
            mSessionClz.put(clzConfig.getSessionType(), clzConfig.getSessionClass());
            mMsgClz.put(clzConfig.getSessionType(), clzConfig.getMsgClass());
        }
    }

    public static ChatSession generateWithDBModel(ChatSessionDBBean model2) {
        ChatSession session;
        block6: {
            session = null;
            try {
                int sessionType = model2.getSessionType();
                long uid = model2.getUid();
                if (uid == 10L && sessionType != 3) {
                    sessionType = 3;
                }
                String msg = model2.getLastMsg();
                Class clz = mMsgClz.get(sessionType);
                Object lastMsg = JsonParser.parseJsonObject((String)msg, (Class)clz);
                Class sessionClz = mSessionClz.get(sessionType);
                Constructor constructor = sessionClz.getConstructor(mMsgClz.get(sessionType));
                session = (ChatSession)constructor.newInstance(lastMsg);
                session.setUnReadCounts(model2.getUnReadCount());
                session.sessionFrom = model2.getExtend();
                session.setUnReadType(model2.getUnReadType());
                session.isFirstShow = model2.getIsFirstShow();
                session.expiredTime = model2.getExpiredTime();
                session.isStickTop = model2.isStickTop();
                int presentWeight = model2.getPresentWeight();
                if (presentWeight != 0 && presentWeight != 3 && presentWeight != 1 && presentWeight != 5) {
                    presentWeight = 0;
                }
                if (session.isStickTop && presentWeight < 5) {
                    presentWeight = 5;
                }
                session.presentWeight = presentWeight;
                long presentationTime = model2.getPresentationTime();
                if (presentationTime == 0L) {
                    presentationTime = model2.getTimestamp();
                }
                session.presentationTime = presentationTime;
                session.setMsgNotExposed(model2.isMsgNotExposed());
                session.setNotArchiveInStrangerSessionContainer(model2.isNotArchiveInStrangerSessionContainer());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (session == null) break block6;
                session.setValid(false);
            }
        }
        return session;
    }

    public abstract void initial();

    public void update(LastMessage msg) {
        this.mLastMessage = msg;
        if (msg instanceof ImMessageDBBean) {
            this.setFromDiscoveryPage(((ImMessageDBBean)msg).getFromDiscoveryPage());
        }
        this.initial();
    }

    public ChatSessionDBBean getDBBean() {
        if (this.mDBBean == null) {
            this.mDBBean = new ChatSessionDBBean();
        }
        String lastMsg = "";
        try {
            if (this.mLastMessage != null) {
                lastMsg = JsonParser.toJson(this.mLastMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mDBBean.setSessionId(this.mSessionId);
        this.mDBBean.setLastMsg(lastMsg);
        this.mDBBean.setSessionType(this.mSessionType);
        this.mDBBean.setUnReadCount(this.unReadCounts);
        this.mDBBean.setTimestamp(this.timeStr);
        this.mDBBean.setUid(this.uid);
        this.mDBBean.setExtend(this.sessionFrom);
        this.mDBBean.setUnReadType(this.unReadType);
        this.mDBBean.setExpiredTime(this.expiredTime);
        this.mDBBean.setIsFirstShow(this.isFirstShow);
        this.mDBBean.setStickTop(this.isStickTop);
        this.mDBBean.setPresentWeight(this.presentWeight);
        this.mDBBean.setPresentationTime(this.presentationTime);
        this.mDBBean.setMsgNotExposed(this.msgNotExposed);
        this.mDBBean.setNotArchiveInStrangerSessionContainer(this.notArchiveInStrangerSessionContainer);
        return this.mDBBean;
    }

    @Bindable
    public int getSessionType() {
        return this.mSessionType;
    }

    @Bindable
    public String getSessionId() {
        return this.mSessionId;
    }

    @Bindable
    public String getTitle() {
        return this.mTitle;
    }

    @Bindable
    public CharSequence getSubTitle() {
        return this.subTitle;
    }

    @Bindable
    public CharSequence getUnreadText() {
        return this.unreadText;
    }

    @Bindable
    public int getUnReadCounts() {
        return this.unReadCounts;
    }

    @Bindable
    public long getTimeStr() {
        return this.timeStr;
    }

    @Bindable
    public long getCanShowDuring() {
        return this.canShowDuring;
    }

    @Bindable
    public long getExpiredTime() {
        return this.expiredTime;
    }

    @Bindable
    public LastMessage getLastMessage() {
        return this.mLastMessage;
    }

    @Bindable
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @Bindable
    public int getUnReadType() {
        return this.unReadType;
    }

    @Bindable
    public boolean getNeedShoWUpdate() {
        return this.needShoWUpdate;
    }

    @Bindable
    public boolean getNeedShowFamily() {
        return this.needShowFamily;
    }

    public void setNeedShoWUpdate(boolean needShoWUpdate) {
        this.needShoWUpdate = needShoWUpdate;
        this.notifyPropertyChanged(BR.needShoWUpdate);
    }

    public void setNeedShowFamily(boolean needShowFamily) {
        this.needShowFamily = needShowFamily;
        this.notifyPropertyChanged(BR.needShowFamily);
    }

    @Bindable
    public boolean getNeedShowDefault() {
        return this.needShowDefault;
    }

    public void setNeedShowDefault(boolean needShowDefault) {
        this.needShowDefault = needShowDefault;
        this.notifyPropertyChanged(BR.needShowDefault);
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        this.notifyPropertyChanged(BR.avatarUrl);
    }

    public void setSessionId(String mSessionId) {
        this.mSessionId = mSessionId;
    }

    public void setTitle(String mTitle) {
        this.mTitle = mTitle;
        this.notifyPropertyChanged(BR.title);
    }

    public void setSubTitle(CharSequence subTitle) {
        this.subTitle = subTitle;
        this.notifyPropertyChanged(BR.subTitle);
    }

    public void setUnReadCounts(int unReadCounts) {
        MLog.info((Object)"ChatSession", (String)"ChannelEntranceSession setUnReadCounts :%d, %s", (Object[])new Object[]{unReadCounts, this.getSessionId()});
        this.unReadCounts = unReadCounts;
        this.unreadText = ResourceUtils.getString((int)R.string.title_session_unread_txt, (Object[])new Object[]{unReadCounts});
        this.notifyPropertyChanged(BR.unReadCounts);
        this.notifyPropertyChanged(BR.unreadText);
    }

    public void setTimeStr(long timeStr) {
        this.timeStr = timeStr;
        this.notifyPropertyChanged(BR.timeStr);
    }

    public void setCanShowDuring(long canShowDuring) {
        this.canShowDuring = canShowDuring;
        this.notifyPropertyChanged(BR.canShowDuring);
    }

    public void setExpiredTime(long expiredTime) {
        this.expiredTime = expiredTime;
        this.notifyPropertyChanged(BR.expiredTime);
    }

    @Bindable
    public List<String> getAvatarUrls() {
        return this.mAvatarUrls;
    }

    public void setAvatarUrls(List<String> mAvatarUrls) {
        if (!FP.empty(mAvatarUrls)) {
            this.mAvatarUrls = mAvatarUrls;
        }
        this.notifyPropertyChanged(BR.avatarUrls);
    }

    @Bindable
    public int getDefaultAvatar() {
        return this.mDefaultAvatar;
    }

    public void setDefaultAvatar(int mDefaultAvatar) {
        if (mDefaultAvatar != 0) {
            this.mDefaultAvatar = mDefaultAvatar;
        }
        this.notifyPropertyChanged(BR.defaultAvatar);
    }

    public void setUnReadType(int unreadType) {
        this.unReadType = unreadType;
        this.notifyPropertyChanged(BR.unReadType);
    }

    @Bindable
    public boolean getTitleBold() {
        return this.titleBold;
    }

    public void setTitleBold(boolean titleBold) {
        this.titleBold = titleBold;
        this.notifyPropertyChanged(BR.titleBold);
    }

    @Bindable
    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
        this.notifyPropertyChanged(BR.bgColor);
    }

    @Bindable
    public boolean getShowIgnore() {
        return this.showIgnore;
    }

    public void setShowIgnore(boolean showIgnore) {
        this.showIgnore = showIgnore;
        this.notifyPropertyChanged(BR.showIgnore);
    }

    @Bindable
    public int getAvatarType() {
        return this.avatarType;
    }

    public void setAvatarType(int avatarType) {
        this.avatarType = avatarType;
        this.notifyPropertyChanged(BR.avatarType);
    }

    @Bindable
    public int getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(int smallIcon) {
        this.smallIcon = smallIcon;
        this.notifyPropertyChanged(BR.smallIcon);
    }

    @Override
    public int getListViewType() {
        return 0;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public String getSessionFrom() {
        return this.sessionFrom;
    }

    public void setSessionFrom(String sessionFrom) {
        this.sessionFrom = sessionFrom;
    }

    public boolean isStrangerChat() {
        return "1".equals(this.sessionFrom);
    }

    public UserInfoKS getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoKS userInfo) {
        this.userInfo = userInfo;
    }

    public String getChannelCover() {
        return this.channelCover == null ? "" : this.channelCover;
    }

    public void setChannelCover(String channelCover) {
        this.channelCover = channelCover;
    }

    public int getChannelPluginMode() {
        return this.channelPluginMode;
    }

    public void setChannelPluginMode(int channelPluginMode) {
        this.channelPluginMode = channelPluginMode;
    }

    public void unbind() {
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.expiredTime > 0L && this.expiredTime > 0L;
    }

    public void setRemoveSelected(boolean selected) {
        this.removeSelected = selected;
        this.notifyPropertyChanged(BR.removeSelected);
    }

    @Bindable
    public boolean getRemoveSelected() {
        return this.removeSelected;
    }

    @Bindable
    public boolean getIsNew() {
        return this.isFirstShow;
    }

    public void setIsNew(boolean isNew) {
        this.isFirstShow = isNew;
        this.notifyPropertyChanged(BR.isNew);
    }

    public boolean isStickTop() {
        return this.isStickTop;
    }

    public void setStickTop(boolean stickTop) {
        this.isStickTop = stickTop;
    }

    @Bindable
    @IChatSession.PresentWeight
    public int getPresentWeight() {
        return this.presentWeight;
    }

    public void setPresentWeight(int presentWeight) {
        this.presentWeight = presentWeight;
        this.notifyPropertyChanged(BR.presentWeight);
    }

    @Bindable
    public long getPresentationTime() {
        return this.presentationTime;
    }

    public void setPresentationTime(long presentationTime) {
        if (presentationTime <= this.presentationTime) {
            return;
        }
        this.presentationTime = presentationTime;
        this.notifyPropertyChanged(BR.presentationTime);
    }

    public boolean isMsgNotExposed() {
        return this.msgNotExposed;
    }

    public void setMsgNotExposed(boolean msgNotExposed) {
        this.msgNotExposed = msgNotExposed;
    }

    @Bindable
    public boolean getFromDiscoveryPage() {
        return this.fromDiscoveryPage;
    }

    public void setFromDiscoveryPage(boolean fromDiscoveryPage) {
        this.fromDiscoveryPage = fromDiscoveryPage;
        this.notifyPropertyChanged(BR.fromDiscoveryPage);
    }

    @Bindable
    public String getDistance() {
        return this.distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
        this.notifyPropertyChanged(BR.distance);
    }

    @Bindable
    public String getOfflineTime() {
        return this.offlineTime;
    }

    public void setOfflineTime(String offlineTime) {
        this.offlineTime = offlineTime;
        this.notifyPropertyChanged(BR.offlineTime);
    }

    @Bindable
    @Nullable
    public String getGameLabel() {
        return this.gameLabel;
    }

    public void setGameLabel(@Nullable String gameLabel) {
        this.gameLabel = gameLabel;
        this.notifyPropertyChanged(BR.gameLabel);
    }

    @Bindable
    public UserOnlineDBBean getUserOnlineDBBean() {
        return this.userOnlineDBBean;
    }

    public void setUserOnlineDBBean(UserOnlineDBBean userOnlineDBBean) {
        this.userOnlineDBBean = userOnlineDBBean;
    }

    public boolean isNotArchiveInStrangerSessionContainer() {
        return this.notArchiveInStrangerSessionContainer;
    }

    public void setNotArchiveInStrangerSessionContainer(boolean notArchiveInStrangerSessionContainer) {
        this.notArchiveInStrangerSessionContainer = notArchiveInStrangerSessionContainer;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionType {
    }
}

