/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.guide;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.view.View;
import androidx.annotation.NonNull;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.relation.base.IBooleanCallback;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import net.ihago.room.srv.follow.EPath;

public class FriendGuidePresenter {
    private static final String TAG = "FriendGuidePresenter";
    private IFriendGuideClickListener mListener;
    private ImMessageDBBean mMessageDBBean;
    private long targetUid = 0L;
    private String mContent = "";

    public void setOnClickListener(IFriendGuideClickListener listener) {
        this.mListener = listener;
    }

    public ChatMessageData createMessage(ImMessageDBBean messageDBBean, final long targetUid) {
        this.targetUid = targetUid;
        if (!this.checkValid(messageDBBean)) {
            MLog.info((Object)TAG, (String)"createMessage invalid:%s", (Object[])new Object[]{messageDBBean});
            return null;
        }
        if (targetUid <= 0L) {
            MLog.info((Object)TAG, (String)"createMessage uid null", (Object[])new Object[0]);
            return null;
        }
        RelationInfo info = ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).getRelationLocal(messageDBBean.getUid());
        if (info.isFriend()) {
            MLog.info((Object)TAG, (String)"createMessage is friend:%s", (Object[])new Object[]{messageDBBean.getUid()});
            return null;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "add_friend_guide_receive").put("act_id", String.valueOf(targetUid)));
        String contentStr = messageDBBean.getContent();
        this.mMessageDBBean = messageDBBean;
        this.mContent = contentStr;
        String clickStr = ResourceUtils.getString((int)R.string.tips_friend_guide_add);
        ClickableSpan span = new ClickableSpan(){
            private long mTargetUid;
            {
                this.mTargetUid = targetUid;
            }

            public void onClick(@NonNull View widget) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "add_friend_guide_click").put("act_id", String.valueOf(this.mTargetUid)));
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.send_request_failed), (int)0);
                    return;
                }
                RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationLocal(this.mTargetUid);
                ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).requestFollow(relationInfo, EPath.PATH_OLD_FRIENDS.getValue(), (ICommonCallback)new IBooleanCallback(){

                    public void onResult(boolean success) {
                        FriendGuidePresenter.this.onFollowResult(success);
                    }
                });
                FriendGuidePresenter.this.reportImOldAddFriends();
            }

            public void updateDrawState(@NonNull TextPaint ds) {
                super.updateDrawState(ds);
                FriendGuidePresenter.this.setDrawState(ds);
            }
        };
        String content = contentStr + " [image] " + clickStr;
        SpannableString spannableString = new SpannableString((CharSequence)content);
        int imageIndex = content.indexOf("[image]");
        Drawable drawable2 = ResourceUtils.getDrawable((int)R.drawable.icon_friend_guide_add);
        drawable2.setBounds(0, 0, ResolutionUtils.dip2Px((float)10.0f), ResolutionUtils.dip2Px((float)10.0f));
        ImageSpan imageSpan = new ImageSpan(drawable2, 1);
        spannableString.setSpan((Object)imageSpan, imageIndex, imageIndex + "[image]".length(), 18);
        int start = content.indexOf(clickStr);
        if (start > -1 && span != null) {
            spannableString.setSpan((Object)span, start, start + clickStr.length(), 33);
        }
        messageDBBean.setSpannableString(spannableString);
        ChatMessageData msg = new ChatMessageData();
        msg.message = messageDBBean;
        return msg;
    }

    private void reportImOldAddFriends() {
        ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("add_friend"));
    }

    private void onFollowResult(boolean isSuccess) {
        if (isSuccess) {
            if (this.mMessageDBBean == null) {
                return;
            }
            String responseStr = ResourceUtils.getString((int)R.string.tips_friend_guide_added);
            String content = this.mContent + " " + responseStr;
            SpannableString spannableString = new SpannableString((CharSequence)content);
            int start = content.indexOf(responseStr);
            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(Color.parseColor((String)"#999999"));
            if (start > -1) {
                spannableString.setSpan((Object)foregroundColorSpan, start, start + responseStr.length(), 33);
            }
            this.mMessageDBBean.setSpannableString(spannableString);
            if (this.mListener != null) {
                this.mListener.onClick(this.mMessageDBBean);
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023803").put("function_id", "1").put("ent_id", "18").put("act_uid", String.valueOf(this.targetUid)));
        }
    }

    private boolean checkValid(ImMessageDBBean messageDBBean) {
        return messageDBBean != null && messageDBBean.getMsgType() == 40 && !TextUtils.isEmpty((CharSequence)messageDBBean.getContent());
    }

    private void setDrawState(TextPaint ds) {
        ds.setColor(Color.parseColor((String)"#42a4ff"));
        ds.setUnderlineText(true);
    }

    public static interface IFriendGuideClickListener {
        public void onClick(ImMessageDBBean var1);
    }
}

