/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.findfriend.v1;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Typeface;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.ui.HiddenAnimUtils;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.im.DR;
import com.yy.im.R;
import com.yy.im.findfriend.v1.bean.AdContainerItem;
import com.yy.im.findfriend.v1.bean.ChannelItem;
import com.yy.im.findfriend.v1.bean.ChannelListComponentItem;
import com.yy.im.findfriend.v1.bean.ChannelListData;
import com.yy.im.findfriend.v1.bean.CreateGroupItem;
import com.yy.im.findfriend.v1.bean.FindFriendItem;
import com.yy.im.findfriend.v1.bean.FriendData;
import com.yy.im.findfriend.v1.bean.FriendItem;
import com.yy.im.findfriend.v1.bean.GameFaceItem;
import com.yy.im.findfriend.v1.bean.Guide;
import com.yy.im.findfriend.v1.bean.GuideItem;
import com.yy.im.findfriend.v1.bean.InviteFriendItem;
import com.yy.im.findfriend.v1.bean.PermissionData;
import com.yy.im.findfriend.v1.bean.PermissionItem;
import com.yy.im.findfriend.v1.bean.SearchFriendItem;
import com.yy.im.findfriend.v1.bean.TitleContent;
import com.yy.im.findfriend.v1.bean.TitleContentItem;
import com.yy.im.findfriend.v1.bean.callback.IFindFriendCallback;
import com.yy.im.findfriend.v1.ui.FindChannelAdapter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FindFriendsAdapter
extends RecyclerView.Adapter<VH> {
    private IFindFriendCallback mCallBack;
    private List<FindFriendItem> mDatas = new ArrayList<FindFriendItem>();

    public FindFriendsAdapter(IFindFriendCallback mCallBack) {
        this.mCallBack = mCallBack;
    }

    public void setDatas(List<FindFriendItem> datas) {
        this.mDatas.clear();
        if (datas != null && !datas.isEmpty()) {
            this.mDatas.addAll(datas);
        }
        this.notifyDataSetChanged();
    }

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 9) {
            return new GameFaceVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_friend_common, parent, false)){

                @Override
                public void onClicked() {
                    FindFriendsAdapter.this.mCallBack.onGameFaceClick();
                }
            };
        }
        if (viewType == 10) {
            return new CreateGroupVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_friend_common, parent, false)){

                @Override
                public void onClicked() {
                    FindFriendsAdapter.this.mCallBack.onCreateGroupClick();
                }
            };
        }
        if (viewType == 6) {
            return new SearchFriendVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_search, parent, false)){

                @Override
                public void onSearchBoxClicked() {
                    FindFriendsAdapter.this.mCallBack.onSearchClick();
                }
            };
        }
        if (viewType == 7) {
            return new FindChannelVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_channel_component, parent, false)){

                @Override
                public void onItemClicked(int position, ChannelItem channelItem) {
                    FindFriendsAdapter.this.mCallBack.onFindChannelClick(channelItem);
                }
            };
        }
        if (viewType == 1) {
            return new TitleContentVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_tips, parent, false));
        }
        if (viewType == 3) {
            return new FriendVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_friend, parent, false)){

                @Override
                public void onFriendItemClick(FriendData data2, int position) {
                    if (FindFriendsAdapter.this.mCallBack != null) {
                        FindFriendsAdapter.this.mCallBack.onFriendItemClick(data2, position);
                    }
                }

                @Override
                public void onAvatarClick(FriendData data2, int position) {
                    if (FindFriendsAdapter.this.mCallBack != null) {
                        FindFriendsAdapter.this.mCallBack.onAvatarClick(data2, position);
                    }
                }

                @Override
                public void onPlayClick(FriendData data2, int position) {
                    if (FindFriendsAdapter.this.mCallBack != null) {
                        FindFriendsAdapter.this.mCallBack.onPlayClick(data2, position);
                    }
                }
            };
        }
        if (viewType == 2) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_invite, parent, false);
            List<BaseShareChannel> shareChannels = this.mCallBack == null ? null : this.mCallBack.getChannels();
            return new InviteVH(view, shareChannels){

                @Override
                public void onBubbleContentClick(YYLinearLayout bubbleContainer, YYTextView bubbleContent, SVGAImageView faceStart, List<View> shareBoxIcons, DResource faceUrl, DResource faceSmilingUrl) {
                    FindFriendsAdapter.this.updateIsGuideOpen(bubbleContainer);
                    super.onBubbleContentClick(bubbleContainer, bubbleContent, faceStart, shareBoxIcons, faceUrl, faceSmilingUrl);
                }

                @Override
                public void onFaceClick(YYLinearLayout bubbleContainer, YYTextView bubbleContent, SVGAImageView faceStart, List<View> shareBoxIcons, DResource faceUrl, DResource faceSmilingUrl) {
                    FindFriendsAdapter.this.updateIsGuideOpen(bubbleContainer);
                    super.onFaceClick(bubbleContainer, bubbleContent, faceStart, shareBoxIcons, faceUrl, faceSmilingUrl);
                }

                public void onClick(View v) {
                    int id2 = v.getId();
                    int shareChannelId = ShareChannelIdDef.getChannelIdByViewId((int)id2);
                    if (shareChannelId != -1) {
                        FindFriendsAdapter.this.mCallBack.onShareInviteClick(shareChannelId);
                    }
                }
            };
        }
        if (viewType == 4) {
            return new GuideVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_guide, parent, false)){

                @Override
                public void onFuncClick(Guide current, int position) {
                    if (FindFriendsAdapter.this.mCallBack != null) {
                        FindFriendsAdapter.this.mCallBack.onFuncClick(current, position);
                    }
                }
            };
        }
        if (viewType == 5) {
            return new FuncVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_func, parent, false)){

                @Override
                public void onFuncClick(PermissionData permissionData, int position) {
                    if (FindFriendsAdapter.this.mCallBack != null) {
                        FindFriendsAdapter.this.mCallBack.onFuncClick(permissionData, position);
                    }
                }
            };
        }
        if (viewType == 8) {
            return new AdVH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_ad, parent, false)){

                @Override
                public void update(ViewGroup adContainerParent, ViewGroup adContainer) {
                    if (FindFriendsAdapter.this.mCallBack != null) {
                        FindFriendsAdapter.this.mCallBack.loadAd(adContainerParent, adContainer);
                    }
                }
            };
        }
        return null;
    }

    private void updateIsGuideOpen(YYLinearLayout bubbleContainer) {
        if (0 == bubbleContainer.getVisibility()) {
            this.mCallBack.updateIsGuideOpen(false);
        } else {
            this.mCallBack.updateIsGuideOpen(true);
        }
    }

    public void onViewDetachedFromWindow(@NonNull VH holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        if (holder instanceof FriendVH) {
            ((FriendVH)holder).onViewDetachedFromWindow();
        }
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        holder.update(this.mDatas.get(position), position);
    }

    public int getItemViewType(int position) {
        return this.mDatas.get(position).type();
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    public static abstract class VH<Data extends FindFriendItem>
    extends RecyclerView.ViewHolder {
        public VH(View itemView) {
            super(itemView);
        }

        public abstract void update(Data var1, int var2);
    }

    private static abstract class AdVH
    extends VH<AdContainerItem> {
        private LinearLayout adContainerParent;
        private RelativeLayout adContainer;

        public AdVH(View itemView) {
            super(itemView);
            this.adContainerParent = (LinearLayout)itemView.findViewById(R.id.friend_ad_container_parent);
            this.adContainer = (RelativeLayout)itemView.findViewById(R.id.friend_ad_container);
        }

        @Override
        public void update(AdContainerItem adContainerItem, int position) {
            this.update((ViewGroup)this.adContainerParent, (ViewGroup)this.adContainer);
        }

        public abstract void update(ViewGroup var1, ViewGroup var2);
    }

    private static abstract class FuncVH
    extends VH<PermissionItem> {
        private CircleImageView ivIcon;
        private YYTextView tvTitle;
        private YYTextView tvContent;
        private YYTextView tvFunc;

        public FuncVH(View itemView) {
            super(itemView);
            this.ivIcon = (CircleImageView)itemView.findViewById(R.id.iv_icon);
            this.tvTitle = (YYTextView)itemView.findViewById(R.id.tv_title);
            this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_content);
            this.tvFunc = (YYTextView)itemView.findViewById(R.id.tv_func);
            FontUtils.setFontType((TextView)this.tvFunc, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        }

        @Override
        public void update(final PermissionItem permissionData, final int position) {
            if (permissionData == null || permissionData.data() == null) {
                return;
            }
            PermissionData data2 = permissionData.data();
            if (data2.type == 0) {
                this.ivIcon.setImageResource(R.drawable.ico_share_facebook);
                this.tvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.fb_friends));
                this.tvContent.setVisibility(8);
                this.tvFunc.setText((CharSequence)ResourceUtils.getString((int)R.string.connect));
                this.tvFunc.setTextColor(ResourceUtils.getColor((int)R.color.yellow_ffc102));
                this.tvFunc.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_yellow_stoke_white_soild_corner));
            } else if (data2.type == 3) {
                this.ivIcon.setImageResource(R.drawable.ico_share_facebook);
                this.tvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.fb_friends));
                this.tvContent.setVisibility(8);
                this.tvFunc.setText((CharSequence)ResourceUtils.getString((int)R.string.facebook_update_account));
                this.tvFunc.setTextColor(ResourceUtils.getColor((int)R.color.yellow_ffc102));
                this.tvFunc.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_yellow_stoke_white_soild_corner));
            } else if (data2.type == 1) {
                this.ivIcon.setImageResource(R.drawable.ico_nearby);
                this.tvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.nb_friends));
                this.tvContent.setVisibility(0);
                this.tvContent.setText((CharSequence)ResourceUtils.getString((int)R.string.location_tips));
                this.tvFunc.setText((CharSequence)ResourceUtils.getString((int)R.string.setting));
                this.tvFunc.setTextColor(ResourceUtils.getColor((int)R.color.red_ff4a6d));
                this.tvFunc.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_red_stoke_white_soild_corner));
            } else if (data2.type == 2) {
                this.ivIcon.setImageResource(R.drawable.ico_mail);
                this.tvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.contact_friends));
                this.tvContent.setVisibility(8);
                this.tvFunc.setText((CharSequence)ResourceUtils.getString((int)R.string.connect));
                this.tvFunc.setTextColor(ResourceUtils.getColor((int)R.color.yellow_ffc102));
                this.tvFunc.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_yellow_stoke_white_soild_corner));
            }
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.onFuncClick(permissionData.data(), position);
                }
            });
        }

        public abstract void onFuncClick(PermissionData var1, int var2);
    }

    private static abstract class GuideVH
    extends VH<GuideItem> {
        private static final String TAG = "GuideVH";
        private ViewPager vpGuide;
        private YYImageView ivFacebook;
        private YYImageView ivLocation;
        private YYImageView ivContact;
        private YYImageView ivAvatar;
        private YYImageView ivPoint0;
        private YYImageView ivPoint1;
        private YYImageView ivPoint2;
        private List<Guide> mDatas = new ArrayList<Guide>();
        private PagerAdapter mAdapter;
        private List<Guide> mLastData;
        private View mLast = null;

        public GuideVH(View itemView) {
            super(itemView);
            this.vpGuide = (ViewPager)itemView.findViewById(R.id.vp);
            this.ivFacebook = (YYImageView)itemView.findViewById(R.id.iv_facebook);
            this.ivLocation = (YYImageView)itemView.findViewById(R.id.iv_location);
            this.ivContact = (YYImageView)itemView.findViewById(R.id.iv_contact);
            this.ivAvatar = (YYImageView)itemView.findViewById(R.id.iv_avatar);
            this.ivPoint0 = (YYImageView)itemView.findViewById(R.id.iv_point0);
            this.ivPoint1 = (YYImageView)itemView.findViewById(R.id.iv_point1);
            this.ivPoint2 = (YYImageView)itemView.findViewById(R.id.iv_point2);
            this.mAdapter = new PagerAdapter(){

                public int getCount() {
                    return mDatas.size();
                }

                @NonNull
                public Object instantiateItem(@NonNull ViewGroup container2, final int position) {
                    View view = LayoutInflater.from((Context)container2.getContext()).inflate(R.layout.layout_permission_guide, container2, false);
                    final Guide current = (Guide)mDatas.get(position);
                    if (view != null && current != null) {
                        TextView tvTips = (TextView)view.findViewById(R.id.tv_tips);
                        tvTips.setText((CharSequence)current.getTips());
                        TextView tvBtn = (TextView)view.findViewById(R.id.tv_guide);
                        tvBtn.setText((CharSequence)current.getBtnTxt());
                        if (current.type == 0) {
                            tvBtn.setTextColor(ResourceUtils.getColor((int)R.color.yellow_ffc102));
                            tvBtn.setBackgroundResource(R.drawable.shape_yellow_stoke_white_soild_corner);
                        } else if (current.type == 1) {
                            tvBtn.setTextColor(ResourceUtils.getColor((int)R.color.white));
                            tvBtn.setBackgroundResource(R.drawable.selector_friendlist_connect_fb);
                        } else if (current.type == 4) {
                            tvBtn.setTextColor(ResourceUtils.getColor((int)R.color.white));
                            tvBtn.setBackgroundResource(R.drawable.selector_friendlist_connect_fb);
                        } else if (current.type == 2) {
                            tvBtn.setTextColor(ResourceUtils.getColor((int)R.color.white));
                            tvBtn.setBackgroundResource(R.drawable.selector_play);
                        } else if (current.type == 3) {
                            tvBtn.setTextColor(ResourceUtils.getColor((int)R.color.white));
                            tvBtn.setBackgroundResource(R.drawable.selector_add_suggest_friend);
                        }
                        tvBtn.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                this.onFuncClick(current, position);
                            }
                        });
                    }
                    container2.addView(view);
                    return view;
                }

                public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
                    return view == object;
                }

                public void destroyItem(@NonNull ViewGroup container2, int position, @NonNull Object object) {
                    container2.removeView((View)object);
                }
            };
            this.vpGuide.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                }

                public void onPageSelected(int position) {
                    this.updateIndex(position, mDatas);
                    ivContact.setEnabled(false);
                    ivLocation.setEnabled(false);
                    ivFacebook.setEnabled(false);
                    View v = this.getView(position);
                    if (v != null) {
                        v.setEnabled(true);
                    }
                }

                public void onPageScrollStateChanged(int state2) {
                }
            });
        }

        @Override
        public void update(GuideItem guideItem, int position) {
            if (guideItem == null || guideItem.data() == null || guideItem.data().isEmpty()) {
                return;
            }
            Object data2 = guideItem.data();
            if (this.mLastData != data2) {
                this.mLastData = data2;
                this.mDatas.clear();
                this.mDatas.addAll((Collection<Guide>)data2);
                this.vpGuide.setAdapter(this.mAdapter);
                this.updateIndex(this.vpGuide.getCurrentItem(), this.mDatas);
            }
        }

        public abstract void onFuncClick(Guide var1, int var2);

        private void updateIndex(int position, List<Guide> datas) {
            Guide guide;
            this.ivPoint0.setVisibility(8);
            this.ivPoint1.setVisibility(8);
            this.ivPoint2.setVisibility(8);
            this.ivPoint0.setEnabled(false);
            this.ivPoint1.setEnabled(false);
            this.ivPoint2.setEnabled(false);
            this.ivFacebook.setVisibility(0);
            this.ivLocation.setVisibility(0);
            this.ivContact.setVisibility(0);
            this.ivAvatar.setImageResource(R.drawable.icon_find_friend_avatar);
            this.ivFacebook.setEnabled(false);
            this.ivLocation.setEnabled(false);
            this.ivContact.setEnabled(false);
            if (position > datas.size() - 1 || datas.size() > 3) {
                return;
            }
            if (datas.size() == 1 && (guide = datas.get(0)) != null && guide.type == 0) {
                this.ivAvatar.setImageResource(R.drawable.icon_message_empty);
                this.ivFacebook.setVisibility(8);
                this.ivLocation.setVisibility(8);
                this.ivContact.setVisibility(8);
                return;
            }
            if (datas.size() == 2) {
                this.ivPoint0.setVisibility(0);
                this.ivPoint1.setVisibility(0);
                this.ivPoint0.setEnabled(position == 0);
                this.ivPoint1.setEnabled(position == 1);
            } else if (datas.size() == 3) {
                this.ivPoint0.setVisibility(0);
                this.ivPoint1.setVisibility(0);
                this.ivPoint2.setVisibility(0);
                this.ivPoint0.setEnabled(position == 0);
                this.ivPoint1.setEnabled(position == 1);
                this.ivPoint2.setEnabled(position == 2);
            }
            View selected = this.getView(position);
            if (selected != null) {
                selected.setEnabled(true);
                this.animate(selected);
            }
        }

        private void animate(View view) {
            if (view == this.mLast || view == null) {
                return;
            }
            this.mLast = view;
            ObjectAnimator scaleDownX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.5f, 1.0f, 1.5f, 1.0f});
            ObjectAnimator scaleDownY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.5f, 1.0f, 1.5f, 1.0f});
            AnimatorSet set2 = new AnimatorSet();
            set2.play((Animator)scaleDownX).with((Animator)scaleDownY);
            set2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            set2.start();
        }

        private View getView(int current) {
            if (this.mDatas.size() <= current || current < 0) {
                return null;
            }
            Guide guide = this.mDatas.get(current);
            if (guide.type == 2) {
                return this.ivLocation;
            }
            if (guide.type == 3) {
                return this.ivContact;
            }
            if (guide.type == 1 || guide.type == 4) {
                return this.ivFacebook;
            }
            return null;
        }
    }

    public static class FriendVH
    extends VH<FriendItem> {
        private RecycleImageView ivAvatar;
        private YYImageView ivOnline;
        private FollowView mFollowView;
        private YYTextView tvName;
        private YYTextView tvFrom;
        private YYTextView tvPlay;
        private SpannableString mAddStr = null;

        public FriendVH(View itemView) {
            super(itemView);
            this.ivAvatar = (RecycleImageView)itemView.findViewById(R.id.iv_avatar);
            this.ivOnline = (YYImageView)itemView.findViewById(R.id.v_online_state);
            this.tvName = (YYTextView)itemView.findViewById(R.id.tv_name);
            this.tvFrom = (YYTextView)itemView.findViewById(R.id.tv_content);
            this.mFollowView = (FollowView)itemView.findViewById(R.id.follow_view);
            this.tvPlay = (YYTextView)itemView.findViewById(R.id.tv_play);
            FontUtils.setFontType((TextView)this.tvPlay, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
            this.mFollowView.setBoldStyle();
        }

        public void onViewDetachedFromWindow() {
            this.mFollowView.removeBinding();
        }

        @Override
        public void update(FriendItem findFriendItem, final int position) {
            final FriendData data2 = findFriendItem.data();
            if (data2 != null) {
                if (data2.mFriend.isNewFirend()) {
                    this.itemView.setBackgroundResource(R.drawable.bg_item_new_friend_selector);
                } else {
                    this.itemView.setBackgroundResource(R.drawable.bg_item_selector);
                }
                ImageLoader.loadBitmap((ImageView)this.ivAvatar, (String)(data2.mFriend.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)data2.mFriend.getSex()));
                boolean isOnline = data2.mFriend.getOnlineStatus() == 1L;
                this.ivOnline.setVisibility(isOnline ? 0 : 8);
                this.tvPlay.setVisibility(isOnline ? 0 : 8);
                this.tvName.setText((CharSequence)data2.mFriend.getNick());
                long type = data2.mFriend.getType();
                if (type == 0L) {
                    String nick = data2.mFriend.getAlias();
                    if (nick != null && nick.length() > 12) {
                        nick = nick.substring(0, 12) + "...";
                    }
                    this.tvFrom.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_fb, (Object[])new Object[]{nick}));
                } else if (type == 1L) {
                    String nick = data2.mFriend.getAlias();
                    this.tvFrom.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_contact, (Object[])new Object[]{nick}));
                } else if (type == 2L) {
                    float distance = data2.mFriend.getDist() * 1000.0f;
                    if (distance == 10.0f) {
                        this.tvFrom.setText((CharSequence)"<10m");
                    } else {
                        this.tvFrom.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%.0fm", (Object[])new Object[]{Float.valueOf(distance)}));
                    }
                } else if (type == 3L) {
                    this.tvFrom.setText((CharSequence)ResourceUtils.getString((int)R.string.hago_friend));
                } else if (type == 6L) {
                    this.tvFrom.setText((CharSequence)ResourceUtils.getString((int)R.string.tip_invited_friend));
                } else if (type == 5L) {
                    this.tvFrom.setText((CharSequence)ResourceUtils.getString((int)R.string.tip_friends_who_invited_you));
                } else {
                    this.tvFrom.setText((CharSequence)"");
                }
                this.mFollowView.setFollowStatusListener((followStatus, oldStatus) -> this.mFollowView.setEnabled(!followStatus.isFollow()));
                final String enterType = String.valueOf(18);
                this.mFollowView.setClickInterceptor(new IFollowClickInterceptor(){

                    public boolean interceptor(RelationInfo followStatus) {
                        if (!followStatus.isFollow()) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "follow_click").put("follow_enter_type", enterType));
                        } else {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "no_follow_click").put("follow_enter_type", enterType));
                        }
                        return false;
                    }
                });
                this.mFollowView.bindFollowStatus(data2.mFriend.getUid(), FollowerUtils.INSTANCE.enterType2ePath(enterType));
                this.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        this.onFriendItemClick(data2, position);
                    }
                });
                this.ivAvatar.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        this.onAvatarClick(data2, position);
                    }
                });
                this.tvPlay.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        this.onPlayClick(data2, position);
                    }
                });
            }
        }

        public void onFriendItemClick(FriendData data2, int position) {
        }

        public void onAvatarClick(FriendData data2, int position) {
        }

        public void onPlayClick(FriendData data2, int position) {
        }
    }

    private static abstract class InviteVH
    extends VH<InviteFriendItem>
    implements View.OnClickListener {
        private static final String TAG = "InviteVH";
        private static final DResource FACE_URL = DR.face;
        private static final DResource FACE_SMILING_URL = com.yy.hiyo.im.base.DR.faceSmiling;
        private LinearLayout shareBox;
        private boolean isOpenFace = false;
        private YYLinearLayout bubbleContainer;
        private SVGAImageView faceStart;
        private YYTextView bubbleContent;
        private List<View> shareBoxIcons;
        private HiddenAnimUtils hiddenAnimUtils;
        private boolean isFirstReport = true;
        int screenWidth = 0;
        int tvWidth = 0;
        int shareChannelWidth = 0;

        public InviteVH(View itemView, List<BaseShareChannel> shareChannels) {
            super(itemView);
            if (this.shareBoxIcons == null) {
                this.shareBoxIcons = new ArrayList<View>();
            }
            this.screenWidth = ResolutionUtils.getScreenWidth((Context)itemView.getContext());
            if (this.screenWidth > 0) {
                this.tvWidth = this.screenWidth - ResolutionUtils.dip2Px((float)90.0f);
                this.shareChannelWidth = this.screenWidth / 4;
            }
            this.shareBoxIcons.clear();
            this.shareBox = (LinearLayout)itemView.findViewById(R.id.ll_share_box);
            this.bubbleContainer = (YYLinearLayout)itemView.findViewById(R.id.bubble_container);
            this.bubbleContent = (YYTextView)itemView.findViewById(R.id.bubble_content);
            if (this.tvWidth > 0) {
                this.bubbleContent.setWidth(this.tvWidth);
            }
            this.faceStart = (SVGAImageView)itemView.findViewById(R.id.find_friends_face);
            this.initShareChannels(shareChannels);
            this.bubbleContent.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.onBubbleContentClick(bubbleContainer, bubbleContent, faceStart, shareBoxIcons, FACE_URL, FACE_SMILING_URL);
                }
            });
            this.faceStart.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.onFaceClick(bubbleContainer, bubbleContent, faceStart, shareBoxIcons, FACE_URL, FACE_SMILING_URL);
                }
            });
        }

        public void onBubbleContentClick(YYLinearLayout bubbleContainer, YYTextView bubbleContent, SVGAImageView faceStart, List<View> shareBoxIcons, DResource faceUrl, DResource faceSmilingUrl) {
            bubbleContent.setEnabled(false);
            this.getHiddenAnimUtils(bubbleContainer, bubbleContent, faceStart, shareBoxIcons, FACE_URL, FACE_SMILING_URL).toggle();
        }

        public void onFaceClick(YYLinearLayout bubbleContainer, YYTextView bubbleContent, SVGAImageView faceStart, List<View> shareBoxIcons, DResource faceUrl, DResource faceSmilingUrl) {
            faceStart.setEnabled(false);
            this.getHiddenAnimUtils(bubbleContainer, bubbleContent, faceStart, shareBoxIcons, FACE_URL, FACE_SMILING_URL).toggle();
        }

        private HiddenAnimUtils getHiddenAnimUtils(YYLinearLayout bubbleContainer, YYTextView bubbleContent, SVGAImageView faceStart, List<View> shareBoxIcons, DResource faceUrl, DResource faceSmilingUrl) {
            if (this.hiddenAnimUtils == null) {
                this.hiddenAnimUtils = new HiddenAnimUtils();
                this.hiddenAnimUtils.init((View)bubbleContainer, (View)bubbleContent, faceStart, shareBoxIcons, faceUrl, faceSmilingUrl);
            }
            return this.hiddenAnimUtils;
        }

        private void initShareChannels(List<BaseShareChannel> channelList) {
            if (channelList == null) {
                return;
            }
            for (BaseShareChannel channel : channelList) {
                int idResId = 0;
                int iconResId = 0;
                String name = null;
                switch (channel.getId()) {
                    case 2: {
                        idResId = R.id.share_platform_whatsapp;
                        iconResId = R.drawable.ico_share_whatsapp;
                        name = ResourceUtils.getString((int)R.string.share_platform_whatsapp);
                        break;
                    }
                    case 5: {
                        idResId = R.id.share_platform_facebook;
                        iconResId = R.drawable.ico_share_facebook;
                        name = ResourceUtils.getString((int)R.string.share_platform_facebook);
                        break;
                    }
                    case 7: {
                        idResId = R.id.share_platform_snapchat;
                        iconResId = R.drawable.ico_share_snapchat;
                        name = ResourceUtils.getString((int)R.string.share_platform_snapchat);
                        break;
                    }
                    case 3: {
                        idResId = R.id.share_platform_instagram;
                        iconResId = R.drawable.ico_share_ins;
                        name = ResourceUtils.getString((int)R.string.share_platform_instagram);
                        break;
                    }
                    case 1: {
                        idResId = R.id.share_platform_line;
                        iconResId = R.drawable.ico_share_line;
                        name = ResourceUtils.getString((int)R.string.share_platform_line);
                        break;
                    }
                    case 6: {
                        idResId = R.id.share_platform_messenger;
                        iconResId = R.drawable.ico_share_messenger;
                        name = ResourceUtils.getString((int)R.string.share_platform_messenger);
                        break;
                    }
                    case 9: {
                        idResId = R.id.share_platform_vk;
                        iconResId = R.drawable.ico_share_vk;
                        name = ResourceUtils.getString((int)R.string.share_platform_vk);
                        break;
                    }
                    case 11: {
                        idResId = R.id.share_platform_zalo;
                        iconResId = R.drawable.ico_share_zalo;
                        name = ResourceUtils.getString((int)R.string.share_platform_zalo);
                        break;
                    }
                    case 10: {
                        idResId = R.id.share_copy_link;
                        iconResId = R.drawable.ico_share_copy_link;
                        name = ResourceUtils.getString((int)R.string.title_share_copy_link);
                        break;
                    }
                    case 0: {
                        idResId = R.id.share_system;
                        iconResId = R.drawable.ico_share_other;
                        name = ResourceUtils.getString((int)R.string.title_share_others);
                        break;
                    }
                }
                if (idResId <= 0 || this.shareBox == null) continue;
                this.addShareItem(idResId, name, iconResId);
            }
        }

        @Override
        public void update(final InviteFriendItem titleContentItem, int position) {
            if (!TextUtils.isEmpty((CharSequence)titleContentItem.data().getBubbleContent())) {
                this.bubbleContent.setText((CharSequence)titleContentItem.data().getBubbleContent());
            }
            if (titleContentItem.data() != null && titleContentItem.data().isNeedShowGuide() && !this.isOpenFace) {
                this.faceStart.setEnabled(true);
                this.isOpenFace = true;
                if (8 == this.bubbleContainer.getVisibility()) {
                    DyResLoader.INSTANCE.loadSvga(this.faceStart, FACE_URL, new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity entity) {
                            if (faceStart != null) {
                                faceStart.startAnimation();
                            }
                            if (titleContentItem.data().isGuideOpen()) {
                                this.getHiddenAnimUtils(bubbleContainer, bubbleContent, faceStart, shareBoxIcons, FACE_URL, FACE_SMILING_URL).toggle();
                                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("pop_init_type", "1"));
                            } else {
                                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("pop_init_type", "2"));
                            }
                        }

                        public void onFailed(Exception e) {
                            MLog.error((Object)"FindFriendsAdapter", (Throwable)e);
                        }
                    });
                }
            } else if (!this.isOpenFace) {
                this.faceStart.setEnabled(false);
                if (this.isFirstReport) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("pop_init_type", "0"));
                    this.isFirstReport = false;
                }
            } else if (8 == this.bubbleContainer.getVisibility()) {
                this.faceStart.startAnimation();
            }
        }

        private void addShareItem(int id2, String name, @DrawableRes int icon) {
            View itemView = LayoutInflater.from((Context)this.shareBox.getContext()).inflate(R.layout.item_share_channel, (ViewGroup)this.shareBox, false);
            if (this.shareChannelWidth > 0) {
                itemView.setMinimumWidth(this.shareChannelWidth);
            }
            itemView.setId(id2);
            YYImageView ivIcon = (YYImageView)itemView.findViewById(R.id.iv_icon);
            View container2 = itemView.findViewById(R.id.share_container);
            ivIcon.setImageResource(icon);
            ViewGroup.LayoutParams lp = ivIcon.getLayoutParams();
            if (lp != null) {
                int size;
                lp.width = size = ResolutionUtils.dip2Px((float)50.0f);
                lp.height = size;
                ivIcon.setLayoutParams(lp);
            }
            YYTextView tvName = (YYTextView)itemView.findViewById(R.id.tv_name);
            tvName.setText((CharSequence)name);
            itemView.setOnClickListener((View.OnClickListener)this);
            this.shareBoxIcons.add(container2);
            this.shareBox.addView(itemView);
        }
    }

    public static abstract class CreateGroupVH
    extends VH<CreateGroupItem> {
        public CreateGroupVH(View itemView) {
            super(itemView);
            YYImageView imageView = (YYImageView)itemView.findViewById(R.id.icon_left);
            YYTextView textView = (YYTextView)itemView.findViewById(R.id.tv_item_title);
            textView.setText((CharSequence)ResourceUtils.getString((int)R.string.title_play_together));
            imageView.setImageResource(R.drawable.icon_create_group);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.onClicked();
                }
            });
        }

        @Override
        public void update(CreateGroupItem createGroupItem, int position) {
        }

        public abstract void onClicked();
    }

    public static abstract class GameFaceVH
    extends VH<GameFaceItem> {
        public GameFaceVH(View itemView) {
            super(itemView);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.onClicked();
                }
            });
        }

        @Override
        public void update(GameFaceItem gameFaceItem, int position) {
        }

        public abstract void onClicked();
    }

    public static abstract class FindChannelVH
    extends VH<ChannelListComponentItem>
    implements FindChannelAdapter.OnItemClickListener {
        private TextView tvTitle;
        private RecyclerView findChannelRecyclerView;
        private View topSpacingView;
        private FindChannelAdapter adapter;

        public FindChannelVH(View itemView) {
            super(itemView);
            this.findChannelRecyclerView = (RecyclerView)itemView.findViewById(R.id.find_channel_recycleview);
            this.tvTitle = (TextView)itemView.findViewById(R.id.tv_title);
            this.topSpacingView = itemView.findViewById(R.id.view_top_spacing);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(itemView.getContext());
            linearLayoutManager.setOrientation(0);
            this.findChannelRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        }

        @Override
        public void update(ChannelListComponentItem channelListComponentItem, int position) {
            boolean notShowTopSpacing;
            if (this.adapter == null) {
                this.adapter = new FindChannelAdapter();
            }
            ChannelListData channelListData = channelListComponentItem.data();
            boolean showTitle = false;
            if (channelListData != null) {
                this.adapter.setData(channelListData.getChannelList());
                showTitle = channelListData.isShowTitle();
            }
            if (showTitle) {
                this.tvTitle.setVisibility(0);
            } else {
                this.tvTitle.setVisibility(8);
            }
            boolean bl = notShowTopSpacing = !showTitle && (channelListData == null || FP.empty(channelListData.getChannelList()));
            if (notShowTopSpacing) {
                this.topSpacingView.setVisibility(8);
            } else {
                this.topSpacingView.setVisibility(0);
            }
            this.adapter.setItemClickListener(this);
            this.findChannelRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        }
    }

    public static class TitleContentVH
    extends VH<TitleContentItem> {
        private YYTextView tvTitle;
        private YYTextView tvContent;

        public TitleContentVH(View itemView) {
            super(itemView);
            this.tvTitle = (YYTextView)itemView.findViewById(R.id.tv_title);
            this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_content);
        }

        @Override
        public void update(TitleContentItem titleContentItem, int position) {
            if (titleContentItem == null) {
                return;
            }
            TitleContent content = titleContentItem.data();
            if (content != null) {
                this.tvTitle.setText((CharSequence)content.title);
                this.tvContent.setVisibility(TextUtils.isEmpty((CharSequence)content.content) ? 8 : 0);
                this.tvContent.setText((CharSequence)content.content);
            }
        }
    }

    public static abstract class SearchFriendVH
    extends VH<SearchFriendItem> {
        private View searchBoxView;

        public SearchFriendVH(View itemView) {
            super(itemView);
            this.searchBoxView = itemView.findViewById(R.id.ll_search);
            this.searchBoxView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.onSearchBoxClicked();
                }
            });
        }

        @Override
        public void update(SearchFriendItem searchFriendItem, int position) {
        }

        public abstract void onSearchBoxClicked();
    }
}

