/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.findfriend.v1;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Observer;
import com.google.gson.JsonObject;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.im.ImPageSourceData;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.kvo.moduledata.PlatformPermissionModuleData;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.callback.ILoadFindFriendsData;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.kvomodule.module.PlatformPermissionModule;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.ICheckNeedUpload;
import com.yy.appbase.service.callback.OnGetGuideTypeCallback;
import com.yy.appbase.service.model.NetCheckUpload;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.OnLineFriendsNumConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.event.kvo.list.KvoListHelper;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.base.bean.create.ChannelCreatorControllerEnter;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.game.base.MsgGameDefProvider;
import com.yy.hiyo.im.FindFriendNotificationDef;
import com.yy.hiyo.im.IImModuleData;
import com.yy.hiyo.im.ImNotificationBaseDef;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ContactBaseUtils;
import com.yy.hiyo.im.base.IChatSession;
import com.yy.hiyo.login.base.IBindThirdPartyAccountCallBack;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.friend.IFriendServices;
import com.yy.hiyo.relation.base.friend.data.NewFriendsData;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.hiyo.wallet.base.IAdService;
import com.yy.im.R;
import com.yy.im.findfriend.IFindFriendController;
import com.yy.im.findfriend.ThirdPartyCallbackProvider;
import com.yy.im.findfriend.v1.IFindCallback;
import com.yy.im.findfriend.v1.IShareCallback;
import com.yy.im.findfriend.v1.bean.AdContainerItem;
import com.yy.im.findfriend.v1.bean.ChannelItem;
import com.yy.im.findfriend.v1.bean.ChannelListComponentItem;
import com.yy.im.findfriend.v1.bean.ChannelListData;
import com.yy.im.findfriend.v1.bean.CreateGroupItem;
import com.yy.im.findfriend.v1.bean.FindFriendItem;
import com.yy.im.findfriend.v1.bean.FriendData;
import com.yy.im.findfriend.v1.bean.FriendItem;
import com.yy.im.findfriend.v1.bean.GameFaceItem;
import com.yy.im.findfriend.v1.bean.Guide;
import com.yy.im.findfriend.v1.bean.InviteData;
import com.yy.im.findfriend.v1.bean.InviteFriendItem;
import com.yy.im.findfriend.v1.bean.PermissionData;
import com.yy.im.findfriend.v1.bean.SearchFriendItem;
import com.yy.im.findfriend.v1.bean.callback.IFindFriendCallback;
import com.yy.im.findfriend.v1.ui.FindFriendsWindowV1;
import com.yy.im.msg.ImModuleMsgDef;
import com.yy.location.LocationHelper;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.data.AdEntity;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import okhttp3.Call;

public class FindFriendControllerV1
extends DefaultWindowController
implements IFindFriendCallback,
IFindCallback,
IShareCallback,
ISharePage,
IFindFriendController {
    private static final String TAG = "FindFriendController";
    private static final long LOAD_STAY_PAGE_INTERVAL = 600000L;
    private static final int LOAD_STAY_PAGE_COUNTS = -1;
    private static final long LOAD_ENTER_INTERVAL = 60000L;
    private static final int LOAD_ENTER_COUNTS = 1;
    private static final long LOAD_UPLOAD_FIRST_INTERVAL = 3000L;
    private static final int LOAD_UPLOAD_FIRST_COUNTS = 1;
    private static final long LOAD_UPLOAD_SECOND_INTERVAL = 3000L;
    private static final int LOAD_UPLOAD_SECOND_COUNTS = 4;
    private static final int LOAD_HOME_INTERVAL = 60000;
    private static final int LOAD_HOME_COUNTS = 1;
    private static final int HOME_FRIEND_LIMIT = 30;
    private static final int FIND_FRIEND_LIMIT = 60;
    private static final int PF_FB = 0;
    private static final int PF_CONTACT = 1;
    private static final int PF_LOCATION = 2;
    private static final int PF_ZALO = 3;
    public static boolean FIRST_LOAD_FRIEND_DATA = true;
    private MaxLimitCacheTask mCacheTask = new MaxLimitCacheTask(this);
    private CheckStatus mFacebookState = null;
    private CheckStatus mContactState = null;
    private CheckStatus mLocationState = null;
    private CheckStatus mZaloState = null;
    private FindFriendsWindowV1 mWindow;
    private final Object mLock = new Object();
    private KvoBinder mBinder = new KvoBinder((Object)this);
    private long mLastClickTs;
    private int enterFriendsTimes = 0;
    private int onLineFriendsNum = 0;
    private int mGuideType = 0;
    public static boolean isGuideOpen = true;
    private List<FindFriendItem> mShowDatas;
    private List<FriendItem> mFriendItems;
    private List<Long> mNewFriendUids = new ArrayList<Long>();
    private List<IChatSession> mChatSessions = new ArrayList<IChatSession>();
    private boolean mChatSessionsReady = false;
    private boolean mIsNewInForShare;
    private boolean mHadRequestGuideType;
    private InviteData inviteData;
    private final ThirdPartyCallbackProvider mCallbackProvider;
    private Observer<List<IChatSession>> chatSessionObserver = new Observer<List<IChatSession>>(){

        public void onChanged(@Nullable List<IChatSession> chatSessions) {
            FindFriendControllerV1.this.mChatSessions.clear();
            FindFriendControllerV1.this.mChatSessions.addAll(chatSessions);
            FindFriendControllerV1.this.mChatSessionsReady = true;
        }
    };
    List<ChannelItem> mChannelItems = new ArrayList<ChannelItem>();

    public FindFriendControllerV1(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(FindFriendNotificationDef.GET_HOME_FRIEND_LIST, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.WSCLIENT_CONNECT_SUCCESS, (INotify)this);
        this.registerMessage(ImModuleMsgDef.MSG_POP_FIND_FRIEND_WINDOW);
        this.mCallbackProvider = new ThirdPartyCallbackProvider((Activity)this.getActivity());
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.WSCLIENT_CONNECT_SUCCESS) {
            this.checkCacheReq();
        } else if (notification.id == FindFriendNotificationDef.GET_HOME_FRIEND_LIST) {
            this.reqLoadHomeData();
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE && notification.extObj instanceof Boolean) {
            if (((Boolean)notification.extObj).booleanValue()) {
                this.onResume();
            }
        } else if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            MLog.info((Object)TAG, (String)"on login account change", (Object[])new Object[0]);
            this.mCacheTask.reset();
            if (this.isAtTop() && AccountUtil.getUid() > 0L) {
                this.loadDataWhenAttach();
            }
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg == null) {
            return;
        }
        if (msg.what == ImModuleMsgDef.MSG_POP_FIND_FRIEND_WINDOW && this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
    }

    private void onResume() {
        if (this.isAtTop()) {
            MLog.info((Object)TAG, (String)("onResume" + AccountUtil.getUid() + AccountUtil.isLoginByGuest()), (Object[])new Object[0]);
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).locationPermission((Activity)this.getActivity());
            this.checkFacebookPermission();
            this.checkContactPermission();
            this.checkZaloPermission();
        }
    }

    @Override
    public void openWindow() {
        this.mWindow = new FindFriendsWindowV1(this.mContext, (UICallBacks)this, this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        MLog.info((Object)TAG, (String)"onWindowAttach", (Object[])new Object[0]);
        this.mIsNewInForShare = true;
        this.mHadRequestGuideType = false;
        this.mChatSessionsReady = false;
        IImModuleData imModuleData = (IImModuleData)KvoModuleManager.getModuleData(ImModule.class);
        imModuleData.observeNormalChatSessionsForever(this.chatSessionObserver);
        this.loadDataWhenAttach();
    }

    private void initOnlineFriendsNumConfig() {
        OnLineFriendsNumConfig configData = (OnLineFriendsNumConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.ONLINE_FRIENDS_NUM);
        if (configData != null) {
            this.onLineFriendsNum = configData.getNum();
        }
    }

    private void loadDataWhenAttach() {
        this.mNewFriendUids.clear();
        NewFriendsData newFriendsData = ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).getNewFriendsData();
        this.mNewFriendUids.addAll((Collection<Long>)newFriendsData.mNewFriendsUids);
        ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).clearNewFriends();
        if (this.mNewFriendUids.size() > 0) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("is_notice", "1"));
        } else {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("is_notice", "0"));
        }
        this.checkFirstEnter();
        this.loadFindFriendData();
        this.checkFacebook();
        this.checkZalo();
        this.checkContact();
        this.checkLocation();
        KvoSource source = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
        Kvo.removeKvoBinding((KvoSource)source, (Object)this, (String)"onFindFriendList");
        Kvo.addKvoBinding((KvoSource)source, (Object)this, (String)"onFindFriendList");
        NewFriendsData newFriendsSource = ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).getNewFriendsData();
        Kvo.addKvoBinding((KvoSource)newFriendsSource, (Object)this, (String)"onNewFriendsUpdate");
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        MLog.info((Object)TAG, (String)"onWindowDetach", (Object[])new Object[0]);
        NewFriendsData newFriendsSource = ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).getNewFriendsData();
        Kvo.removeKvoBinding((KvoSource)newFriendsSource, (Object)this, (String)"onNewFriendsUpdate");
        ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).clearNewFriends();
        if (this.mContactState != null) {
            Kvo.removeKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onUploadContactEvent");
        }
        if (this.mFacebookState != null) {
            Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onUploadFBEvent");
        }
        if (this.mContactState != null) {
            this.mContactState.setValue("hasUpload", (Object)false);
        }
        if (this.mFacebookState != null) {
            this.mFacebookState.setValue("hasUpload", (Object)false);
        }
        IImModuleData imModuleData = (IImModuleData)KvoModuleManager.getModuleData(ImModule.class);
        imModuleData.removeNormalChatSessionsObserver(this.chatSessionObserver);
        this.mCacheTask.clear();
        if (this.mWindow != null) {
            this.mWindow.removeAnimation();
        }
        this.mWindow = null;
        ContactBaseUtils.S_CAN_CONTACT_DIALOG_SHOW = false;
    }

    private void checkFirstEnter() {
        this.enterFriendsTimes = SettingFlags.getIntValue((String)"first_enter_play_with_friends_times", (int)0);
        ++this.enterFriendsTimes;
        if (this.enterFriendsTimes < 3) {
            SettingFlags.setIntValue((String)"first_enter_play_with_friends_times", (int)this.enterFriendsTimes);
        }
    }

    private void checkFacebook() {
        if (AccountUtil.getUid() <= 0L) {
            MLog.info((Object)TAG, (String)"unsupport login type,do not check fb bind status. ", (Object[])new Object[0]);
            return;
        }
        if (this.mFacebookState == null) {
            KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
            if (!(moduleData instanceof PlatformPermissionModuleData)) {
                return;
            }
            PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
            this.mFacebookState = moduleData1.facebookState;
            if (this.mFacebookState != null) {
                Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
                Kvo.addKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
            }
        }
        if (this.mFacebookState != null) {
            Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onUploadFBEvent");
            Kvo.addKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onUploadFBEvent");
        }
        this.checkFacebookPermission();
        this.checkUploadFacebook();
    }

    private void checkZalo() {
        if (AccountUtil.getUid() <= 0L) {
            MLog.info((Object)TAG, (String)"unsupport login type,do not check fb bind status. ", (Object[])new Object[0]);
            return;
        }
        if (this.mZaloState == null) {
            KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
            if (!(moduleData instanceof PlatformPermissionModuleData)) {
                return;
            }
            PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
            this.mZaloState = moduleData1.zaloState;
            if (this.mZaloState != null) {
                Kvo.removeKvoBinding((KvoSource)this.mZaloState, (Object)this, (String)"onZaloPermissionChange");
                Kvo.addKvoBinding((KvoSource)this.mZaloState, (Object)this, (String)"onZaloPermissionChange");
            }
        }
        this.checkZaloPermission();
    }

    private void checkFacebookPermission() {
        if (this.mFacebookState != null && this.mFacebookState.permissionState != CheckStatus.EXPIRE) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).facebookPermission(this.mFacebookState.permissionState);
        } else {
            MLog.info((Object)TAG, (String)("checkUploadFacebook do not need: " + this.mFacebookState), (Object[])new Object[0]);
        }
    }

    private void checkZaloPermission() {
        if (this.mZaloState != null && this.mZaloState.permissionState != CheckStatus.EXPIRE) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).zaloPermission(this.mZaloState.permissionState);
        } else {
            MLog.info((Object)TAG, (String)("checkUploadZalo do not need: " + this.mZaloState), (Object[])new Object[0]);
        }
    }

    private void checkUploadFacebook() {
        if (this.mFacebookState != null && !this.mFacebookState.hasUpload) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).checkUploadFb((INetRespCallback)new INetRespCallback<NetCheckUpload>(){

                public void onError(Call call, Exception e, int id2) {
                }

                public void onResponse(String response, BaseResponseBean<NetCheckUpload> res, int id2) {
                    if (res != null && res.isSuccess()) {
                        FindFriendControllerV1.this.startUploadFacebookFriendList();
                    }
                }
            });
        }
    }

    private void checkContact() {
        if (this.mContactState == null) {
            KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
            if (!(moduleData instanceof PlatformPermissionModuleData)) {
                return;
            }
            PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
            this.mContactState = moduleData1.contactState;
            if (this.mContactState != null) {
                Kvo.removeKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onContactPermissionChange");
                Kvo.addKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onContactPermissionChange");
            }
        }
        if (this.mContactState != null) {
            Kvo.removeKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onUploadContactEvent");
            Kvo.addKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onUploadContactEvent");
        }
        this.checkContactPermission();
        this.checkUploadContacts();
    }

    private void checkContactPermission() {
        if (this.mContactState != null) {
            MLog.info((Object)TAG, (String)"check contact permission", (Object[])new Object[0]);
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).contactPermission((Activity)this.getActivity(), this.mContactState.permissionState);
        }
    }

    private void checkUploadContacts() {
        if (this.mContactState != null && !this.mContactState.hasUpload) {
            MLog.info((Object)TAG, (String)"checkUploadContact err ", (Object[])new Object[0]);
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).checkUploadContacts(new ICheckNeedUpload(){

                public void onSuccess(NetCheckUpload responseBean) {
                    FindFriendControllerV1.this.startUploadContacts();
                }

                public void onError(int code, String msg) {
                    MLog.info((Object)FindFriendControllerV1.TAG, (String)("checkUploadContact err " + code + " msg" + msg), (Object[])new Object[0]);
                }
            });
        }
    }

    private void checkLocation() {
        KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
        if (!(moduleData instanceof PlatformPermissionModuleData)) {
            return;
        }
        PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
        this.mLocationState = moduleData1.locationState;
        if (this.mLocationState != null) {
            Kvo.removeKvoBinding((KvoSource)this.mLocationState, (Object)this, (String)"onLocationPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mLocationState, (Object)this, (String)"onLocationPermissionChange");
            Kvo.removeKvoBinding((KvoSource)this.mLocationState, (Object)this, (String)"onUploadLocationEvent");
            Kvo.addKvoBinding((KvoSource)this.mLocationState, (Object)this, (String)"onUploadLocationEvent");
        }
        ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).locationPermission((Activity)this.getActivity());
    }

    private void reqLoadHomeData() {
        if (!this.mCacheTask.hasTask()) {
            MLog.info((Object)TAG, (String)"load home request data", (Object[])new Object[0]);
            this.mCacheTask.setStrategy(false, true, LoadDataStrategy.createHomeStrategy());
        }
    }

    private void loadFindFriendData() {
        if (FIRST_LOAD_FRIEND_DATA) {
            MLog.info((Object)TAG, (String)"load home request data first time", (Object[])new Object[0]);
            this.mWindow.autoRefresh();
            FIRST_LOAD_FRIEND_DATA = false;
            return;
        }
        if (this.mCacheTask.mFbFastCheck || this.mCacheTask.mContactFastCheck || this.mCacheTask.mLocationFastCheck || !this.mNewFriendUids.isEmpty()) {
            MLog.info((Object)TAG, (String)("last time fail to get type data,retry now." + this.mCacheTask.mLocationFastCheck + this.mCacheTask.mContactFastCheck + this.mCacheTask.mFbFastCheck), (Object[])new Object[0]);
            this.mCacheTask.setStrategy(true, false, LoadDataStrategy.createFindFriendPageStrategy(), LoadDataStrategy.createImmeStrategy());
            this.mCacheTask.mFbFastCheck = false;
            this.mCacheTask.mContactFastCheck = false;
            this.mCacheTask.mLocationFastCheck = false;
        } else if (!this.mCacheTask.hasTask()) {
            MLog.info((Object)TAG, (String)"load home request data", (Object[])new Object[0]);
            this.mCacheTask.setStrategy(false, true, LoadDataStrategy.createFindFriendPageStrategy(), LoadDataStrategy.createEnterPageStrategy());
        }
    }

    private void checkCacheReq() {
        MLog.info((Object)TAG, (String)("ws connected,has task cache: :" + this.mCacheTask.hasTask()), (Object[])new Object[0]);
        if (this.mCacheTask.hasTask()) {
            this.mCacheTask.executeTask(0L);
        }
    }

    private void onPermissionChange(int platForm) {
        this.parseShowData(((PlatformPermissionModuleData)KvoModuleManager.getModuleData(PlatformPermissionModule.class)).findFriendList);
    }

    private void startUploadContacts() {
        if (this.mContactState.permissionState == CheckStatus.AUTH) {
            if (this.mContactState.checkNeedUpload != null && this.mContactState.checkNeedUpload.need && !this.mContactState.hasUpload) {
                ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).uploadContacts();
            } else {
                MLog.info((Object)TAG, (String)("on contact permission auth ,but " + this.mContactState), (Object[])new Object[0]);
            }
        }
    }

    private void startUploadFacebookFriendList() {
        if (this.mFacebookState.permissionState == CheckStatus.AUTH) {
            if (this.mFacebookState.checkNeedUpload != null && this.mFacebookState.checkNeedUpload.need && !this.mFacebookState.hasUpload) {
                MLog.info((Object)TAG, (String)"start to request upload facebook", (Object[])new Object[0]);
                ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).uploadFacebookFriendList();
            } else {
                MLog.info((Object)TAG, (String)("onFacebookPermissionChange ,permission is auth,but checkupload = " + this.mFacebookState.checkNeedUpload), (Object[])new Object[0]);
            }
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onFacebookPermissionChange(KvoEventIntent event) {
        if (this.mFacebookState == null || this.mFacebookState.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        MLog.info((Object)TAG, (String)("onFacebookPermissionChange ,p:" + this.mFacebookState.permissionState), (Object[])new Object[0]);
        this.onPermissionChange(0);
        if (this.mFacebookState.permissionState == CheckStatus.AUTH && this.mFacebookState.checkNeedUpload != null && !this.mFacebookState.checkNeedUpload.need) {
            this.checkUploadFacebook();
            return;
        }
        this.startUploadFacebookFriendList();
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onContactPermissionChange(KvoEventIntent event) {
        if (this.mContactState == null || this.mContactState.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        this.onPermissionChange(1);
        MLog.info((Object)TAG, (String)("onContactPermissionChange:" + this.mContactState.permissionState), (Object[])new Object[0]);
        if (this.mContactState.permissionState == CheckStatus.AUTH && this.mContactState.checkNeedUpload != null && !this.mContactState.checkNeedUpload.need) {
            this.checkUploadContacts();
            return;
        }
        this.startUploadContacts();
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onLocationPermissionChange(KvoEventIntent event) {
        if (this.mLocationState == null || this.mLocationState.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        this.onPermissionChange(2);
        MLog.info((Object)TAG, (String)("onLocationPermissionChange:" + this.mLocationState.permissionState), (Object[])new Object[0]);
        if (this.mLocationState.permissionState == CheckStatus.AUTH) {
            LocationHelper.location();
            this.mLocationState.setValue("hasUpload", (Object)true);
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onZaloPermissionChange(KvoEventIntent event) {
        if (this.mZaloState == null || this.mZaloState.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        this.onPermissionChange(3);
        MLog.info((Object)TAG, (String)("onZaloPermissionChange:" + this.mZaloState.permissionState), (Object[])new Object[0]);
        if (this.mZaloState.permissionState == CheckStatus.AUTH) {
            this.mZaloState.setValue("hasUpload", (Object)true);
        }
    }

    @KvoMethodAnnotation(name="hasUpload", sourceClass=CheckStatus.class)
    public void onUploadFBEvent(KvoEventIntent event) {
        if (this.mFacebookState == null) {
            return;
        }
        boolean hasUpload = this.mFacebookState.hasUpload;
        MLog.info((Object)TAG, (String)("onUploadFBEvent hasUpload:" + hasUpload + " hasFastCheck:" + this.mFacebookState.hasFastCheck), (Object[])new Object[0]);
        if (hasUpload) {
            this.mFacebookState.hasFastCheck = true;
            this.mCacheTask.mFbFastCheck = true;
            this.mCacheTask.setStrategy(false, false, LoadDataStrategy.createFindFriendPageStrategy(), LoadDataStrategy.createSecondBindReturnStrategy(0), LoadDataStrategy.createFirstBindReturnStrategy(0));
        }
    }

    @KvoMethodAnnotation(name="hasUpload", sourceClass=CheckStatus.class)
    public void onUploadContactEvent(KvoEventIntent event) {
        if (this.mContactState == null) {
            return;
        }
        boolean hasUpload = this.mContactState.hasUpload;
        MLog.info((Object)TAG, (String)("onUploadContactEvent hasUpload:" + hasUpload + " hasFastCheck:" + this.mContactState.hasFastCheck), (Object[])new Object[0]);
        if (hasUpload && !this.mContactState.hasFastCheck) {
            this.mContactState.hasFastCheck = true;
            this.mCacheTask.mContactFastCheck = true;
            this.mCacheTask.setStrategy(false, false, LoadDataStrategy.createFindFriendPageStrategy(), LoadDataStrategy.createSecondBindReturnStrategy(1), LoadDataStrategy.createFirstBindReturnStrategy(1));
        }
    }

    @KvoMethodAnnotation(name="hasUpload", sourceClass=CheckStatus.class)
    public void onUploadLocationEvent(KvoEventIntent event) {
        if (this.mLocationState == null) {
            return;
        }
        boolean hasUpload = this.mLocationState.hasUpload;
        MLog.info((Object)TAG, (String)("onUploadLocationEvent hasUpload:" + hasUpload + " hasFastCheck:" + this.mLocationState.hasFastCheck), (Object[])new Object[0]);
        if (hasUpload && !this.mLocationState.hasFastCheck) {
            this.mLocationState.hasFastCheck = true;
            this.mCacheTask.mLocationFastCheck = true;
            this.mCacheTask.setStrategy(false, false, LoadDataStrategy.createFindFriendPageStrategy(), LoadDataStrategy.createSecondBindReturnStrategy(2), LoadDataStrategy.createFirstBindReturnStrategy(2));
        }
    }

    @KvoMethodAnnotation(name="findFriendList", sourceClass=PlatformPermissionModuleData.class, thread=1)
    public void onFindFriendList(KvoEventIntent event) {
        List friends = (List)event.caseNewValue(new ArrayList());
        this.parseShowData(friends);
        this.reportDatas(friends);
    }

    @KvoMethodAnnotation(name="mNewFriendsUids", sourceClass=NewFriendsData.class)
    public void onNewFriendsUpdate(KvoEventIntent event) {
        KvoListHelper.KvoListChangeType type = KvoListHelper.getNotifyType((KvoEventIntent)event);
        if (type != KvoListHelper.KvoListChangeType.KvoEventArg_Type_Insert) {
            return;
        }
        List list = (List)event.newValue();
        KvoListHelper.NSRange range = KvoListHelper.getNotifyRange((KvoEventIntent)event);
        List uids = list.subList(range.position, range.position + range.length);
        if (uids.isEmpty()) {
            return;
        }
        for (Long uid : uids) {
            if (this.mNewFriendUids.contains(uid)) continue;
            this.mNewFriendUids.add(uid);
            this.findAndSetNewFriend(uid);
        }
        ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).clearNewFriends();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseShowData(final List<FindFriend> friends) {
        Object object = this.mLock;
        synchronized (object) {
            boolean isShowGuide = false;
            int onLineFriendsCount = 0;
            ArrayList<FriendItem> hagoFriends = new ArrayList<FriendItem>();
            ArrayList<FriendItem> offlineFriends = new ArrayList<FriendItem>();
            ArrayList<FriendItem> onlineFriends = new ArrayList<FriendItem>();
            this.mFriendItems = new ArrayList<FriendItem>();
            if (friends != null && !friends.isEmpty()) {
                UserInfoModule module = (UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class);
                boolean shouldCheckMatch = this.mCacheTask.mCurStrategy != null && this.mCacheTask.mCurStrategy.isValid() && ((MaxLimitCacheTask)this.mCacheTask).mCurStrategy.targetMatch != -1;
                boolean shouldRemoveFastReq = false;
                for (FindFriend friend : friends) {
                    long type;
                    if (friend.isOnline()) {
                        ++onLineFriendsCount;
                    }
                    if (this.mNewFriendUids.contains(friend.getUid())) {
                        friend.setNewFirend(true);
                    } else {
                        friend.setNewFirend(false);
                    }
                    RelationInfo info = ((IRelationService)this.getServiceManager().getService(IRelationService.class)).getRelationLocal(friend.getUid());
                    FriendItem friendItem = new FriendItem(friend, info);
                    if (friend.getType() == 3L) {
                        hagoFriends.add(friendItem);
                    } else if (!friend.isOnline()) {
                        offlineFriends.add(friendItem);
                    } else {
                        onlineFriends.add(friendItem);
                    }
                    if (shouldCheckMatch && !shouldRemoveFastReq && friend.getType() == (long)((MaxLimitCacheTask)this.mCacheTask).mCurStrategy.targetMatch) {
                        MLog.info((Object)TAG, (String)("has match type data,clear fast request:" + ((MaxLimitCacheTask)this.mCacheTask).mCurStrategy.targetMatch), (Object[])new Object[0]);
                        shouldRemoveFastReq = true;
                    }
                    if ((type = friend.getType()) == 2L) {
                        this.mCacheTask.mLocationFastCheck = false;
                        continue;
                    }
                    if (type == 1L) {
                        this.mCacheTask.mContactFastCheck = false;
                        continue;
                    }
                    if (type != 0L) continue;
                    this.mCacheTask.mFbFastCheck = false;
                }
                if (shouldRemoveFastReq) {
                    this.mCacheTask.setStrategy(false, true, LoadDataStrategy.createFindFriendPageStrategy());
                }
            }
            this.initOnlineFriendsNumConfig();
            PlatformPermissionModuleData data2 = (PlatformPermissionModuleData)KvoModuleManager.getModuleData(PlatformPermissionModule.class);
            if (data2.friendsListStatus.isSuccess() && onLineFriendsCount < this.onLineFriendsNum) {
                isShowGuide = true;
            }
            this.mShowDatas = new ArrayList<FindFriendItem>();
            this.mShowDatas.add(new SearchFriendItem());
            this.mShowDatas.add(new GameFaceItem());
            if (NAB.A.equals((Object)NewABDefine.DISCOVER_PEOPLE_CREAT_GROUP.getTest())) {
                this.mShowDatas.add(new CreateGroupItem());
                this.reportPlayTogether();
            }
            if (this.inviteData == null) {
                this.inviteData = new InviteData();
            }
            this.mShowDatas.add(new InviteFriendItem(this.inviteData));
            this.requestGuideType(isShowGuide);
            this.mChannelItems.clear();
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)"vanda", (String)("mZaloState.permissionState = " + (this.mZaloState == null ? "null" : Integer.valueOf(this.mZaloState.permissionState))), (Object[])new Object[0]);
            }
            if (AccountUtil.isShowZaloBind() && this.mZaloState != null && this.mZaloState.permissionState == CheckStatus.UNAUTH) {
                this.mChannelItems.add(new ChannelItem(6));
            }
            if (this.mLocationState != null && this.mLocationState.permissionState == CheckStatus.UNAUTH) {
                this.mChannelItems.add(new ChannelItem(2));
            }
            if (!AccountUtil.hideFacebookBind()) {
                if (this.mFacebookState != null && this.mFacebookState.permissionState == CheckStatus.UNAUTH) {
                    MLog.info((Object)TAG, (String)("guide fb status:" + this.mFacebookState.permissionState), (Object[])new Object[0]);
                    this.mChannelItems.add(new ChannelItem(1));
                }
                if (this.mFacebookState != null && this.mFacebookState.permissionState == CheckStatus.EXPIRE) {
                    MLog.info((Object)TAG, (String)("guide fb status:" + this.mFacebookState.permissionState), (Object[])new Object[0]);
                    this.mChannelItems.add(new ChannelItem(4));
                }
            }
            if (this.mContactState != null && this.mContactState.permissionState == CheckStatus.UNAUTH) {
                this.mChannelItems.add(new ChannelItem(3));
            }
            this.sortHagoFriends(hagoFriends);
            this.mFriendItems.addAll(onlineFriends);
            this.mFriendItems.addAll(hagoFriends);
            this.mFriendItems.addAll(offlineFriends);
            ChannelListData channelListData = new ChannelListData();
            channelListData.setChannelList(this.mChannelItems);
            channelListData.setShowTitle(!FP.empty(this.mFriendItems));
            this.mShowDatas.add(new ChannelListComponentItem(channelListData));
            this.mShowDatas.addAll(this.mFriendItems);
            int adLineNumber = ((IAdService)this.getServiceManager().getService(IAdService.class)).getAdLineNumber(4);
            if (adLineNumber != -1) {
                int friendSize;
                int showDataSize = this.mShowDatas.size();
                if ((adLineNumber += showDataSize - (friendSize = this.mFriendItems.size())) < 0) {
                    adLineNumber = 0;
                }
                if (showDataSize < adLineNumber) {
                    adLineNumber = showDataSize;
                }
                AdContainerItem adContainerItem = new AdContainerItem();
                this.mShowDatas.add(adLineNumber, adContainerItem);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (FindFriendControllerV1.this.mWindow != null) {
                        FindFriendControllerV1.this.mWindow.setDatas(FindFriendControllerV1.this.mShowDatas);
                        FindFriendControllerV1.this.mWindow.onSuccess(friends != null && !friends.isEmpty());
                    }
                }
            });
        }
    }

    private boolean isZaloLoginType() {
        return AccountUtil.getUid() > 0L && AccountUtil.getsLoginType() == 7;
    }

    private void sortHagoFriends(List<FriendItem> hagoFriends) {
        if (!this.mChatSessionsReady) {
            return;
        }
        if (this.mChatSessions.isEmpty()) {
            return;
        }
        if (hagoFriends == null) {
            return;
        }
        ArrayList<FriendItem> tmpList = new ArrayList<FriendItem>();
        tmpList.addAll(hagoFriends);
        hagoFriends.clear();
        block0: for (IChatSession chatSession : this.mChatSessions) {
            long uid = chatSession.getUid();
            for (int i = 0; i < tmpList.size(); ++i) {
                FriendItem friendItem = (FriendItem)tmpList.get(i);
                if (friendItem.data().mFriend.getUid() != uid) continue;
                hagoFriends.add(friendItem);
                tmpList.remove(i);
                continue block0;
            }
        }
        hagoFriends.addAll(tmpList);
    }

    @Override
    public void onFuncClick(PermissionData permissionData, int position) {
        if (!this.canClick()) {
            return;
        }
        if (permissionData.type == 0) {
            this.facebookAction();
        } else if (permissionData.type == 3) {
            this.facebookExpireAction();
        } else if (permissionData.type == 2) {
            this.contactAction();
        } else if (permissionData.type == 1) {
            this.locationAction();
        }
    }

    private void locationAction() {
        PermissionHelper.requestLocationPermission((Activity)this.getActivity(), (IPermissionListener)new IPermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                if (FindFriendControllerV1.this.mLocationState != null) {
                    FindFriendControllerV1.this.mLocationState.setValue("permissionState", (Object)CheckStatus.AUTH);
                    ToastUtils.showToast((Context)FindFriendControllerV1.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_connect_success), (int)1);
                }
            }

            public void onPermissionDenied(@NonNull String[] permission) {
                if (FindFriendControllerV1.this.mLocationState != null) {
                    FindFriendControllerV1.this.mLocationState.setValue("permissionState", (Object)CheckStatus.UNAUTH);
                }
            }
        }, (boolean)true);
    }

    @Override
    public void onFuncClick(Guide current, int position) {
        if (!this.canClick()) {
            return;
        }
        if (current.type == 1) {
            this.facebookAction();
        } else if (current.type == 4) {
            this.facebookExpireAction();
        } else if (current.type == 3) {
            this.contactAction();
        } else if (current.type == 2) {
            this.locationAction();
        } else if (current.type == 0) {
            this.sendMessage(BaseMsgDef.MSG_SHARE_LIST);
            this.reportInviteClick();
        }
    }

    @Override
    public void onFindChannelClick(ChannelItem channelItem) {
        if (channelItem == null) {
            return;
        }
        int type = channelItem.getType();
        if (type == 3) {
            this.contactAction();
        } else if (type == 2) {
            this.locationAction();
        } else if (type == 1) {
            this.facebookAction();
        } else if (type == 4) {
            this.facebookExpireAction();
        } else if (type == 6) {
            this.zaloAction();
        }
    }

    private void updateZaloItem() {
        if (this.mChannelItems.size() >= 1 && this.mChannelItems.get(0).getType() == 6) {
            this.mChannelItems.remove(0);
            this.mWindow.updateAdapter();
        }
    }

    private void zaloAction() {
        if (this.isZaloLoginType()) {
            return;
        }
        if (AccountUtil.isLoginByGuest()) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_GUEST_LOGIN_WITH_TYPE;
            Bundle bundle = new Bundle();
            bundle.putInt("key_login_type", 7);
            bundle.putInt("key_login_source", 6);
            msg.setData(bundle);
            MsgDispatcher.getInstance().sendMessage(msg);
        } else {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindZalo((Object)new IBindThirdPartyAccountCallBack(){

                public void onSuccess() {
                    FindFriendControllerV1.this.updateZaloItem();
                }

                public void onCancel() {
                }

                public void onError(int errorCode, Exception e) {
                }
            });
        }
    }

    private void contactAction() {
        PermissionHelper.requestContactPermission((Activity)this.getActivity(), (IPermissionListener)new IPermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                if (FindFriendControllerV1.this.mContactState != null) {
                    FindFriendControllerV1.this.mContactState.setValue("permissionState", (Object)CheckStatus.AUTH);
                    ToastUtils.showToast((Context)FindFriendControllerV1.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_connect_success), (int)1);
                }
            }

            public void onPermissionDenied(@NonNull String[] permission) {
                if (FindFriendControllerV1.this.mContactState != null) {
                    FindFriendControllerV1.this.mContactState.setValue("permissionState", (Object)CheckStatus.UNAUTH);
                }
            }
        });
    }

    private void facebookAction() {
        if (this.mFacebookState == null) {
            return;
        }
        if (AccountUtil.isLoginByGuest()) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_GUEST_LOGIN_WITH_TYPE;
            Bundle bundle = new Bundle();
            bundle.putInt("key_login_type", 1);
            bundle.putInt("key_login_source", 5);
            msg.setData(bundle);
            this.sendMessage(msg);
        } else if (this.mFacebookState.permissionState == CheckStatus.UNAUTH) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindFacebook((Object)this.mCallbackProvider.getBindCallBack());
        } else if (this.mFacebookState.permissionState == CheckStatus.EXPIRE) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).authFacebook((Object)this.mCallbackProvider.getAuthCallback());
        }
    }

    private void facebookExpireAction() {
        if (this.mFacebookState == null) {
            return;
        }
        if (this.mFacebookState.permissionState == CheckStatus.EXPIRE) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).authFacebook((Object)this.mCallbackProvider.getAuthCallback());
        }
    }

    @Override
    public void onSearchClick() {
        if (!this.canClick()) {
            return;
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationBaseDef.IM_POP_SEARCH_FRIENDS_PAGE, (Object)1));
        this.reportFindClick();
    }

    @Override
    public void onShareInviteClick(int channelId) {
        if (!this.canClick()) {
            return;
        }
        this.sendMessage(BaseMsgDef.MSG_SHARE_FIND_FRIEND, channelId, 7, this.mIsNewInForShare);
        this.mIsNewInForShare = false;
        this.reportShareClick(channelId);
    }

    private void findAndSetNewFriend(long uid) {
        if (this.mFriendItems == null) {
            return;
        }
        for (FriendItem friendItem : this.mFriendItems) {
            FindFriend friend = friendItem.data().mFriend;
            if (friend == null || friend.getUid() != uid) continue;
            if (friend.isNewFirend()) break;
            friend.setNewFirend(true);
            this.findAndUpdateItem(friendItem);
            break;
        }
    }

    private void findAndUpdateItem(FriendItem item) {
        if (this.mShowDatas == null || item == null) {
            return;
        }
        int position = this.mShowDatas.indexOf(item);
        if (position < 0 || position >= this.mShowDatas.size()) {
            return;
        }
        if (this.mWindow != null) {
            this.mWindow.updateItem(position);
        }
        this.checkShowMoreNewFriends();
    }

    private void setNewFriendNot(FriendData data2, int position) {
        if (data2 == null) {
            return;
        }
        if (data2.mFriend == null) {
            return;
        }
        long uid = data2.mFriend.getUid();
        this.mNewFriendUids.remove(uid);
        data2.mFriend.setNewFirend(false);
        if (this.mWindow != null) {
            this.mWindow.updateItem(position);
        }
    }

    @Override
    public void onFriendItemClick(FriendData data2, int position) {
        if (!this.canClick()) {
            return;
        }
        ImPageSourceData imPageBean = new ImPageSourceData(data2.mFriend.getUid(), 2);
        if (ServiceManagerProxy.getService(ImService.class) != null) {
            ((ImService)ServiceManagerProxy.getService(ImService.class)).openImPage(imPageBean);
        }
        this.reportListClick(data2.mFriend);
        this.setNewFriendNot(data2, position);
    }

    @Override
    public void onAvatarClick(FriendData data2, int position) {
        if (!this.canClick()) {
            return;
        }
        ProfileReportBean bean = new ProfileReportBean();
        bean.setUid(Long.valueOf(data2.mFriend.getUid()));
        bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getPlayWithFriends()));
        bean.setSource(3);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.OPEN_USER_NEW_PROFILE, (Object)bean));
        this.reportHeadClick(data2.mFriend);
        this.setNewFriendNot(data2, position);
    }

    @Override
    public void onPlayClick(FriendData data2, int position) {
        if (!this.canClick()) {
            return;
        }
        ImPageSourceData imPageBean = new ImPageSourceData(data2.mFriend.getUid(), 2);
        if (ServiceManagerProxy.getService(ImService.class) != null) {
            ((ImService)ServiceManagerProxy.getService(ImService.class)).openImPage(imPageBean);
        }
        if (data2.mFriend.getOnlineStatus() == 1L) {
            this.reportOnlineClick(data2.mFriend);
        }
        this.setNewFriendNot(data2, position);
    }

    @Override
    public void autoRefresh() {
        if (FIRST_LOAD_FRIEND_DATA) {
            this.mCacheTask.setStrategy(true, false, LoadDataStrategy.createFindFriendPageStrategy(), LoadDataStrategy.createEnterPageStrategy());
        } else {
            this.mCacheTask.setStrategy(false, false, LoadDataStrategy.createFindFriendPageStrategy(), LoadDataStrategy.createImmeStrategy());
        }
    }

    @Override
    public void updateIsGuideOpen(boolean isOpen) {
        isGuideOpen = isOpen;
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("function_id", "click_pop").put("pop_open_type", isOpen ? "1" : "2"));
    }

    @Override
    public void onGameFaceClick() {
        this.sendMessage(MsgGameDefProvider.SELECT_SAMESCREEN);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("function_id", "game_with_friend"));
    }

    @Override
    public void onCreateGroupClick() {
        CreateChannelParams params = CreateChannelParams.obtain((String)"", (int)CreateChannelParams.From.PLAY_WITH_FRIENDS);
        ChannelCreatorControllerEnter.INSTANCE.go(params, true);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023771").put("function_id", "discover_people_play_together_click"));
    }

    @Override
    public List<BaseShareChannel> getChannels() {
        return ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).getChannelsByPage((ISharePage)this);
    }

    @Override
    public void moveNewFriendToTop() {
        if (this.mShowDatas == null || this.mFriendItems == null) {
            return;
        }
        FriendItem firstNewNotShowItem = null;
        for (FriendItem friendItem : this.mFriendItems) {
            FriendData data2 = friendItem.data();
            if (data2 == null || data2.mIsShown || !data2.mFriend.isNewFirend()) continue;
            firstNewNotShowItem = friendItem;
            break;
        }
        if (firstNewNotShowItem == null) {
            return;
        }
        int position = this.mShowDatas.indexOf(firstNewNotShowItem);
        if (position < 0 || position >= this.mShowDatas.size()) {
            return;
        }
        if (this.mWindow != null) {
            this.mWindow.scrollToPosition(position);
        }
    }

    public void checkShowMoreNewFriends() {
        if (this.mWindow != null) {
            this.mWindow.isShowMoreNewFriends(this.hasNewFriendNotShow());
        }
    }

    @Override
    public void updateLastVisibleItemPosition(int position) {
        if (this.mFriendItems == null || this.mShowDatas == null) {
            return;
        }
        int otherItemSize = this.mShowDatas.size() - this.mFriendItems.size();
        if (position < otherItemSize) {
            return;
        }
        int lastVisiblePosition = position - otherItemSize;
        for (int i = 0; i <= lastVisiblePosition && i < this.mFriendItems.size(); ++i) {
            FriendItem friendItem = this.mFriendItems.get(i);
            friendItem.data().mIsShown = true;
        }
        this.checkShowMoreNewFriends();
    }

    @Override
    public void loadAd(final ViewGroup adContainerParent, ViewGroup adContainer) {
        ((IAdService)this.getServiceManager().getService(IAdService.class)).loadAd(4, adContainer, new IAdCallback(){

            public void onAdLoadSuccess(AdEntity adEntity) {
                if (adContainerParent != null) {
                    ViewGroup.LayoutParams layoutParams2 = adContainerParent.getLayoutParams();
                    layoutParams2.width = -1;
                    layoutParams2.height = -2;
                    adContainerParent.setLayoutParams(layoutParams2);
                    adContainerParent.setVisibility(0);
                }
            }

            public void onError(int code, String error) {
            }

            public void onAdClickClose() {
                super.onAdClickClose();
                if (adContainerParent != null) {
                    ViewGroup.LayoutParams layoutParams2 = adContainerParent.getLayoutParams();
                    layoutParams2.width = 0;
                    layoutParams2.height = 0;
                    adContainerParent.setLayoutParams(layoutParams2);
                }
            }
        });
    }

    @Override
    public boolean hasNewFriendNotShow() {
        if (this.mFriendItems == null || this.mFriendItems.isEmpty()) {
            return false;
        }
        if (this.mNewFriendUids.isEmpty()) {
            return false;
        }
        for (int i = this.mFriendItems.size() - 1; i >= 0; --i) {
            FriendItem friendItem = this.mFriendItems.get(i);
            FriendData data2 = friendItem.data();
            if (data2 == null || data2.mIsShown || !data2.mFriend.isNewFirend()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIntlShareService getShareService() {
        return (IIntlShareService)this.getServiceManager().getService(IIntlShareService.class);
    }

    @Override
    public int getGuideType() {
        return this.mGuideType;
    }

    @Override
    public Map<String, String> getShareConfig() {
        return ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).getShareConfigByPage("play_with_friends");
    }

    @Override
    public void showProgress() {
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
    }

    @Override
    public void dismissProgress() {
        this.mDialogLinkManager.dismissDialog();
    }

    private boolean isAtTop() {
        return this.mWindow != null && this.mWindowMgr.getCurrentWindow() == this.mWindow;
    }

    @Override
    public void onNetWorkErr() {
        if (this.isAtTop()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)FindFriendControllerV1.this.mContext, (int)R.string.check_network_and_retry, (int)0);
                }
            });
        }
    }

    public String getPageName() {
        return "new_play_with_friends";
    }

    private boolean canClick() {
        long cur = System.currentTimeMillis();
        if (Math.abs(cur - this.mLastClickTs) > 300L) {
            this.mLastClickTs = cur;
            return true;
        }
        return false;
    }

    private void report(String funcId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("page_id", "find_friends").put("function_id", funcId));
    }

    private void reportPlayTogether() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023771").put("function_id", "discover_people_play_together_show"));
    }

    private void reportOnlineClick(FindFriend findFriend) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("page_id", "find_friends").put("function_id", "online_friends_click").put("friend_type", this.getFriendType(findFriend)).put("uid", String.valueOf(findFriend.getUid())));
    }

    private void reportOnlineAdd(FindFriend findFriend) {
        if (findFriend != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("page_id", "find_friends").put("function_id", "online_friends_add").put("friend_type", this.getFriendType(findFriend)).put("uid", String.valueOf(findFriend.getUid())));
        }
    }

    private String getFriendType(FindFriend findFriend) {
        if (findFriend != null) {
            String typeStr;
            JsonObject jsonObject = new JsonObject();
            long typeInt = findFriend.getType();
            String string2 = typeInt == 0L ? "fb" : (typeInt == 1L ? "contacts" : (typeStr = typeInt == 2L ? "nearby" : "hago_friend"));
            if (typeInt == 5L) {
                typeStr = "inviter";
            }
            if (typeInt == 6L) {
                typeStr = "invitee";
            }
            jsonObject.addProperty("source", typeStr);
            jsonObject.addProperty("online", (Number)(findFriend.getOnlineStatus() == 1L ? 1 : 0));
            jsonObject.addProperty("add_flag", (Number)(findFriend.getbHagoFriend() == 1L ? 1 : 0));
            return jsonObject.toString();
        }
        return "";
    }

    private void requestGuideType(final boolean isShowGuide) {
        if (this.mHadRequestGuideType) {
            return;
        }
        this.mHadRequestGuideType = true;
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getFindFriendGuideType(AccountUtil.getUid(), new OnGetGuideTypeCallback(){

            public void onGetGuideTypeSuccess(int guideType) {
                if (FindFriendControllerV1.this.inviteData == null) {
                    return;
                }
                if (guideType == 1) {
                    FindFriendControllerV1.this.mGuideType = 1;
                    FindFriendControllerV1.this.inviteData.setGuideOpen(isGuideOpen);
                    FindFriendControllerV1.this.inviteData.setNeedShowGuide(true);
                    FindFriendControllerV1.this.inviteData.setBubbleContent(ResourceUtils.getString((int)R.string.tips_share_pk_game_guide));
                } else if (guideType == 2) {
                    FindFriendControllerV1.this.mGuideType = 2;
                    FindFriendControllerV1.this.inviteData.setNeedShowGuide(true);
                    FindFriendControllerV1.this.inviteData.setGuideOpen(isGuideOpen);
                    FindFriendControllerV1.this.inviteData.setBubbleContent(ResourceUtils.getString((int)R.string.tips_share_single_game_guide));
                } else if (FindFriendControllerV1.this.enterFriendsTimes < 3) {
                    FindFriendControllerV1.this.mGuideType = 3;
                    FindFriendControllerV1.this.inviteData.setGuideOpen(isGuideOpen);
                    FindFriendControllerV1.this.inviteData.setNeedShowGuide(true);
                    FindFriendControllerV1.this.inviteData.setBubbleContent(ResourceUtils.getString((int)R.string.face_pk_guide));
                } else if (isShowGuide) {
                    FindFriendControllerV1.this.mGuideType = 4;
                    FindFriendControllerV1.this.inviteData.setNeedShowGuide(true);
                    FindFriendControllerV1.this.inviteData.setGuideOpen(isGuideOpen);
                    FindFriendControllerV1.this.inviteData.setBubbleContent(ResourceUtils.getString((int)R.string.invite_friends_guide));
                } else {
                    FindFriendControllerV1.this.mGuideType = 0;
                    FindFriendControllerV1.this.inviteData.setNeedShowGuide(false);
                }
                if (FindFriendControllerV1.this.mWindow != null) {
                    FindFriendControllerV1.this.mWindow.updateAdapter();
                }
                FindFriendControllerV1.this.reportPopType(FindFriendControllerV1.this.mGuideType);
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    private void reportOfflineAdd(FindFriend findFriend) {
        if (findFriend != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("page_id", "find_friends").put("function_id", "offline_friends_add").put("friend_type", this.getFriendType(findFriend)).put("uid", String.valueOf(findFriend.getUid())));
        }
    }

    private void reportFindClick() {
        this.report("friends_find_click");
    }

    private void reportListClick(FindFriend findFriend) {
        if (findFriend != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("page_id", "find_friends").put("function_id", "list_click").put("friend_type", this.getFriendType(findFriend)).put("uid", String.valueOf(findFriend.getUid())));
        }
    }

    private void reportHeadClick(FindFriend findFriend) {
        if (findFriend != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("page_id", "find_friends").put("function_id", "head_click").put("friend_type", this.getFriendType(findFriend)).put("uid", String.valueOf(findFriend.getUid())));
        }
    }

    private void reportInviteClick() {
        this.report("invite_click");
    }

    private void reportHasAddFriends() {
        this.report("have_add_friends");
    }

    private void reportShareClick(int channelId) {
        if (channelId == 11) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "3").put("page_id", "7"));
            return;
        }
        String reportChannel = ShareChannelIdDef.getReportChannel((int)channelId);
        if (StringUtils.isNotEmpty((String)reportChannel)) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "7").put("share_channel", reportChannel));
        }
    }

    private void reportPopType(int type) {
        int popType = -1;
        switch (type) {
            case 0: {
                popType = 1;
                break;
            }
            case 3: {
                popType = 3;
                break;
            }
            case 4: {
                popType = 2;
                break;
            }
            case 1: {
                popType = 4;
                break;
            }
            case 2: {
                popType = 5;
                break;
            }
        }
        if (popType > 0) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("page_id", "find_friends").put("pop_type", "" + popType));
        }
    }

    private void reportDatas(List<FindFriend> friends) {
        if (friends == null) {
            friends = new ArrayList<FindFriend>();
        }
        final ArrayList<FindFriend> fFriends = new ArrayList<FindFriend>(friends);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                int fbOnline = 0;
                int contactOnline = 0;
                int nearOnline = 0;
                int hagoOnline = 0;
                int fbOffline = 0;
                int contactOffline = 0;
                int newFriends = 0;
                if (fFriends != null && !fFriends.isEmpty()) {
                    boolean hasAddFriends = false;
                    for (FindFriend findFriend : fFriends) {
                        boolean online;
                        if (!hasAddFriends) {
                            hasAddFriends = findFriend.getbHagoFriend() == 0L;
                            FindFriendControllerV1.this.reportHasAddFriends();
                        }
                        long type = findFriend.getType();
                        boolean bl = online = findFriend.getOnlineStatus() == 1L;
                        if (type == 0L) {
                            if (online) {
                                ++fbOnline;
                            } else {
                                ++fbOffline;
                            }
                        } else if (type == 1L) {
                            if (online) {
                                ++contactOnline;
                            } else {
                                ++contactOffline;
                            }
                        } else if (type == 2L && online) {
                            ++nearOnline;
                        } else if (type == 3L && online) {
                            ++hagoOnline;
                        }
                        if (!findFriend.isNewFirend()) continue;
                        ++newFriends;
                    }
                }
                boolean fbBind = FindFriendControllerV1.this.mFacebookState != null && (((FindFriendControllerV1)FindFriendControllerV1.this).mFacebookState.checkNeedUpload != null && !((FindFriendControllerV1)FindFriendControllerV1.this).mFacebookState.checkNeedUpload.need || ((FindFriendControllerV1)FindFriendControllerV1.this).mFacebookState.permissionState == CheckStatus.AUTH);
                boolean contactAuth = FindFriendControllerV1.this.mContactState != null && (((FindFriendControllerV1)FindFriendControllerV1.this).mContactState.checkNeedUpload != null && !((FindFriendControllerV1)FindFriendControllerV1.this).mContactState.checkNeedUpload.need || ((FindFriendControllerV1)FindFriendControllerV1.this).mContactState.permissionState == CheckStatus.AUTH);
                boolean locationAuth = FindFriendControllerV1.this.mLocationState != null && ((FindFriendControllerV1)FindFriendControllerV1.this).mLocationState.permissionState == CheckStatus.AUTH;
                JsonObject friendsNum = new JsonObject();
                friendsNum.addProperty("fb_online", (Number)fbOnline);
                friendsNum.addProperty("contact_online", (Number)contactOnline);
                friendsNum.addProperty("nearby_online", (Number)nearOnline);
                friendsNum.addProperty("hago_online", (Number)hagoOnline);
                friendsNum.addProperty("fb_offline", (Number)fbOffline);
                friendsNum.addProperty("contact_offline", (Number)contactOffline);
                friendsNum.addProperty("new_friend", (Number)newFriends);
                JsonObject stateId = new JsonObject();
                stateId.addProperty("bind_fb", (Number)(fbBind ? 1 : 0));
                stateId.addProperty("auth_contact", (Number)(contactAuth ? 1 : 0));
                stateId.addProperty("auth_location", (Number)(locationAuth ? 1 : 0));
                String stateStr = stateId.toString();
                String friendSum = friendsNum.toString();
                MLog.info((Object)FindFriendControllerV1.TAG, (String)("report data func:" + stateStr + " friendsNum:" + friendSum), (Object[])new Object[0]);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025223").put("page_id", "find_friends").put("state_id", stateStr).put("friends_num", friendSum).put("function_id", "show"));
            }
        });
    }

    private static class MaxLimitCacheTask {
        private long mLastUpdateTime = 0L;
        private Stack<LoadDataStrategy> mCacheStacks = new Stack();
        private LoadDataStrategy mCurStrategy;
        private final Object mLock = new Object();
        private IFindCallback callback;
        private boolean mFbFastCheck;
        private boolean mContactFastCheck;
        private boolean mLocationFastCheck;
        private Runnable excuteTask = new Runnable(){

            @Override
            public void run() {
                if (KvoModuleManager.isKvoInitEnved()) {
                    this.loadFriendsData();
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            KvoModuleManager.addInitEnvCallback((KvoModuleManager.InitEnvCallback)new KvoModuleManager.InitEnvCallback(){

                                public void onInitEnv() {
                                    YYTaskExecutor.execute((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            this.loadFriendsData();
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadFriendsData() {
                LoadDataStrategy strategy = mCurStrategy;
                if (strategy == null || !strategy.isValid()) {
                    mCurStrategy = null;
                    return;
                }
                mLastUpdateTime = System.currentTimeMillis();
                List list = ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).loadFriendsData((Object)this, strategy.limits, new ILoadFindFriendsData(){

                    public void onLoadSuccess(Object ctx, List<FindFriend> ret, int inputLimit) {
                    }

                    public void onLoadError(Object ctx, int inputLimit, String msg, int errCode) {
                        if (callback != null) {
                            callback.onNetWorkErr();
                        }
                    }

                    public boolean onRetry(Object ctx, int inputLimit) {
                        return false;
                    }
                });
                MLog.info((Object)FindFriendControllerV1.TAG, (String)("excute load data task" + mLastUpdateTime), (Object[])new Object[0]);
                Object object = mLock;
                synchronized (object) {
                    if (mCurStrategy != null) {
                        mCurStrategy.countDown();
                    }
                    if (mCurStrategy != null && mCurStrategy.isValid()) {
                        this.executeTask(((MaxLimitCacheTask)this).mCurStrategy.timeInterval);
                    } else if (!mCacheStacks.isEmpty()) {
                        mCurStrategy = (LoadDataStrategy)mCacheStacks.pop();
                        if (mCurStrategy != null && mCurStrategy.isValid()) {
                            this.executeTask(((MaxLimitCacheTask)this).mCurStrategy.timeInterval);
                        } else {
                            mCurStrategy = null;
                        }
                    }
                }
            }
        };

        MaxLimitCacheTask(IFindCallback callback) {
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setStrategy(boolean invokeInme, boolean checkLastTime, LoadDataStrategy ... strategys) {
            Object object = this.mLock;
            synchronized (object) {
                this.clear();
                if (strategys == null || strategys.length == 0) {
                    return;
                }
                for (LoadDataStrategy strategy : strategys) {
                    if (strategy == null || !strategy.isValid()) continue;
                    this.mCacheStacks.push(strategy);
                }
                this.mCurStrategy = this.mCacheStacks.pop();
                if (this.mCurStrategy == null) {
                    return;
                }
                if (!ProtoManager.getInstance().isWSConnected()) {
                    if (this.callback != null && !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                        this.callback.onNetWorkErr();
                    }
                    return;
                }
                if (invokeInme) {
                    this.executeTask(0L);
                } else if (checkLastTime) {
                    long distance = System.currentTimeMillis() - this.mLastUpdateTime;
                    if (distance > this.mCurStrategy.timeInterval) {
                        this.executeTask(0L);
                    } else {
                        long rest = this.mCurStrategy.timeInterval - distance;
                        this.executeTask(rest);
                    }
                } else {
                    this.executeTask(this.mCurStrategy.timeInterval);
                }
            }
        }

        private void clear() {
            this.mCurStrategy = null;
            this.mCacheStacks.clear();
            YYTaskExecutor.removeTask((Runnable)this.excuteTask);
        }

        private void reset() {
            this.mLastUpdateTime = 0L;
            FIRST_LOAD_FRIEND_DATA = true;
            this.clear();
        }

        synchronized void executeTask(long delay) {
            YYTaskExecutor.removeTask((Runnable)this.excuteTask);
            YYTaskExecutor.execute((Runnable)this.excuteTask, (long)delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasTask() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mCurStrategy != null && this.mCurStrategy.isValid();
            }
        }
    }

    private static class LoadDataStrategy {
        private static final int UNLIMIT = -1;
        long timeInterval;
        int times;
        int limits;
        int targetMatch = -1;

        static LoadDataStrategy createHomeStrategy() {
            return new LoadDataStrategy(60000L, 1, 30);
        }

        static LoadDataStrategy createFindFriendPageStrategy() {
            return new LoadDataStrategy(600000L, -1, 60);
        }

        static LoadDataStrategy createFirstBindReturnStrategy(int type) {
            return new LoadDataStrategy(3000L, 1, 60, type);
        }

        static LoadDataStrategy createSecondBindReturnStrategy(int type) {
            return new LoadDataStrategy(3000L, 4, 60, type);
        }

        static LoadDataStrategy createEnterPageStrategy() {
            return new LoadDataStrategy(60000L, 1, 60);
        }

        static LoadDataStrategy createImmeStrategy() {
            return new LoadDataStrategy(0L, 1, 60);
        }

        LoadDataStrategy(long timeInterval, int times, int limits) {
            this.timeInterval = timeInterval;
            this.times = times;
            this.limits = limits;
        }

        LoadDataStrategy(long timeInterval, int times, int limits, int targetMatch) {
            this.timeInterval = timeInterval;
            this.times = times;
            this.limits = limits;
            this.targetMatch = targetMatch;
        }

        public boolean isValid() {
            return (this.times == -1 || this.times > 0) && this.limits > 0 && this.timeInterval >= 0L;
        }

        public void countDown() {
            if (this.times != -1) {
                --this.times;
            }
        }
    }
}

