/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.filter;

import com.yy.im.filter.Filter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FilterManager<E> {
    private List<Filter<E>> mFilters = new ArrayList<Filter<E>>();

    public void addFilter(Filter<E> filter) {
        if (filter != null && !this.mFilters.contains(filter)) {
            this.mFilters.add(filter);
        }
    }

    public void removeFilter(Filter<E> filter) {
        if (filter != null) {
            this.mFilters.remove(filter);
        }
    }

    public void filter(List<E> input, OnFilterCallBack<E> callBack) {
        if (input == null || input.isEmpty()) {
            if (callBack != null) {
                callBack.onResult(input, input);
            }
            return;
        }
        if (this.mFilters == null || this.mFilters.isEmpty()) {
            if (callBack != null) {
                callBack.onResult(input, input);
            }
            return;
        }
        ArrayList<E> result = new ArrayList<E>(input);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            for (Filter filter : this.mFilters) {
                if (!filter.filter(element)) continue;
                iterator.remove();
            }
        }
        if (callBack != null) {
            callBack.onResult(input, result);
        }
    }

    public static interface OnFilterCallBack<E> {
        public void onResult(List<E> var1, List<E> var2);
    }
}

