/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.controller;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.hummer.im.model.chat.Message;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.OutOfLineBean;
import com.yy.appbase.im.ImPageSourceData;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IWebService;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.bean.CInterregion;
import com.yy.hiyo.channel.base.bean.unreadmsg.IChannelUnreadMsgPuller;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.im.IMsgDeleteCallback;
import com.yy.hiyo.im.IMsgReceiveService;
import com.yy.hiyo.im.IMsgSendService;
import com.yy.hiyo.im.ISuggestedFriendViewModel;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.OpenUserData;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.CimPullMsgResp;
import com.yy.hiyo.im.base.CimPullParams;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.hiyo.user.base.profilesource.ProfileSourceBean;
import com.yy.im.chatim.MsgReceiveService;
import com.yy.im.chatim.MsgSendServiceDelegate;
import com.yy.im.cim.CIMMsgRequest;
import com.yy.im.cim.CimPullMsgRespItem;
import com.yy.im.cim.CimPullParamsItem;
import com.yy.im.cim.CimUnreadMsgPuller;
import com.yy.im.controller.ImOufOfLineManager;
import com.yy.im.model.FriendRequest;
import com.yy.im.model.SearchFriend;
import com.yy.im.module.room.utils.ChatHistoryHelper;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.im.viewmodel.SuggestedFriendViewModel;
import com.yy.im.web.ImJsEventModule;
import com.yy.webservice.event.JsEvent;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.msg.PullType;

public class ImController
extends DefaultController
implements ImService {
    private IMsgSendService mIMsgSendService;
    private IMsgReceiveService mIMsgReceiveService;
    private Environment mBaseEnv;
    private long currentUid;
    private boolean registerJsEvent = false;

    public ImController(Environment env) {
        super(env);
        this.mBaseEnv = env;
        this.mIMsgSendService = new MsgSendServiceDelegate();
        this.mIMsgReceiveService = new MsgReceiveService(this.mContext);
        MLog.info((Object)"ImController", (String)"create", (Object[])new Object[0]);
    }

    @NonNull
    public IMsgSendService getSendService() {
        if (this.mIMsgSendService == null) {
            this.mIMsgSendService = new MsgSendServiceDelegate();
        }
        return this.mIMsgSendService;
    }

    @NonNull
    public IMsgReceiveService getReceiveMsg() {
        if (this.mIMsgReceiveService == null) {
            this.mIMsgReceiveService = new MsgReceiveService(this.mContext);
        }
        return this.mIMsgReceiveService;
    }

    public <T> void getIMHistory(int count, long targetUid, int queryType, @NonNull MyBox.IGetItemsCallBack<T> callBack) {
        this.clearUnusedKey(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        if (count > 0 && targetUid > 0L) {
            if (queryType == 1) {
                ChatHistoryHelper.queryTargetRecentHistoryMsg(this.getServiceManager(), targetUid, Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid), count, callBack);
            } else {
                ChatHistoryHelper.queryRecentHistoryMsg(this.getServiceManager(), 0L, Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid), count, callBack);
            }
        } else {
            callBack.onLoaded(null);
        }
    }

    public void openImPage(ImPageSourceData imPageBean) {
        long uid = imPageBean.getTargetUid();
        android.os.Message msg = android.os.Message.obtain();
        if (10L == uid || 14L == uid) {
            msg.what = AppbaseMsgDef.GOTO_OFFICIAL_MESSAGE_PAGE;
            Bundle bundle = new Bundle();
            bundle.putLong("target_uid", uid);
            bundle.putString("im_room_id", Utils.getSessionId((long)AccountUtil.getUid(), (long)uid));
            bundle.putBoolean("xiaolang_from_push", false);
            msg.setData(bundle);
            this.sendMessage(msg);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20044725").put("function_id", "hago_im_click"));
        } else if (13L == uid) {
            msg.what = AppbaseMsgDef.GOTO_RECHARGE_OFFICIAL_PAGE;
            Bundle bundle = new Bundle();
            bundle.putLong("target_uid", uid);
            msg.setData(bundle);
            this.sendMessage(msg);
        } else {
            msg.what = BaseMsgDef.IM_ROOM_SHOW;
            Bundle bundle = new Bundle();
            bundle.putLong("target_uid", uid);
            bundle.putInt("im_page_source", imPageBean.getSource());
            msg.setData(bundle);
            this.sendMessageSync(msg);
        }
    }

    private void clearUnusedKey(String sessionId2) {
        if (SettingFlags.containKey((String)sessionId2)) {
            SettingFlags.removeKey((String)sessionId2);
        }
    }

    public void onForegroundChange(boolean isForeground) {
        if (isForeground && AccountUtil.getUid() > 0L) {
            MLog.info((Object)"App", (String)"N_FOREGROUND_CHANGE", (Object[])new Object[0]);
            this.mIMsgReceiveService.pullMsg(PullType.Default.getValue());
        }
    }

    public void onAccountChange() {
        this.mIMsgReceiveService.onAccountChange();
        this.initOutOfLine();
    }

    public void initOutOfLine() {
        if (AccountUtil.getUid() > 0L) {
            ImOufOfLineManager.INSTANCE.setDbBox((MyBox<OutOfLineBean>)((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(OutOfLineBean.class));
        }
    }

    public OpenUserData getOpenUserData(Object originData) {
        OpenUserData userData = null;
        if (originData instanceof ProfileSourceBean) {
            ProfileSourceBean sourceBean = (ProfileSourceBean)originData;
            if (sourceBean.getExtObject() instanceof SearchFriend) {
                userData = new OpenUserData();
                userData.from = ((SearchFriend)sourceBean.getExtObject()).getFromType();
                userData.uid = ((SearchFriend)sourceBean.getExtObject()).getUid();
                userData.isFromIm = ((SearchFriend)sourceBean.getExtObject()).isFromIm();
            } else if (sourceBean.getExtObject() instanceof FriendRequest) {
                userData = new OpenUserData();
                userData.uid = ((FriendRequest)sourceBean.getExtObject()).getUid();
            } else if (sourceBean.getExtObject() instanceof Long) {
                userData = new OpenUserData();
                userData.uid = (Long)sourceBean.getExtObject();
            } else if (sourceBean.getExtObject() instanceof SuggestFriendData) {
                userData = new OpenUserData();
                userData.from = ((SuggestFriendData)sourceBean.getExtObject()).fromType;
                userData.uid = ((SuggestFriendData)sourceBean.getExtObject()).mFriend.getUid();
            }
            if (userData != null) {
                userData.source = sourceBean.getSource();
            }
        }
        return userData;
    }

    public ISuggestedFriendViewModel getSuggestedFriendVM(FragmentActivity aty, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        return BizViewModel.getVM(this.getActivity(), SuggestedFriendViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
    }

    public IChannelUnreadMsgPuller createUnreadMsgPuller() {
        return new CimUnreadMsgPuller();
    }

    public void deleteMsg(String channelId, String region, BaseImMsg msg, IMsgDeleteCallback callback) {
        CIMMsgRequest.deleteMsg(channelId, region, msg, callback);
    }

    public void getHistoryMsgList(String channelId, CInterregion region, IMsgService.MsgAnchor anchor, int pullNum, boolean nextFromColdData, IMsgService.IGetMsgList callBack) {
        CIMMsgRequest.getHistoryMsgList(channelId, region, anchor, pullNum, nextFromColdData, callBack);
    }

    public CimPullParams transform(String jsonStr) {
        CimPullParamsItem item = (CimPullParamsItem)JsonParser.parseJsonObject((String)jsonStr, CimPullParamsItem.class);
        if (item != null) {
            Message message = item.getAnthor();
            IMsgService.MsgAnchor anchor = null;
            if (message != null) {
                anchor = new IMsgService.MsgAnchor(message.getTimestamp(), message.getUuid(), (Object)message);
            }
            CimPullParams cimPullParams = new CimPullParams(item.getNum(), item.getOffset(), item.getSnap());
            cimPullParams.setAllowCache(item.getAllowCache());
            cimPullParams.setAnthor(anchor);
            cimPullParams.setNextFromColdData(item.getNextFromColdData());
            cimPullParams.setTotal(item.getTotal());
            return cimPullParams;
        }
        return null;
    }

    public String transform(CimPullMsgResp data2) {
        if (data2 == null) {
            return "";
        }
        CimPullMsgRespItem item = null;
        IMsgService.MsgAnchor msgAnchor = data2.getNextAnchor();
        item = msgAnchor != null && msgAnchor.getAnchor() instanceof Message ? new CimPullMsgRespItem(data2.getHasMore(), (Message)msgAnchor.getAnchor(), data2.getMsgs()) : new CimPullMsgRespItem(data2.getHasMore(), null, data2.getMsgs());
        return JsonParser.toJson((Object)item);
    }

    public void addImJsEvent() {
        if (this.registerJsEvent) {
            return;
        }
        Object[] list = new ImJsEventModule(this.getEnvironment()).allJsEvent();
        if (FP.empty((Object[])list)) {
            return;
        }
        for (Object event : list) {
            ((IWebService)this.getServiceManager().getService(IWebService.class)).addGlobalJsEvent((JsEvent)event);
        }
        this.registerJsEvent = true;
        MLog.info((Object)"IMController", (String)"addImJsEvent", (Object[])new Object[0]);
    }

    public boolean isFakeService() {
        return false;
    }

    public long getCurrChatUid() {
        return this.currentUid;
    }

    public void setCurrChatUid(long uid) {
        this.currentUid = uid;
    }
}

