/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.cim;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.chat.roaming.RoamingFetchingParams;
import com.hummer.im.model.chat.roaming.RoamingFetchingResult;
import com.hummer.im.model.chat.states.Revoked;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.RoamingService;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.bean.CInterregion;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.im.IMsgDeleteCallback;
import com.yy.im.cim.GroupCimMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public class CIMMsgRequest {
    private static HMR.StateListener stateListener;
    private static final String TAG = "CIMMsgRequest";

    public static void getHistoryMsgList(final String channelId, final CInterregion region, IMsgService.MsgAnchor myAnchor, final int pullNum, final boolean nextFromColdData, final IMsgService.IGetMsgList callBack) {
        Message anchor = null;
        if (myAnchor != null && myAnchor.getAnchor() instanceof Message) {
            anchor = (Message)myAnchor.getAnchor();
            if (anchor.getTimestamp() != myAnchor.getTimestamp()) {
                anchor.setTimestamp(myAnchor.getTimestamp());
            }
        } else {
            anchor = null;
        }
        final Message fAnchor = anchor;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                CRC32 crc32 = new CRC32();
                crc32.update(channelId.getBytes());
                long channelIdInt = crc32.getValue();
                if (HMR.getState() == HMR.State.Opened) {
                    MLog.info((Object)CIMMsgRequest.TAG, (String)"HMR state opened", (Object[])new Object[0]);
                    CIMMsgRequest.getHistoryMsgListInner(channelId, region, channelIdInt, fAnchor, pullNum, nextFromColdData, callBack);
                } else {
                    MLog.info((Object)CIMMsgRequest.TAG, (String)"HMR state not opened, listener", (Object[])new Object[0]);
                    if (stateListener != null) {
                        HMR.removeStateListener((HMR.StateListener)stateListener);
                        stateListener = null;
                    }
                    stateListener = (fromState, toState) -> {
                        if (toState == HMR.State.Opened) {
                            CIMMsgRequest.getHistoryMsgListInner(channelId, region, channelIdInt, fAnchor, pullNum, nextFromColdData, callBack);
                            if (stateListener != null) {
                                HMR.removeStateListener((HMR.StateListener)stateListener);
                                stateListener = null;
                            }
                        }
                    };
                    HMR.addStateListener((HMR.StateListener)stateListener);
                }
            }
        });
    }

    private static void getHistoryMsgListInner(final String channelId, final CInterregion region, final long channelIdInt, final Message anchor, final int pullNum, boolean nextFromColdData, final IMsgService.IGetMsgList callBack) {
        MLog.info((Object)TAG, (String)"getHistoryMsgList start HMR statu:%s, channelId:%s,channelIdInt:%s, state:%s, anmouse:%b, beforeTime:%d", (Object[])new Object[]{HMR.getState() == HMR.State.Opened ? "true" : "false", channelId, String.valueOf(channelIdInt), HMR.getState(), HMR.getMe() != null ? Boolean.valueOf(HMR.getMe().isAnonymous()) : "null", anchor != null ? anchor.getTimestamp() : 0L});
        HMR.CompletionArg<RoamingFetchingResult> requestCallBack = new HMR.CompletionArg<RoamingFetchingResult>(){

            public void onSuccess(final RoamingFetchingResult result) {
                final List msgs = result != null ? result.getMessages() : null;
                int msgNum = msgs != null ? msgs.size() : 0;
                final Message tmpAnchor = msgs != null && msgs.size() > 0 ? (Message)msgs.get(0) : null;
                MLog.info((Object)CIMMsgRequest.TAG, (String)"getHistoryMsgList success,channelId:%s,msgNum:%d, ts:%d!,  hasMore: %b, nextColdData: %b", (Object[])new Object[]{channelId, msgNum, tmpAnchor != null ? tmpAnchor.getTimestamp() : 0L, result != null && result.getHasMore(), result != null && result.getNextFromColdData()});
                if (msgNum == 0) {
                    if (result != null && !result.getHasMore() && result.getNextFromColdData()) {
                        CIMMsgRequest.getHistoryMsgListInner(channelId, region, channelIdInt, anchor, pullNum, result.getNextFromColdData(), callBack);
                    } else if (callBack != null) {
                        IMsgService.MsgAnchor msgAnchor = null;
                        if (anchor != null) {
                            msgAnchor = new IMsgService.MsgAnchor(anchor.getTimestamp(), anchor.getUuid(), (Object)anchor);
                        }
                        callBack.onMsgs(channelId, result.getHasMore(), result.getNextFromColdData(), msgAnchor, new ArrayList());
                    }
                    return;
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        final ArrayList<BaseImMsg> cimMsg = new ArrayList<BaseImMsg>(msgs.size());
                        GroupCimMsg item = null;
                        for (Message msg : msgs) {
                            if (!(msg.getContent() instanceof GroupCimMsg) || (item = (GroupCimMsg)msg.getContent()).getMsg() == null || callBack == null || callBack.isUnSupportBelow_3_3(item.getMsg())) continue;
                            ChannelPushContent groupPushContentInner = CIMMsgRequest.transformPushContent(msg.getPushContent());
                            BaseImMsg baseImMsg = callBack.transformMsgItem(item.getMsg().msgid, item.getMsg(), groupPushContentInner);
                            if (baseImMsg == null) continue;
                            baseImMsg.setGroupPushContent(groupPushContentInner);
                            baseImMsg.setMsgState(1);
                            cimMsg.add(baseImMsg);
                            if (!(msg.getState() instanceof Revoked)) continue;
                            MsgSection section = (MsgSection)baseImMsg.getSections().get(0);
                            section.setType(3609);
                        }
                        if (RuntimeContext.sIsDebuggable) {
                            ArrayList cimMsgLog = new ArrayList(cimMsg);
                            MLog.debug((Object)CIMMsgRequest.TAG, (String)"getHistoryMsgList list:%s", (Object[])new Object[]{cimMsgLog.toString()});
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (callBack != null) {
                                    IMsgService.MsgAnchor msgAnchor = null;
                                    if (tmpAnchor != null) {
                                        msgAnchor = new IMsgService.MsgAnchor(tmpAnchor.getTimestamp(), tmpAnchor.getUuid(), (Object)tmpAnchor);
                                    }
                                    callBack.onMsgs(channelId, result.getHasMore(), result.getNextFromColdData(), msgAnchor, (List)cimMsg);
                                }
                                if (cimMsg.size() == 1 && result != null && !result.getHasMore() && result.getNextFromColdData() && !((BaseImMsg)cimMsg.get(0)).isValid()) {
                                    CIMMsgRequest.getHistoryMsgListInner(channelId, region, channelIdInt, tmpAnchor, pullNum, result.getNextFromColdData(), callBack);
                                }
                            }
                        });
                    }
                });
            }

            public void onFailed(Error error) {
                if (error != null) {
                    MLog.error((Object)CIMMsgRequest.TAG, (String)"getHistoryMsgList error channelId:%s,code:%d,tips:%s!", (Object[])new Object[]{channelId, error.code, error.desc});
                    if (callBack != null) {
                        callBack.onError(channelId, error.code, error.desc);
                    }
                } else if (callBack != null) {
                    callBack.onError(channelId, -1, "");
                }
            }
        };
        AppSession appSession = null;
        if (region != null) {
            String regionLower = region.region != null ? region.region.toLowerCase() : "";
            appSession = new AppSession(channelId, channelIdInt, regionLower);
        } else {
            appSession = new AppSession(channelId, channelIdInt, "");
        }
        RoamingFetchingParams params = new RoamingFetchingParams().setLimit(pullNum);
        params.setAnchor(anchor);
        MLog.info((Object)TAG, (String)appSession.toString(), (Object[])new Object[0]);
        ((RoamingService)HMR.getService(RoamingService.class)).fetchHistoryMessages((Identifiable)appSession, params, nextFromColdData, (HMR.CompletionArg)requestCallBack);
    }

    public static void deleteMsg(final String channelId, final String region, final BaseImMsg msg, final IMsgDeleteCallback callback) {
        Message message = new Message();
        message.setUuid(msg.getMsgId());
        message.setTimestamp(System.currentTimeMillis());
        message.setSender((Identifiable)new User(msg.getFrom()));
        CRC32 crc32 = new CRC32();
        crc32.update(channelId.getBytes());
        long channelIdInt = crc32.getValue();
        message.setReceiver((Identifiable)new AppSession(channelId, channelIdInt, region));
        ((RoamingService)HMR.getService(RoamingService.class)).deleteMessage(message, new HMR.Completion(){

            public void onSuccess() {
                MLog.info((Object)CIMMsgRequest.TAG, (String)"deleteMessage onSuccess", (Object[])new Object[0]);
                if (callback != null) {
                    callback.onSuccess(channelId, region, msg);
                }
            }

            public void onFailed(Error err) {
                MLog.debug((Object)CIMMsgRequest.TAG, (String)("deleteMessage onFailed code = " + err.code + ", reason = " + err.desc), (Object[])new Object[0]);
                if (callback != null) {
                    callback.onError(channelId, region, msg, new java.lang.Error(err != null ? err.desc : ""));
                }
            }
        });
    }

    public static ChannelPushContent transformPushContent(PushContent pushContent) {
        if (pushContent != null) {
            ChannelPushContent groupPushContentInner = new ChannelPushContent();
            groupPushContentInner.setTitle(pushContent.getTitle());
            groupPushContentInner.setPayload(pushContent.getPayload());
            groupPushContentInner.setContent(pushContent.getContent());
            groupPushContentInner.setAvatar(pushContent.getIconUrl());
            groupPushContentInner.setPayloadString(new String(pushContent.getPayload()));
            return groupPushContentInner;
        }
        return null;
    }
}

