/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.addfriend;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import androidx.annotation.NonNull;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.kvo.moduledata.PlatformPermissionModuleData;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.PlatformPermissionModule;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.ICheckNeedUpload;
import com.yy.appbase.service.model.NetCheckUpload;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.im.IAddFriendService;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.base.FriendRedPointBean;
import com.yy.hiyo.im.base.INewFriendListener;
import com.yy.hiyo.login.base.IBindThirdPartyAccountCallBack;
import com.yy.hiyo.login.base.IFacebookLoginCallback;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.addfriend.NewAddFriendsContract;
import com.yy.im.addfriend.hiido.AddFriendReporter;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import javax.annotation.Nonnull;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

class NewAddFriendsPresenter
extends BasePresenter<IMvpContext>
implements NewAddFriendsContract.INewAddFriendsPresenter,
INewFriendListener {
    private static final String TAG = "NewAddFriendsPresenter";
    private Activity mContext;
    private NewAddFriendsContract.INewAddFriendsView mView;
    private DialogLinkManager mDialogLinkManager;
    private ProgressDialog mLoadingDialog;
    private CheckStatus mFacebookState = null;
    private CheckStatus mContactState = null;
    private CheckStatus mZaloState = null;
    private boolean mContactClicked = false;
    private boolean mFacebookClicked = false;
    private boolean mZaloClicked = false;
    private int mSource = 0;
    private IBindThirdPartyAccountCallBack mBindThirdPartyAccountCallBack = new IBindThirdPartyAccountCallBack(){

        public void onSuccess() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MLog.info((Object)NewAddFriendsPresenter.TAG, (String)"BindThirdParty success", (Object[])new Object[0]);
                }
            });
        }

        public void onCancel() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Activity)NewAddFriendsPresenter.this.mContext, (int)R.string.fb_bind_cancel, (int)1);
                }
            });
        }

        public void onError(final int errorCode, Exception e) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (errorCode == 20410) {
                        ToastUtils.showToast((Context)NewAddFriendsPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_no_phone_login), (int)1);
                    } else if (errorCode == 20413) {
                        ToastUtils.showToast((Context)NewAddFriendsPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_account_has_bind_other_phone), (int)1);
                    } else if (errorCode == 20412) {
                        ToastUtils.showToast((Context)NewAddFriendsPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_phone_has_bind_other_account), (int)1);
                    } else if (errorCode == 20422) {
                        NewAddFriendsPresenter.this.showSwitchAccountDialog();
                    } else {
                        ToastUtils.showToast((Context)NewAddFriendsPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_connect_fail), (int)1);
                    }
                }
            });
        }
    };
    private IThirdPartyAuthorizationCallBack mThirdPartyAuthorizationCallBack = new IThirdPartyAuthorizationCallBack(){

        public void onSuccess(LoginSuccessResult result) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Activity)NewAddFriendsPresenter.this.mContext, (int)R.string.bind_fb_success, (int)1);
                    MLog.info((Object)NewAddFriendsPresenter.TAG, (String)"ThirdPartyAuthorization success", (Object[])new Object[0]);
                    NewAddFriendsPresenter.this.mFacebookClicked = true;
                }
            });
        }

        public void onCancel() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Activity)NewAddFriendsPresenter.this.mContext, (int)R.string.fb_bind_cancel, (int)1);
                }
            });
        }

        public void onError(int errorCode, Exception e) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)NewAddFriendsPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_bind_fail), (int)1);
                }
            });
        }
    };
    private Runnable mReportRunnable = () -> {
        if (this.mContactState == null || this.mFacebookState == null || this.mZaloState == null) {
            MLog.info((Object)TAG, (String)("report fail state is null, Contact=" + this.mContactState + ",Facebook=" + this.mFacebookClicked + ",Zalo=" + this.mZaloState), (Object[])new Object[0]);
            return;
        }
        if (this.mSource == 0) {
            MLog.info((Object)TAG, (String)"report fail cause source unknown", (Object[])new Object[0]);
            return;
        }
        AddFriendReporter.INSTANCE.reportAddNewFriendsPageShow(this.mContactState.permissionState == CheckStatus.AUTH, this.mFacebookState.permissionState == CheckStatus.AUTH, this.mZaloState.permissionState == CheckStatus.AUTH, this.mSource);
    };

    NewAddFriendsPresenter() {
    }

    public void onInit(@Nonnull IMvpContext mvpContext) {
        super.onInit(mvpContext);
        this.mContext = (Activity)mvpContext.getContext();
        ((IAddFriendService)ServiceManagerProxy.getInstance().getService(IAddFriendService.class)).addNewFriendNotifyListener((INewFriendListener)this);
        this.checkContact();
        this.checkFacebook();
        this.checkZalo();
        this.reportShow();
    }

    @Override
    public void setView(@NotNull NewAddFriendsContract.INewAddFriendsView view) {
        this.mView = view;
    }

    private void checkContact() {
        if (this.mContactState == null) {
            KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
            if (!(moduleData instanceof PlatformPermissionModuleData)) {
                return;
            }
            PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
            this.mContactState = moduleData1.contactState;
            Kvo.removeKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onContactPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onContactPermissionChange");
        }
        Kvo.removeKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onUploadContactEvent");
        Kvo.addKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onUploadContactEvent");
        this.checkContactPermission();
        this.checkUploadContacts();
    }

    private void checkContactPermission() {
        if (this.mContactState != null) {
            MLog.info((Object)TAG, (String)"check contact permission", (Object[])new Object[0]);
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).contactPermission(this.mContext, this.mContactState.permissionState);
        }
    }

    private void checkUploadContacts() {
        if (this.mContactState != null && !this.mContactState.hasUpload) {
            MLog.info((Object)TAG, (String)"checkUploadContacts", (Object[])new Object[0]);
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).checkUploadContacts(new ICheckNeedUpload(){

                public void onSuccess(NetCheckUpload responseBean) {
                    NewAddFriendsPresenter.this.startUploadContacts();
                }

                public void onError(int code, String msg) {
                    MLog.info((Object)NewAddFriendsPresenter.TAG, (String)("checkUploadContact err " + code + " msg" + msg), (Object[])new Object[0]);
                }
            });
        }
    }

    @KvoMethodAnnotation(name="hasUpload", sourceClass=CheckStatus.class, thread=1)
    public void onUploadContactEvent(KvoEventIntent event) {
        if (this.mContactState == null) {
            if (this.mContactClicked) {
                this.finishLoading();
                this.mContactClicked = false;
            }
            return;
        }
        boolean hasUpload = this.mContactState.hasUpload;
        MLog.info((Object)TAG, (String)("onUploadContactEvent hasUpload:" + hasUpload + " hasFastCheck:" + this.mContactState.hasFastCheck), (Object[])new Object[0]);
        if (hasUpload && !this.mContactState.hasFastCheck) {
            this.mContactState.hasFastCheck = true;
        }
        if (this.mContactClicked) {
            this.finishLoading();
            this.mContactClicked = false;
            if (this.mContactState != null && this.mContactState.permissionState == CheckStatus.AUTH && this.mContactState.hasUpload) {
                MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_DETAIL, 1);
            }
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onContactPermissionChange(KvoEventIntent event) {
        if (this.mContactState == null || this.mContactState.permissionState == CheckStatus.UNCHECK) {
            if (this.mContactClicked) {
                this.finishLoading();
                this.mContactClicked = false;
            }
            return;
        }
        MLog.info((Object)TAG, (String)("onContactPermissionChange:" + this.mContactState.permissionState), (Object[])new Object[0]);
        if (this.mContactState.permissionState == CheckStatus.AUTH && this.mContactState.checkNeedUpload != null && !this.mContactState.checkNeedUpload.need) {
            this.checkUploadContacts();
            return;
        }
        this.startUploadContacts();
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onFacebookPermissionChange(KvoEventIntent event) {
        if (this.mFacebookState == null || this.mFacebookState.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        MLog.info((Object)TAG, (String)("onFacebookPermissionChange ,p:" + this.mFacebookState.permissionState), (Object[])new Object[0]);
        if (this.mFacebookState.permissionState == CheckStatus.AUTH && this.mFacebookState.checkNeedUpload != null && !this.mFacebookState.checkNeedUpload.need) {
            this.checkUploadFacebook();
            return;
        }
        this.startUploadFacebookFriendList();
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onZaloPermissionChange(KvoEventIntent event) {
        if (this.mZaloState == null || this.mZaloState.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        MLog.info((Object)TAG, (String)("onZaloPermissionChange:" + this.mZaloState.permissionState), (Object[])new Object[0]);
        if (this.mZaloState.permissionState == CheckStatus.AUTH) {
            this.mZaloState.setValue("hasUpload", (Object)true);
        }
    }

    @KvoMethodAnnotation(name="hasUpload", sourceClass=CheckStatus.class)
    public void onUploadFBEvent(KvoEventIntent event) {
        if (this.mFacebookState == null) {
            return;
        }
        boolean hasUpload = this.mFacebookState.hasUpload;
        MLog.info((Object)TAG, (String)("onUploadFBEvent hasUpload:" + hasUpload + " hasFastCheck:" + this.mFacebookState.hasFastCheck), (Object[])new Object[0]);
        if (hasUpload) {
            this.mFacebookState.hasFastCheck = true;
        }
    }

    private void startUploadContacts() {
        if (this.mContactState.permissionState == CheckStatus.AUTH) {
            if (this.mContactState.checkNeedUpload != null && this.mContactState.checkNeedUpload.need && !this.mContactState.hasUpload) {
                ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).uploadContacts();
            } else {
                MLog.info((Object)TAG, (String)("on contact permission auth ,but " + this.mContactState), (Object[])new Object[0]);
                if (this.mContactClicked) {
                    this.finishLoading();
                    this.mContactClicked = false;
                }
            }
        }
    }

    private void checkFacebook() {
        if (AccountUtil.getUid() <= 0L) {
            MLog.info((Object)TAG, (String)"unsupport login type,do not check fb bind status. ", (Object[])new Object[0]);
            return;
        }
        if (this.mFacebookState == null) {
            KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
            if (!(moduleData instanceof PlatformPermissionModuleData)) {
                return;
            }
            PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
            this.mFacebookState = moduleData1.facebookState;
            Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
        }
        Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onUploadFBEvent");
        Kvo.addKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onUploadFBEvent");
        this.checkFacebookPermission();
        this.checkUploadFacebook();
    }

    private void checkFacebookPermission() {
        if (this.mFacebookState != null && this.mFacebookState.permissionState != CheckStatus.EXPIRE) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).facebookPermission(this.mFacebookState.permissionState);
        } else {
            MLog.info((Object)TAG, (String)("checkUploadFacebook do not need: " + this.mFacebookState), (Object[])new Object[0]);
        }
    }

    private void checkUploadFacebook() {
        if (this.mFacebookState != null && !this.mFacebookState.hasUpload) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).checkUploadFb((INetRespCallback)new INetRespCallback<NetCheckUpload>(){

                public void onError(Call call, Exception e, int id2) {
                    MLog.info((Object)NewAddFriendsPresenter.TAG, (String)"checkUploadFacebook %s, id=%s", (Object[])new Object[]{e, id2});
                }

                public void onResponse(String response, BaseResponseBean<NetCheckUpload> res, int id2) {
                    if (res != null && res.isSuccess()) {
                        NewAddFriendsPresenter.this.startUploadFacebookFriendList();
                    }
                }
            });
        }
    }

    private void startUploadFacebookFriendList() {
        if (this.mFacebookState.permissionState == CheckStatus.AUTH) {
            if (this.mFacebookState.checkNeedUpload != null && this.mFacebookState.checkNeedUpload.need && !this.mFacebookState.hasUpload) {
                MLog.info((Object)TAG, (String)"start to request upload facebook", (Object[])new Object[0]);
                ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).uploadFacebookFriendList();
            } else {
                MLog.info((Object)TAG, (String)("onFacebookPermissionChange ,permission is auth,but checkupload = " + this.mFacebookState.checkNeedUpload), (Object[])new Object[0]);
            }
        }
    }

    private void checkZalo() {
        if (AccountUtil.getUid() <= 0L) {
            MLog.info((Object)TAG, (String)"unsupport login type,do not check fb bind status. ", (Object[])new Object[0]);
            return;
        }
        if (this.mZaloState == null) {
            KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
            if (!(moduleData instanceof PlatformPermissionModuleData)) {
                return;
            }
            PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
            this.mZaloState = moduleData1.zaloState;
            Kvo.removeKvoBinding((KvoSource)this.mZaloState, (Object)this, (String)"onZaloPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mZaloState, (Object)this, (String)"onZaloPermissionChange");
        }
        this.checkZaloPermission();
    }

    private void checkZaloPermission() {
        if (this.mZaloState != null && this.mZaloState.permissionState != CheckStatus.EXPIRE) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).zaloPermission(this.mZaloState.permissionState);
        } else {
            MLog.info((Object)TAG, (String)("checkUploadZalo do not need: " + this.mZaloState), (Object[])new Object[0]);
        }
    }

    @Override
    public void onDetach() {
        Kvo.removeKvoBinding((KvoSource)this.mContactState, (Object)this, (String)"onUploadContactEvent");
        Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onUploadFBEvent");
        if (this.mContactState != null) {
            this.mContactState.setValue("hasUpload", (Object)false);
        }
        if (this.mFacebookState != null) {
            this.mFacebookState.setValue("hasUpload", (Object)false);
        }
        ((IAddFriendService)ServiceManagerProxy.getInstance().getService(IAddFriendService.class)).removeNewFriendNotifyListener((INewFriendListener)this);
        YYTaskExecutor.removeTask((Runnable)this.mReportRunnable);
    }

    private void contactAction() {
        PermissionHelper.requestContactPermission((Activity)this.mContext, (IPermissionListener)new IPermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                MLog.info((Object)NewAddFriendsPresenter.TAG, (String)"contactAction granted", (Object[])new Object[0]);
                if (NewAddFriendsPresenter.this.mContactState != null) {
                    NewAddFriendsPresenter.this.mContactState.setValue("permissionState", (Object)CheckStatus.AUTH);
                }
                NewAddFriendsPresenter.this.mContactClicked = true;
                NewAddFriendsPresenter.this.showLoading();
            }

            public void onPermissionDenied(@NonNull String[] permission) {
                if (NewAddFriendsPresenter.this.mContactState != null) {
                    NewAddFriendsPresenter.this.mContactState.setValue("permissionState", (Object)CheckStatus.UNAUTH);
                }
            }
        });
    }

    private void facebookAction() {
        if (this.mFacebookState == null) {
            return;
        }
        if (AccountUtil.isLoginByGuest()) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_GUEST_LOGIN_WITH_TYPE;
            Bundle bundle = new Bundle();
            bundle.putInt("key_login_type", 1);
            bundle.putInt("key_login_source", 5);
            msg.setData(bundle);
            MsgDispatcher.getInstance().sendMessage(msg);
        } else if (this.mFacebookState.permissionState == CheckStatus.UNAUTH) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindFacebook((Object)this.mBindThirdPartyAccountCallBack);
        } else if (this.mFacebookState.permissionState == CheckStatus.EXPIRE) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).authFacebook((Object)this.mThirdPartyAuthorizationCallBack);
        }
    }

    private void zaloAction() {
        if (AccountUtil.getUid() > 0L && AccountUtil.getsLoginType() == 7) {
            return;
        }
        if (AccountUtil.isLoginByGuest()) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_GUEST_LOGIN_WITH_TYPE;
            Bundle bundle = new Bundle();
            bundle.putInt("key_login_type", 7);
            bundle.putInt("key_login_source", 6);
            msg.setData(bundle);
            MsgDispatcher.getInstance().sendMessage(msg);
        } else {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindZalo((Object)new IBindThirdPartyAccountCallBack(){

                public void onSuccess() {
                }

                public void onCancel() {
                }

                public void onError(int errorCode, Exception e) {
                }
            });
        }
    }

    private void showSwitchAccountDialog() {
        DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)this.mContext);
        OkCancelDialog tipsDialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.facebook_switch_account), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_FACEBOOK_SWITCH_BIND, -1, -1, (Object)new IFacebookLoginCallback(){

                    public void onSuccess() {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Message msg = Message.obtain();
                                msg.what = BaseMsgDef.GOTO_HOMEPAGE;
                                MsgDispatcher.getInstance().sendMessage(msg);
                            }
                        });
                    }

                    public void onCancel() {
                    }

                    public void onError(String errorCode, String des) {
                    }
                });
            }
        });
        dialogLinkManager.showDialog((BaseDialog)tipsDialog2);
    }

    @Override
    public void clickFriendType(int type) {
        if (type == 1) {
            if (this.mContactState != null && this.mContactState.permissionState == CheckStatus.AUTH && (!this.mContactState.checkNeedUpload.need || this.mContactState.hasUpload)) {
                MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_DETAIL, 1);
            } else {
                this.contactAction();
            }
            AddFriendReporter.INSTANCE.reportMobileContactsClick();
        } else if (type == 2) {
            if (this.mFacebookState != null && this.mFacebookState.permissionState == CheckStatus.AUTH) {
                MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_DETAIL, 2);
            } else {
                this.facebookAction();
            }
            AddFriendReporter.INSTANCE.reportFacebookClick();
        } else if (type == 3) {
            if (this.mZaloState != null && this.mZaloState.permissionState == CheckStatus.AUTH && (!this.mZaloState.checkNeedUpload.need || this.mZaloState.hasUpload)) {
                MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_DETAIL, 3);
            } else {
                this.zaloAction();
            }
            AddFriendReporter.INSTANCE.reportZaloClick();
        }
    }

    public void onNewFriend(@NotNull FriendRedPointBean bean) {
        if (this.mView != null) {
            this.mView.setFriendRedPoint(bean);
        }
    }

    @Override
    public void getConcatRedPoint() {
        ((IAddFriendService)ServiceManagerProxy.getInstance().getService(IAddFriendService.class)).getConcatRedPoint();
    }

    @Override
    public void setDialogLinkManager(@NotNull DialogLinkManager dialogLinkManager) {
        this.mDialogLinkManager = dialogLinkManager;
    }

    private void showLoading() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        if (this.mLoadingDialog == null) {
            this.mLoadingDialog = new ProgressDialog("", true, false, new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog2) {
                    NewAddFriendsPresenter.this.mLoadingDialog = null;
                }
            });
        }
        this.mDialogLinkManager.showDialog((BaseDialog)this.mLoadingDialog);
    }

    private void finishLoading() {
        if (this.mDialogLinkManager == null || this.mLoadingDialog == null) {
            return;
        }
        this.mDialogLinkManager.dismissDialog();
    }

    private void reportShow() {
        YYTaskExecutor.postToMainThread((Runnable)this.mReportRunnable, (long)500L);
    }

    @Override
    public void setSource(int source) {
        this.mSource = source;
    }
}

