/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.controller;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.OutOfLineBean;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.IIMdata;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.im.controller.o;
import com.yy.im.controller.p;
import com.yy.im.controller.q;
import com.yy.im.module.room.callback.a;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public enum ImOufOfLineManager {
    INSTANCE;

    private static final String TAG = "ImOufOfLineManager";
    private HashMap<String, OutOfLineBean> mOutOfLineData;
    private static final String SHARE_PRE_NAME = "im_out_of_line";
    private static final String KEY_CLICK_AT = "CLICK_AT";
    private static final String DATE = "date";
    private static final String REPEAT_NUM_SHOW = "repeatNumShow";
    private static final String SENSITIVE_NUM_SHOW = "sensitiveNumShow";
    private static final int REPORT_MSG_SIZE = 30;
    private a<OutOfLineBean> mOutOfLineListener;
    private MyBox<OutOfLineBean> mDbBox;
    private boolean isInRoom = false;
    private boolean isTodayFirstShow = true;
    private boolean isShowGoSettingPrompt = true;
    private int sensitiveShowTimes = 0;
    private int repeatShowTimes = 0;
    private static final int REPEAT_NUM = 5;
    private static final int SENSITIVE_NUM = 3;
    private boolean repeatNumShow = true;
    private boolean sensitiveNumShow = true;
    private boolean isNeedWriteRepeatNumShow = true;
    private boolean isNeedWriteSensitiveNumShow = true;
    private boolean isNeedWriteDate = true;
    private boolean isAddGoSettingMessage = true;
    private boolean isReply = false;
    private UserInfoBean mMyUserInfo;
    private UserInfoBean mTargetUserInfo;
    private String keyId;

    public void setDbBox(MyBox<OutOfLineBean> myBox) {
        this.mDbBox = myBox;
        this.mOutOfLineData = new HashMap(1);
        if (this.mDbBox != null) {
            this.mDbBox.getAll((MyBox.IGetItemsCallBack)new o(this));
        }
    }

    public void updateDb(@Nonnull OutOfLineBean outOfLineBean) {
        if (this.mDbBox != null) {
            this.mDbBox.updateItem((BaseDBBean)outOfLineBean, false);
        }
    }

    public void onReceiveOutOfLine(MsgData msgData) {
        MLog.info((Object)TAG, (String)"onReceiveOutOfLine %s, isInRoom %b", (Object[])new Object[]{msgData, this.isInRoom});
        try {
            String string2 = msgData.getMsg();
            JSONObject jSONObject = JsonParser.obtainJSONObject((String)string2);
            OutOfLineBean outOfLineBean = (OutOfLineBean)JsonParser.parseJsonObject((String)jSONObject.optString("ofl"), OutOfLineBean.class);
            long l2 = outOfLineBean != null ? outOfLineBean.uid : 0L;
            boolean bl2 = this.isClickedToday(l2);
            MLog.info((Object)TAG, (String)"onReceiveOutOfLine %b", (Object[])new Object[]{bl2});
            if (outOfLineBean != null && !FP.empty((CharSequence)outOfLineBean.seq) && !bl2) {
                outOfLineBean.isShowInUi = this.isInRoom;
                outOfLineBean.outOfLineSeq = msgData.getSeq();
                this.mOutOfLineData.put(outOfLineBean.seq, outOfLineBean);
                if (this.mDbBox != null) {
                    this.mDbBox.addItem((BaseDBBean)outOfLineBean);
                }
                if (this.mOutOfLineListener != null) {
                    YYTaskExecutor.postToMainThread((Runnable)new p(this, outOfLineBean));
                }
            }
        }
        catch (JSONException jSONException) {
            MLog.error((Object)TAG, (Throwable)jSONException);
        }
    }

    public boolean isOutOfLine(@Nonnull ImMessageDBBean imMessageDBBean, long l2) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"isOutOfLine targetUid %s, seq: %s, content: %s", (Object[])new Object[]{l2, imMessageDBBean.getMsgId(), imMessageDBBean.getContent()});
        }
        if (this.mOutOfLineData == null || imMessageDBBean.getMsgId() == 0L) {
            return false;
        }
        String string2 = String.valueOf(imMessageDBBean.getMsgId());
        OutOfLineBean outOfLineBean = this.mOutOfLineData != null ? this.mOutOfLineData.get(string2) : null;
        return !FP.empty((CharSequence)string2) && outOfLineBean != null;
    }

    public boolean isShowOutOfLineUi(@Nonnull ImMessageDBBean imMessageDBBean, long l2) {
        if (this.isClickedToday(l2) || this.mOutOfLineData == null || imMessageDBBean.getMsgId() == 0L) {
            return false;
        }
        String string2 = String.valueOf(imMessageDBBean.getMsgId());
        OutOfLineBean outOfLineBean = this.mOutOfLineData != null ? this.mOutOfLineData.get(string2) : null;
        return !FP.empty((CharSequence)string2) && outOfLineBean != null && outOfLineBean.isShowInUi && !outOfLineBean.isNeverShow;
    }

    public boolean isFriend(long l2) {
        return this.getFollowStatus() == Relation.FRIEND;
    }

    public boolean isClickedToday(long l2) {
        int n2 = this.getPreference().getInt(KEY_CLICK_AT + l2 + "_" + AccountUtil.getUid(), -1);
        int n3 = Calendar.getInstance().get(6);
        return n2 != -1 && n3 == n2;
    }

    @Nullable
    public OutOfLineBean getOutOfLine(String string2) {
        return this.mOutOfLineData != null ? this.mOutOfLineData.get(string2) : null;
    }

    public void onBlock(long l2, @Nullable a<Boolean> a2) {
        this.updateActionAt(l2);
    }

    private void updateActionAt(long l2) {
        this.getPreference().edit().putInt(KEY_CLICK_AT + l2 + "_" + AccountUtil.getUid(), Calendar.getInstance().get(6)).apply();
    }

    public void onReportOutOfLine(@Nonnull DefaultController defaultController, long l2, List<IIMdata> list, int n2, a<Boolean> a2) {
        this.updateActionAt(l2);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        for (int i2 = n2 - 1; i2 >= 0 && n3 < 30; --i2) {
            ImMessageDBBean imMessageDBBean = list.get(i2).getMessageDBBean();
            if (imMessageDBBean.getUid() != l2) continue;
            ++n3;
            arrayList.add(imMessageDBBean.getContent());
        }
        MLog.info((Object)TAG, (String)"onReportOutOfLine content %s", (Object[])new Object[]{arrayList});
        YYTaskExecutor.execute((Runnable)new q(this, l2, arrayList, a2, defaultController));
    }

    public void onNoMoreNoticeToday(long l2) {
        this.updateActionAt(l2);
    }

    private SharedPreferences getPreference() {
        return SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, SHARE_PRE_NAME, 0);
    }

    public void setOutOfLineListener(a<OutOfLineBean> a2) {
        this.mOutOfLineListener = a2;
    }

    public void hideAll() {
        if (this.mOutOfLineData != null && !this.mOutOfLineData.isEmpty()) {
            Set<String> set = this.mOutOfLineData.keySet();
            ArrayList<String> arrayList = new ArrayList<String>(this.mOutOfLineData.size());
            for (String string2 : set) {
                OutOfLineBean outOfLineBean = this.mOutOfLineData.get(string2);
                arrayList.add(outOfLineBean.seq);
            }
            if (this.mDbBox != null) {
                this.mDbBox.deleteByIndexs(arrayList);
            }
        }
    }

    public void onRoomEnter() {
        this.isInRoom = true;
    }

    public void onRoomExit() {
        this.isInRoom = false;
        this.mOutOfLineListener = null;
    }

    public void initIsTodayDate() {
        if (this.mMyUserInfo == null || this.mTargetUserInfo == null) {
            MLog.error((Object)TAG, (String)"initIsTodayDate fail, mMyUserInfo or mTargetUserInfo is null", (Object[])new Object[0]);
            return;
        }
        this.repeatNumShow = true;
        this.sensitiveNumShow = true;
        this.isNeedWriteRepeatNumShow = true;
        this.isNeedWriteSensitiveNumShow = true;
        this.isNeedWriteDate = true;
        this.isTodayFirstShow = true;
        this.isShowGoSettingPrompt = true;
        this.keyId = this.mMyUserInfo.getUid() + "and" + this.mTargetUserInfo.getUid();
        String string2 = SettingFlags.getStringValue((String)(this.keyId + DATE));
        if (!TextUtils.isEmpty((CharSequence)string2) && DateUtils.isToday((Calendar)Calendar.getInstance(), (long)DateUtils.stringtoDate((String)string2, (String)"yyyy-MM-dd").getTime())) {
            this.isTodayFirstShow = false;
        } else {
            this.isTodayFirstShow = true;
            SettingFlags.setBoolean((String)(this.keyId + REPEAT_NUM_SHOW), (boolean)true);
            SettingFlags.setBoolean((String)(this.keyId + SENSITIVE_NUM_SHOW), (boolean)true);
        }
        this.repeatNumShow = SettingFlags.getBoolean((String)(this.keyId + REPEAT_NUM_SHOW), (boolean)true);
        this.sensitiveNumShow = SettingFlags.getBoolean((String)(this.keyId + SENSITIVE_NUM_SHOW), (boolean)true);
        if (SettingFlags.containKey((String)(AccountUtil.getUid() + "match_gender"))) {
            this.isShowGoSettingPrompt = false;
        }
        MLog.info((Object)TAG, (String)"initIsTodayDate keyId= %s, repeatNumShow = %s, sensitiveNumShow = %s, isShowGoSettingPrompt = %s, isTodayFirstShow = %s", (Object[])new Object[]{this.keyId, this.repeatNumShow, this.sensitiveNumShow, this.isShowGoSettingPrompt, this.isTodayFirstShow});
    }

    public void resetRepeatTimes(ImMessageDBBean imMessageDBBean) {
        if (this.mMyUserInfo != null && imMessageDBBean.getUid() == this.mMyUserInfo.getUid()) {
            this.repeatShowTimes = 0;
            this.isReply = true;
        }
    }

    public void updateUserInfo(UserInfoBean userInfoBean, UserInfoBean userInfoBean2) {
        this.mMyUserInfo = userInfoBean;
        this.mTargetUserInfo = userInfoBean2;
    }

    public boolean isRepeatSensitiveShow(ImMessageDBBean imMessageDBBean) {
        if (this.mMyUserInfo == null || this.mTargetUserInfo == null || imMessageDBBean == null || this.getFollowStatus() == Relation.NONE) {
            MLog.error((Object)TAG, (String)"isRepeatSensitiveShow fail, mMyUserInfo,mTargetUserInfo,msg or relationship is null", (Object[])new Object[0]);
            return false;
        }
        if (this.isShowGoSettingPrompt && this.getFollowStatus() != Relation.FRIEND && DateUtils.isToday((Calendar)Calendar.getInstance(), (long)imMessageDBBean.getSendTime()) && this.mMyUserInfo.getSex() == 0 && this.mMyUserInfo != null && imMessageDBBean.getUid() != this.mMyUserInfo.getUid() && this.repeatShowTimes < 5 && this.repeatNumShow && !this.isReply) {
            ++this.repeatShowTimes;
            if (this.repeatShowTimes == 5) {
                if (this.isNeedWriteDate) {
                    SettingFlags.setStringValue((String)(this.keyId + DATE), (String)DateUtils.getNow());
                    this.isNeedWriteDate = false;
                    MLog.info((Object)TAG, (String)"updateDate repeatShow isNeedWriteDate=%s", (Object[])new Object[]{this.isNeedWriteDate});
                }
                if (this.isNeedWriteRepeatNumShow) {
                    SettingFlags.setBoolean((String)(this.keyId + REPEAT_NUM_SHOW), (boolean)false);
                    this.isNeedWriteRepeatNumShow = false;
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "tips_show").put("act_uid", String.valueOf(this.mTargetUserInfo.getUid())));
                    MLog.info((Object)TAG, (String)"updateDate repeatShow isNeedWriteRepeatNumShow=%s", (Object[])new Object[]{this.isNeedWriteRepeatNumShow});
                }
                return true;
            }
        }
        return false;
    }

    public boolean isSensitiveShow(ImMessageDBBean imMessageDBBean) {
        if (imMessageDBBean != null && !DateUtils.isToday((Calendar)Calendar.getInstance(), (long)imMessageDBBean.getSendTime())) {
            return false;
        }
        if (this.mMyUserInfo == null || this.mTargetUserInfo == null || this.getFollowStatus() == Relation.NONE) {
            MLog.error((Object)TAG, (String)"isSensitiveShow fail, mMyUserInfo or mTargetUserInfo or relationship is null", (Object[])new Object[0]);
            return false;
        }
        if (this.isShowGoSettingPrompt && this.getFollowStatus() != Relation.FRIEND && this.mMyUserInfo.getSex() == 0 && this.sensitiveShowTimes < 3 && this.sensitiveNumShow) {
            ++this.sensitiveShowTimes;
            if (this.sensitiveShowTimes == 3) {
                if (this.isNeedWriteDate) {
                    SettingFlags.setStringValue((String)(this.keyId + DATE), (String)DateUtils.getNow());
                    this.isNeedWriteDate = false;
                }
                if (this.isNeedWriteSensitiveNumShow) {
                    SettingFlags.setBoolean((String)(this.keyId + SENSITIVE_NUM_SHOW), (boolean)false);
                    this.isNeedWriteSensitiveNumShow = false;
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "tips_show").put("act_uid", String.valueOf(this.mTargetUserInfo.getUid())));
                }
                return true;
            }
        }
        return false;
    }

    public void resetAllTimes() {
        this.repeatShowTimes = 0;
        this.sensitiveShowTimes = 0;
        this.isReply = false;
    }

    public boolean getIsAddGoSettingMessage() {
        return this.isAddGoSettingMessage;
    }

    public void setIsAddGoSettingMessage(boolean bl2) {
        this.isAddGoSettingMessage = bl2;
    }

    private Relation getFollowStatus() {
        if (this.mTargetUserInfo == null) {
            return Relation.NONE;
        }
        IRelationService iRelationService = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
        if (iRelationService == null) {
            return Relation.NONE;
        }
        return iRelationService.getRelationLocal(this.mTargetUserInfo.getUid()).getRelation();
    }

    static /* synthetic */ HashMap access$000(ImOufOfLineManager imOufOfLineManager) {
        return imOufOfLineManager.mOutOfLineData;
    }

    static /* synthetic */ a access$100(ImOufOfLineManager imOufOfLineManager) {
        return imOufOfLineManager.mOutOfLineListener;
    }
}

