/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im;

import androidx.annotation.NonNull;
import androidx.lifecycle.Observer;
import com.yy.appbase.im.SessionUnread;
import com.yy.appbase.kvomodule.AutoUnbindMutableLiveData;
import com.yy.appbase.kvomodule.BaseModuleData;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.im.IImModuleData;
import com.yy.hiyo.im.base.IChatSession;
import com.yy.im.e;
import com.yy.im.model.ChatSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImModuleData
extends BaseModuleData
implements IImModuleData {
    public final AutoUnbindMutableLiveData<List<ChatSession>> normalChatSessions = new AutoUnbindMutableLiveData();
    public final AutoUnbindMutableLiveData<List<ChatSession>> strangerChatSessions = new AutoUnbindMutableLiveData();
    public final AutoUnbindMutableLiveData<List<ChatSession>> gamePublicChatSessions = new AutoUnbindMutableLiveData();
    public final AutoUnbindMutableLiveData<List<ChatSession>> officialAccountChatSessions = new AutoUnbindMutableLiveData();
    public final SessionUnread mNormalSessionUnread = new SessionUnread();
    public final SessionUnread mStrangerSessionUnread = new SessionUnread();
    public final SessionUnread mGamePublicSessionUnread = new SessionUnread();
    public final SessionUnread mOfficialAccountSessionUnread = new SessionUnread();
    public final SessionUnread mExtUnRead = new SessionUnread();
    public final SessionUnread mTotalListUnRead = new SessionUnread();
    private HashMap<Observer, Observer<List<ChatSession>>> mObserverHashMap;

    public void resetWhenLogout() {
        super.resetWhenLogout();
        this.resetData();
    }

    public void resetData() {
        super.resetData();
        this.normalChatSessions.setValue(new ArrayList());
        this.strangerChatSessions.setValue(new ArrayList());
        this.gamePublicChatSessions.setValue(new ArrayList());
        this.officialAccountChatSessions.setValue(new ArrayList());
        this.mNormalSessionUnread.reset();
        this.mStrangerSessionUnread.reset();
        this.mGamePublicSessionUnread.reset();
        this.mOfficialAccountSessionUnread.reset();
        this.mExtUnRead.reset();
        this.mTotalListUnRead.reset();
        FeatureLog.i((String)"FTChannelNotice", (String)"resetData", (Object[])new Object[0]);
    }

    public synchronized void removeNormalChatSessionsObserver(@NonNull Observer<List<IChatSession>> observer) {
        if (this.mObserverHashMap != null && this.mObserverHashMap.size() > 0) {
            this.normalChatSessions.removeObserver(this.mObserverHashMap.get(observer));
            this.mObserverHashMap.remove(observer);
        }
    }

    public synchronized void observeNormalChatSessionsForever(@NonNull Observer<List<IChatSession>> observer) {
        if (this.mObserverHashMap == null) {
            this.mObserverHashMap = new HashMap(2);
        }
        e e2 = new e(this, observer);
        this.mObserverHashMap.put(observer, e2);
        this.normalChatSessions.observeForever((Observer)e2);
    }
}

