/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.im.base;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.IMPostData;
import com.yy.hiyo.im.base.FeedbackBean;
import ikxd.msg.PushSourceType;
import ikxd.msg.StyleType;
import org.json.JSONException;
import org.json.JSONObject;

public enum MsgContentCreator {
    Instance;

    private static final String TAG = "MsgContentCreator";

    public String initPayloadContent(long uid, String title, String content) {
        JSONObject pushJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            pushJson.put("uid", uid);
            pushJson.put("push_title", (Object)title);
            pushJson.put("push_content", (Object)content);
            if (userInfoKS != null) {
                pushJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return pushJson.toString();
    }

    public String initImagePayloadContent(String content, long uid, String imageSize, String title, String msgContent, int gifFrom, String tinyGif, int emojiType, boolean fromShare) {
        JSONObject pushJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            pushJson.put("txt", (Object)content);
            pushJson.put("uid", uid);
            pushJson.put("image_size", (Object)imageSize);
            pushJson.put("push_title", (Object)title);
            pushJson.put("push_content", (Object)msgContent);
            pushJson.put("push_source", PushSourceType.kPushSourceUserChat.getValue());
            if (emojiType == 2) {
                pushJson.put("from", 1);
                pushJson.put("isGif", true);
            } else {
                if (gifFrom > 0) {
                    pushJson.put("from", gifFrom);
                }
                if (ImageUtil.isGif((String)tinyGif)) {
                    pushJson.put("tinyGif", (Object)tinyGif);
                    pushJson.put("isGif", true);
                }
            }
            if (userInfoKS != null) {
                pushJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
            if (fromShare) {
                pushJson.put("from_type", 2);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return pushJson.toString();
    }

    public String initGameInvalidPayloadContent(String gameId, String gameName, String pkId, String title, String content) {
        JSONObject pushJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            pushJson.put("gameId", (Object)gameId);
            pushJson.put("gameName", (Object)gameName);
            pushJson.put("pkId", (Object)pkId);
            pushJson.put("push_title", (Object)title);
            pushJson.put("push_content", (Object)content);
            if (userInfoKS != null) {
                pushJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return pushJson.toString();
    }

    public String initGameIncompatiblePayloadContent(String gameId, String gameName, String pkId, int gameVersion, String title, String content) {
        JSONObject pushJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            pushJson.put("gameId", (Object)gameId);
            pushJson.put("gameName", (Object)gameName);
            pushJson.put("pkId", (Object)pkId);
            pushJson.put("gameVersion", gameVersion);
            pushJson.put("push_title", (Object)title);
            pushJson.put("push_content", (Object)content);
            if (userInfoKS != null) {
                pushJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return pushJson.toString();
    }

    public String initImOnlinePayloadContent(boolean isExit, long uid) {
        JSONObject pushJson = JsonParser.obtainJSONObject();
        try {
            pushJson.put("isExit", isExit);
            pushJson.put("uid", uid);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return pushJson.toString();
    }

    public String initImUserChatPushPayload(int type, String sessionId, long fromUid, String title, String content, String roomSource) {
        JSONObject pushPayloadJson = JsonParser.obtainJSONObject();
        JSONObject imJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            imJson.put("session_id", (Object)sessionId);
            imJson.put("from_uid", fromUid);
            imJson.put("room_source", (Object)roomSource);
            pushPayloadJson.put("type", type);
            pushPayloadJson.put("im", (Object)imJson);
            pushPayloadJson.put("push_title", (Object)title);
            pushPayloadJson.put("push_content", (Object)content);
            pushPayloadJson.put("push_source", PushSourceType.kPushSourceUserChat.getValue());
            if (userInfoKS != null) {
                pushPayloadJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initImPushPayload ex: %s", (Object[])new Object[]{e});
        }
        return pushPayloadJson.toString();
    }

    public String initImPushPayload(int type, String sessionId, long fromUid, String title, String content) {
        return this.initImPushPayload(type, sessionId, fromUid, title, "", content);
    }

    public String initImPushPayload(int type, String sessionId, long fromUid, String title, String gameId, String content) {
        JSONObject pushPayloadJson = JsonParser.obtainJSONObject();
        JSONObject imJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            imJson.put("session_id", (Object)sessionId);
            imJson.put("from_uid", fromUid);
            pushPayloadJson.put("type", type);
            pushPayloadJson.put("im", (Object)imJson);
            pushPayloadJson.put("gameid", (Object)gameId);
            pushPayloadJson.put("push_title", (Object)title);
            pushPayloadJson.put("push_content", (Object)content);
            pushPayloadJson.put("push_source", PushSourceType.kPushSourceUserChat.getValue());
            if (userInfoKS != null) {
                pushPayloadJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initImPushPayload ex: %s", (Object[])new Object[]{e});
        }
        return pushPayloadJson.toString();
    }

    public String initImPkPushPayload(int type, String sessionId, long fromUid, String title, String content) {
        JSONObject pushPayloadJson = JsonParser.obtainJSONObject();
        JSONObject imJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            imJson.put("session_id", (Object)sessionId);
            imJson.put("from_uid", fromUid);
            pushPayloadJson.put("type", type);
            pushPayloadJson.put("im", (Object)imJson);
            pushPayloadJson.put("push_title", (Object)title);
            pushPayloadJson.put("push_content", (Object)content);
            pushPayloadJson.put("push_source", PushSourceType.kPushSourceGameInvite.getValue());
            if (userInfoKS != null) {
                pushPayloadJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
            pushPayloadJson.put("style", StyleType.StyleTypeGameInvite.getValue());
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initImPushPayload ex: %s", (Object[])new Object[]{e});
        }
        return pushPayloadJson.toString();
    }

    public String initImPushPayload(int type, String sessionId, long fromUid, int inviteType, String teamId, int gameTemplate, String gameId, String title, String content) {
        JSONObject pushPayloadJson = JsonParser.obtainJSONObject();
        JSONObject imJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            imJson.put("session_id", (Object)sessionId);
            imJson.put("from_uid", fromUid);
            imJson.put("inviteType", inviteType);
            imJson.put("teamId", (Object)teamId);
            imJson.put("gameTemplate", gameTemplate);
            imJson.put("gameId", (Object)gameId);
            pushPayloadJson.put("type", type);
            pushPayloadJson.put("im", (Object)imJson);
            pushPayloadJson.put("push_title", (Object)title);
            pushPayloadJson.put("push_content", (Object)content);
            if (userInfoKS != null) {
                pushPayloadJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
            pushPayloadJson.put("style", StyleType.StyleTypeGameInvite.getValue());
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initImPushPayload ex: %s", (Object[])new Object[]{e});
        }
        return pushPayloadJson.toString();
    }

    public String initFriendPushPayload(int type, String sessionId, long fromUid) {
        JSONObject pushPayloadJson = JsonParser.obtainJSONObject();
        JSONObject imJson = JsonParser.obtainJSONObject();
        try {
            imJson.put("session_id", (Object)sessionId);
            imJson.put("from_uid", fromUid);
            pushPayloadJson.put("type", type);
            pushPayloadJson.put("friend", (Object)imJson);
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initFriendPushPayload ex: %s", (Object[])new Object[]{e});
        }
        return pushPayloadJson.toString();
    }

    public String initWebJumpPushPayload(int type, String url) {
        JSONObject pushPayloadJson = JsonParser.obtainJSONObject();
        JSONObject jumpJson = JsonParser.obtainJSONObject();
        try {
            jumpJson.put("url", (Object)url);
            pushPayloadJson.put("type", type);
            pushPayloadJson.put("webjump", (Object)jumpJson);
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initWebJumpPushPayload ex: %s", (Object[])new Object[]{e});
        }
        return pushPayloadJson.toString();
    }

    public String initAppJumpPushPayload(int type, String url) {
        JSONObject pushPayloadJson = JsonParser.obtainJSONObject();
        JSONObject jumpJson = JsonParser.obtainJSONObject();
        try {
            jumpJson.put("url", (Object)url);
            pushPayloadJson.put("type", type);
            pushPayloadJson.put("appjump", (Object)jumpJson);
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initAppJumpPushPayload ex: %s", (Object[])new Object[]{e});
        }
        return pushPayloadJson.toString();
    }

    public String initEmojiPayload(String content, String gameId, String title, String pushContent) {
        JSONObject pushJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            pushJson.put("txt", (Object)content);
            pushJson.put("gameId", (Object)gameId);
            pushJson.put("push_title", (Object)title);
            pushJson.put("push_content", (Object)pushContent);
            if (userInfoKS != null) {
                pushJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return pushJson.toString();
    }

    public String initMsgTxtContent(String content, String payloadJson, IMPostData postData, boolean isFromDiscoveryChange) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("txt", (Object)content);
            msgJson.put("txt", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
            msgJson.put("isFromDiscoveryChange", isFromDiscoveryChange);
            if (null != postData) {
                msgJson.put("post", (Object)this.initPostCotent(postData));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgInteractiveEmojiContent(int type, String content, String payloadJson, boolean isFromDiscoveryChange) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("txt", (Object)content);
            contentJson.put("type", type);
            msgJson.put("em", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
            msgJson.put("isFromDiscoveryChange", isFromDiscoveryChange);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgPayloadContent(String payloadJson) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            msgJson.put("payload", (Object)payloadJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgImageContent(String content, String payloadJson, int emojiType, IMPostData postData, boolean isFromDiscoveryChange) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("url", (Object)content);
            contentJson.put("emoji_type", emojiType);
            msgJson.put("pic", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
            msgJson.put("isFromDiscoveryChange", isFromDiscoveryChange);
            if (null != postData) {
                msgJson.put("post", (Object)this.initPostCotent(postData));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initVoiceImMsgContent(String url, long duration, IMPostData postData, boolean isFromDiscoveryChange) {
        JSONObject json = JsonParser.obtainJSONObject();
        try {
            JSONObject voice = JsonParser.obtainJSONObject();
            voice.put("url", (Object)url);
            voice.put("duration", duration);
            json.put("voice", (Object)voice);
            json.put("payload", (Object)JsonStringBuilder.newBuilder().put("isShow", (Object)true).buildJson());
            json.put("isFromDiscoveryChange", isFromDiscoveryChange);
            if (null != postData) {
                json.put("post", (Object)this.initPostCotent(postData));
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return json.toString();
    }

    public String initBigEmojiImMsgContent(String id2) {
        JSONObject json = JsonParser.obtainJSONObject();
        try {
            JSONObject emoji = JsonParser.obtainJSONObject();
            emoji.put("id", (Object)id2);
            json.put("bigemoji", (Object)emoji);
            json.put("payload", (Object)JsonStringBuilder.newBuilder().put("isShow", (Object)true).buildJson());
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return json.toString();
    }

    public String initMsgInviteContent(String gameId, JSONObject payloadJson, boolean isFromDiscoveryChange) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("gameid", (Object)gameId);
            msgJson.put("pk", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
            msgJson.put("isFromDiscoveryChange", isFromDiscoveryChange);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgAcceptContent(String gameId, JSONObject payloadJson) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("gameid", (Object)gameId);
            msgJson.put("pk", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgShareBigContent(String url, String id2, String type, String jumpUrl, String title, String buttonText, boolean isShowBtn, String content, int source) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("url", (Object)url);
            contentJson.put("id", (Object)id2);
            contentJson.put("type", (Object)type);
            contentJson.put("jump_url", (Object)jumpUrl);
            contentJson.put("title", (Object)title);
            contentJson.put("button_txt", (Object)buttonText);
            contentJson.put("button", isShowBtn);
            contentJson.put("content", (Object)content);
            contentJson.put("source", source);
            msgJson.put("share", (Object)contentJson);
            JSONObject payloadJson = JsonParser.obtainJSONObject();
            payloadJson.put("isShow", true);
            msgJson.put("payload", (Object)payloadJson.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgShareSmallContent(String url, String id2, String type, String jumpUrl, String title, String subTitle, String content, int source, boolean isCircleIcon, String pluginId, String smallUrl, boolean isMultiVideo) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("url", (Object)url);
            contentJson.put("id", (Object)id2);
            contentJson.put("type", (Object)type);
            contentJson.put("jump_url", (Object)jumpUrl);
            contentJson.put("title", (Object)title);
            contentJson.put("subtitle", (Object)subTitle);
            contentJson.put("content", (Object)content);
            contentJson.put("source", source);
            contentJson.put("is_circle", isCircleIcon);
            contentJson.put("plugin_id", (Object)pluginId);
            contentJson.put("smallUrl", (Object)smallUrl);
            contentJson.put("is_multi_video", isMultiVideo);
            msgJson.put("share", (Object)contentJson);
            JSONObject payloadJson = JsonParser.obtainJSONObject();
            payloadJson.put("isShow", true);
            msgJson.put("payload", (Object)payloadJson.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgBbsShareContent(String url, String id2, String type, String jumpUrl, String title, String subTitle, String content, int source, boolean isCircleIcon, String pluginId, String smallUrl, boolean isMultiVideo, String extra, String reverse) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("url", (Object)url);
            contentJson.put("id", (Object)id2);
            contentJson.put("type", (Object)type);
            contentJson.put("jump_url", (Object)jumpUrl);
            contentJson.put("title", (Object)title);
            contentJson.put("subtitle", (Object)subTitle);
            contentJson.put("content", (Object)content);
            contentJson.put("source", source);
            contentJson.put("is_circle", isCircleIcon);
            contentJson.put("plugin_id", (Object)pluginId);
            contentJson.put("smallUrl", (Object)smallUrl);
            contentJson.put("is_multi_video", isMultiVideo);
            contentJson.put("extra", (Object)extra);
            contentJson.put("reverse", (Object)reverse);
            msgJson.put("share", (Object)contentJson);
            JSONObject payloadJson = JsonParser.obtainJSONObject();
            payloadJson.put("isShow", true);
            msgJson.put("payload", (Object)payloadJson.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgRejectContent(String gameId, JSONObject payloadJson) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("gameid", (Object)gameId);
            msgJson.put("acpk", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initMsgCancelContent(String gameId, JSONObject payloadJson) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("gameid", (Object)gameId);
            msgJson.put("cancelPk", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public JSONObject initFeedbackContent(FeedbackBean feedbackBean) {
        if (feedbackBean == null) {
            return null;
        }
        JSONObject jsonObject = JsonParser.obtainJSONObject();
        try {
            jsonObject.put("type", feedbackBean.getType());
            jsonObject.put("uid", feedbackBean.getUid());
            jsonObject.put("platform", (Object)feedbackBean.getPlatform());
            jsonObject.put("version", (Object)feedbackBean.getVersion());
            jsonObject.put("phone_type", (Object)feedbackBean.getPhoneType());
            jsonObject.put("system", (Object)feedbackBean.getSystem());
            jsonObject.put("content", (Object)feedbackBean.getContent());
            jsonObject.put("contact", (Object)feedbackBean.getContact());
            jsonObject.put("log_url", (Object)feedbackBean.getLogUrl());
            jsonObject.put("pic_url", (Object)feedbackBean.getPicUrl());
            jsonObject.put("country", (Object)feedbackBean.getCountry());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public String initFeedbackAllContent(String payloadJson, JSONObject feedbackJson) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            msgJson.put("feedback", (Object)feedbackJson);
            msgJson.put("payload", (Object)payloadJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initVoiceRoomInviteImContent(String roomId, String roomTitle, String roomToken, String roomHostAvatar, String payloadJson, boolean isSameCity, String sameCityLatLng, String familyDetailUrl, String content, String transKey, String transInfo, String gid) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("roomid", (Object)roomId);
            contentJson.put("room_title", (Object)roomTitle);
            contentJson.put("room_token", (Object)roomToken);
            contentJson.put("owner_avatar", (Object)roomHostAvatar);
            contentJson.put("same_city", isSameCity);
            contentJson.put("same_city_latlng", (Object)sameCityLatLng);
            contentJson.put("content", (Object)content);
            if (StringUtils.isNotEmpty((String)transKey) && StringUtils.isNotEmpty((String)transInfo)) {
                contentJson.put("game_trans_key", (Object)transKey);
                contentJson.put("game_trans_value", (Object)transInfo);
            }
            contentJson.put("gid", (Object)gid);
            msgJson.put("vchat", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
            JSONObject familyJson = JsonParser.obtainJSONObject();
            familyJson.put("inviteUrl", (Object)familyDetailUrl);
            msgJson.put("family", (Object)familyJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    public String initVoiceRoomInvitePushPayload(int type, String sessionId, long fromUid, String roomId, String roomToken, String familyDetailUrl, String roomSource, String gid) {
        JSONObject pushPayloadJson = JsonParser.obtainJSONObject();
        JSONObject imJson = JsonParser.obtainJSONObject();
        JSONObject familyJson = JsonParser.obtainJSONObject();
        try {
            imJson.put("session_id", (Object)sessionId);
            imJson.put("from_uid", fromUid);
            imJson.put("roomid", (Object)roomId);
            imJson.put("room_token", (Object)roomToken);
            imJson.put("room_source", (Object)roomSource);
            imJson.put("gid", (Object)gid);
            familyJson.put("inviteUrl", (Object)familyDetailUrl);
            pushPayloadJson.put("vchat", (Object)imJson);
            pushPayloadJson.put("type", type);
            pushPayloadJson.put("push_source", PushSourceType.kPushSourceChannelInvite.getValue());
            pushPayloadJson.put("family", (Object)familyJson);
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initVoiceRoomInvitePushPayload ex: %s", (Object[])new Object[]{e});
        }
        return pushPayloadJson.toString();
    }

    public String initChannelInvitePushPayload(int type, long uid, String title, String content, String roomId, String roomToken) {
        JSONObject pushJson = JsonParser.obtainJSONObject();
        JSONObject channelJson = JsonParser.obtainJSONObject();
        try {
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
            pushJson.put("type", type);
            pushJson.put("push_title", (Object)title);
            pushJson.put("push_content", (Object)content);
            pushJson.put("push_source", PushSourceType.kPushSourceChannelInvite.getValue());
            channelJson.put("from_uid", uid);
            channelJson.put("cid", (Object)roomId);
            channelJson.put("token", (Object)roomToken);
            pushJson.put("channel", (Object)channelJson);
            if (userInfoKS != null) {
                pushJson.put("avatar", (Object)userInfoKS.getAvatar());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return pushJson.toString();
    }

    public String initChannelInviteImContent(int type, long fromUid, String roomId, String roomTitle, String roomToken) {
        JSONObject contentJson = JsonParser.obtainJSONObject();
        JSONObject imJson = JsonParser.obtainJSONObject();
        JSONObject payloadJson = JsonParser.obtainJSONObject();
        try {
            imJson.put("from_uid", fromUid);
            imJson.put("roomid", (Object)roomId);
            imJson.put("room_token", (Object)roomToken);
            imJson.put("room_title", (Object)roomTitle);
            contentJson.put("channel", (Object)imJson);
            payloadJson.put("isShow", true);
            contentJson.put("payload", (Object)payloadJson);
            contentJson.put("type", type);
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"initVoiceRoomInvitePushPayload ex: %s", (Object[])new Object[]{e});
        }
        return contentJson.toString();
    }

    public String initRedPacketInvitePushPayload(String roomId, String roomTitle, String roomToken, String roomHostAvatar, String payloadJson, String redPacketId, String imgUrl, String familyDetailUrl) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            JSONObject familyJson = JsonParser.obtainJSONObject();
            contentJson.put("roomid", (Object)roomId);
            contentJson.put("room_title", (Object)roomTitle);
            contentJson.put("room_token", (Object)roomToken);
            contentJson.put("owner_avatar", (Object)roomHostAvatar);
            contentJson.put("img_url", (Object)imgUrl);
            contentJson.put("packet_id", (Object)redPacketId);
            familyJson.put("inviteUrl", (Object)familyDetailUrl);
            msgJson.put("vchat", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
            msgJson.put("family", (Object)familyJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }

    private String initPostCotent(IMPostData postData) {
        JSONObject postJson = JsonParser.obtainJSONObject();
        try {
            postJson.put("postid", (Object)postData.getPostId());
            postJson.put("posttype", postData.getPostType());
            postJson.put("image", (Object)postData.getImage());
            postJson.put("content", (Object)postData.getContent());
            postJson.put("time", (Object)postData.getTime());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return postJson.toString();
    }
}

